/*
 * 
 */
package com.topimagesystems.intent;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.widget.Toast;

import com.topimagesystems.Common.OCRType;
import com.topimagesystems.Constants;
import com.topimagesystems.MobiFlowException;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISBarcodeType;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowInputMessages;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.data.TISLicenseParameters;
import com.topimagesystems.util.FileUtils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

// TODO: Auto-generated Javadoc
/**
 * The Class MICRIntent. use for connection between the calling application to
 * the library.
 */
public class CaptureIntent {

	/** The Constant MICR_REQUEST_CODE. */
	public static final int MOBI_FLOW_REQUEST_CODE = 1024;

	/** The Constant ACTION_CAPTURE. */
	private static final String ACTION_CAPTURE = "com.topimagesystems.CAPTURE";
	// incoming
	/** The Constant INTENT_IS_DEBUG. */
	public static final String INTENT_IS_DEBUG = "IS_DEBUG";

	/** The Constant INTENT_MICR_TYPE. */
	public static final String INTENT_OCR_TYPE = "MICR_TYPE";

	/** The Constant INTENT_MAX_NUMBER_OF_RETRIES. */
	public static final String INTENT_MAX_NUMBER_OF_RETRIES = "INTENT_MAX_NUMBER_OF_RETRIES";

	/** The Constant INTENT_MIN_RATIO_HEIGHT_WIDTH. */
	public static final String INTENT_MIN_RATIO_HEIGHT_WIDTH = "INTENT_MIN_RATIO_HEIGHT_WIDTH";

	/** The Constant INTENT_MAX_RATIO_HEIGHT_WIDTH. */
	public static final String INTENT_MAX_RATIO_HEIGHT_WIDTH = "INTENT_MAX_RATIO_HEIGHT_WIDTH";

	/** The Constant INTENT_IS_MANUAL_CAPTURE. */
	public static final String INTENT_IS_MANUAL_CAPTURE = "INTENT_IS_MANUAL_CAPTURE";

	/** The Constant INTENT_TXT_VALID_FROM. */
	public static final String INTENT_TXT_VALID_FROM = "INTENT_TXT_VALID_FROM";

	/** The Constant INTENT_TXT_VALID_TO. */
	public static final String INTENT_TXT_VALID_TO = "INTENT_TXT_VALID_TO";


	public static final String INTENT_SHOW_MICR_OVERALY = "INTENT_SHOW_MICR_OVERALY";


	/** The Constant INTENT_ISAUTO_FRONT. */
	public static final String INTENT_ISAUTO_FRONT = "INTENT_ISAUTO_FRONT";

	/** The Constant INTENT_ISAUTO_BACK. */
	public static final String INTENT_ISAUTO_BACK = "INTENT_ISAUTO_BACK";

	/** The Constant INTENT_ISIQA_PASSED_FRONT. */
	public static final String INTENT_ISIQA_PASSED_FRONT = "INTENT_ISIQA_PASSED_FRONT";

	/** The Constant INTENT_ISIQA_PASSED_BACK. */
	public static final String INTENT_ISIQA_PASSED_BACK = "INTENT_ISIQA_PASSED_BACK";

	/** The Constant TAKE. */
	public static final String TAKE = "INTENT_ISIQA_PASSED_BACK";

	/** The Constant INTENT_IQA_ENABLED. */
	public static final String INTENT_IQA_ENABLED = "INTENT_IQA_ENABLED";

	/** The Constant INTENT_IQA_SETTINGS. */
	public static final String INTENT_IQA_SETTINGS = "INTENT_IQA_SETTINGS";

	/** The Constant IS_CUSTOM_VIEW. */
	public static final String IS_CUSTOM_VIEW = "IS_CUSTOM_VIEW";

	/** The Constant CURRENT_SESSION_PARAMS. */
	public static final String CURRENT_SESSION_PARAMS = "SESSION_PARAMETERS";

	/** The Constant CURRENT_INPUT_SESSION_PARAMS. */
	public static final String CURRENT_INPUT_SESSION_PARAMS = "CURRENT_INPUT_SESSION_PARAMS";

	/** The Constant SCAN_FRONT_ONLY. */
	public final static String SCAN_FRONT_ONLY = "SCAN_FRONT_ONLY";

	/** The Constant SCAN_BACK_ONLY. */
	public final static String SCAN_BACK_ONLY = "SCAN_BACK_ONLY";

	/** The Constant INFO_SCREEN_ENABLED. */
	public final static String INFO_SCREEN_ENABLED = "INFO_SCREEN_ENABLED";

	/** The Constant INFO_SCREEN_INTERVAL. */
	public final static String INFO_SCREEN_INTERVAL = "INFO_SCREEN_INTERVAL";

	/** The Constant GUIDLINES_INDICATOR. */
	public final static String GUIDLINES_INDICATOR = "GUIDLINES_INDICATOR";

	/** The Constant IS_BLUR_ENABLED. */
	public final static String IS_BLUR_ENABLED = "IS_BLUR_ENABLED";

	public final static String IS_BLUR_ENABLED_ON_BACK_SIDE = "IS_BLUR_ENABLED_ON_BACK_SIDE";


	/** The Constant MAX_VIDEO_FRAMES_TO_CAPTURE. */
	public final static String MAX_VIDEO_FRAMES_TO_CAPTURE = "MAX_VIDEO_FRAMES_TO_CAPTURE";

	/** The Constant FOLDER_LOCATION. */
	public final static String FOLDER_LOCATION = "FOLDER_LOCATION";

	/** The Constant GRAY_SCALE. */
	public final static String GRAY_SCALE = "GRAY_SCALE";

	/** The Constant OUTPUT_ORIGINAL_IMAGE. */
	public final static String OUTPUT_ORIGINAL_IMAGE = "SAVE_ORIGINAL_IMAGE";

	/** The Constant OUTPUT_COLORED_IMAGE. */
	public final static String OUTPUT_COLORED_IMAGE = "OUTPUT_COLORED_IMAGE";

	/** The Constant OUTPUT_BW_IMAGE. */
	public final static String OUTPUT_BW_IMAGE = "OUTPUT_BW_IMAGE";

	/** The Constant ENABLE_PROCESSING_VIEW. */
	public final static String ENABLE_PROCESSING_VIEW = "ENABLE_PROCESSING_VIEW";

	/** The Constant IS_PORTRIT_MODE. */
	public final static String IS_PORTRIT_MODE = "IS_PORTRIT_MODE";

	/** The Constant FRONT_IMAGE_RECT. */
	public final static String FRONT_IMAGE_RECT = "FRONT_IMAGE_RECT_ARRAY";

	/** The Constant GRAY_SCALE_SIZE. */
	public final static String GRAY_SCALE_SIZE = "GRAY_SCALE_SIZE";

	/** The Constant ENABLE_COUNTDOWN_SOUND. */
	public final static String ENABLE_COUNTDOWN_SOUND = "ENABLE_COUNTDOWN_SOUND";

	/** The Constant ENABLE_VIDEO_MODE. */
	public final static String ENABLE_VIDEO_MODE = "ENABLE_VIDEO_MODE";

	/** The Constant ENABLE_MULTI_CAPTURE. */
	public final static String ENABLE_MULTI_CAPTURE = "ENABLE_MULTI_CAPTURE";
	public final static String ENABLE_DYNAMIC_CAPTURE = "ENABLE_DYNAMIC_CAPTURE";



	/** The Constant SHOW_COUNT_DOWN. */
	public final static String SHOW_COUNT_DOWN = "SHOW_COUNT_DOWN";

	
	
	/** The Constant MOBIFLOW_ERROR_DETAILS. */
	public final static String MOBIFLOW_ERROR_DETAILS = "MOBIFLOW_ERROR_DETAILS";
	
	/** The Constant SCAN_BARCODE_LOCATION. */
	public final static String SCAN_BARCODE_LOCATION = "SCAN_BARCODE_LOCATION";
	
	/** The Constant BARCODE_TYPES. */
	public final static String BARCODE_TYPES = "BARCODE_TYPES";
	
	/** The Constant MOBIFLOW_ERROR_DETAILS. */
	public final static String IS_BINARIZE_BACK_SAME_AS_FRONT = "IS_BINARIZE_BACK_SAME_AS_FRONT";
	
	public final static String BINARIZATION_TYPE = "BINARIZATION_TYPE";
	
	public final static String ENABLE_SOFT_CAPTURE = "ENABLE_SOFT_CAPTURE";
	
	public final static String BINARIZATION_TRASHOLD = "BINARIZATION_TRASHOLD";
	
	public final static String COLOR_IMAGE_COMPRESSION = "COLOR_IMAGE_COMPRESSION";
	
	public final static String GRAY_SCALE_IMAGE_COMPRESSION = "GRAY_SCALE_IMAGE_COMPRESSION";
	public final static String USE_MAX_RESOLUTION_STILLS = "USE_MAX_RESOLUTION_STILLS";
	public final static String USE_CAMERA_API2 = "USE_CAMERA_API2";

	public final static String TAP_TO_FOCUS = "TAP_TO_FOCUS";

	public final static String TIS_LICENSE_CLASS = "TIS_LICENSE_CLASS";
    public final static String INVALID_LISENSE_KEY = "Invalid License Key";
    public final static String VALID_LISENSE_KEY = "Valid License Key";
    public final static String INVALID_LISENSE = "Invalid license";
    public final static String INVALID_SDK_VERSION = "Invalid sdk version";
    public final static String INVALID_EXPERATION_DATE = "License has expired";

	public final static String TIS_SOFT_CAPTURE_THRESHOLD = "TIS_SOFT_CAPTURE_THRESHOLD";
	public final static String ENABLE_TRANSIATION_BETWEEN_ANIMATION = "ENABLE_TRANSIATION_BETWEEN_ANIMATION";

	/**
	 * The Class IQAIntentKeys.
	 */
	public static class IQAIntentKeys {

		/** The Constant IS_IQA_MODE. */
		public final static String IS_IQA_MODE = "IS_IQA_MODE";

		/** The Constant CORNERDATA_FRONT_KEY. */
		public final static String CORNERDATA_FRONT_KEY = "CORNERDATA_FRONT_KEY";

		/** The Constant CORNERDATA_BACK_KEY. */
		public final static String CORNERDATA_BACK_KEY = "CORNERDATA_BACK_KEY";

		/** The Constant EDGE_KEY. */
		public final static String EDGE_KEY = "EDGE_KEY";

		/** The Constant CORNERDATA_FRONT_TL_W_KEY. */
		public final static String CORNERDATA_FRONT_TL_W_KEY = "CORNERDATA_FRONT_TL_W_KEY";

		/** The Constant CORNERDATA_FRONT_TL_H_KEY. */
		public final static String CORNERDATA_FRONT_TL_H_KEY = "CORNERDATA_FRONT_TL_H_KEY";

		/** The Constant CORNERDATA_FRONT_TL_A_KEY. */
		public final static String CORNERDATA_FRONT_TL_A_KEY = "CORNERDATA_FRONT_TL_A_KEY";

		/** The Constant CORNERDATA_FRONT_TR_W_KEY. */
		public final static String CORNERDATA_FRONT_TR_W_KEY = "CORNERDATA_FRONT_TR_W_KEY";

		/** The Constant CORNERDATA_FRONT_TR_H_KEY. */
		public final static String CORNERDATA_FRONT_TR_H_KEY = "CORNERDATA_FRONT_TR_H_KEY";

		/** The Constant CORNERDATA_FRONT_TR_A_KEY. */
		public final static String CORNERDATA_FRONT_TR_A_KEY = "CORNERDATA_FRONT_TR_A_KEY";

		/** The Constant CORNERDATA_FRONT_BL_W_KEY. */
		public final static String CORNERDATA_FRONT_BL_W_KEY = "CORNERDATA_FRONT_BL_W_KEY";

		/** The Constant CORNERDATA_FRONT_BL_H_KEY. */
		public final static String CORNERDATA_FRONT_BL_H_KEY = "CORNERDATA_FRONT_BL_H_KEY";

		/** The Constant CORNERDATA_FRONT_BL_A_KEY. */
		public final static String CORNERDATA_FRONT_BL_A_KEY = "CORNERDATA_FRONT_BL_A_KEY";

		/** The Constant CORNERDATA_FRONT_BR_W_KEY. */
		public final static String CORNERDATA_FRONT_BR_W_KEY = "CORNERDATA_FRONT_BR_W_KEY";

		/** The Constant CORNERDATA_FRONT_BR_H_KEY. */
		public final static String CORNERDATA_FRONT_BR_H_KEY = "CORNERDATA_FRONT_BR_H_KEY";

		/** The Constant CORNERDATA_FRONT_BR_A_KEY. */
		public final static String CORNERDATA_FRONT_BR_A_KEY = "CORNERDATA_FRONT_BR_A_KEY";
		//
		/** The Constant CORNERDATA_BACK_TL_W_KEY. */
		public final static String CORNERDATA_BACK_TL_W_KEY = "CORNERDATA_BACK_TL_W_KEY";

		/** The Constant CORNERDATA_BACK_TL_H_KEY. */
		public final static String CORNERDATA_BACK_TL_H_KEY = "CORNERDATA_BACK_TL_H_KEY";

		/** The Constant CORNERDATA_BACK_TL_A_KEY. */
		public final static String CORNERDATA_BACK_TL_A_KEY = "CORNERDATA_BACK_TL_A_KEY";

		/** The Constant CORNERDATA_BACK_TR_W_KEY. */
		public final static String CORNERDATA_BACK_TR_W_KEY = "CORNERDATA_BACK_TR_W_KEY";

		/** The Constant CORNERDATA_BACK_TR_H_KEY. */
		public final static String CORNERDATA_BACK_TR_H_KEY = "CORNERDATA_BACK_TR_H_KEY";

		/** The Constant CORNERDATA_BACK_TR_A_KEY. */
		public final static String CORNERDATA_BACK_TR_A_KEY = "CORNERDATA_BACK_TR_A_KEY";

		/** The Constant CORNERDATA_BACK_BL_W_KEY. */
		public final static String CORNERDATA_BACK_BL_W_KEY = "CORNERDATA_BACK_BL_W_KEY";

		/** The Constant CORNERDATA_BACK_BL_H_KEY. */
		public final static String CORNERDATA_BACK_BL_H_KEY = "CORNERDATA_BACK_BL_H_KEY";

		/** The Constant CORNERDATA_BACK_BL_A_KEY. */
		public final static String CORNERDATA_BACK_BL_A_KEY = "CORNERDATA_BACK_BL_A_KEY";

		/** The Constant CORNERDATA_BACK_BR_W_KEY. */
		public final static String CORNERDATA_BACK_BR_W_KEY = "CORNERDATA_BACK_BR_W_KEY";

		/** The Constant CORNERDATA_BACK_BR_H_KEY. */
		public final static String CORNERDATA_BACK_BR_H_KEY = "CORNERDATA_BACK_BR_H_KEY";

		/** The Constant CORNERDATA_BACK_BR_A_KEY. */
		public final static String CORNERDATA_BACK_BR_A_KEY = "CORNERDATA_BACK_BR_A_KEY";
		// ---edge
		/** The Constant EDGE_DATA_T_W_KEY. */
		public final static String EDGE_DATA_T_W_KEY = "EDGE_DATA_T_W_KEY";

		/** The Constant EDGE_DATA_T_H_KEY. */
		public final static String EDGE_DATA_T_H_KEY = "EDGE_DATA_T_H_KEY";

		/** The Constant EDGE_DATA_T_A_KEY. */
		public final static String EDGE_DATA_T_A_KEY = "EDGE_DATA_T_A_KEY";

		/** The Constant EDGE_DATA_B_W_KEY. */
		public final static String EDGE_DATA_B_W_KEY = "EDGE_DATA_B_W_KEY";

		/** The Constant EDGE_DATA_B_H_KEY. */
		public final static String EDGE_DATA_B_H_KEY = "EDGE_DATA_B_H_KEY";

		/** The Constant EDGE_DATA_B_A_KEY. */
		public final static String EDGE_DATA_B_A_KEY = "EDGE_DATA_B_A_KEY";

		/** The Constant EDGE_DATA_L_W_KEY. */
		public final static String EDGE_DATA_L_W_KEY = "EDGE_DATA_L_W_KEY";

		/** The Constant EDGE_DATA_L_H_KEY. */
		public final static String EDGE_DATA_L_H_KEY = "EDGE_DATA_L_H_KEY";

		/** The Constant EDGE_DATA_L_A_KEY. */
		public final static String EDGE_DATA_L_A_KEY = "EDGE_DATA_L_A_KEY";

		/** The Constant EDGE_DATA_R_W_KEY. */
		public final static String EDGE_DATA_R_W_KEY = "EDGE_DATA_R_W_KEY";

		/** The Constant EDGE_DATA_R_H_KEY. */
		public final static String EDGE_DATA_R_H_KEY = "EDGE_DATA_R_H_KEY";

		/** The Constant EDGE_DATA_R_A_KEY. */
		public final static String EDGE_DATA_R_A_KEY = "EDGE_DATA_R_A_KEY";

		/** The Constant MAX_SKEW_KEY. */
		public final static String MAX_SKEW_KEY = "MAX_SKEW_KEY";

		/** The Constant MAX_DARNESS_FRONT_KEY. */
		public final static String MAX_DARNESS_FRONT_KEY = "MAX_DARNESS_FRONT_KEY";

		/** The Constant MIN_DARNESS_FRONT_KEY. */
		public final static String MIN_DARNESS_FRONT_KEY = "MIN_DARNESS_FRONT_KEY";

		/** The Constant MAX_DARNESS_BACK_KEY. */
		public final static String MAX_DARNESS_BACK_KEY = "MAX_DARNESS_BACK_KEY";

		/** The Constant MIN_DARNESS_BACK_KEY. */
		public final static String MIN_DARNESS_BACK_KEY = "MIN_DARNESS_BACK_KEY";

		/** The Constant MAX_SPOTS_FRONT_KEY. */
		public final static String MAX_SPOTS_FRONT_KEY = "MAX_SPOTS_FRONT_KEY";

		/** The Constant MAX_SPOTS_BACK_KEY. */
		public final static String MAX_SPOTS_BACK_KEY = "MAX_SPOTS_BACK_KEY";

		/** The Constant MIN_IMAGE_SIZE_FRONT_KEY. */
		public final static String MIN_IMAGE_SIZE_FRONT_KEY = "MIN_IMAGE_SIZE_FRONT";

		/** The Constant MAX_IMAGE_SIZE_FRONT_KEY. */
		public final static String MAX_IMAGE_SIZE_FRONT_KEY = "MAX_IMAGE_SIZE_FRONT";

		/** The Constant MIN_IMAGE_SIZE_BACK_KEY. */
		public final static String MIN_IMAGE_SIZE_BACK_KEY = "MIN_IMAGE_SIZE_BACK";

		/** The Constant MAX_IMAGE_SIZE_BACK_KEY. */
		public final static String MAX_IMAGE_SIZE_BACK_KEY = "MAX_IMAGE_SIZE_BACK";

		/** The Constant HORIZONTAL_STREAK_SUM_BLACK_PIXELS. */
		public final static String HORIZONTAL_STREAK_SUM_BLACK_PIXELS = "HORIZONTAL_STREAK_SUM_BLACK_PIXELS";
		/** The Constant HORIZONTAL_STREAK_LINE_WIDTH. */
		public final static String HORIZONTAL_STREAK_LINE_WIDTH = "HORIZONTAL_STREAK_LINE_WIDTH";
		/** The Constant HORIZONTAL_STREAK_NUM_LINES. */
		public final static String HORIZONTAL_STREAK_NUM_LINES = "HORIZONTAL_STREAK_NUM_LINES";

		/** The Constant CARBON_STRIP_SUM_BLACK_PIXELS. */
		public final static String CARBON_STRIP_SUM_BLACK_PIXELS = "CARBON_STRIP_SUM_BLACK_PIXELS";
		/** The Constant CARBON_STRIP_LINE_WIDTH. */
		public final static String CARBON_STRIP_LINE_WIDTH = "CARBON_STRIP_LINE_WIDTH";
		/** The Constant CARBON_STRIP_NUM_LINES. */
		public final static String CARBON_STRIP_NUM_LINES = "CARBON_STRIP_NUM_LINES";

		/** The Constant PIGGY_BACK_WIDTH_THRESHOLD. */
		public final static String PIGGY_BACK_WIDTH_THRESHOLD = "PIGGY_BACK_WIDTH_THRESHOLD";

		/** The Constant PIGGY_BACK_LOCATION_THRESHOLD. */
		public final static String PIGGY_BACK_LOCATION_THRESHOLD = "PIGGY_BACK_LOCATION_THRESHOLD";

	}

	/**
	 * The Enum documentType.
	 */
	public static enum TISDocumentType {

		/** choose for check capture. */
		CHECK(0),
		/** choose for payment capture. */
		PAYMENT(1),
		/** choose for full page capture. */
		FULL_PAGE(2),			
		PASSPORT(3),	
		CARD(4),
		/** choose for custom capture. */
		CUSTOM(5);
		
		private int id;
		
		private TISDocumentType(int id) {
			this.id = id;
		}
		
		/**
		 * Gets the id.
		 *
		 * @return the id
		 */
		public int getId() {
		
			return id;
		}
		
		/**
		 * Gets the enum.
		 *
		 * @return the enum
		 */
		public static TISDocumentType getEnum(int value) {
			switch (value) {
			case 0:
				return CHECK;
			case 1:
				return PAYMENT;
			case 2:
				return FULL_PAGE;
			case 3:
				return PASSPORT;
			case 4:
				return CARD;
			case 5:
				return CUSTOM;

			default:
				break;
			}
		
			return CUSTOM;
		}
		

	}
	
	
	public static enum TISFlowUXType{		
		STATIC(0),
		LIVE(1);
		
		private int id;
		
		private TISFlowUXType(int id) {
			this.id = id;
		}
		
		/**
		 * Gets the id.
		 *
		 * @return the id
		 */
		public int getId() {
		
			return id;
		}
		
		/**
		 * Gets the enum.
		 *
		 * @return the enum
		 */
		public static TISFlowUXType getEnum(int value) {
			switch (value) {
			case 0:
				return STATIC;
			case 1:
				return LIVE;
			}

			return STATIC;
		}
	}

	/**
	 * The Enum SessionType.
	 */
	public static enum SessionType {

		/** The normal. */
		NORMAL,
		/** The test. */
		TEST,
		/** The portrait. */
		PORTRAIT,		
	}
	
	public static enum TISBinarizationType {

		/** The normal. */
		TIS_GENERAL_BINARIZATION(0),
		/** The test. */
		TIS_CHECK_BINARIZATION(1);
		/** The portrait. */	
		
		private int id;
		
		private TISBinarizationType(int id) {
			this.id = id;
		}
		
		/**
		 * Gets the id.
		 *
		 * @return the id
		 */
		public int getId() {
		
			return id;
		}
		
		/**
		 * Gets the enum.
		 *
		 * @return the enum
		 */
		public static TISBinarizationType getEnum(int value) {
			switch (value) {
			case 0:
				return TIS_GENERAL_BINARIZATION;
			case 1:
				return TIS_CHECK_BINARIZATION;
			}

			return TIS_GENERAL_BINARIZATION;
		}
		
		
	}

	/**
	 * The Enum LevelerType.
	 */
	public static enum LevelerType {
		/** The none. */
		NONE(0),
		/** The one unit. */
		ONE_UNIT(1),
		/** The two units horizontal and portrait. */
		TWO_UNITS(2),
		/** The scale. */
		SCALE(3);
		
		private int type;
	    
		LevelerType (int i){
	    	this.type = i;
	    }
	    
	    public int getValue(){
	    	return type;
	    }
	    
	    static public LevelerType getEnum(int value){
	    	switch (value) {
			case 0:				
				return NONE;
			case 2:				
				return TWO_UNITS;
			case 3:				
				return SCALE;
				
			default:
				return ONE_UNIT;
			}
	    }
	}
	
	/**
	 * The Enum TISScanBarcodeLocation.
	 */
	public static enum TISScanBarcodeLocation{
		/** The TISScanBarcodeFront. */
	    BARCODE_FRONT(0),
		/** The TISScanBarcodeBack. */
	    BARCODE_BACK(1) ,
		/** The TISScanBarcodeFrontAndBack. */
	    BARCODE_FRONT_AND_BACK(2),
		/** The NONE. */
	    BARCODE_NONE(3);
	    
	    private int type;
	    
	    TISScanBarcodeLocation (int i){
	    	this.type = i;
	    }
	    
	    public int getValue(){
	    	return type;
	    }
	    
	    static public TISScanBarcodeLocation getEnum(int value){
	    	switch (value) {
			case 0:				
				return BARCODE_FRONT;
			case 1:				
				return BARCODE_BACK;
			case 2:				
				return BARCODE_FRONT_AND_BACK;
			case 3:				
				return BARCODE_NONE;
				
			default:
				return BARCODE_NONE;
			}
	    }
	}

	/** The current image type. */
	public static TISDocumentType currentImageType;

	// outgoing
	/** The intent ocr digital row length. */
	public static String INTENT_OCR_DIGITAL_ROW_LENGTH = "OCR_DIGITAL_ROW_LENGTH";

	/** The intent ocr result. */
	public static String INTENT_OCR_RESULT = "OCR_RESULT";

	/** The intent ocr raw result. */
	public static String INTENT_OCR_RAW_RESULT = "OCR_RAW_RESULT";

	/** The intent ocr score result. */
	public static String INTENT_OCR_SCORE_RESULT = "OCR_SCORE_RESULT";

	/** The intent ocr front image tiff path. */
	public static String INTENT_OCR_FRONT_IMAGE_TIFF_PATH = "OCR_FRONT_IMAGE_TIFF_PATH";

	/** The intent ocr back image tiff path. */
	public static String INTENT_OCR_BACK_IMAGE_TIFF_PATH = "OCR_BACK_IMAGE_TIFF_PATH";

	/** The intent ocr front image path. */
	public static String INTENT_OCR_FRONT_IMAGE_PATH = "OCR_FRONT_IMAGE_PATH";

	/** The intent ocr back image path. */
	public static String INTENT_OCR_BACK_IMAGE_PATH = "OCR_BACK_IMAGE_PATH";

	/**
	 * The Class IntentBoolFlags.
	 */
	public static class IntentBoolFlags {

		/** The is iqa passed back. */
		public boolean isAutoCaptureFront, isAutoCaptureBack, isIQAPassedFront,
				isIQAPassedBack;

		/**
		 * Instantiates a new intent bool flags.
		 *
		 * @param intent
		 *            the intent
		 */
		IntentBoolFlags(Intent intent) {
			isAutoCaptureFront = intent.getBooleanExtra(INTENT_ISAUTO_FRONT,
					true);
			isAutoCaptureBack = intent
					.getBooleanExtra(INTENT_ISAUTO_BACK, true);
			isIQAPassedFront = intent.getBooleanExtra(
					INTENT_ISIQA_PASSED_FRONT, true);
			isIQAPassedBack = intent.getBooleanExtra(INTENT_ISIQA_PASSED_BACK,
					true);
		}
	};

	/** The activity. */
	private final Activity activity;
	private final Object fragment;
	
	
	private boolean isUsingFragment() {
		return fragment != null;
	}
	

	/**
	 * Instantiates a new MICR intent.
	 *
	 * @param activity
	 *            the activity
	 */
	public CaptureIntent(Activity activity) {
		this.activity = activity;
		this.fragment = null;
	}

	/**
	 * Instantiates a new MICR intent.
	 *
	 * @param fragment (can be native fragment or from support library)
	 *            the fragment
	 * @throws MobiFlowException
	 */

	public CaptureIntent(Object fragment) throws MobiFlowException {
		if (fragment instanceof Activity) {
			this.activity = (Activity) fragment;
			this.fragment = null;
			return;
		}

		Activity _activity = null;
		try {
			// check if fragment is valid
			Class clz = fragment.getClass();

			Method _getActivity_Method = clz.getMethod("getActivity", null);
			Class[] cArg = new Class[2];
			cArg[0] = Intent.class;
			cArg[1] = Integer.TYPE;
			Method _startActivity_Method = clz.getMethod("startActivityForResult", cArg);

			// try to invoke method
			_activity = (Activity) _getActivity_Method.invoke(fragment);
		} catch (Exception roe) {
			
			throw new MobiFlowException(MobiFlowException.NOT_VALID_FRAGMENT);
		}

		// No exceptions has been thrown
		this.fragment = fragment;
		this.activity = _activity;
	}
	
	

	/**
	 * Capture document.
	 * 
	 * @param input
	 *            document parameters class.
	 * @return true, if successful
	 */
	@TargetApi(Build.VERSION_CODES.HONEYCOMB)
	public boolean captureDocument(baseCaptureParams input) {
//        String licenseValidation = checkLicenseValidation(input.license);
//		if(!licenseValidation.equals(VALID_LISENSE_KEY)){
//            Toast.makeText(activity.getApplicationContext(),licenseValidation,Toast.LENGTH_SHORT);
//            return false;
//		}
		Intent intentCapture = new Intent(
				activity,
				com.topimagesystems.controllers.imageanalyze.CameraManagerController.class);
		intentCapture.setAction(ACTION_CAPTURE);
		//
		intentCapture.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		intentCapture.addFlags(Intent.FLAG_ACTIVITY_CLEAR_WHEN_TASK_RESET);

		// add extras

		intentCapture.putExtra(INTENT_MAX_NUMBER_OF_RETRIES, 1000);
		intentCapture.putExtra(INTENT_MIN_RATIO_HEIGHT_WIDTH,
				input.minHeightWidthAspectRatio);
		intentCapture.putExtra(INTENT_MAX_RATIO_HEIGHT_WIDTH,
				input.maxHeightWidthAspectRatio);
		intentCapture.putExtra(INTENT_IS_MANUAL_CAPTURE, false);
		intentCapture.putExtra(INTENT_IS_DEBUG, input.debugMode);
		intentCapture.putExtra(INFO_SCREEN_ENABLED, input.showInfoScreen);
		intentCapture.putExtra(SCAN_FRONT_ONLY, input.scanFrontOnly);
		intentCapture.putExtra(SCAN_BACK_ONLY, input.scanBackOnly);
		intentCapture.putExtra(SHOW_COUNT_DOWN, input.showCountDown);
		if (input.license == null){
			Toast.makeText(activity,"Please init TISLicenseParameters Class",Toast.LENGTH_SHORT).show();
			return false;
		}

		intentCapture.putExtra(TIS_LICENSE_CLASS, input.license);
		if (input.softCaptureThreshold > 1){
			input.softCaptureThreshold = 1;
		}
		intentCapture.putExtra(TIS_SOFT_CAPTURE_THRESHOLD, input.softCaptureThreshold);

		// intentCapture.putExtra(CURRENT_IMAGE_TYPE, documentType.CHECK);
		intentCapture.putExtra(IS_BLUR_ENABLED, input.enableBlurDetection);
		intentCapture.putExtra(IS_BLUR_ENABLED_ON_BACK_SIDE, input.enableBlurDetectionOnBackSide);

		intentCapture.putExtra(MAX_VIDEO_FRAMES_TO_CAPTURE,
				input.maxVideoFramesToCapture);

		// license id extras

		intentCapture.putExtra(GUIDLINES_INDICATOR,
				input.showGuidelinesIndicators);
		intentCapture.putExtra(ENABLE_COUNTDOWN_SOUND,
				input.enableCountdownSound);

		intentCapture.putExtra(ENABLE_VIDEO_MODE, input.videoFeedProcessing);

		intentCapture.putExtra(INTENT_IQA_ENABLED, input.enableIQA);
		intentCapture.putExtra(GRAY_SCALE, input.outputGrayscaleImage);
		intentCapture
				.putExtra(OUTPUT_ORIGINAL_IMAGE, input.outputOriginalImage);
		intentCapture.putExtra(OUTPUT_COLORED_IMAGE, input.outputColorImage);

		intentCapture.putExtra(OUTPUT_BW_IMAGE, input.outputBinarizedImage);
		intentCapture.putExtra(IS_CUSTOM_VIEW, input.customView);
		intentCapture.putExtra(ENABLE_PROCESSING_VIEW,
				input.showDefaultProcessingView);
		intentCapture.putExtra(ENABLE_MULTI_CAPTURE, input.multiPageCapture);
		intentCapture.putExtra(SCAN_BARCODE_LOCATION, input.scanBarcodeLocation.getValue());
		intentCapture.putExtra(BARCODE_TYPES, TISBarcodeType.getIntegerArrayListFromEnumList(input.barcodeTypes));
	
		intentCapture.putExtra(INTENT_IQA_SETTINGS,
				input.IQASettings.toBundle());
		intentCapture.putExtra(FRONT_IMAGE_RECT, input.frontImageSize);
		intentCapture.putExtra(SHOW_COUNT_DOWN, input.showCountDown);
		intentCapture.putExtra(ENABLE_SOFT_CAPTURE, input.enableSoftCapture);
		intentCapture.putExtra(INFO_SCREEN_INTERVAL, input.infoScreenInterval);
		intentCapture.putExtra(COLOR_IMAGE_COMPRESSION, input.colorImageCompression);
		intentCapture.putExtra(GRAY_SCALE_IMAGE_COMPRESSION, input.grayscaleImageCompression);
		intentCapture.putExtra(USE_MAX_RESOLUTION_STILLS, input.useMaxResolution);
		intentCapture.putExtra(USE_CAMERA_API2, input.useCameraAPI2);
		intentCapture.putExtra(TAP_TO_FOCUS, input.tapToFocus);
		intentCapture.putExtra(ENABLE_TRANSIATION_BETWEEN_ANIMATION, input.animateTransitionInLivePreview);

		if (input.uxType == TISFlowUXType.LIVE){
			intentCapture.putExtra(ENABLE_DYNAMIC_CAPTURE, true);
		}
		else{
			intentCapture.putExtra(ENABLE_DYNAMIC_CAPTURE, false);
		}
		
		intentCapture.putExtra(FOLDER_LOCATION,
				FileUtils.getTestImagePath(activity));
		CameraManagerController.imageType =
				currentImageType;
		CameraManagerController.dynamicStrings = null;
		if (input.dynamicStrings != null) {
			CameraManagerController.dynamicStrings = input.dynamicStrings;
		}
		switch(input.binarizationType){
		case TIS_GENERAL_BINARIZATION:
			intentCapture.putExtra(BINARIZATION_TYPE,Constants.TIS_GENERAL_BINARIZATION);
			break;
			
		case TIS_CHECK_BINARIZATION:
			intentCapture.putExtra(BINARIZATION_TYPE,Constants.TIS_CHECK_BINARIZATION);
			break;
		}
		intentCapture.putExtra(BINARIZATION_TRASHOLD, input.binarizationThreshold);
		intentCapture.putExtra(INTENT_OCR_TYPE,
				input.ocrType.name());
		switch (currentImageType) {

		case CHECK:
			checkCaptureParams checkParams = (checkCaptureParams) input;
			intentCapture.putExtra(INTENT_TXT_VALID_FROM,
					checkParams.minMICRLength);
			intentCapture.putExtra(INTENT_TXT_VALID_TO,
					checkParams.maxMICRLength);

			break;
								
		case CUSTOM:
			customCaptureParams customParams = (customCaptureParams) input;
			intentCapture
					.putExtra(IS_PORTRIT_MODE, customParams.portraitCapture);
			if (customParams.portraitCapture) {
				CameraManagerController.sessionType = SessionType.PORTRAIT;
			}
			break;
		default:
			break;
		}

		// start activity
		if (isUsingFragment()) {
			try {
				tryReflectionStartActivity(intentCapture);
			} catch (Exception e) {
				return false;
			}
		} else
			activity.startActivityForResult(intentCapture, MOBI_FLOW_REQUEST_CODE);
		return true;
	}
	
	private void tryReflectionStartActivity(Intent intentCapture) throws Exception {
		Class clz = fragment.getClass();
		Method m2 = null;

		Class[] cArg = new Class[2];
		cArg[0] = Intent.class;
		cArg[1] = Integer.TYPE;

		m2 = clz.getMethod("startActivityForResult", cArg);
		m2.invoke(fragment, intentCapture, MOBI_FLOW_REQUEST_CODE);
	}

	/**
	 * The Class baseCaptureParams init here the parameters for the session
	 * relevant for all Document type.
	 */
	public class baseCaptureParams {

		/**  Maximum allowed ratio between captured document height and width. */
		public float maxHeightWidthAspectRatio = 0.52f;

		/**  Minimum allowed ratio between captured document height and width. */
		public float minHeightWidthAspectRatio = 0.35f;

		/**  the document type from documentType enum documentType.CHECK, documentType.PAYMENT, documentType.FULL_PAGE, documentType.CUSTOM */
		public TISDocumentType documnetType = TISDocumentType.PAYMENT;

		/**
		 * In debug images are stored on device and logs are written to console.
		 * Default value: False.
		 */
		public boolean debugMode = false;

		/**
		 * If set to true will capture only front side, if set to false and
		 * scanBackOnly set to false will capture both front and back. Default
		 * value: False
		 */
		public boolean scanFrontOnly = false;

		/**
		 * If set to true will capture only back side, if scanFrontOnly is also
		 * true, will fail to initialize the Library. Default value: False
		 */
		public boolean scanBackOnly = false;

		/**
		 * If set to true will show info screen after custom time. Default
		 * value: True
		 */
		public boolean showInfoScreen = true;

		/**
		 * Interval to show the info screen. Default Value: 10000
		 */
		public long infoScreenInterval = 10000;

		/**
		 * IQA settings can be configured in the IqaSettings class. Can leave
		 * defaults if not in use.
		 */
		public IQASettingsIntent IQASettings = new IQASettingsIntent();

		/**
		 * Enable or Disable the IQA validations. Default value: False
		 */
		public boolean enableIQA = false;

		/**
		 * When set to false - only 2 static indicators will be presented.
		 * TISFlowIndicatorAlign – static indictor showing TISFlowIndicatorHold
		 * – indicator for hold state When set to true – dynamic indicators will
		 * show. Default value: True
		 */
		public boolean showGuidelinesIndicators = true;

		/**
		 * Image Blur detection enable/disable. Default Value: True for payment
		 * and full page, False for check. Default value: False
		 */
		public boolean enableBlurDetection = false;


		public boolean enableBlurDetectionOnBackSide = false;

		/**
		 * When set to true the Library will create grayscale image. Default
		 * value: True
		 */
		public boolean outputGrayscaleImage = true;

		/**
		 * When set to true the output includes the original image captured.
		 * Default value: False
		 */
		public boolean outputOriginalImage = true;

		/**
		 * When set to true the output includes the cropped original image
		 * captured. Default value: False
		 */
		public boolean outputColorImage = true;

		/**
		 * When set to True the output includes the black & white image
		 * captured. Default value is True.
		 */
		public boolean outputBinarizedImage = true;

		/** Enable/Disable sound while the countdown is shown Default value: False. */
		public boolean enableCountdownSound = false;

		/**
		 * When set to true will use the custom view that was set up. Default
		 * value: False
		 */
		public boolean customView = false;

		/**
		 * When set to true a new Layout from mbck_camera_layout will be
		 * presented on the screen when processing stage has been started
		 * (@+id/processingOverlay) When set to false the progress bar will be
		 * presented over the camera overlay Default value: True .
		 */
		public boolean showDefaultProcessingView = true;

		/**
		 * When set to YES, will enable multi capture of documents. After each
		 * capture a prompt screen will show up asking the user if he would like
		 * to capture another image. If the user select “Finish” the Library will
		 * call OnActivityResult. After every captured image onMessageReceive
		 * listener will be called withTISFlowActionCallback action
		 * MULTI_CAPTURE, but the camera session will stay
		 * open until the user finishes the multipage session. Default value:
		 * False
		 */
		public boolean multiPageCapture = false;
		
		/**
		 * Indication if a bar-code needs to be found in one of the document side
		 *  Default value: NONE
		 */
		public TISScanBarcodeLocation scanBarcodeLocation = TISScanBarcodeLocation.BARCODE_NONE;
		
		/**
		 * The barcode types that can be read in the document
		 *  Default value: null
		 */
		public ArrayList<TISBarcodeType> barcodeTypes = null;

		/**
		 * Option To change strings.xml values on runtime, the key is the String
		 * id like shows on the Strings.xml. the value is the string to replace,
		 * if some key doesn't has value or all the object is null the default
		 * value will be taken from the Strings.xml (set to null no change from
		 * the original behavior).
		 */
		public HashMap<String, String> dynamicStrings = null;

		/** The gray scale size. */
		public int[] grayScaleSize = null;
		
		/** The micr type. */
		public OCRType ocrType = OCRType.OFF;
	

		/**
		 * Applicable only for devices with at least 1920*1080 video resolution.
		 * When set to YES, the picture will be taken directly from the video
		 * feed when the document is aligned properly with the frame. In this
		 * case it will not switch to still mode and will not present the
		 * countdown sequence. When set to NO, it will switch to still mode to
		 * take the picture. For devices with lower video resolution than
		 * 1920*1080 the image will be taken on still mode even if video feed
		 * processing was set to enabled. Please follow section 3.3.8 for more
		 * details. Default value: False
		 */
		public boolean videoFeedProcessing = false;

		/**
		 * Applicable for still mode only. When set to true, a countdown will be
		 * shown on the screen once the user in a position to take a picture and
		 * frame turns green, the countdown will be show until picture is taken
		 * automatically. When set to false, no countdown will be shown and the
		 * picture will be taken while the frame is green and the user sees the
		 * hold still message on the screen. Default value: False
		 */
		public boolean showCountDown = false;

		
		/**
		 * Front image size, can be used to guarantee equal pixels amount for
		 * front image and back image. When capture front side first and then
		 * the back side.
		 */
		public int[] frontImageSize = null;
//		frontImageSize[0] = 0;
//		frontImageSize[1] = 0;

		/** The max video frames to capture. */
		public int maxVideoFramesToCapture = 7;
		/**
		 * When set to true the same binarization algorithm that runs on the front side will run on the back side of the check.
		 * Default value: False
		 */
		public boolean binarizeBackSameAsFront;
		
		
		public TISFlowUXType uxType  = TISFlowUXType.LIVE;
		
		public TISBinarizationType binarizationType = TISBinarizationType.TIS_GENERAL_BINARIZATION;
		
		public float binarizationThreshold;
		
		
		public boolean enableSoftCapture;
		
		
		public float colorImageCompression = 1.0f;
		
		public float grayscaleImageCompression = 1.0f;
	//	public dynamicCaptureParams dynamicCaptureUiParams;
		public boolean useMaxResolution = false;
		public boolean useCameraAPI2 = false;
		public boolean tapToFocus = true;
        public TISLicenseParameters license;

		public float softCaptureThreshold;
		public boolean animateTransitionInLivePreview = true;


	}

	/**
	 * The Class checkCaptureParams. check parameters
	 */
	public class checkCaptureParams extends baseCaptureParams {



		/**
		 * The minimum micr length the digits recognized for a successful
		 * capture.
		 */
		public int minMICRLength = 15;

		/** The maximum micr length the digits recognized for a successful capture. */
		public int maxMICRLength = 50;

		/**
		 * Instantiates a new check capture params.
		 */
		public checkCaptureParams() {
			ocrType = OCRType.E_138B;
			enableBlurDetection = false;
			videoFeedProcessing = true;
			documnetType = TISDocumentType.CHECK;
			binarizationType = TISBinarizationType.TIS_CHECK_BINARIZATION;
		};

	}


	/**
	 * Gets the capture params.
	 *
	 * @param imageType
	 *            the image type
	 * @return the capture params
	 */

	
	public baseCaptureParams getCaptureParams(TISDocumentType imageType) {
		if (imageType== null){			
			currentImageType = TISDocumentType.PAYMENT;
		}
		else{
			currentImageType = imageType;
		}		
		switch (currentImageType) {
		case CHECK:
			return new checkCaptureParams();
		case PAYMENT:
			return new paymentCaptureParams();
		case CUSTOM:
			return new customCaptureParams();
		case FULL_PAGE:
			return new FullPageCaptureParams();		
		case PASSPORT:
			return new passportParams();
		case CARD:
			return new CardParams();
		default:
			return new baseCaptureParams();
		}

	}

	/**
	 * The Class FullPageCaptureParams.
	 */
	public class FullPageCaptureParams extends baseCaptureParams {

		/**
		 * Instantiates a new full page capture params.
		 */
		public FullPageCaptureParams() {
			enableBlurDetection = true;
			minHeightWidthAspectRatio = 1.35f;
			maxHeightWidthAspectRatio = 1.45f;
			enableIQA = false;
			documnetType = TISDocumentType.FULL_PAGE;
			CameraManagerController.sessionType = SessionType.PORTRAIT;
		};

	}

	/**
	 * The Class paymentCaptureParams.
	 */
	public class paymentCaptureParams extends baseCaptureParams {

		/**
		 * Instantiates a new payment capture params.
		 */
		public paymentCaptureParams() {
			enableBlurDetection = true;
			maxHeightWidthAspectRatio = 0.52f;
			minHeightWidthAspectRatio = 0.35f;
			documnetType = TISDocumentType.PAYMENT;
		};
	}
	
	public class passportParams extends baseCaptureParams {		
		/**
		 * Instantiates a new payment capture params.
		 */
		public passportParams() {
			enableBlurDetection = true;
			maxHeightWidthAspectRatio = 0.65f;
			minHeightWidthAspectRatio = 0.8f;
			documnetType = TISDocumentType.PASSPORT;
			ocrType= OCRType.MRZ;
		};
	}
	
	public class CardParams extends baseCaptureParams {		
		/**
		 * Instantiates a new payment capture params.
		 */
		public CardParams() {
			enableBlurDetection = false;
			maxHeightWidthAspectRatio = 0.7752f; //0.66// 105mm/74mm
			minHeightWidthAspectRatio = 0.6342f;//0.54
			documnetType = TISDocumentType.CARD;			
		};
	}
	
//	public class dynamicCaptureParams{
//		private Context context;
//		public dynamicCaptureParams(Context c){
//			context = c;
//		}
//		public int gridNumberOfRows = 12;
//		public int gridNumberOfcols = 12;
//		public int gridColor = context.getResources().getColor(R.id.§);
//		public int gridWidth;
//		public Color validRectFillColor;
//		public Color validRectStrokeColor;
//		public Color inValidRectStrokeColor;
//		
//	}

	/**
	 * The Class customCaptureParams.
	 */
	public class customCaptureParams extends baseCaptureParams {

		/**
		 * Instantiates a new custom capture params.
		 */
		public customCaptureParams() {
			enableBlurDetection = true;
		};

		/** The is portrait mode. */
		public boolean portraitCapture = false;

	}

	/**
	 * Parses the activity result.
	 *
	 * @param requestCode
	 *            the request code
	 * @param resultCode
	 *            the result code
	 * @param intent
	 *            the intent
	 * @return the session result params
	 */
	public static SessionResultParams parseActivityResult(int requestCode,
			int resultCode, Intent intent) {
	
//		if (CameraManagerController.imageType == TISDocumentType.PASSPORT){			
//			PassportResultParams currentSessionParams = intent
//					.getParcelableExtra(CURRENT_SESSION_PARAMS);
//			currentSessionParams.passportResult = OcrValidationUtils.parsePassportResult(currentSessionParams.getOcrParams()[1]);
//			return currentSessionParams;
//		}
//		else if (CameraManagerController.imageType == TISDocumentType.CARD && CameraManagerController.ocrType == OCRType.PAN){
//			CardResultParams currentSessionParams = intent
//					.getParcelableExtra(CURRENT_SESSION_PARAMS);
//			currentSessionParams.cardResultsByField = OcrValidationUtils.parsePanCardResult(currentSessionParams.getOcrParams()[1]);
//			return currentSessionParams;
//		}
//		else{
		SessionResultParams currentSessionParams = intent
				.getParcelableExtra(CURRENT_SESSION_PARAMS);
		return currentSessionParams;
		//}		
		
	}

	/**
	 * Read file.
	 *
	 * @param file
	 *            the file
	 * @return the byte[]
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	public static byte[] readFile(File file) throws IOException {
		// Open file
		RandomAccessFile f = new RandomAccessFile(file, "r");

		try {
			// Get and check length
			long longlength = f.length();
			int length = (int) longlength;
			if (length != longlength)
				throw new IOException("File size >= 2 GB");

			// Read file and return data
			byte[] data = new byte[length];
			f.readFully(data);
			return data;
		} finally {
			f.close();
		}
	}

	/**
	 * The Interface callbackReturnMessage.
	 * In order to capture messages from the library implement this interface to get a real time messages from the library,
	 *  note that  CameraController.registerListener(this) should be register first; 
	 * and implement callBackMessage interface.
		
	 */
	public static interface callbackReturnMessage {

		/**
		 * On message return.
		 *
		 * @param command
		 *            the command
		 */
		public void onMessageReturn(TISFlowInputMessages command);

		/**
		 * On message return failed.
		 */
		public void onMessageReturnFailed();
		
	}

}