package com.topimagesystems.data;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by mobi1 on 31/01/16.
 */
public class TISLicenseParameters implements Parcelable {
    private String licensee;
    private String licenseKey;
    private String activeLicense ;



    public TISLicenseParameters(String license, String licenseKey, String activeLicense){
        this.licensee = license;
        this.licenseKey = licenseKey;
        this.activeLicense = activeLicense;
    }
    public String getLicense() {
        return licensee;
    }

    public void setLicense(String license) {
        this.licensee = license;
    }

    public String getLicenseKey() {
        return licenseKey;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public String getActiveLicense() {
        return activeLicense;
    }

    public void setActiveLicense(String activeLicense) {
        this.activeLicense = activeLicense;
    }

    protected TISLicenseParameters(Parcel in) {
        licensee = in.readString();
        licenseKey = in.readString();
        activeLicense = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(licensee);
        dest.writeString(licenseKey);
        dest.writeString(activeLicense);
    }

    @SuppressWarnings("unused")
    public static final Parcelable.Creator<TISLicenseParameters> CREATOR = new Parcelable.Creator<TISLicenseParameters>() {
        @Override
        public TISLicenseParameters createFromParcel(Parcel in) {
            return new TISLicenseParameters(in);
        }

        @Override
        public TISLicenseParameters[] newArray(int size) {
            return new TISLicenseParameters[size];
        }
    };
}