/*
 * 
 */
package com.topimagesystems.data;

import com.topimagesystems.controllers.imageanalyze.BarcodeReader.BarcodeResult;

import android.os.Parcel;
import android.os.Parcelable;

// TODO: Auto-generated Javadoc
/**
 * The Class SessionResultParams.
 */
public class SessionResultParams implements Parcelable {
    

    /** The ocr params. */
    private String[] ocrParams;

    /** The barcode params. */
    private String[] barcodeParams;
    
    /** The front image rect. */
    private int[] frontImageRect;
    
    /* private boolean isAutoCaptureFront; private boolean isAutoCaptureBack;
     * private boolean isIQAPassedFront; private boolean isIQAPassedBack; */
    
    /** The digital row length. */
    public static int DIGITAL_ROW_LENGTH = 0;
    
    /** The ocr result with delimeter. */
    public static int OCR_RESULT_WITH_DELIMETER = 1;
    
    /** The ocr raw result. */
    public static int OCR_RAW_RESULT = 2;
    
    /** The score result. */
    public static int SCORE_RESULT = 3;
    
    /** The tiff front. */
    public static byte[] tiffFront;
    
    /** The jpeg bw front. */
    public static byte[] jpegBWFront;
    
    /** The grayscale front. */
    public static byte[] grayscaleFront;
    
    /** The color front. */
    public static byte[] colorFront;
    
    /** The original front. */
    public static byte[] originalFront;
    
    /** The tiff back. */
    public static byte[] tiffBack;
    
    /** The jpeg bw back. */
    public static byte[] jpegBWBack;
    
    /** The grayscale back. */
    public static byte[] grayscaleBack;
    
    /** The color back. */
    public static byte[] colorBack;
    
    /** The original back. */
    public static byte[] originalBack;
    

    /**
     * Instantiates a new session result params.
     */
    public SessionResultParams() {
    }

    /**
     * Gets the ocr params.
     *
     * @return the ocr params
     */
    public String[] getOcrParams() {
	return ocrParams;
    }

    /**
     * Sets the ocr params.
     *
     * @param ocrParams the new ocr params
     */
    public void setOcrParams(String[] ocrParams) {
	this.ocrParams = ocrParams;
    }
    
    /**
     * Gets the barcode results.
     *
     * @return the barcode result object
     */
    public BarcodeResult getBarcodeResult() {
        BarcodeResult barcodeResult = new BarcodeResult(barcodeParams);
        barcodeResult.parse();
	return barcodeResult;
    }


    /**
     * Gets the barcode params.
     *
     * @return the barcode params
     */
    public String[] getBarcodeParams() {
	return barcodeParams;
    }

    /**
     * Sets the barcode params.
     *
     * @param barcodeParams the new barcode params
     */
    public void setBarcodeParams(String[] barcodeParams) {
	this.barcodeParams = barcodeParams;
    }

    
    


    /**
     * Gets the front image rect array.
     *
     * @return the front image rect array
     */
    public int[] getFrontImageRectArray() {
	return frontImageRect;
    }

    /**
     * Instantiates a new session result params.
     *
     * @param _frontImagePath the _front image path
     * @param _backImagePath the _back image path
     * @param _ocrParams the _ocr params
     * @param _getFrontImagePathAsTiff the _get front image path as tiff
     * @param _getBackImagePathAsTiff the _get back image path as tiff
     * @param frontRect the front rect
     * @param retriesNumberFront the retries number front
     * @param retriesNumberBack the retries number back
     * @param _barcodeParams the barcode params
     */
    public SessionResultParams(String[] _ocrParams, int[] frontRect, int retriesNumberFront, int retriesNumberBack, String[] _barcodeParams) {
	if (_ocrParams != null) {
	    ocrParams = _ocrParams;
	}
	if (_barcodeParams != null) {
	    barcodeParams = _barcodeParams;
	}
	if (frontRect != null)
	    frontImageRect = frontRect;

    }
    
    

    /* (non-Javadoc)
     * @see android.os.Parcelable#writeToParcel(android.os.Parcel, int)
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
	dest.writeStringArray(ocrParams);
	dest.writeIntArray(frontImageRect);
	dest.writeStringArray(barcodeParams);
	
	//dest.writeInt(numberOfFaliuresFront);
	//dest.writeInt(numberOfFaliuresBack);
    }

    /**
     * Gets the creator.
     *
     * @return the creator
     */
    public static Parcelable.Creator<SessionResultParams> getCreator() {
	return CREATOR;
    }

    /** The Constant CREATOR. */
    public static final Parcelable.Creator<SessionResultParams> CREATOR = new Parcelable.Creator<SessionResultParams>() {
	public SessionResultParams createFromParcel(Parcel in) {
	    return new SessionResultParams(in);
	}

	public SessionResultParams[] newArray(int size) {
	    return new SessionResultParams[size];
	}

    };

    /**
     * Instantiates a new session result params.
     *
     * @param in the in
     */
    public SessionResultParams(Parcel in) {
	readFromParcel(in);
    }

    /**
     * Read from parcel.
     *
     * @param in the in
     */
    private void readFromParcel(Parcel in) {
	this.ocrParams = in.createStringArray();
	this.frontImageRect = in.createIntArray();
	this.barcodeParams = in.createStringArray();	
    }

    /* (non-Javadoc)
     * @see android.os.Parcelable#describeContents()
     */
    @Override
    public int describeContents() {
	// TODO Auto-generated method stub
	return 0;
    }

    /* public void setBoolFlags(MICRIntent.IntentBoolFlags flags) {
     * isAutoCaptureFront = flags.isAutoCaptureFront; isAutoCaptureBack =
     * flags.isAutoCaptureBack; isIQAPassedFront = flags.isIQAPassedFront;
     * isIQAPassedBack = flags.isIQAPassedBack; }
     * 
     * public boolean getAutoCaptureFront() { return isAutoCaptureFront; }
     * 
     * public boolean getAutoCaptureBack() { return isAutoCaptureBack; }
     * 
     * public boolean getIQAPassedFront() { return isIQAPassedFront; }
     * 
     * public boolean getIQAPassedBack() { return isIQAPassedBack; } */

    /* public int getSessionFaliureNumberFront() { return numberOfFaliuresFront;
     * }
     * 
     * public int getSessionFaliureNumberBack() { return numberOfFaliuresBack; } */

}
