/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Message;
import android.util.Log;

import com.google.zxing.Result;
import com.topimagesystems.Common.OCRType;
import com.topimagesystems.Constants;
import com.topimagesystems.controllers.imageanalyze.CameraController.CameraActivityHandler;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager.CheckInPLaceResult;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.HintIndicator;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent.SessionType;
import com.topimagesystems.intent.CaptureIntent.TISDocumentType;
import com.topimagesystems.micr.BoundingBoxResult;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.micr.OCRCommon.ErrorCode;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.UserInterfaceUtils;

import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.highgui.Highgui;
import org.opencv.imgproc.Imgproc;

import java.util.Date;

// TODO: Auto-generated Javadoc
/**
 * The Class PreviewCallback.
 */
public class PreviewCallback implements Camera.PreviewCallback {

	/** The Constant TAG. */
	private static final String TAG = Logger.makeLogTag("PreviewCallback");

	/** The config manager. */
	private  CameraConfigurationManager configManager;

	/** The mobi checkocr. */
	private MobiCHECKOCR mobiCHECKOCR;

	/** The mat yuv. */
	private Mat matYuv;

	/** The mat rgba. */
	private Mat matRgba;

	private Mat passMat;
	private Mat croppedVideoMat;

	/** The box bitmap. */

	public Bitmap boxBitmap;
	public static boolean processingVideo = false;

	/** The activity. */
	private CameraController activity;

	/** The is front. */
	boolean isFront;

	/** The last focus request time. */
	private long lastFocusRequestTime = 0;

	/** The is focus. */
	private boolean isFocus;

	/** The buffer. */
	private byte[] buffer;

	/** The barcode reader. */
	private BarcodeReader barcodeReader;
	Bundle messageBundle = new Bundle();
	BoundingBoxResult boundingBoxResult = null;
	GenericBoundingBoxResult genericBoundingBoxResult = null;
	int orientation = 0;
	ErrorCode errorCode = null;

	/**
	 * Instantiates a new preview callback.
	 *
	 * @param configManager
	 *            the config manager
	 */
	PreviewCallback(CameraConfigurationManager configManager) {
		this.configManager = configManager;
		processingVideo = false;
		if (CameraController.getInstance()!= null && CameraManagerController.enableBarcodeDetection) {// && barcodeReader != null
			CheckBoundaries cb = CameraManagerController.getOcrAnalyzeSession(activity).getBarcodeBoundariesRectDisp();
			Rect rect = cb.getValidationRect();

			barcodeReader = new BarcodeReader(CameraManagerController.barcodeTypes, rect.x, rect.y, rect.width, rect.height);

		}
	}

	/**
	 * Verify mats.
	 *
	 * @param width
	 *            the width
	 * @param height
	 *            the height
	 */
	private void verifyMats(int width, int height) {

		if (matYuv == null) {
			matYuv = new Mat(height + height / 2, width, CvType.CV_8UC1);
		}
		if (matRgba == null) {
			matRgba = new Mat();
		}

	}

	/**
	 * Sets the activity.
	 *
	 * @param cameraController
	 *            the camera controller
	 * @param mobiCHECKOCR
	 *            the mobi checkocr
	 * @param buffer
	 *            the buffer
	 * @param bufferSize
	 *            the buffer size
	 */
	public void setActivity(CameraController cameraController, MobiCHECKOCR mobiCHECKOCR, byte[] buffer, int bufferSize) {
		this.mobiCHECKOCR = mobiCHECKOCR;
		this.activity = cameraController;
		verifyMats(configManager.getCameraPreviewResolution().x, configManager.getCameraPreviewResolution().y);

	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see android.hardware.Camera.PreviewCallback#onPreviewFrame(byte[],
	 * android.hardware.Camera)
	 */
	public void onPreviewFrame(byte[] data, Camera camera) {
		final Point cameraResolution = configManager.getCameraPreviewResolution();
		final byte[] imgData = data;
		final android.hardware.Camera c = camera;

		Thread thread = new Thread() {
			@Override
			public void run() {
				if (imgData!= null && !CameraController.backPressed) {
					processFrame(imgData, c, cameraResolution.x, cameraResolution.y, null);
				}
			}
		};

		thread.start();

		data = null;

	}

	/**
	 * Process frame.
	 *
	 * @param data
	 *            the data
	 * @param camera
	 *            the camera
	 * @param width
	 *            the width
	 * @param height
	 *            the height
	 */


	public synchronized void  processMat(final byte[] data, final Camera camera, final int width, final int height, final Mat image) {
//		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
//		verifyMats(width, height);
//		matYuv.put(0, 0, data);
//		Imgproc.cvtColor(matYuv, matRgba, Imgproc.COLOR_YUV420sp2RGB, 4);
//			matRgba = matRgba.clone();
//			if (image != null) {
//				image.close();
//			}
//		}
		Thread thread = new Thread() {
			@Override
			public void run() {
				if (data != null || image!= null && !CameraController.backPressed )
					processFrame(data,  camera,  width,  height,image);
			}
		};

		thread.start();
	}



	public void processFrame(byte[] data, final Camera camera, int width, int height, Mat incomingMat) {

		//		if (!CameraController.isCameraOpenShouldBeOpen){
		//			return;
		//		}
		processingVideo = true;
		if (activity == null){
			activity = CameraController.getInstance();
		}
		if ( (data == null && incomingMat == null) ||  activity == null) {

			return;
		}

		errorCode = null;



		try {

			Mat originalVideoMat;

			if (!activity.isValidOrientation()) {
				sendNotValidMessage(HintIndicator.Align, errorCode, null, orientation, null);

				// camera.addCallbackBuffer(buffer);

				return;
			}
			if (incomingMat == null) {
				verifyMats(width, height);
				matYuv.put(0, 0, data);
				Imgproc.cvtColor(matYuv, matRgba, Imgproc.COLOR_YUV420sp2RGB, 4);
			}
			else{
				matRgba = incomingMat;
			}
			if (CameraManagerController.isDebug){
				Logger.i(TAG, "image preview size is: "+matRgba.width()+" "+matRgba.height());
			}
			if (matRgba == null || matRgba.height() == 0 || matRgba.width() == 0 ) {
				sendNotValidMessage(HintIndicator.Align, ErrorCode.errorNoValidBoundingBox, null, orientation, null);
			}
			else{
			//	Highgui.imwrite("/storage/sdcard0/.mobiflow/incomingMat.jpg", matRgba);
			}
		//	if (!CameraManagerController.useCameraAPI2)

			if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == SessionType.PORTRAIT) {

				matRgba = FileUtils.rotateMat(matRgba, 90);
			}
			if (CameraManagerController.deviceName.equals("LGE Nexus 5X")){// Mirroring problem with Nexus 5X device
				matRgba = FileUtils.rotateMat(matRgba, 90);
				matRgba = FileUtils.rotateMat(matRgba, 90);
				data = FileUtils.convertJpgMatToByte(matRgba);
				if (!CameraManagerController.useCameraAPI2 && !CameraManagerController.getOcrAnalyzeSession(activity).isBarcodeSession)
					Imgproc.cvtColor(matRgba, matRgba, Imgproc.COLOR_BGR2RGB, 4);

			}

			else if (!CameraManagerController.isStillMode){
				Imgproc.cvtColor(matRgba, matRgba, Imgproc.COLOR_BGR2RGB, 4);
			}



			//boolean isaved = Highgui.imwrite(baseImagesFolder+ FileUtils.getCurrentTime() + ".jpg",matRgba);

			if (matRgba.width() == 0 || matRgba.height() == 0){
				sendNotValidMessage(null, ErrorCode.notValidBoundaries, null, orientation, null);
				return;
			}

			originalVideoMat = matRgba;

			if (mobiCHECKOCR == null){
				mobiCHECKOCR = CameraController.getInstance().mobiCHECKOCR;
			}
			if (mobiCHECKOCR == null) {
				Logger.e(TAG, "mobichecOCR is null !!");
				sendNotValidMessage(null, ErrorCode.errorInializeOCR, null, orientation, null);
				if (camera!= null)
					camera.addCallbackBuffer(buffer);

				return;
			}

			if (matRgba == null || matRgba.rows() == 0 || matRgba.cols() == 0) {
				Logger.e(TAG, "process frame, couldn't create Mat");
				sendNotValidMessage(null, ErrorCode.emptyImage, null, orientation, null);

				return;
			}

			final boolean isValidContrast = mobiCHECKOCR.isValidContrast(matRgba);
			if (!isValidContrast) {
				sendNotValidMessage(HintIndicator.NoLight, errorCode, null, orientation, null);

				return;
			} else {
				if (mobiCHECKOCR != null) { // locateBorderUsingKmeans
					isFront = (CameraManagerController.getOcrAnalyzeSession(activity).captureMode == CaptureMode.FRONT);
					if (CameraManagerController.isDynamicCapture) {
						croppedVideoMat = new Mat();
						genericBoundingBoxResult = mobiCHECKOCR.findGenericBoundingBox(matRgba, croppedVideoMat);
						CameraSessionManager.getInstance().currCroppedVideoMat = croppedVideoMat;
						if (genericBoundingBoxResult.errorCodeId != -1 || genericBoundingBoxResult.width == 0) {
							errorCode = genericBoundingBoxResult.getErrorCode();
						} else {
							errorCode = ErrorCode.ok;
							boundingBoxResult = new BoundingBoxResult();
							boundingBoxResult.setRect(genericBoundingBoxResult.x, genericBoundingBoxResult.y, genericBoundingBoxResult.width, genericBoundingBoxResult.height);
							boundingBoxResult.setRect(genericBoundingBoxResult.x, genericBoundingBoxResult.y, genericBoundingBoxResult.width, genericBoundingBoxResult.height);
						}
						if (genericBoundingBoxResult.bottomLeftX != 0 && genericBoundingBoxResult.bottomLeftY != 0 && genericBoundingBoxResult.topLeftX != 0
								&& genericBoundingBoxResult.topLeftY != 0) {
							boundingBoxResult.bottomLeft[0] = genericBoundingBoxResult.bottomLeftX;
							boundingBoxResult.bottomLeft[1] = genericBoundingBoxResult.bottomLeftY;
							boundingBoxResult.bottomRight[0] = genericBoundingBoxResult.bottomRightX;
							boundingBoxResult.bottomRight[1] = genericBoundingBoxResult.bottomRightY;
							boundingBoxResult.topLeft[0] = genericBoundingBoxResult.topLeftX;
							boundingBoxResult.topLeft[1] = genericBoundingBoxResult.topLeftY;
							boundingBoxResult.topRight[0] = genericBoundingBoxResult.topRightX;
							boundingBoxResult.topRight[1] = genericBoundingBoxResult.topRightY;
							messageBundle.putBundle(Constants.INTENT_CHECK_RECT, OCRHelper.rectToBundle(boundingBoxResult.getRect(), boundingBoxResult.bottomLeft,
									boundingBoxResult.bottomRight, boundingBoxResult.topLeft, boundingBoxResult.topRight));
						}

					}

					else if (CameraManagerController.imageType != TISDocumentType.PASSPORT) {						
						boundingBoxResult = mobiCHECKOCR.findCheckBoundingBox(matRgba, isFront, true);
//						if (CameraManagerController.getOcrAnalyzeSession(activity).isBarcodeSession && barcodeReader != null && !CameraManagerController.isDynamicCapture) {
//
//							if (CameraManagerController.BarcodeDetectionTries > CameraManagerController.maxBarcodeTries){
//								CameraManagerController.getOcrAnalyzeSession(activity).isBarcodeSession = false;
//								return;
//							}
//							if  (boundingBoxResult.topLeft[0] == 0 &&  boundingBoxResult.topRight[0] == 0){
//								return;
//							}
//							readBarcode(camera, data, matRgba);
//							return;
//						}


						if (boundingBoxResult == null) {
							Logger.e(TAG, "locateBorderUsingApproximateKmeans returned null boundingBoxResult");
							sendNotValidMessage(null, ErrorCode.notValidBoundaries, null, orientation, null);
						}
						errorCode = boundingBoxResult.getErrorCode();
					}




					// for passport get rect from screen dimentation target!
					else {
						Rect screenRect = CameraManagerController.getOcrAnalyzeSession(activity).getCheckBoundariesDisp().getValidationRect();
						boundingBoxResult = new BoundingBoxResult();
						boundingBoxResult.setRect(screenRect.x, screenRect.y, screenRect.width, screenRect.height);
					}
				}

				if (errorCode != null && errorCode != ErrorCode.ok) {
					// error occurred
					if (errorCode == ErrorCode.detectableColor) {
						sendNotValidMessage(HintIndicator.NoLight, errorCode, null, orientation, null);
					} else {
						sendNotValidMessage(null, errorCode, null, orientation, null);
					}
				}
				// look for barcode after we find rectangle
					if (CameraManagerController.getOcrAnalyzeSession(activity).isBarcodeSession && barcodeReader != null) {
						if (CameraManagerController.BarcodeDetectionTries > CameraManagerController.maxBarcodeTries){
							CameraManagerController.getOcrAnalyzeSession(activity).isBarcodeSession = false;
							sendNotValidMessage(HintIndicator.MoveToBARCODE, null, null, 0, null);
						}

						final Mat detectBarcode = CameraManagerController.isDynamicCapture ? croppedVideoMat : matRgba;
						if (CameraManagerController.useCameraAPI2 && !CameraManagerController.isDynamicCapture){
							final byte[] finalData = data;
							Thread thread = new Thread() {
								@Override
								public void run() {
									processingVideo = true;
									if (!readBarcode(camera, finalData, detectBarcode)) {

										sendNotValidMessage(HintIndicator.MoveToBARCODE, null, null, 0, null);
										CameraManagerController.BarcodeDetectionTries++;
										processingVideo = false;

									}
									else{
										sendValidMessage(messageBundle, 0, CameraTypes.MESSAGE_BARCODE_DETECTED);
										processingVideo = false;

									}
									return;
								}
							};

							thread.start();
						}

						else {
							if (!readBarcode(camera, data, detectBarcode)) {

								sendNotValidMessage(HintIndicator.MoveToBARCODE, null, null, 0, null);
								CameraManagerController.BarcodeDetectionTries++;

							} else {
								sendValidMessage(messageBundle, 0, CameraTypes.MESSAGE_BARCODE_DETECTED);

							}
						}

					}

				 else {
					if(boundingBoxResult == null || boundingBoxResult.getRect() == null){
						sendNotValidMessage(null, ErrorCode.notValidBoundaries, null, orientation, null);
						return;
					}
					final Rect checkRect = boundingBoxResult.getRect();
					CheckInPLaceResult checkInPlace = new CheckInPLaceResult();
					// dynamic capture calculate is check in place! 
					if (CameraManagerController.isDynamicCapture) {

						// calc aspect ratio for documnet if needed for dynamic capture.
						double currentBoxAR = (double) checkRect.height / checkRect.width;
						if (CameraManagerController.ocrAnalyzeSession.maxRatioHW > 0 && CameraManagerController.ocrAnalyzeSession.minRatioHW > 0
								&& currentBoxAR > CameraManagerController.ocrAnalyzeSession.maxRatioHW*1.1 || currentBoxAR < CameraManagerController.ocrAnalyzeSession.minRatioHW*0.9) {
							checkInPlace.isInPlace = false;
							checkInPlace.hintIndicator = HintIndicator.None;
							//return result;				
						} else {
							// check image orientation.
							checkInPlace.hintIndicator = CameraSessionManager.getInstance().validateImageOreintation(boundingBoxResult.bottomLeft, boundingBoxResult.topLeft,
									boundingBoxResult.bottomRight, boundingBoxResult.topRight, 6);
							if (checkInPlace.hintIndicator != HintIndicator.Hold) {
								checkInPlace.isInPlace = false;
							} else {
								// compare rects for dynamic capture
								checkInPlace = CameraSessionManager.getInstance().isCheckInPlace(checkRect, boundingBoxResult.sizeIndicator, width, height);
							}

							if (checkInPlace.hintIndicator != HintIndicator.Hold) {
								checkInPlace.isInPlace = false;
								CameraSessionManager.getInstance().resetRectComapreCounter();
							}

						}
					}

					else {
						// static capture.
						checkInPlace = CameraSessionManager.getInstance().isCheckInPlace(checkRect, boundingBoxResult.sizeIndicator, width, height);
					}
					if (checkInPlace.isInPlace || CameraManagerController.imageType == TISDocumentType.PASSPORT) {

						final int timestamp = Math.abs((int) (new Date()).getTime() / 1000);

						CameraManagerController.getOcrAnalyzeSession(activity).timestamp = timestamp;
						CameraManagerController.getOcrAnalyzeSession(activity).setVideoMat(originalVideoMat);
						CameraManagerController.getOcrAnalyzeSession(activity).setVideoBoundingBox(checkRect);
						orientation = UserInterfaceUtils.getScreenOrientation(activity);
						// orientation = boundingBoxResult.orientation;
						String path;
						path = getImagePath(isFront);
						CameraManagerController.getOcrAnalyzeSession(activity).checkRect = checkRect;
						if (isFront) {
							CameraManagerController.getOcrAnalyzeSession(activity).setFrontImagePath(path);
							CameraManagerController.getOcrAnalyzeSession(activity).setFrontImageTIFFPath(path.replace(".jpg", ".tiff"));

						} else {
							CameraManagerController.getOcrAnalyzeSession(activity).setBackImagePath(path);
							CameraManagerController.getOcrAnalyzeSession(activity).setBackImageTIFFPath(path.replace(".jpg", ".tiff"));

						}

						if (CameraManagerController.imageType == TISDocumentType.PASSPORT) {
							readPassport();

							return;
						}
						try {
							croppedVideoMat = originalVideoMat.submat(checkRect);
							CameraSessionManager.getInstance().currCroppedVideoMat = croppedVideoMat;
						}catch (Exception e){ // invalid video mat cropping failed.
							sendNotValidMessage(checkInPlace.hintIndicator = HintIndicator.Align, errorCode, messageBundle, orientation, null);
						}


						if (CameraManagerController.falseRecognitionVideoFrames >= CameraManagerController.maxVideoFramesToProcess) {
							CameraManagerController.isStillMode = true;
						}

						// on the S5 check for focus on stills and video
						if (FileUtils.isSamsungS5() && isFront && CameraManagerController.ocrType == OCRType.OFF
								&& (CameraManagerController.imageType == TISDocumentType.PAYMENT)) {
							boolean isBlur = mobiCHECKOCR.detectBlur(croppedVideoMat, CameraManagerController.isDebug, CameraManagerController.imageType.ordinal(),
									(int) CameraConfigurationManager.captureResolutionHeight * (int) CameraConfigurationManager.captureResolutionWidth, isFront);
							if (isBlur) {

								long currentTime = System.currentTimeMillis();
								// ... do something ...
								long estimatedTime = currentTime - lastFocusRequestTime;

								sendNotValidMessage(checkInPlace.hintIndicator = HintIndicator.Blur, errorCode, messageBundle, orientation, null);
								// get focus after blur frame
								if (!FileUtils.isSamsungS5() && CameraManagerController.imageType != TISDocumentType.CHECK)
									CameraManagerController.falseRecognitionVideoFrames++;
								if (estimatedTime >= 3000) {
									//Log.e(TAG, "focus request previewCallBack ");

									CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, CameraTypes.MESSAGE_AUTO_FOCUS);
									lastFocusRequestTime = System.currentTimeMillis();

									return;
								}

								return;
							}
						}

						// for stills mode video we need to check that the
						// previuos video image is sharp and than
						if (CameraManagerController.isStillMode) {

							sendValidMessage(messageBundle, orientation, CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE);

						} else {
							CameraController.getInstance().runOnUiThread(new Runnable() {
								@Override
								public void run() {
									CameraController.getInstance().showGreenIndicatorForVideo();

								}
							});

							//							//boolean isValid = Highgui.imwrite(path, originalVideoMat);
							//							if (!isValid && CameraManagerController.isDebug){
							//								Log.e(TAG, "failed to save iamge path " + path);
							//							}				
						//	Imgproc.cvtColor(originalVideoMat, originalVideoMat, Imgproc.COLOR_BGR2RGBA);
							if (!CameraManagerController.isStillMode){
								Imgproc.cvtColor(originalVideoMat, originalVideoMat, Imgproc.COLOR_RGB2RGBA, 4);
							}
							try {
								if (isFront) {

									SessionResultParams.originalFront = FileUtils.convertJpgMatToByte(originalVideoMat);
								} else
									SessionResultParams.originalBack = FileUtils.convertJpgMatToByte(originalVideoMat);
							}catch(Exception e){
								sendNotValidMessage(HintIndicator.Align, errorCode, messageBundle, orientation, null);
							}
							CameraManagerController.getOcrAnalyzeSession(activity).setImagePath(path);
							CameraActivityHandler handler;
							if (!CameraManagerController.isDynamicCapture) {
								handler = CameraController.getInstance().handler;
							} else {
								handler = DynamicCaptureCameraController.getInstance().getHandler();
							}
							mobiCHECKOCR.setHandler(handler);
							if (CameraManagerController.imageType == TISDocumentType.PASSPORT
									&& CameraManagerController.getOcrAnalyzeSession(activity).captureMode == CaptureMode.FRONT) {
								readPassport();

								return;
							} else {
								ProcessStillImageThread processStillImageThread = new ProcessStillImageThread(activity, handler, mobiCHECKOCR, true, timestamp);
								processStillImageThread.start();
							}
						}

					} else {

						if (!CameraManagerController.isStillMode && !CameraManagerController.isDynamicCapture) {
							CameraController.getInstance().runOnUiThread(new Runnable() {
								@Override
								public void run() {
									CameraController.getInstance().showRedIndicatorForVideo();
									CameraController.getInstance().cameraOverlayView.invalidate();

								}
							});
						}

						if (activity != null && activity.isDebug()) {
							int timestamp = Math.abs((int) (new Date()).getTime() / 1000);
							FileUtils.addToLogFile(timestamp + " | video invalid rect:" + checkRect.toString(), this.activity);
						}

						sendNotValidMessage(checkInPlace.hintIndicator, errorCode, messageBundle, orientation, null);

					}
				}
			}
		} catch (Exception e) {
			matRgba = null;
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile(TAG, Log.getStackTraceString(e), this.activity);

			}
			sendNotValidMessage(HintIndicator.None, ErrorCode.error_deviceMemory, null, 1, Log.getStackTraceString(e));
		}
		finally {
			processingVideo = false;
		}

	}

	/**
	 * Check for focus before capture.
	 */
	private void checkForFocusBeforeCapture() {
		CameraController.getInstance().cameraSessionManager.requestAutoFocus(null, 0);
	}

	/**
	 * Release.
	 */
	public void release() {

		if (activity != null) {
			activity = null;
		}

		if (mobiCHECKOCR != null) {
			mobiCHECKOCR = null;
		}

		if (matYuv != null) {
			matYuv.release();
			matYuv = null;
		}

		if (matRgba != null) {
			matRgba.release();
			matRgba = null;
		}
		if (buffer != null) {
			buffer = null;
		}

		// barCodeScanner = null;

	}

	/**
	 * Send valid message.
	 *
	 * @param messageBundle
	 *            the message bundle
	 * @param orientation
	 *            the orientation
	 * @param checkRect
	 *            the check rect
	 */
	private void readPassport() {
		Rect PassRect;
		Imgproc.cvtColor(matRgba, matRgba, Imgproc.COLOR_RGB2RGBA, 4);
		if (CameraConfigurationManager.videoResolutionHeight >= 1080 || CameraConfigurationManager.videoResolutionWidth >= 1080){
			 PassRect = new Rect(0, (int) (matRgba.rows() * 0.7), matRgba.cols(), (int) (matRgba.rows() * 0.25) - 1);
		}
		else{
			 PassRect = new Rect(0, (int) (matRgba.rows() * 0.6), matRgba.cols(), (int) (matRgba.rows() * 0.3) - 1);
		}
		// passMat.release();
		passMat = new Mat(matRgba, PassRect);
		OCRResult PassRes = mobiCHECKOCR.readPassport(passMat);
		errorCode = PassRes.getErrorCode();
		CameraManagerController.getOcrAnalyzeSession(activity).setVideoMat(matRgba);
		Logger.i(TAG, "pass res " + PassRes.ocrRawResult + "delimeter " + PassRes.ocrResultWithDelimiter);
		// if something was found send valid message
		if (PassRes.errorCodeId == -1 && PassRes.ocrRawResult.length() > 1) {
			messageBundle.putString(Constants.PASSPORT_OCR_RESULT, PassRes.ocrRawResult);
			messageBundle.putString(Constants.PASSPORT_OCR_RESULT_WITH_DELIMETER, PassRes.ocrResultWithDelimiter);
			messageBundle.putInt(Constants.PASSPORT_OCR_RESULT_LENGTH, PassRes.digitalRowLength);
			Logger.i(TAG, "found pass " + PassRes.ocrRawResult);
			Logger.i(TAG, "found pass  delemetere " + PassRes.ocrResultWithDelimiter);
			float VideoToScreenWidthAR = (float) CameraConfigurationManager.videoResolutionWidth / (float) CameraConfigurationManager.screenResolution.x;
			float VideoToScreenHeightAR = (float) CameraConfigurationManager.videoResolutionHeight / (float) CameraConfigurationManager.screenResolution.y;
			int[] boundingBox = { (int) (boundingBoxResult.x * VideoToScreenWidthAR), (int) (boundingBoxResult.y * VideoToScreenHeightAR),
					(int) (boundingBoxResult.width * VideoToScreenWidthAR), (int) (boundingBoxResult.height * VideoToScreenHeightAR) };
			messageBundle.putIntArray(Constants.INTENT_BOUNDING_BOX_RESULT, boundingBox);
			sendValidMessage(messageBundle, orientation, CameraTypes.PASSPORT_RESULT);
			processingVideo = false;
			return;
		} else {

			long currentTime = System.currentTimeMillis();
			// ... do something ...
			long estimatedTime = currentTime - lastFocusRequestTime;
			if (estimatedTime >= 3000) {
				CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, CameraTypes.MESSAGE_AUTO_FOCUS);
				lastFocusRequestTime = System.currentTimeMillis();
			}

			sendNotValidMessage(HintIndicator.HoldFlat, ErrorCode.errorPassportNotFound, null, orientation, null);
			processingVideo = false;
			return;
		}
	}

	private boolean readBarcode(Camera camera, byte[] data,Mat img) {


		if (CameraManagerController.getOcrAnalyzeSession(activity).isBarcodeSession && barcodeReader != null) {
			orientation = UserInterfaceUtils.getScreenOrientation(activity);

			Result result = barcodeReader.scanImage(data,  CameraConfigurationManager.videoResolutionWidth, CameraConfigurationManager.videoResolutionHeight, orientation,img);

			if (result != null && barcodeReader.getFormats().contains(result.getBarcodeFormat())) {
				CameraManagerController.BarcodeDetectionTries = 0;
				boundingBoxResult = new BoundingBoxResult();
				messageBundle.putString(Constants.BAR_CODE_TYPE, result.getBarcodeFormat().toString());
				messageBundle.putString(Constants.BAR_CODE_DATA, result.getText());
				messageBundle.putBoolean(Constants.INTENT_PROCEED_WITH_PROCESSING, true);
				int[] boundingBox = { (int) (boundingBoxResult.x), (int) (boundingBoxResult.y), (int) (boundingBoxResult.width), (int) (boundingBoxResult.height) };
				messageBundle.putIntArray(Constants.INTENT_BOUNDING_BOX_RESULT, boundingBox);
				return true;

			} else {
				long currentTime = System.currentTimeMillis();
				long estimatedTime = currentTime - lastFocusRequestTime;
				if (estimatedTime >= 3000) {
					CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, CameraTypes.MESSAGE_AUTO_FOCUS);
					lastFocusRequestTime = System.currentTimeMillis();
				}
				if (CameraManagerController.BarcodeDetectionTries >= CameraManagerController.maxBarcodeTries){
					CameraManagerController.getOcrAnalyzeSession(activity).isBarcodeSession = false;
				}


			}

		}
		return false;
	}

	// , CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE
	private void sendValidMessage(Bundle messageBundle, double orientation, int messageToHandle) {
		if (CameraManagerController.isDebug)
			Logger.i(TAG, "got valid message "+ messageToHandle + " " +messageBundle.toString());
		if (activity == null){
			activity = CameraController.getInstance();
		}
		activity.getHandler().removeAllMessages();

		Message message = Message.obtain(activity.getHandler(), messageToHandle);
		if (message != null) {
			message.obj = true;
			messageBundle.putDouble(Constants.INTENT_ORIENTATION, orientation);
			messageBundle.putBoolean(Constants.INTENT_PROCEED_WITH_PROCESSING, false);
			message.setData(messageBundle);
			message.sendToTarget();
		}
		activity = null;
	}

	/**
	 * Send not valid message.
	 *
	 * @param hintIndicator
	 *            the hint indicator
	 * @param errorCode
	 *            the error code
	 * @param checkRect
	 *            the check rect
	 * @param orientation
	 *            the orientation
	 * @param exception
	 *            the exception
	 */
	private void sendNotValidMessage(HintIndicator hintIndicator, ErrorCode errorCode, Bundle messageBundle, double orientation, String exception) {

		if (CameraManagerController.isDebug){
			//Logger.i(TAG, "got invalid message "+ " " + messageBundle. + "");
			if (errorCode != null){
				Logger.i(TAG, "got invalid message "+ " " + errorCode.toString() + "");
			}
		}

		if (activity == null){
			activity = CameraController.getInstance();
		}
		if (CameraController.getInstance().getHandler() == null){
			return;
		}
		Message message = Message.obtain(CameraController.getInstance().getHandler(), CameraTypes.MESSAGE_PROCESS_NOT_VALID);

		if (activity.getHandler()!= null) {
			activity.getHandler().removeAllPreviewProcessingMessages();
		}

		if (message != null) {
			if (messageBundle == null)
				messageBundle = new Bundle();

			message.obj = false;
			if (hintIndicator != null)
				messageBundle.putString(Constants.INTENT_HINT_NAME, hintIndicator.name());

			if (errorCode != null) {
				messageBundle.putString(Constants.INTENT_ERROR_CODE, errorCode.name());
			}
			if (exception != null) {
				messageBundle.putString(Constants.INTENT_EXCEPTION_ERROR, exception);
			}
			messageBundle.putDouble(Constants.INTENT_ORIENTATION, orientation);

			message.setData(messageBundle);
			if (activity != null && message != null) {
				if (activity.getHandler() == null){
					activity.handler = new CameraActivityHandler(CameraController.getInstance(), true);
				}
				activity.getHandler().sendMessage(message);
			}
		}
		activity = null;
	}

	/**
	 * Gets the image path.
	 *
	 * @param isFront
	 *            the is front
	 * @return the image path
	 */
	public static String getImagePath(boolean isFront) {
		String path;
		//String basePath = FileUtils.getHighResImagePath(CameraController.activity) + "/";
		String basePath = CameraController.activity.getFilesDir().getAbsolutePath()+"/"+ FileUtils.tempPath +"/";
		//FileUtils.logFilePath = basePath;
		String currentDateAndTime = FileUtils.getCurrentTime();
		if (isFront)
			path = basePath + "FRONT" + "_" + currentDateAndTime + "_" + ".jpg";
		//path = "/storage/sdcard0/.mobiflow/" + "FRONT" + "_" + s[0] + "_" + s[1] + ".jpg";
		else
			path = basePath + "BACK" + "_" + currentDateAndTime + "_" + ".jpg";
		//path = "/storage/sdcard0/.mobiflow/" + "BACK" + "_" + s[0] + "_" + s[1] + ".jpg";

		return path;

	}
}