/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import com.topimagesystems.util.Logger;

import android.os.IBinder;

// TODO: Auto-generated Javadoc
/**
 * The Class FlashlightManager.
 */
final class FlashlightManager {

	/** The Constant TAG. */
	private static final String TAG = Logger.makeLogTag("FlashlightManager");

	/** The Constant iHardwareService. */
	private static final Object iHardwareService;
	
	/** The Constant setFlashEnabledMethod. */
	private static final Method setFlashEnabledMethod;
	static {
		iHardwareService = getHardwareService();
		setFlashEnabledMethod = getSetFlashEnabledMethod(iHardwareService);
		if (iHardwareService == null) {
			Logger.v(TAG, "This device does supports control of a flashlight");
		}
		else {
			Logger.v(TAG, "This device does not support control of a flashlight");
		}
	}

	/**
	 * Instantiates a new flashlight manager.
	 */
	private FlashlightManager() {
	}

	/**
	 * Gets the hardware service.
	 *
	 * @return the hardware service
	 */
	private static Object getHardwareService() {
		Class<?> serviceManagerClass = maybeForName("android.os.ServiceManager");
		if (serviceManagerClass == null) {
			return null;
		}

		Method getServiceMethod = maybeGetMethod(serviceManagerClass, "getService", String.class);
		if (getServiceMethod == null) {
			return null;
		}

		Object hardwareService = invoke(getServiceMethod, null, "hardware");
		if (hardwareService == null) {
			return null;
		}

		Class<?> iHardwareServiceStubClass = maybeForName("android.os.IHardwareService$Stub");
		if (iHardwareServiceStubClass == null) {
			return null;
		}

		Method asInterfaceMethod = maybeGetMethod(iHardwareServiceStubClass, "asInterface", IBinder.class);
		if (asInterfaceMethod == null) {
			return null;
		}

		return invoke(asInterfaceMethod, null, hardwareService);
	}

	/**
	 * Gets the sets the flash enabled method.
	 *
	 * @param iHardwareService the i hardware service
	 * @return the sets the flash enabled method
	 */
	private static Method getSetFlashEnabledMethod(Object iHardwareService) {
		if (iHardwareService == null) {
			return null;
		}
		Class<?> proxyClass = iHardwareService.getClass();
		return maybeGetMethod(proxyClass, "setFlashlightEnabled", boolean.class);
	}

	/**
	 * Maybe for name.
	 *
	 * @param name the name
	 * @return the class
	 */
	private static Class<?> maybeForName(String name) {
		try {
			return Class.forName(name);
		}
		catch (ClassNotFoundException cnfe) {
			// OK
			return null;
		}
		catch (RuntimeException re) {
			Logger.w(TAG, "Unexpected error while finding class " + name, re);
			return null;
		}
	}

	/**
	 * Maybe get method.
	 *
	 * @param clazz the clazz
	 * @param name the name
	 * @param argClasses the arg classes
	 * @return the method
	 */
	private static Method maybeGetMethod(Class<?> clazz, String name, Class<?>... argClasses) {
		try {
			return clazz.getMethod(name, argClasses);
		}
		catch (NoSuchMethodException nsme) {
			// OK
			return null;
		}
		catch (RuntimeException re) {
			Logger.w(TAG, "Unexpected error while finding method " + name, re);
			return null;
		}
	}

	/**
	 * Invoke.
	 *
	 * @param method the method
	 * @param instance the instance
	 * @param args the args
	 * @return the object
	 */
	private static Object invoke(Method method, Object instance, Object... args) {
		try {
			return method.invoke(instance, args);
		}
		catch (IllegalAccessException e) {
			Logger.w(TAG, "Unexpected error while invoking " + method, e);
			return null;
		}
		catch (InvocationTargetException e) {
			Logger.w(TAG, "Unexpected error while invoking " + method, e.getCause());
			return null;
		}
		catch (RuntimeException re) {
			Logger.w(TAG, "Unexpected error while invoking " + method, re);
			return null;
		}
	}

	/**
	 * Enable flashlight.
	 */
	static void enableFlashlight() {
		setFlashlight(true);
	}

	/**
	 * Disable flashlight.
	 */
	static void disableFlashlight() {
		setFlashlight(false);
	}

	/**
	 * Sets the flashlight.
	 *
	 * @param active the new flashlight
	 */
	private static void setFlashlight(boolean active) {
		if (iHardwareService != null) {
			invoke(setFlashEnabledMethod, iHardwareService, active);
		}
	}
}
