package com.topimagesystems.controllers.imageanalyze;

import java.io.IOException;
import java.util.Locale;

import org.opencv.core.Rect;

import com.topimagesystems.Constants;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager.State;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.HintIndicator;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.NEXT_ACTION;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowGeneralMessages;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowUIMessages;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.OCRCommon.ErrorCode;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.OcrValidationUtils;
import com.topimagesystems.util.StringUtils;

import android.content.Intent;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.widget.RelativeLayout;

public class DynamicCaptureCameraController extends CameraController implements CaptureIntent.callbackReturnMessage {
	static double M_PI =  3.14159265358979323846264338327950288;

	@Override
	protected void initUI() {
		// TODO Auto-generated method stub
		// super.initUI();
		layoutRoot = new RelativeLayout(this);
		RelativeLayout.LayoutParams rlp = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
		layoutRoot.setLayoutParams(rlp);

		RelativeLayout.LayoutParams previewSurfaceParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);

		surfaceView = new SurfaceView(getApplicationContext());
		surfaceView.setLayoutParams(previewSurfaceParams);
		layoutRoot.addView(surfaceView);
		Logger.i(TAG, "surfaceView added");
		activity = this;
		
		dynamicCameraOverlayView = (DynamicCameraOverlayLayout) getLayoutInflater().inflate(R.layout.dynmaic_capture_overlay, null);
		dynamicCameraOverlayView.setActionClickListener(new ActionClickListenerImpl());
		dynamicCameraOverlayView.setWillNotDraw(false);
		if (CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).isBarcodeSession)
			//dynamicCameraOverlayView.setCheckBoundariesRect(CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).getBarcodeBoundariesRectDisp());
			dynamicCameraOverlayView.invalidate();

		videoImageTaken = false;

		layoutRoot.addView(dynamicCameraOverlayView);
		if (doOcrOnly) {
			// cameraOverlayView.showProcessingOverlay(true);
		}
		setContentView(layoutRoot);
		// sensor manager for orientation
		sensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
		//dynamicCameraOverlayView.setCameraController(this);

		handler = null;
		isSurfaceCreated = false;
		if (getIntent() != null) {
			isBinarizeCurrentImageAsIs = getIntent().getBooleanExtra(CameraManagerController.INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS, false);
			isInfoScreenEnable = getIntent().getBooleanExtra(CaptureIntent.INFO_SCREEN_ENABLED, isInfoScreenEnable);
			infoScreenInterval = getIntent().getLongExtra(CaptureIntent.INFO_SCREEN_INTERVAL, infoScreenInterval);
		}		
	}
	
	@Override
	 protected void proceedSuccessfullFront(String dialogTitleMessage) {		
		showProceedingDialog(dialogTitleMessage, StringUtils.dynamicString(this, "TISFlowPleaseCaptureCheckBack"), NEXT_ACTION.CAPTURE_BACK);
	}
	@Override
	protected void initCamera(SurfaceHolder surfaceHolder, boolean isTorchOn) {
		// TODO Auto-generated method stub		
		try {
			Logger.i(TAG, "isSurfaceCreated  init camera");

			if ((CameraManagerController.deviceName.equals("LGE Nexus 5X") || CameraManagerController.invertedCamera) && !CameraManagerController.useCameraAPI2 ){
				cameraSessionManager.openDriver(surfaceHolder);
			}
			else if (CameraManagerController.useCameraAPI2){
				cameraSessionManager.openCamera2Api(isTorchOn);
			}
			else{
				cameraSessionManager.openCamera(surfaceHolder,isTorchOn);
			}
			// Creating the handler starts the preview, which can also throw a
			// RuntimeException.

			handleFlashSupport();

			if (handler == null) {
				handler = new DynamicCameraActivityHandler(this, true);
			}
			mobiCHECKOCR.setHandler(handler);
			handleProcessPreviouslyCapturedImage();
		} catch (IOException ioe) {
			Logger.w(TAG, "IOException", ioe);
		//	displayFrameworkBugMessageAndExit(StringUtils.dynamicString(this, "failedConnectToCamera"));

//			Intent data = new Intent();
//			data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, exception);
//			looperActivity.get().setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
//			looperActivity.get().finish();
//			
			
		} catch (RuntimeException e) {
			// Barcode Scanner has seen crashes in the wild of this variety:
			// java.?lang.?RuntimeException: Fail to connect to camera service
			Logger.w(TAG, "Unexpected error initializating camera", e);
			//displayFrameworkBugMessageAndExit(StringUtils.dynamicString(this, "failedConnectToCamera"));
//			Intent data = new Intent();
//			data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, exception);
//			looperActivity.get().setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
//			looperActivity.get().finish();
		}
	}

	@Override
	protected void onDestroy() {	
		if (camera!= null){
			camera.release(); // for hp notify
		}
		releaseCameraAndResources();
		try{
		if (mobiCHECKOCR != null) {
			mobiCHECKOCR.release();
			mobiCHECKOCR = null;
			
		}
		super.onDestroy();
		}catch(Exception e){			
			if (CameraManagerController.isDebug){				
				Logger.e(TAG, Log.getStackTraceString(e));
				FileUtils.addToLogFile(Log.getStackTraceString(e),this);
			}
		}

	}
	
	
	
	public static class DynamicCameraActivityHandler extends CameraActivityHandler {
		public DynamicCameraActivityHandler(CameraController cameraController, boolean startPreview) {
			super(cameraController, startPreview);
			// TODO Auto-generated constructor stub
		}



		/** The next frame delay max interval. */
			
//		DynamicCameraActivityHandler(CameraController cameraController, boolean startPreview) {			
//			looperActivity = new WeakReference<CameraController>(cameraController);
//			initProceedingToNextFrameDelay();
//			if (startPreview)
//				startPreview();
//		}
				

		/*
		 * (non-Javadoc)
		 * 
		 * @see android.os.Handler#handleMessage(android.os.Message)
		 */
		final CameraController cameraController = looperActivity.get();
		@Override
		public void handleMessage(Message message) {
			// if (returnAfterMaxTry){
			// CameraManagerController.
			// }
			final Bundle messageData = message.getData();
			OCRResult result;
			
			if (cameraController == null) {
				Logger.e(TAG, "handleMessage cameraController reference is null");
				return;
			}
			Logger.i(TAG, "handler processing message:" + message.what);
			switch (message.what) {

			case CameraTypes.MESSAGE_SHOW_COUNTER:
				Logger.i(TAG, "MESSAGE_SHOW_COUNTER");
				int elapsedTime = message.arg1;
			
				if (CameraManagerController.isDebug && cameraController != null && cameraController.getBaseContext() != null) {
					FileUtils.addToLogFile("MESSAGE_SHOW_COUNTER", cameraController.getBaseContext());
				}
				break;

			case CameraTypes.MESSAGE_HIDE_HINT_INDICATOR:

				if (CameraManagerController.isDebug && cameraController != null && cameraController.getBaseContext() != null) {
					FileUtils.addToLogFile("MESSAGE_HIDE_HINT_INDICATOR", cameraController.getBaseContext());
				}

				break;

			case CameraTypes.MESSAGE_SHOW_PROCESSING_LABEL:
				Logger.i(TAG, "MESSAGE_SHOW_PROCESSING_LABEL");
				cameraController.onSentUIEventMessage(TISFlowUIMessages.BEFORE_PROCESSING);
				String text = (String) message.obj;
				if (!CameraManagerController.isStillMode) {
					if (text.toLowerCase(Locale.getDefault()).contains("processing")) {
						Logger.d(TAG, "debug");
					}
				
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_SHOW_PROCESSING_LABEL", cameraController.getBaseContext());
				}

				break;
					
			case CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT:
				Logger.i(TAG, "MESSAGE_HIDE_BOUNDARIES_RECT");
				if (cameraController.isDebug || drawFoundedRectangle) {
					//cameraController.dynamicOverlayLayoutView.showCheckBoundyRect(false, null);
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_HIDE_BOUNDARIES_RECT", cameraController.getBaseContext());
				}
				break;

			case CameraTypes.MESSAGE_HIDE_ERROR_MESSAGE:

				Logger.i(TAG, "MESSAGE_HIDE_ERROR_MESSAGE");
			

				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_HIDE_ERROR_MESSAGE", cameraController.getBaseContext());
				}
				break;

			case CameraTypes.MESSAGE_AUTO_FOCUS:
				Logger.i(TAG, "MESSAGE_AUTO_FOCUS");
				// continuous auto focus
				if (cameraController.cameraSessionManager.getState() == State.PREVIEW) {
					cameraController.cameraSessionManager.requestAutoFocus(this, CameraTypes.MESSAGE_AUTO_FOCUS);
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_AUTO_FOCUS", cameraController.getBaseContext());
				}
				break;
			case CameraTypes.MESSAGE_RESTART_PREVIEW:
				Logger.i(TAG, "MESSAGE_RESTART_PREVIEW");
				Logger.d(TAG, "Got restart preview message");
				restartPreviewAndDecode();
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_RESTART_PREVIEW", cameraController.getBaseContext());
				}
				break;
			case CameraTypes.MESSAGE_PROCESS_NOT_VALID:
				String hintName = messageData.getString(Constants.INTENT_HINT_NAME);
				final String errorCodeName = messageData.getString(Constants.INTENT_ERROR_CODE);
				final Bundle checkRectBundle = messageData.getBundle(Constants.INTENT_CHECK_RECT);
				
				final double orientation = messageData.getDouble(Constants.INTENT_ORIENTATION, 0);
				Log.i("MESSAGE_PROCESS_NOT_VALID", "MESSAGE_PROCESS_NOT_VALID");				
				if (!StringUtils.isEmptyOrNull(hintName)) {
					HintIndicator hintIndicator = HintIndicator.valueOf(hintName);
					// in no light cell phone may be lying and not in use.
					// if these messages comes in certain frequency in a row we
					// need to update
					// delay the proceeding to next frame.
					checkNextFrameDelay(hintIndicator);
					cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);

					//cameraController.cameraOverlayView.showCheckBoundyRect(false, null);
				}								
				HintIndicator hintIndicator =  HintIndicator.None;
				if (checkRectBundle != null && checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_LEFT )!= null){
//					hintIndicator = HintIndicator.ZoomIn;
//					cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);					
					if (!StringUtils.isEmptyOrNull(hintName)) {
						 hintIndicator = HintIndicator.valueOf(hintName);
					}

					cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);

					Log.i("checkRectBundle != null", "checkRectBundle != null");					
					cameraController.dynamicCameraOverlayView.isValidRect = false;		
					boolean drawRect = true;
					if (hintIndicator == HintIndicator.AspectRatioFailed){
						hintIndicator = HintIndicator.None;// dont show hint when AR is not match, to be align with iOS.
						drawRect = false;
					}

					cameraController.dynamicCameraOverlayView.isRectFound = drawRect;
					cameraController.dynamicCameraOverlayView.bottomLeft = checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_LEFT);
					cameraController.dynamicCameraOverlayView.bottomRight = checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_RIGHT);
					cameraController.dynamicCameraOverlayView.topRight = checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_RIGHT);
					cameraController.dynamicCameraOverlayView.topLeft = checkRectBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_LEFT);
					CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectBundle);
				}
				else{
					cameraController.dynamicCameraOverlayView.isRectFound = false;
					
				}
				cameraController.dynamicCameraOverlayView.invalidate();
				if (!StringUtils.isEmptyOrNull(hintName)) {
					 hintIndicator = HintIndicator.valueOf(hintName);
					// in no light cell phone may be lying and not in use.
					// if these messages comes in certain frequency in a row we
					// need to update
					// delay the proceeding to next frame.
					checkNextFrameDelay(hintIndicator);
				
				}

				if (!StringUtils.isEmptyOrNull(errorCodeName)) {
					final ErrorCode errorCode = ErrorCode.valueOf(errorCodeName);
					if (errorCode == ErrorCode.error_deviceMemory) {
						final String exception = messageData.getString(Constants.INTENT_EXCEPTION_ERROR);
						Intent data = new Intent();
						data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, exception);
						looperActivity.get().setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
						looperActivity.get().finish();
						return;
					}
			
				}

				if (cameraController.isDebug || drawFoundedRectangle) {
					if (checkRectBundle != null) {
						Rect rect = OCRHelper.bundleToRect(checkRectBundle);
			
						dispatchHintIndicator(messageData);
						sendEmptyMessageDelayed(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT, CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY);
					}
				}

				proceedWithProcessing();
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_PROCESS_NOT_VALID", cameraController.getBaseContext());
				}
				break;

				case CameraTypes.ID_CARD_RESULT:
					if (CameraManagerController.isDebug) {
						FileUtils.addToLogFile("ID_CARD_RESULT", cameraController.getBaseContext());
					}
					cameraController.currentCallBack = TISFlowGeneralMessages.ID_CARD_OCR_RESULT;
					cameraController.currentError = null;
					String idResult[] = new String[4];
					result = (OCRResult) message.obj;
					idResult[0] = String.valueOf(result.digitalRowLength);
					idResult[1] = result.ocrResultWithDelimiter;
					idResult[2] = result.ocrRawResult;
					idResult[3] = result.scoreResult;
					// for video first check internal validation after call callig app for OCR aproval.
					if (!CameraManagerController.isStillMode) {
						listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, idResult, looperActivity.get().dynamicCameraOverlayView.getContext());
					}
					// stills we can't ask another frame - close session.
					else {
						cameraController.activityResultFinish(result.isValidRead);
					}
					break;

			case CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE:
				// cameraController.currentCallBack =
				// TISFlowActionCallback.START_PROCESSING_IMAGE;
				// cameraController.currentError = null;
				// listener.onMessageReceive(cameraController.currentCallBack,
				// cameraController.currentError,
				// null,looperActivity.get().cameraOverlayView.getContext());
				Logger.i(TAG, "MESSAGE_CAPTURE_STILL_IMAGE");
	
				initProceedingToNextFrameDelay();

				if (cameraController.isFinishing())
					return;

				Bundle bundleCaptureStillImage = messageData;
				if (cameraController.cameraSessionManager.getState() == State.PREVIEW) {
					// cameraSessionManager.update

					final Bundle checkRectCaptureBundle = bundleCaptureStillImage.getBundle(Constants.INTENT_CHECK_RECT);
					Rect rect = OCRHelper.bundleToRect(checkRectCaptureBundle);
				
					
					
					cameraController.dynamicCameraOverlayView.bottomLeft = checkRectCaptureBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_LEFT);
					cameraController.dynamicCameraOverlayView.bottomRight = checkRectCaptureBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_BOTTOM_RIGHT);
					cameraController.dynamicCameraOverlayView.topRight = checkRectCaptureBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_RIGHT);
					cameraController.dynamicCameraOverlayView.topLeft = checkRectCaptureBundle.getFloatArray(Constants.INTENT_CHECK_QUADS_TOP_LEFT);
					
					cameraController.dynamicCameraOverlayView.isValidRect = true;				
					cameraController.dynamicCameraOverlayView.isRectFound = true;
					
					CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectCaptureBundle);					
					cameraController.dynamicCameraOverlayView.invalidate();
					hintIndicator = HintIndicator.Hold;					
					cameraController.dynamicCameraOverlayView.showIndicator(hintIndicator, true);
					cameraController.dynamicCameraOverlayView.invalidate();
					if (cameraController.cameraSessionManager.getMatchRectsCounter() >= CameraManagerController.identicalRectanglesToCapture){
					CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).orientation = bundleCaptureStillImage
							.getDouble(Constants.INTENT_ORIENTATION);

					// to be sure remove all messages
					removeAllMessages();
					
					captureStillImage();
					}
					else{
						proceedWithProcessing();
					}
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_CAPTURE_STILL_IMAGE", cameraController.getBaseContext());
				}
	

				break;
			case CameraTypes.MESSAGE_BARCODE_DETECTED:
				Logger.i(TAG, "MESSAGE_BARCODE_DETECTED");
				if (cameraController.cameraSessionManager.getState() == State.PREVIEW) {

					OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext());

					String barcodeType = messageData.getString(Constants.BAR_CODE_TYPE);
					String barcodeData = messageData.getString(Constants.BAR_CODE_DATA);

					if (ocrAnalyzeSession.captureMode == CaptureMode.FRONT) {
						ocrAnalyzeSession.setFrontBarcodeType(barcodeType);
						ocrAnalyzeSession.setFrontBarcodeData(barcodeData);
					} else {
						ocrAnalyzeSession.setBackBarcodeType(barcodeType);
						ocrAnalyzeSession.setBackBarcodeData(barcodeData);
					}

				//	cameraController.dynamicCameraOverlayView.startFadeoutAnimationForBoundaries();
					Handler handler = new Handler(cameraController.getApplicationContext().getMainLooper());
					handler.postDelayed(new Runnable() {
						public void run() {
							cameraController.dynamicCameraOverlayView.clearBoundariesRect();
							proceedWithProcessing();
						}
					}, 1000);
					
					
					

					ocrAnalyzeSession.isBarcodeSession = false;
				} else
					proceedWithProcessing();

				break;
			case CameraTypes.MESSAGE_ERROR:
				Logger.i(TAG, "MESSAGE_ERROR");
				if (!CameraManagerController.isStillMode) {
					proceedWithProcessing();
				} else {
					String errorMessage = (String) message.obj;
					Intent data = new Intent();
					Logger.e(TAG, errorMessage);
					data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, errorMessage);
					activity.setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
					activity.finish();
					break;
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_ERROR", cameraController.getBaseContext());
				}

				break;
			case CameraTypes.MESSAGE_PROCESS_PRE_CAPTURED_IMAGE:
				Logger.i(TAG, "MESSAGE_PROCESS_PRE_CAPTURED_IMAGE");
				if (CameraManagerController.isStillMode)
					stopPreview();
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_PROCESS_PRE_CAPTURED_IMAGE", cameraController.getBaseContext());
				}
				break;
			// and the rest as in MESSAGE_PROCESS_CAPTURED_IMAGE
			case CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE:
				Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE");				
				cameraController.dynamicCameraOverlayView.isRectFound = false;
				cameraController.dynamicCameraOverlayView.invalidate();				
				if (CameraManagerController.isStillMode) {
					cameraController.cameraSessionManager.stopPreviewOnly();	
				}
				cameraController.dynamicCameraOverlayView.showProcessImg();

				String imagePath = (String) message.obj;
				// to be sure, remove all messages
				if (CameraManagerController.isStillMode)
					removeAllMessages();

				if (CameraManagerController.scanBackOnly) { // only for back
															// capture
					// cameraController.startBinarizationAfterFaliure(imagePath);
					cameraController.processCapturedImage(imagePath); // for
																		// front
																		// capture
					CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).frontImageRect = FileUtils.arrayToRect(getFrontImageArrayValues());
				} else {
					cameraController.processCapturedImage(imagePath); // for
																		// front
																		// capture
				}

				break;
			case CameraTypes.CHECK_MICR_RESULT:
				cameraController.currentCallBack = TISFlowGeneralMessages.CHECK_OCR_RESULT;
				cameraController.currentError = null;
				String ocrResult[] = new String[4];
				result = (OCRResult) message.obj;
				ocrResult[0] = String.valueOf(result.digitalRowLength);
				ocrResult[1] = result.ocrResultWithDelimiter;
				ocrResult[2] = result.ocrRawResult;
				ocrResult[3] = result.scoreResult;
				// for video first check internal validation after call callig app for OCR aproval.
				if (!CameraManagerController.isStillMode) {				
					listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, ocrResult, looperActivity.get().dynamicCameraOverlayView.getContext());
					} 									
				// stills we can't ask another frame - close session.
				else {
					cameraController.activityResultFinish(result.isValidRead);
				}
				break;
			case CameraTypes.PAN_CARD_RESULT:
				cameraController.currentCallBack = TISFlowGeneralMessages.PAN_CARD_OCR_RESULT;
				cameraController.currentError = null;
				String panResult[] = new String[4];				
				result = (OCRResult) message.obj;
				panResult[0] = String.valueOf(result.digitalRowLength);
				panResult[1] = result.ocrResultWithDelimiter;
				panResult[2] = result.ocrRawResult;
				panResult[3] = result.scoreResult;
				// for video first check internal validation after call callig app for OCR aproval.
				if (!CameraManagerController.isStillMode) {
					if (OcrValidationUtils.validationPanCard(result.ocrResultWithDelimiter)) {
						listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, panResult, looperActivity.get().dynamicCameraOverlayView.getContext());
					} else { // ask focus on video when validation didn't pass
						cameraController.cameraSessionManager.requestAutoFocus(this, CameraTypes.MESSAGE_AUTO_FOCUS);
						proceedWithProcessing();
					}
				}
				// stills we can't ask another frame - close session.
				else {
					cameraController.activityResultFinish(result.isValidRead);
				}
				break;
			case CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT:
				Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT");
				// cameraController.currentCallBack =
				// TISFlowActionCallback.FINISH_PROCESSING_IMAGE;
				// cameraController.currentError = null;
				// listener.onMessageReceive(cameraController.currentCallBack,
				// cameraController.currentError,null,looperActivity.get().cameraOverlayView.getContext());
				
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT", cameraController.getBaseContext());
				}
				result = (OCRResult) message.obj;
				// processCapturedImageResult(result);				
				if (!CameraManagerController.isStillMode) {
					if (result.isValidRead)
						cameraController.activityResultFinish(result.isValidRead);
					else {
						if (cameraController.continueVideoModeOrShowAlert()){
							//cameraController.onSentUIEventMessage(TISFlowUIMessages.AFTER_PROCESSING);						
							proceedWithProcessing();
						}
						else
							cameraController.activityResultFinish(result.isValidRead);

					}

				} else {
					cameraController.activityResultFinish(result.isValidRead);
				}
				break;
			case CameraTypes.MESSAGE_CONTINUE_ANYWAY:
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_CONTINUE_ANYWAY", cameraController.getBaseContext());
				}
				cameraController.activityResultFinish(true);
				break;
				


			case CameraTypes.MESSAGE_TOGGLE_TORCH:
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_TOGGLE_TORCH", cameraController.getBaseContext());
				}
				CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).isTorchOn = (Boolean) message.obj;
				restartPreview();
				cameraController.dynamicCameraOverlayView.enableTorchButton(true);
				break;
			}
		}

		
		double calAngleBetweenPoints(float[] first, float[] second){		
			float heigth1 = (second[1] - first[1]);
			float width1 = (second[0] - first[0]);
			float rads = (float) Math.atan2(heigth1, width1);
			return (180.0 * rads / M_PI);
		}
		
		/**
		 * Gets the front image array values.
		 *
		 * @return the front image array values
		 */
		private int[] getFrontImageArrayValues() {
			if (CameraManagerController.frontImageRectArray == null) {
				CameraManagerController.frontImageRectArray = new int[4];
				CameraManagerController.frontImageRectArray[0] = 0;
				CameraManagerController.frontImageRectArray[1] = 0;
				CameraManagerController.frontImageRectArray[2] = 1200;
				CameraManagerController.frontImageRectArray[3] = 600;
			}

			return CameraManagerController.frontImageRectArray;

		}		
		

		/**
		 * Inits the proceeding to next frame delay.
		 */
//		private void initProceedingToNextFrameDelay() {
//			lastTimeWasreceived = 0;
//			notOptimalStateCounter = 0;
//			proceedingToNextFrameDelay = 0;
//		}

		/**
		 * Check next frame delay.
		 *
		 * @param hintIndicator
		 *            the hint indicator
		 */
//		private void checkNextFrameDelay(HintIndicator hintIndicator) {
//			if (hintIndicator == HintIndicator.NoLight) {
//				long currentTimeWasreceived = Calendar.getInstance().getTimeInMillis();
//				long timeDelta = currentTimeWasreceived - lastTimeWasreceived;
//
//				if (lastTimeWasreceived > 0 && timeDelta <= NEXT_FRAME_DELAY_MAX_INTERVAL) {
//					if (notOptimalStateCounter > NEXT_FRAME_DELAY_COUNTER_STEP_TRIGGER) {
//						long multiplier = notOptimalStateCounter / NEXT_FRAME_DELAY_COUNTER_STEP_TRIGGER;
//						long nextDelay = NEXT_FRAME_DELAY_COUNTER_STEP_MULITPLIER * multiplier;
//						nextDelay = nextDelay > NEXT_FRAME_MAX_DELAY ? NEXT_FRAME_MAX_DELAY : nextDelay;
//						proceedingToNextFrameDelay = nextDelay;
//					}
//					notOptimalStateCounter++;
//				}
//				lastTimeWasreceived = currentTimeWasreceived;
//
//			} else {
//				initProceedingToNextFrameDelay();
//			}
//		}

		/**
		 * Dispatch hint indicator.
		 *
		 * @param messageData
		 *            the message data
		 */
		private void dispatchHintIndicator(final Bundle messageData) {
			CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "dispatchHintIndicator cameraController reference is null");
				return;
			}
			if (messageData != null) {
				final String hintIndicatorName = messageData.getString(Constants.INTENT_HINT_NAME);
				if (!StringUtils.isEmptyOrNull(hintIndicatorName)) {
					HintIndicator indicator = HintIndicator.valueOf(hintIndicatorName);				
				}
			}
		}

		/**
		 * Proceed with processing.
		 */
		private void proceedWithProcessing() {
			// delay next process if necessary
			final CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "proceedWithProcessing cameraController reference is null");
				return;
			}

			if (cameraController.isFinishing())
				return;

			postDelayed(new Runnable() {
				@Override
				public void run() {
					cameraController.cameraSessionManager.requestPreviewFrame(activity, cameraController.mobiCHECKOCR);
				}
			}, proceedingToNextFrameDelay);

		}

		/**
		 * Capture still image.
		 */
		private void captureStillImage() {
			Logger.i(TAG, "captureStillImage");
		//	disableInfoScreenOnProcess = true;
			final CameraController cameraController = looperActivity.get();
			// cameraController.cameraOverlayView.setConfirmationIndicators();
			

			postDelayed(new Runnable() {
				@Override
				public void run() {
					cameraController.cameraSessionManager.requestCaptureStillImage(activity.handler, CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE,
							CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).captureMode);
				}
			}, 100);
		}

		
		/**
		 * Restart preview.
		 */
		private void restartPreview() {
			stopPreview();
			startPreview();
		}
		
	
		

		/**
		 * Start preview.
		 */
		protected void startPreview() {
			CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "startPreview cameraController reference is null");
				return;
			}
			cameraController.cameraSessionManager.startPreview(CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).isTorchOn);
			restartPreviewAndDecode();
		}

		/**
		 * Stop preview.
		 */
		public void stopPreview() {
			CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "stopPreview cameraController reference is null");
				return;
			}
			cameraController.cameraSessionManager.setState(State.DONE);
			cameraController.cameraSessionManager.stopPreview();
		}

		/**
		 * Quit synchronously.
		 */
		public void quitSynchronously() {
			stopPreview();
			// remove all queued messages
			removeAllMessages();
		}

		/**
		 * Removes the all messages.
		 */
		public void removeAllMessages() {
			removeMessages(CameraTypes.MESSAGE_QUIT);
			removeMessages(CameraTypes.MESSAGE_AUTO_FOCUS);
			removeMessages(CameraTypes.MESSAGE_RESTART_PREVIEW);
			removeMessages(CameraTypes.MESSAGE_PROCESS_NOT_VALID);
			removeMessages(CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE);
			removeMessages(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE);
			removeMessages(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT);
			removeMessages(CameraTypes.MESSAGE_SHOW_COUNTER);
			removeMessages(CameraTypes.MESSAGE_SHOW_PROCESSING_LABEL);
			removeMessages(CameraTypes.MESSAGE_HIDE_HINT_INDICATOR);
			removeMessages(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT);
			removeMessages(CameraTypes.MESSAGE_TOGGLE_TORCH);
			removeMessages(CameraTypes.MESSAGE_INFO);
			removeMessages(CameraTypes.MESSAGE_ERROR);
			removeMessages(CameraTypes.MESSAGE_BARCODE_DETECTED);
			removeMessages(CameraTypes.MESSAGE_BARCODE_ANIMATION_FINISHED);
		}

		/**
		 * Removes the all preview processing messages.
		 */
		public void removeAllPreviewProcessingMessages() {
			removeMessages(CameraTypes.MESSAGE_RESTART_PREVIEW);
			removeMessages(CameraTypes.MESSAGE_PROCESS_NOT_VALID);
			removeMessages(CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE);
			removeMessages(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE);
			removeMessages(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT);
			removeMessages(CameraTypes.MESSAGE_SHOW_COUNTER);
			removeMessages(CameraTypes.MESSAGE_SHOW_PROCESSING_LABEL);
			removeMessages(CameraTypes.MESSAGE_HIDE_HINT_INDICATOR);
			removeMessages(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT);
			removeMessages(CameraTypes.MESSAGE_INFO);
			removeMessages(CameraTypes.MESSAGE_ERROR);
			removeMessages(CameraTypes.MESSAGE_BARCODE_DETECTED);
			removeMessages(CameraTypes.MESSAGE_BARCODE_ANIMATION_FINISHED);
		}

		/**
		 * Restart preview and decode.
		 */
		private void restartPreviewAndDecode() {
			CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "restartPreviewAndDecode cameraController reference is null");
				return;
			}
			if (cameraController.cameraSessionManager.getState() == State.NONE || cameraController.cameraSessionManager.getState() == State.PREVIEW
					|| cameraController.cameraSessionManager.getState() == State.SUCCESS) {

				// in auto capture mode we r processing preview frame for check
				// boundaries
				if (!CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).isManualCapture) {
					postDelayed(new Runnable() {
						@Override
						public void run() {
							proceedWithProcessing();
						}
					}, 500);
				}
				cameraController.cameraSessionManager.requestAutoFocus(this, CameraTypes.MESSAGE_AUTO_FOCUS);
			}
		}
		

		/**
		 * Removes the low priority messages.
		 */
		public void removeLowPriorityMessages() {
			removeMessages(CameraTypes.MESSAGE_AUTO_FOCUS);
			removeMessages(CameraTypes.MESSAGE_SHOW_COUNTER);
			removeMessages(CameraTypes.MESSAGE_SHOW_PROCESSING_LABEL);
			removeMessages(CameraTypes.MESSAGE_HIDE_HINT_INDICATOR);
			removeMessages(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT);
		}

	}

	
}
