/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.ToggleButton;

import com.topimagesystems.Config;
import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraController.ActionClickListener;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.HintIndicator;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowUIMessages;
import com.topimagesystems.controllers.imageanalyze.StabilityDetection.StableSampleQueue;
import com.topimagesystems.intent.CaptureIntent.LevelerType;
import com.topimagesystems.intent.CaptureIntent.SessionType;
import com.topimagesystems.intent.CaptureIntent.TISDocumentType;
import com.topimagesystems.micr.OCRCommon.ErrorCode;
import com.topimagesystems.ui.CheckBounderiesView;
import com.topimagesystems.ui.Counter;
import com.topimagesystems.ui.DebugRectView;
import com.topimagesystems.ui.OneUnitLeveler;
import com.topimagesystems.ui.ScaleLeveler;
import com.topimagesystems.ui.TwoUnitsLeveler;
import com.topimagesystems.util.AccessibilityUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import com.topimagesystems.util.UserInterfaceUtils;

import org.opencv.core.Rect;

import static com.topimagesystems.Config.ACCELERATION_BASIC_THRESHOLD;
import static com.topimagesystems.R.string.Camera;

// TODO: Auto-generated Javadoc
/**
 * The Class CameraOverlayLayout.
 */
public class CameraOverlayLayout extends RelativeLayout implements SensorEventListener, OnClickListener {

	/** The Constant TAG. */
	private final static String TAG = Logger.makeLogTag("CameraOverlay");
	//
	/** The btn torch. */
	protected ToggleButton btnTorch;

	/** The btn cancel. */
	private Button btnCancel;

	/** The btn capture. */
	private Button btnCapture;

	/** The touch to focus view. */
	private View viewTouchFocus;

	/** The check rect bounderies. */
	private DebugRectView checkRectBounderies;

	/** The check bounderies view. */
	protected CheckBounderiesView checkBounderiesView;

	// private ImageView imgHintIndicator;
	/** The txt capture. */
	private TextView txtCapture;

	/** The txt error message. */
	private TextView txtErrorMessage;

	/** The txt x. */
	private TextView txtX;

	/** The txt y. */
	private TextView txtY;

	/** The txt z. */
	private TextView txtZ;

	/** The text indicator. */
	public TextView textIndicator;

	/** The text hold indicator. */
	public TextView textHoldIndicator;

	/** The text static indicator. */
	private TextView textStaticIndicator;

	/** The counter. */
	private Counter counter;

	/** The one unit leveler. */
	protected OneUnitLeveler oneUnitLeveler;

	/** The horizontal leveler. */
	protected TwoUnitsLeveler horizontalLeveler;

	/** The portrait leveler. */
	protected TwoUnitsLeveler verticalLeveler;

	/** The horizontal leveler. */
	protected ScaleLeveler horizontalScaleLeveler;

	/** The portrait leveler. */
	protected ScaleLeveler verticalScaleLeveler;

	/** The processing overlay. */
	private View processingOverlay;

	/** The capture overlay. */
	private RelativeLayout captureOverlay;

	/** The txt processing. */
	private TextView txtProcessing;

	/** The img logo water mark. */
	protected ImageView imgLogoWaterMark;

	/** The is custom view. */
	private boolean isCustomView = true;

	/** The current hint indicator. */
	private HintIndicator currentHintIndicator;

	/** The context. */
	private Context context;

	/** The capture frame inicator. */
	private boolean captureFrameInicator = false;

	/** The action click listener. */
	private ActionClickListener actionClickListener;
	//
	/** The camera controller. */

	/** The is himing hint. */
	private boolean isShowingHint;

	/** The is valid x. */
	private boolean isValidX;

	/** The is valid y. */
	private boolean isValidY;

	/** The is valid z. */
	private boolean isValidZ;

	/** The is valid. */
	private boolean isValid;

	/** The last time indicator was displayed. */
	private long lastTimeIndicatorWasDisplayed = 0;
	
	/** The last time accessibility announcement for indicator was sent. */
	private long lastTimeIndicatorWasAnnounced = 0;
	
	/** The last time accessibility announcement for instruction was sent. */
	private long lastTimeInstructionWasAnnounced = 0;

	/** The last time show orientation. */
	private long lastTimeShowOrientation = 0;

	/** The check boundaries rect. */
	protected CheckBoundaries checkBoundariesRect;

	/** The fade out. */
	protected Animation fadeOut;

	/** The is check bounderies view init. */
	protected boolean isCheckBounderiesViewInit = false;

	/** The is one unit leveler. */
	protected boolean isOneUnitLeveler = true;

	/** The ishorizontal unit leveler. */
	protected boolean isHorizontalUnitLeveler = false;

	/** The is portarait unit leveler. */
	protected boolean isVerticalUnitLeveler = false;
	
	/** The ishorizontal unit leveler. */
	protected boolean isHorizontalScaleLeveler = false;

	/** The is portarait unit leveler. */
	protected boolean isVerticalScaleLeveler = false;

	/** The is valid orientation. */
	private boolean isValidOrientation;

	/** The is fade out animation. */
	private boolean isFadeOutAnimation = false;

	/** The is fade out animation. */
	private boolean isFadeOutBoundariesAnimation = false;

	/** The spinner. */
	protected ProgressBar spinner;

	/** The orientation y. */
	float orientationY;

	/** The orientation x. */
	float orientationX;

	/** The orientation z. */
	float orientationZ;

	float azimutLocation;
	float pitchLocation;
	float rollLocation;
	float[] geoMagnetic, gravity;

	/** The sample queue. */
	private final StableSampleQueue sampleQueue = new StableSampleQueue();


	/**
	 * Instantiates a new camera overlay layout.
	 *
	 * @param _context the _context
	 */
	public CameraOverlayLayout(Context _context) {
		super(_context);
		context = _context;
	}

	/**
	 * Instantiates a new camera overlay layout.
	 *
	 * @param _context the _context
	 * @param attributeSet the attribute set
	 */
	public CameraOverlayLayout(Context _context, AttributeSet attributeSet) {
		super(_context, attributeSet);
		context = _context;

	}

	/**
	 * Instantiates a new camera overlay layout.
	 *
	 * @param _context the _context
	 * @param attributeSet the attribute set
	 * @param defStyle the def style
	 */
	public CameraOverlayLayout(Context _context, AttributeSet attributeSet, int defStyle) {
		super(_context, attributeSet, defStyle);
		context = _context;

	}

	/**
	 * Sets the camera controller.
	 *
	 * @param cameraController the new camera controller
	 */

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.view.View#onFinishInflate()
	 */
	@Override
	protected void onFinishInflate() {
		ensureUI();
	};

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * android.hardware.SensorEventListener#onAccuracyChanged(android.hardware
	 * .Sensor, int)
	 */
	@Override
	public void onAccuracyChanged(Sensor paramSensor, int paramInt) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.view.View.OnClickListener#onClick(android.view.View)
	 */
	@Override
	public void onClick(View v) {
		Message message = CameraController.getInstance().getHandler().obtainMessage(CameraTypes.MESSAGE_AUTO_FOCUS);
		CameraController.getInstance().getHandler().sendMessage(message);
	}



	protected OnTouchListener tapToFocusListener = new OnTouchListener() {
		@Override
		public boolean onTouch(View v, MotionEvent event) {
			switch (event.getAction()) {
				case MotionEvent.ACTION_DOWN:
					CameraController.getInstance().handleTouchForFocus(true);
					break;
				case MotionEvent.ACTION_UP:
				case MotionEvent.ACTION_CANCEL:
					CameraController.getInstance().handleTouchForFocus(false);
					break;
			}
			return true;
		}
	};


	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * android.hardware.SensorEventListener#onSensorChanged(android.hardware
	 * .SensorEvent)
	 */
	@SuppressWarnings("deprecation")
	@Override
	public void onSensorChanged(SensorEvent event) {
		if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
			gravity = event.values.clone();
			if (CameraController.getInstance().isPreviewing()) {
				orientationY = event.values[1];
				orientationZ = event.values[2];
				orientationX = event.values[0];

				isValidOrientation = calcIsValidOrientation(orientationX, orientationY, orientationZ);
				if (!CameraManagerController.deviceName.contains("ASUS Transformer Pad")) {
					if (isValidOrientation) {
						boolean accelerating = isAccelerating(event);
						long timestamp = event.timestamp;
						sampleQueue.addSample(timestamp, accelerating);
						if (!sampleQueue.isStable())
							isValidOrientation = false;
					} else
						sampleQueue.clear();
				}
			}
		}

		else if (event.sensor.getType() == Sensor.TYPE_MAGNETIC_FIELD && CameraController.getInstance().isPreviewing()) {
			final long currentTimeInMillsec = System.currentTimeMillis();
			final long delta = currentTimeInMillsec - lastTimeShowOrientation;

			if (delta > CameraConfigurationManager.SHOW_ORIENTATION_VALUES_DELAY) {
				lastTimeShowOrientation = currentTimeInMillsec;
				geoMagnetic = event.values.clone();
				if (geoMagnetic != null & gravity != null) {
					float R[] = new float[9];
					float I[] = new float[9];
					boolean success = SensorManager.getRotationMatrix(R, I, gravity, geoMagnetic);
					boolean remapped = SensorManager.remapCoordinateSystem(I, SensorManager.AXIS_Y, SensorManager.AXIS_MINUS_X, I);
					if (success) {
						float orientation[] = new float[3];
						SensorManager.getOrientation(R, orientation);
						azimutLocation = 57.29578F * orientation[0];
						pitchLocation = 57.29578F * orientation[1];
						rollLocation = 57.29578F * orientation[2]; // the sensor
																	// for ma
						float dist = Math.abs((float) (1.4f * Math.tan(pitchLocation * Math.PI / 180)));
						// Logger.d("log", "TYPE_MAGNETIC_FIELD values: " +
						// azimutLocation + " / " + pitchLocation + " / " +
						// rollLocation + " dist = " + dist);
					}
				}

				if (CameraManagerController.deviceName.contains("ASUS Transformer Pad")) { 
					// Asus transform replaces x and y values.
					float tmp = pitchLocation;
					pitchLocation = rollLocation;
					rollLocation = tmp;
				}
				event.values[0] = azimutLocation;
				event.values[1] = pitchLocation;
				event.values[2] = rollLocation;
				showBounderies(isValidOrientation, event.values);
				if (!isValidOrientation) {
					showIndicator(HintIndicator.HoldFlat, true);
				}
			}
			if (CameraController.getInstance() != null) {
				CameraController.getInstance().setIsValidOrientation(isValidOrientation);
			}
		}
	}

	/**
	 *  Returns true if the device is currently accelerating.
	 *
	 * @param event the event
	 * @return true, if is accelerating
	 */
	private boolean isAccelerating(SensorEvent event) {
		float ax = event.values[0];
		float ay = event.values[1];
		float az = event.values[2];

		final double magnitude = Math.sqrt(ax * ax + ay * ay + az * az);

		return magnitude > 10.5;
	}

	/**
	 * Calc is valid orientation.
	 *
	 * @param orientationX the orientation x
	 * @param orientationY the orientation y
	 * @param orientationZ the orientation z
	 * @return true, if successful
	 */
	public boolean calcIsValidOrientation(double orientationX, double orientationY, double orientationZ) {

		Config.ACCELERATION_X_THRESHOLD = 1.5f;
		Config.ACCELERATION_BASIC_THRESHOLD= 1.5f;
		if (CameraManagerController.enableSoftCaptureAndImageAligment) { 
			// make x orientation flexible when capturing.
			Config.ACCELERATION_X_THRESHOLD *= 2.3f + CameraManagerController.softCaptureThreshold*2.0f;
			ACCELERATION_BASIC_THRESHOLD *= 1.1f + CameraManagerController.softCaptureThreshold*0.15f;
		}
		
		isValidX = Math.abs(orientationX - Config.ACCELERATION_OPTIMAL_X) < Config.ACCELERATION_X_THRESHOLD;
		isValidY = Math.abs(orientationY - Config.ACCELERATION_OPTIMAL_Y) < ACCELERATION_BASIC_THRESHOLD;
		isValidZ = Math.abs(orientationZ - Config.ACCELERATION_OPTIMAL_Z) < ACCELERATION_BASIC_THRESHOLD;
		
		if (isHorizontalUnitLeveler && !isVerticalUnitLeveler){
			isValidX = true;
		}
		if (!isHorizontalUnitLeveler && isVerticalUnitLeveler){
			isValidY = true;
		}
		return isValidX && isValidY && isValidZ;
	}

	/**
	 * Gets the capture frame indicator.
	 *
	 * @return the capture frame indicator
	 */
	public boolean getCaptureFrameIndicator() {
		return captureFrameInicator;
	}

	/**
	 * Ensure ui.
	 */
	protected void initOneUnitLeveler() {
		if (oneUnitLeveler != null) {
			isOneUnitLeveler = oneUnitLeveler.getVisibility() == View.VISIBLE
					|| (CameraManagerController.levlerType != null && CameraManagerController.levlerType == LevelerType.ONE_UNIT);

			if (isOneUnitLeveler) {

				oneUnitLeveler.showLeveler();
				if (oneUnitLeveler.isDraggingEnable() && Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
					oneUnitLeveler.setOnTouchListener(new OnTouchListener() {
						PointF levelerTouched = new PointF(); // Record Mouse Position When Pressed Down
						PointF levelerStartDrag = new PointF(); // Record Start Position of 'img'

						@SuppressLint("NewApi")
						@Override
						public boolean onTouch(View v, MotionEvent event) {
							int eid = event.getAction();
							switch (eid) {
							case MotionEvent.ACTION_MOVE:
								PointF mv = new PointF(event.getX() - levelerTouched.x, event.getY() - levelerTouched.y);
								oneUnitLeveler.setX((int) (levelerStartDrag.x + mv.x));
								oneUnitLeveler.setY((int) (levelerStartDrag.y + mv.y));
								levelerStartDrag = new PointF(oneUnitLeveler.getX(), oneUnitLeveler.getY());
								break;
							case MotionEvent.ACTION_DOWN:
								levelerTouched.x = event.getX();
								levelerTouched.y = event.getY();
								levelerStartDrag = new PointF(oneUnitLeveler.getX(), oneUnitLeveler.getY());
								break;
							case MotionEvent.ACTION_UP:
								// Nothing have to do
								break;
							default:
								break;
							}
							return true;
						}
					});

				}
			}
		}

	}

	public void ensureUI() {
		isCustomView = CameraManagerController.isCustomView;// CameraManagerController.isCustomView;//CameraManagerController.isCustomView;
		if (isInEditMode()) {
			return;
		}
		boolean isDebug = CameraManagerController.isDebug;

		checkRectBounderies = (DebugRectView) findViewById(isCustomView ? R.id.customCheckRectBounderies : R.id.checkRectBounderies);

		processingOverlay = findViewById(isCustomView ? R.id.customProcessingOverlay : R.id.processingOverlay);
		captureOverlay = (RelativeLayout) findViewById(isCustomView ? R.id.customCaptureOverlay : R.id.captureOverlay);
		imgLogoWaterMark = (ImageView) findViewById(isCustomView ? R.id.customImgLogoWaterMark : R.id.imgLogoWaterMark);
		txtProcessing = (TextView) findViewById(isCustomView ? R.id.customTxtProcessing : R.id.txtProcessing);
		spinner = (ProgressBar) findViewById(isCustomView ? R.id.customProgressBarMainView : R.id.progressBarMainView);
		counter = (Counter) findViewById(isCustomView ? R.id.customCounter : R.id.counter);
		oneUnitLeveler = (OneUnitLeveler) findViewById(isCustomView ? R.id.customLeveler : R.id.leveler);

		horizontalLeveler = (TwoUnitsLeveler) findViewById(isCustomView ? R.id.customLevelerHorizontal : R.id.levelerHorizontal);
		horizontalScaleLeveler = (ScaleLeveler) findViewById(isCustomView ? R.id.customScaleLevelerHorizontal : R.id.scaleLevelerHorizontal);
		verticalLeveler = (TwoUnitsLeveler) findViewById(isCustomView ? R.id.customLevelerPortrait : R.id.levelerPortrait);

		verticalScaleLeveler = (ScaleLeveler) findViewById(isCustomView ? R.id.customScaleLevelerVertical : R.id.scaleLevelerVertical);

		if (oneUnitLeveler != null) {
			initOneUnitLeveler();
		}
		initLeveler();
		
		if (checkBoundariesRect != null ) {
			initcheckBounderiesView(checkBoundariesRect);
		}

		textIndicator = (TextView) findViewById(isCustomView ? R.id.customTxtIndicator : R.id.txtIndicator);
		textIndicator.setVisibility(View.GONE);

		textHoldIndicator = (TextView) findViewById(isCustomView ? R.id.customTxtHoldIndicator : R.id.txtHoldIndicator);
		if (CameraManagerController.isCustomView) {
			textStaticIndicator = (TextView) findViewById(R.id.customStaticTxtIndicator);
			textStaticIndicator.setVisibility(View.VISIBLE);
		}
		textHoldIndicator.setVisibility(View.GONE);
		
		LinearLayout debugBox = (LinearLayout) findViewById(isCustomView ? R.id.customDebugBox : R.id.debugBox);

		// debugBox.setVisibility(View.GONE);
		debugBox.setVisibility(isDebug ? View.VISIBLE : View.GONE);
		txtCapture = (TextView) findViewById(isCustomView ? R.id.customTxtCapture : R.id.txtCapture);

		txtCapture.setText("");

		txtErrorMessage = (TextView) findViewById(isCustomView ? R.id.customTxtErrorMessage : R.id.txtErrorMessage);
		txtX = (TextView) findViewById(isCustomView ? R.id.customTxtX : R.id.txtX);
		txtY = (TextView) findViewById(isCustomView ? R.id.customTxtY : R.id.txtY);
		txtZ = (TextView) findViewById(isCustomView ? R.id.customTxtZ : R.id.txtZ);
		fadeOut = AnimationUtils.loadAnimation(context, R.anim.view_fade_out);
		setAnimationListener();
		btnTorch = (ToggleButton) findViewById(isCustomView ? R.id.customBtnTorch : R.id.btnTorch);
		btnCancel = (Button) findViewById(isCustomView ? R.id.customBtnCancel : R.id.btnCancel);
		// btnCancel.setText(StringUtils.dynamicString(context,
		// 
		btnCapture = (Button) findViewById(isCustomView ? R.id.customBtnCapture : R.id.btnCapture);

		viewTouchFocus = findViewById(isCustomView ? R.id.customTouchFocusView : R.id.touchFocusView);
		if (CameraManagerController.tapToFocus)
			viewTouchFocus.setOnTouchListener(tapToFocusListener);


		btnCapture.setText(StringUtils.dynamicString(context, "next"));
		final OnClickListenerIMpl onClickListenerIMpl = new OnClickListenerIMpl();
		btnCancel.setOnClickListener(onClickListenerIMpl);
		btnCapture.setOnClickListener(onClickListenerIMpl);
		btnTorch.setOnClickListener(onClickListenerIMpl);
		if (CameraController.getInstance() != null) {
			CameraController.getInstance().onSentUIEventMessage(TISFlowUIMessages.INIT_LAYOUT);
		}
		setCaptureCaption(CameraManagerController.getOcrAnalyzeSession(CameraController.getInstance()).captureMode);
		btnTorch.setVisibility(CameraController.isCameraFlashSupported ? VISIBLE : INVISIBLE);
	}


	protected void handleCameraFlashSupport() {
		if (btnTorch != null)
			btnTorch.setVisibility(CameraController.isCameraFlashSupported ? VISIBLE : INVISIBLE);

	}


	/**
	 * Sets the checks if is torch on.
	 *
	 * @param isTorchOn the new checks if is torch on
	 */
	public void setIsTorchOn(boolean isTorchOn) {
		btnTorch.setOnClickListener(null);
		btnTorch.setChecked(isTorchOn);
		btnTorch.setOnClickListener(new OnClickListenerIMpl());
	}

	/**
	 * The Class OnClickListenerIMpl.
	 */
	class OnClickListenerIMpl implements OnClickListener {

		/*
		 * (non-Javadoc)
		 * 
		 * @see android.view.View.OnClickListener#onClick(android.view.View)
		 */
		@Override
		public void onClick(View v) {
			if (v == btnTorch) {
				if (CameraController.getInstance().getHandler() != null) {
					btnTorch.setEnabled(false);
					Message message = CameraController.getInstance().getHandler().obtainMessage(CameraTypes.MESSAGE_TOGGLE_TORCH);
					message.obj = btnTorch.isChecked();
					CameraController.getInstance().getHandler().sendMessage(message);
				}
			} else if (v == btnCancel) {
				if (!CameraManagerController.isStillMode && CameraController.processStart)
					return;
				else
					CameraController.getInstance().quitActivity();
			} else if (v == btnCapture) {
				actionClickListener.capture();
			}
		}
	}

	/**
	 * Enable torch button.
	 *
	 * @param isEnable the is enable
	 */
	public void enableTorchButton(boolean isEnable) {
		btnTorch.setEnabled(isEnable);
	}

	/**
	 * Sets the capture caption.
	 *
	 * @param captureMode the new capture caption
	 */
	public void setCaptureCaption(CaptureMode captureMode) {
		String caption = null;
		switch (captureMode) {
		case FRONT:
			switch (CameraManagerController.imageType) {		
			case CHECK:
				caption = StringUtils.dynamicString(getContext(), "TISFlowPleaseCaptureCheckFront");
				break;
			default:
				caption = StringUtils.dynamicString(getContext(), "TISFlowPleaseCaptureImageFront");
				break;
			}

			break;
		case BACK:
			switch (CameraManagerController.imageType) {	
			case CHECK:
				caption = StringUtils.dynamicString(getContext(), "TISFlowPleaseCaptureCheckBack");
				break;
			default:
				caption = StringUtils.dynamicString(getContext(), "TISFlowPleaseCaptureImageBack");
				break;			
			}
			
		default:
			break;
		}
		
		if (CameraManagerController.getOcrAnalyzeSession(getContext()).isBarcodeSession)
			caption = StringUtils.dynamicString(getContext(), "TISFlowPleaseCaptureTheBarcode");
		
		final long currentTimeInMillsec = System.currentTimeMillis();

		boolean shouldSendAnnouncement = !txtCapture.getText().toString().equals(caption) ||
				(currentTimeInMillsec - lastTimeInstructionWasAnnounced) >= CameraConfigurationManager.ANNOUNCE_HINT_INDICATOR_DELAY;	
		
		
		if (caption != null) {
			txtCapture.setText(caption);
			txtCapture.setContentDescription(caption);
			if (shouldSendAnnouncement){
				CameraController.getInstance().onSentUIEventMessage(TISFlowUIMessages.INSTRUCTION_CHANGED);
				AccessibilityUtils.sendAnnouncement(getContext(), txtCapture, getClass().getName());
				if (lastTimeInstructionWasAnnounced == 0)
					lastTimeInstructionWasAnnounced = 1;
				else
					lastTimeInstructionWasAnnounced = currentTimeInMillsec;
			}
		}
	}

	/**
	 * Show counter.
	 *
	 * @param from the from
	 */
	private void showCounter(int from) {
		showCounter(true, from);

	}

	/**
	 * Finish capture.
	 */
	public void finishCapture() {
			
		counter.setVisibility(View.GONE);
		txtCapture.setVisibility(View.VISIBLE);
		btnTorch.setVisibility(View.VISIBLE);
		imgLogoWaterMark.setVisibility(View.VISIBLE);
		checkBounderiesView.showBounderies(false, true);
		textHoldIndicator.setVisibility(View.GONE);
		textIndicator.setVisibility(View.VISIBLE);
		btnCancel.setVisibility(View.VISIBLE);
		currentHintIndicator = HintIndicator.None;
		if (CameraManagerController.isCustomView) {
			textStaticIndicator.setVisibility(View.VISIBLE);
		}
		if (isOneUnitLeveler) {
			// oneUnitLeveler.startAnimation(fadeOut);
			oneUnitLeveler.setVisibility(View.VISIBLE);
		}

		if (isVerticalUnitLeveler)
			verticalLeveler.setVisibility(View.VISIBLE);

		// portraitLeveler.startAnimation(fadeOut);
		if (isHorizontalUnitLeveler)
			horizontalLeveler.setVisibility(View.VISIBLE);
		if (isHorizontalScaleLeveler)
			horizontalScaleLeveler.setVisibility(View.VISIBLE);
		if (isVerticalScaleLeveler)
			verticalScaleLeveler.setVisibility(View.VISIBLE);
		spinner.setVisibility(View.GONE);
		checkBounderiesView.invalidate();
		

	}

	/**
	 * Switch to processing view.
	 *
	 * @param showBoundries the show boundries
	 */
	public void switchToProcessingView(boolean showBoundries) {		
		if (!showBoundries) {
			textHoldIndicator.setVisibility(View.GONE);
			textIndicator.setVisibility(View.GONE);
			checkBounderiesView.showBounderies(false, false);
		}
		spinner.setVisibility(View.VISIBLE);
		counter.setVisibility(View.GONE);
		btnTorch.setVisibility(View.GONE);
		imgLogoWaterMark.setVisibility(View.GONE);
		// checkBounderiesView.showBounderies(false);
		btnCancel.setVisibility(View.GONE);
		txtCapture.setVisibility(View.GONE);
		currentHintIndicator = HintIndicator.None;
		if (CameraManagerController.isCustomView) {
			textStaticIndicator.setVisibility(View.GONE);
		}
		if (isOneUnitLeveler) {
			// oneUnitLeveler.startAnimation(fadeOut);
			oneUnitLeveler.setVisibility(View.GONE);
		}

		if (isVerticalUnitLeveler)
			verticalLeveler.setVisibility(View.GONE);
		// portraitLeveler.startAnimation(fadeOut);
		if (isHorizontalUnitLeveler)
			horizontalLeveler.setVisibility(View.GONE);
		if (isHorizontalScaleLeveler)
			horizontalScaleLeveler.setVisibility(View.GONE);
		if (isVerticalScaleLeveler)
			verticalScaleLeveler.setVisibility(View.GONE);
		
	}

	/**
	 * Show counter.
	 *
	 * @param isShow the is show
	 * @param elapsedTime the elapsed time
	 */
	public void showCounter(boolean isShow, long elapsedTime) {
		if (isShow) {
			btnCancel.setVisibility(View.GONE);

			// btnCancel.setEnabled(false);
			if (oneUnitLeveler.getVisibility() == View.VISIBLE) {
				// oneUnitLeveler.startAnimation(fadeOut);
				oneUnitLeveler.setVisibility(View.GONE);
			}

			if (verticalLeveler.getVisibility() == View.VISIBLE)
				verticalLeveler.setVisibility(View.GONE);
			// portraitLeveler.startAnimation(fadeOut);
			if (horizontalLeveler.getVisibility() == View.VISIBLE)
				horizontalLeveler.setVisibility(View.GONE);
			if (CameraManagerController.isCustomView) {
				textStaticIndicator.setVisibility(View.GONE);
			}
			// horizontalLeveler.startAnimation(fadeOut);
			counter.startCountdown((int) elapsedTime);
		} else {
			btnCancel.setVisibility(View.VISIBLE);
			counter.stopCountdown();
		}
	}

	/**
	 * Show bounderies.
	 *
	 * @param isValid the is valid
	 * @param values the values
	 */
	public void showBounderies(final boolean isValid, final float[] values) {
		final boolean isPortrait = CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == SessionType.PORTRAIT;
		if (!CameraManagerController.isDynamicCapture) {
			try {
				if (txtX != null && txtY!= null && txtZ!= null){

					txtX.setText("x:" + String.format("%.02f", values[2]));
					txtY.setText("y:" + String.format("%.02f", values[1]));
					txtZ.setText("Z:" + String.format("%.02f", values[0]));

					txtX.setTextColor(getResources().getColor(isValid ? R.color.valid_value : R.color.invalid_value));
					txtY.setTextColor(getResources().getColor(isValid ? R.color.valid_value : R.color.invalid_value));
					txtZ.setTextColor(getResources().getColor(isValid ? R.color.valid_value : R.color.invalid_value));
				}
			}catch(Exception e){
				Logger.e(TAG, Log.getStackTraceString(e));
			}
		}
		if (isOneUnitLeveler) {
			if (oneUnitLeveler.isFadeAnimationEnable()) {
				if (!isValid) {
					// leveler.setVisibility(View.VISIBLE);//startAnimation(AnimationUtils.loadAnimation(context,
					// R.anim.view_fade_out));
					if (oneUnitLeveler.getVisibility() != View.VISIBLE) {
						if (isFadeOutAnimation) {
							oneUnitLeveler.clearAnimation();
							oneUnitLeveler.setVisibility(View.VISIBLE);
							Logger.e(TAG, "cancel animation");

						} else if (!isFadeOutAnimation) {
							oneUnitLeveler.setVisibility(View.VISIBLE);
						}
					}
				} else {
					if (oneUnitLeveler.getVisibility() == View.VISIBLE && !isFadeOutAnimation) {
						Handler handler = new Handler(context.getMainLooper());
						handler.postDelayed(new Runnable() {
							public void run() {
								if (isValidOrientation)
									oneUnitLeveler.startAnimation(fadeOut);
							}
						}, 1000);

					}
					// leveler.setVisibility(View.GONE);

				}
			}
			oneUnitLeveler.updateLevelerLocation(values, isValid, isPortrait);

		}

		if (isHorizontalUnitLeveler) {
			horizontalLeveler.updateLevelerLocation(values, isValidY, isValidZ, isPortrait);
			handleAnimation(horizontalLeveler, isValid);
		}
		if (isVerticalUnitLeveler) {
			verticalLeveler.updateLevelerLocation(values, isValidY, isValidZ, isPortrait);
			handleAnimation(verticalLeveler, isValid);
		}
		if (isHorizontalScaleLeveler) {
			horizontalScaleLeveler.updateLevelerLocation(values, isValidY, isValidZ, isPortrait);
			handleAnimation(horizontalScaleLeveler, isValid);
		}
		if (isVerticalScaleLeveler) {
			verticalScaleLeveler.updateLevelerLocation(values, isValidY, isValidZ, isPortrait);
			handleAnimation(verticalScaleLeveler, isValid);
		}

	}
	

	/**
	 * Handle animation.
	 *
	 * @param leveler the leveler
	 * @param isValid the is valid
	 */
	protected void handleAnimation(final TwoUnitsLeveler leveler, boolean isValid) {
		if (leveler.isFadeAnimationEnable()) {
			if (!isValid) {
				if (leveler.getVisibility() != View.VISIBLE) {
					if (!isFadeOutAnimation) {
						leveler.clearAnimation();
						leveler.setVisibility(View.VISIBLE);
					} else {

						Handler handler = new Handler(context.getMainLooper());
						handler.postDelayed(new Runnable() {
							public void run() {
								if (isValidOrientation)
									leveler.startAnimation(fadeOut);
							}
						}, 1500);

					}
				}
			} else {
				if (leveler.getVisibility() == View.VISIBLE && !isFadeOutAnimation) {
					Handler handler = new Handler(context.getMainLooper());
					handler.postDelayed(new Runnable() {
						public void run() {
							if (isValidOrientation)
								leveler.startAnimation(fadeOut);
						}
					}, 1500);
				}

			}

		}

	}

	/**
	 * Handle animation.
	 *
	 * @param leveler the leveler
	 * @param isValid the is valid
	 */
	private void handleAnimation(final ScaleLeveler leveler, boolean isValid) {
		if (leveler.isFadeAnimationEnable()) {
			if (!isValid) {
				if (leveler.getVisibility() != View.VISIBLE) {
					if (!isFadeOutAnimation) {
						leveler.clearAnimation();
						leveler.setVisibility(View.VISIBLE);
					} else {

						Handler handler = new Handler(context.getMainLooper());
						handler.postDelayed(new Runnable() {
							public void run() {
								if (isValidOrientation)
									leveler.startAnimation(fadeOut);
							}
						}, 1500);

					}
				}
			} else {
				if (leveler.getVisibility() == View.VISIBLE && !isFadeOutAnimation) {
					Handler handler = new Handler(context.getMainLooper());
					handler.postDelayed(new Runnable() {
						public void run() {
							if (isValidOrientation)
								leveler.startAnimation(fadeOut);
						}
					}, 1500);
				}

			}

		}

	}

	/**
	 * Show indicator.
	 *
	 * @param hintIndicator the hint indicator
	 * @param isShow the is show
	 * @return true, if successful
	 */
	public boolean showIndicator(HintIndicator hintIndicator, boolean isShow) {
		if (isShow) {
			if (currentHintIndicator == HintIndicator.Hold && CameraManagerController.isStillMode && !CameraManagerController.isDynamicCapture) {
				Logger.i(TAG, "not showing other indicators while in hold");
				return isShowingHint;
			}
			if (CameraManagerController.getOcrAnalyzeSession(CameraController.getInstance()) != null && CameraManagerController.getOcrAnalyzeSession(CameraController.getInstance()).isBarcodeSession){
				hintIndicator = HintIndicator.MoveToBARCODE;
				isShowingHint = isShow;
				textIndicator.setText(hintIndicator.getText());
				textIndicator.setContentDescription(hintIndicator.getText());
				textIndicator.setVisibility(View.VISIBLE);
				return  true;
			}


			if (CameraManagerController.showGuidelinesIndicators && hintIndicator == HintIndicator.None) {
				return hideIndicator();
			} else {
				if (CameraController.getInstance().getHandler() == null) {
					return false;
				}
				
				final long currentTimeInMillsec = System.currentTimeMillis();

				// hold is shown no matter what state we r now
				if (hintIndicator == HintIndicator.Hold) {
					lastTimeIndicatorWasDisplayed = currentTimeInMillsec;
					currentHintIndicator = hintIndicator;
					// imgHintIndicator.setBackgroundResource(hintIndicator.getResourceId());
					// imgHintIndicator.setVisibility(View.VISIBLE);
					textIndicator.setVisibility(View.GONE);
					textHoldIndicator.setVisibility(View.VISIBLE);
					textHoldIndicator.setText(hintIndicator.getText());

					AccessibilityUtils.sendAnnouncement(getContext(), textHoldIndicator, getClass().getName());

					isShowingHint = isShow;
				} else {
					final long delta = currentTimeInMillsec - lastTimeIndicatorWasDisplayed;
					if (delta >= CameraConfigurationManager.SHOW_HINT_INDICATOR_DELAY) {
						CameraController.getInstance().getHandler().sendEmptyMessageDelayed(CameraTypes.MESSAGE_HIDE_HINT_INDICATOR, CameraConfigurationManager.SHOW_HINT_INDICATOR_DELAY);
						lastTimeIndicatorWasDisplayed = currentTimeInMillsec;
						currentHintIndicator = hintIndicator;
						// imgHintIndicator.set\groundResource(hintIndicator.getResourceId());
						// imgHintIndicator.setVisibility(View.VISIBLE);
						if (!CameraManagerController.showGuidelinesIndicators) { // use
																					// o
							hintIndicator = HintIndicator.Align;
						}
						textHoldIndicator.setVisibility(View.GONE);
						
						String t = hintIndicator.getText();
						boolean shouldSendAnnouncement = !textIndicator.getText().toString().equals(t) ||
								(currentTimeInMillsec - lastTimeIndicatorWasAnnounced) >= CameraConfigurationManager.SHOW_HINT_INDICATOR_DELAY * 3;	
						
						textIndicator.setText(hintIndicator.getText());
						textIndicator.setContentDescription(hintIndicator.getText());
						textIndicator.setVisibility(View.VISIBLE);

						isShowingHint = isShow;

						
						if (shouldSendAnnouncement) {
							CameraController.getInstance().onSentUIEventMessage(TISFlowUIMessages.HINT_CHANGED);
							AccessibilityUtils.sendAnnouncement(getContext(), textIndicator, getClass().getName());
							lastTimeIndicatorWasAnnounced = currentTimeInMillsec;
						}
							
						
					} else {
						// skipping indicator
					}
				}
				return isShowingHint;
			}
		} else {
			return hideIndicator();
		}
	}
	

	/**
	 * Hide indicator.
	 *
	 * @return true, if successful
	 */
	private boolean hideIndicator() {
		// currentHintIndicator = HintIndicator.None;
		// imgHintIndicator.setVisibility(View.GONE);

		// textIndicator.setText(hintIndicator.getText());
		textIndicator.setVisibility(View.GONE);
		//textHoldIndicator.setVisibility(View.GONE);
		isShowingHint = false;
		return isShowingHint;
	}

	/**
	 * Hide error message.
	 */
	public void hideErrorMessage() {
		showErrorMessage(false, null);
	}

	/**
	 * Show error message.
	 *
	 * @param errorCode the error code
	 */
	public void showErrorMessage(ErrorCode errorCode) {
		showErrorMessage(true, errorCode);
	}

	/**
	 * Show error message.
	 *
	 * @param isShowError the is show error
	 * @param errorCode the error code
	 */
	private void showErrorMessage(boolean isShowError, ErrorCode errorCode) {
		if (isShowError) {
			txtErrorMessage.setVisibility(View.VISIBLE);

			if (errorCode == null)
				return;

			txtErrorMessage.setText(errorCode.getResourceId());
		} else {
			txtErrorMessage.setVisibility(View.GONE);
		}
	}

	/**
	 * Show check boundy rect.
	 *
	 * @param isShow the is show
	 * @param rect the rect
	 */
	public void showCheckBoundyRect(boolean isShow, Rect rect) {
		if (isShow) {
			checkRectBounderies.drawCheckRect(rect);
		} else {
			checkRectBounderies.clearCheckRect();
		}
	}

	/**
	 * Sets the action click listener.
	 *
	 * @param actionClickListener the new action click listener
	 */
	public void setActionClickListener(ActionClickListener actionClickListener) {
		this.actionClickListener = actionClickListener;
	}

	/**
	 * Sets the checks if is manual capture.
	 *
	 * @param isManualCapture the new checks if is manual capture
	 */
	public void setIsManualCapture(boolean isManualCapture) {
		if (isManualCapture) {
			btnCapture.setVisibility(View.VISIBLE);
		} else {
			btnCapture.setVisibility(View.GONE);
		}
	}

	/**
	 * Sets the check boundaries rect.
	 *
	 * @param checkBoundariesRect the new check boundaries rect
	 */
	public void setCheckBoundariesRect(CheckBoundaries checkBoundariesRect) {
		this.checkBoundariesRect = checkBoundariesRect;
		if (!isCheckBounderiesViewInit) {
			initcheckBounderiesView(checkBoundariesRect);
		}
	}

	public void clearBoundariesRect() {
		if (checkBounderiesView != null)
			checkBounderiesView.clearView();
	}

	/**
	 * start the Fadeout Animation For Boundaries.
	 */
	public void startFadeoutAnimationForBoundaries() {
//		isFadeOutBoundariesAnimation = true;
//		checkBounderiesView.startAnimation(fadeOut);

	}

	public void animateToCheckBoundariesRect(CheckBoundaries checkBoundariesRect) {
		checkBounderiesView.animateToCheckBoundaries(checkBoundariesRect, CameraController.getInstance().getHandler(), CameraTypes.MESSAGE_BARCODE_ANIMATION_FINISHED);

	}

	public void animateToCheckBoundariesRect(CheckBoundaries checkBoundariesRect, Rect[] rectangles) {
		checkBounderiesView.animateRectanglesSeries(checkBoundariesRect, CameraController.getInstance().getHandler(), CameraTypes.MESSAGE_BARCODE_ANIMATION_FINISHED, rectangles);
	}

	public void forceNewCheckBoundariesRect(CheckBoundaries checkBoundariesRect) {
		this.checkBoundariesRect = checkBoundariesRect;
		initcheckBounderiesView(checkBoundariesRect);
	}

	/**
	 * initLeveler
	 */

	protected void initLeveler() {

		isHorizontalUnitLeveler = horizontalLeveler.getVisibility() == View.VISIBLE
				|| (CameraManagerController.levlerType != null && CameraManagerController.levlerType == LevelerType.TWO_UNITS);

		final Point displayDimensions = UserInterfaceUtils.getDisplayDimensions(getContext());
		//Rect levelerAreaRect = new Rect(0, 0, displayDimensions.x, (int) (displayDimensions.y*0.80f));
		Rect levelerAreaRect = new Rect(0, 0, displayDimensions.x,displayDimensions.y);
		if (isHorizontalUnitLeveler) {
			//horizontalLeveler.setFrame(checkBounderiesView.getValidationRect());
			horizontalLeveler.setFrame(levelerAreaRect);
			horizontalLeveler.showLeveler();
		}
		
		isHorizontalScaleLeveler = horizontalScaleLeveler.getVisibility() == View.VISIBLE
				|| (CameraManagerController.levlerType != null && CameraManagerController.levlerType == LevelerType.SCALE);

		if (isHorizontalScaleLeveler) {
			//horizontalScaleLeveler.setFrame(checkBounderiesView.getValidationRect());
			horizontalScaleLeveler.setFrame(levelerAreaRect);
			horizontalScaleLeveler.showLeveler();
		}
		// horizontalLeveler.setLayoutParams(params)

		isVerticalUnitLeveler = verticalLeveler.getVisibility() == View.VISIBLE
				|| (CameraManagerController.levlerType != null && CameraManagerController.levlerType == LevelerType.TWO_UNITS);

		if (isVerticalUnitLeveler) {
			//verticalLeveler.setFrame(checkBounderiesView.getValidationRect());
			verticalLeveler.setFrame(levelerAreaRect);
			verticalLeveler.showLeveler();
		}
		isVerticalScaleLeveler = verticalScaleLeveler.getVisibility() == View.VISIBLE
				|| (CameraManagerController.levlerType != null && CameraManagerController.levlerType == LevelerType.SCALE);
		if (isVerticalScaleLeveler) {
			Point screenResolution = UserInterfaceUtils.getDisplayDimensions(context);

			//verticalScaleLeveler.setFrame(CameraManagerController.isDynamicCapture ? new org.opencv.core.Rect(0, 0, screenResolution.x, screenResolution.y) : checkBounderiesView
			//		.getValidationRect());
			verticalScaleLeveler.setFrame(levelerAreaRect);
			verticalScaleLeveler.showLeveler();
		}

		if (horizontalLeveler.isDraggingEnable() && Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB && isHorizontalUnitLeveler) {
			horizontalLeveler.setOnTouchListener(new OnTouchListener() {
				PointF levelerTouched = new PointF();
				PointF levelerStartDrag = new PointF();

				@SuppressLint("NewApi")
				@Override
				public boolean onTouch(View v, MotionEvent event) {
					int eid = event.getAction();
					switch (eid) {
					case MotionEvent.ACTION_MOVE:
						PointF mv = new PointF(event.getX() - levelerTouched.x, event.getY() - levelerTouched.y);
						horizontalLeveler.setX((int) (levelerStartDrag.x + mv.x));
						horizontalLeveler.setY((int) (levelerStartDrag.y + mv.y));
						levelerStartDrag = new PointF(horizontalLeveler.getX(), horizontalLeveler.getY());
						break;
					case MotionEvent.ACTION_DOWN:
						levelerTouched.x = event.getX();
						levelerTouched.y = event.getY();
						levelerStartDrag = new PointF(horizontalLeveler.getX(), horizontalLeveler.getY());
						break;
					case MotionEvent.ACTION_UP:
						// Nothing have to do
						break;
					default:
						break;
					}
					return true;
				}
			});

		}

		if (verticalLeveler.isDraggingEnable() && Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB && isVerticalUnitLeveler) {
			verticalLeveler.setOnTouchListener(new OnTouchListener() {
				PointF levelerTouched = new PointF(); // Record Mouse Position
														// When Pressed Down
				PointF levelerStartDrag = new PointF(); // Record Start Position
														// of 'img'

				@SuppressLint("NewApi")
				@Override
				public boolean onTouch(View v, MotionEvent event) {
					int eid = event.getAction();
					switch (eid) {
					case MotionEvent.ACTION_MOVE:
						PointF mv = new PointF(event.getX() - levelerTouched.x, event.getY() - levelerTouched.y);
						verticalLeveler.setX((int) (levelerStartDrag.x + mv.x));
						verticalLeveler.setY((int) (levelerStartDrag.y + mv.y));
						levelerStartDrag = new PointF(verticalLeveler.getX(), verticalLeveler.getY());
						break;
					case MotionEvent.ACTION_DOWN:
						levelerTouched.x = event.getX();
						levelerTouched.y = event.getY();
						levelerStartDrag = new PointF(verticalLeveler.getX(), verticalLeveler.getY());
						break;
					case MotionEvent.ACTION_UP:
						// Nothing have to do
						break;
					default:
						break;
					}
					return true;
				}
			});

		}

	}

	protected void initcheckBounderiesView(CheckBoundaries checkBoundariesRect) {
		isCheckBounderiesViewInit = true;
		final Point displayDimensions = UserInterfaceUtils.getDisplayDimensions(getContext());
		checkBounderiesView = (CheckBounderiesView) findViewById(isCustomView ? R.id.customCheckBounderiesView : R.id.checkBounderiesView);
		checkBounderiesView.setCheckBounderies(displayDimensions, checkBoundariesRect);
		horizontalLeveler = (TwoUnitsLeveler) findViewById(isCustomView ? R.id.customLevelerHorizontal : R.id.levelerHorizontal);
		horizontalScaleLeveler = (ScaleLeveler) findViewById(isCustomView ? R.id.customScaleLevelerHorizontal : R.id.scaleLevelerHorizontal);
		verticalLeveler = (TwoUnitsLeveler) findViewById(isCustomView ? R.id.customLevelerPortrait : R.id.levelerPortrait);

		verticalScaleLeveler = (ScaleLeveler) findViewById(isCustomView ? R.id.customScaleLevelerVertical : R.id.scaleLevelerVertical);
		//initLeveler();
		if (CameraManagerController.imageType == TISDocumentType.PASSPORT) {

			ImageView mrzLine = new ImageView(context);
			mrzLine.setImageResource(R.drawable.passport_overlay);
			RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(checkBoundariesRect.getValidationBoundariesRectByCaptureMode().width - 20,
					RelativeLayout.LayoutParams.WRAP_CONTENT);
			lp.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, R.id.checkBounderiesView);
			lp.addRule(RelativeLayout.ALIGN_PARENT_LEFT, R.id.checkBounderiesView);
			lp.leftMargin = checkBoundariesRect.getValidationBoundariesRectByCaptureMode().x + 10;
			lp.bottomMargin = 120;
			captureOverlay.addView(mrzLine, lp);
		}

//		if (CameraManagerController.imageType == TISDocumentType.CHECK && CameraManagerController.ocrType == Common.OCRType.CMC7) {
//
//			ImageView mrzLine = new ImageView(context);
//			mrzLine.setImageResource(R.drawable.cmc7_line);
//			RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(checkBoundariesRect.getValidationBoundariesRectByCaptureMode().width,
//					RelativeLayout.LayoutParams.WRAP_CONTENT);
//			//lp.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, R.id.checkBounderiesView);
//			lp.addRule(RelativeLayout.ALIGN_PARENT_LEFT, R.id.checkBounderiesView);
//			//lp.leftMargin = checkBoundariesRect.getValidationBoundariesRectByCaptureMode().x + 10;
//			//lp.bottomMargin = 220;
//			captureOverlay.addView(mrzLine, lp);
//		}

	}

	/**
	 * Show processing overlay.
	 *
	 * @param isShown the is shown
	 */
	public void showProcessingOverlay(boolean isShown) {	
		processingOverlay.setVisibility(isShown ? View.VISIBLE : View.GONE);
		captureOverlay.setVisibility(isShown ? View.GONE : View.VISIBLE);		
	}

	/**
	 * Update processing message.
	 *
	 * @param message the message
	 */
	public void updateProcessingMessage(String message) {
		txtProcessing.setText(message);
	}

	/**
	 * Sets the confirmation indicators.
	 */
	public void setConfirmationIndicators() {		
		captureFrameInicator = true;
		checkBounderiesView.showBounderies(getCaptureFrameIndicator(), true);

		showIndicator(HintIndicator.Hold, true);
		isShowingHint = true;
		checkBounderiesView.invalidate();

	}

	/**
	 * Sets the non confirmation indicators.
	 */
	public void setNonConfirmationIndicators() {
		captureFrameInicator = false;
		checkBounderiesView.showBounderies(getCaptureFrameIndicator(), true);

		showIndicator(HintIndicator.None, true);
		checkBounderiesView.invalidate();
	}

	/**
	 * Prepare for still capture.
	 */
	public void prepareForStillCapture() {
		if (CameraManagerController.showCountDown) {
			showCounter(counter.getCountDownStartNumber());
		}

		showIndicator(HintIndicator.Hold, true);
	}

	/**
	 * Drag image.
	 *
	 * @param v the v
	 * @param event the event
	 * @return true, if successful
	 */
	@SuppressLint("NewApi")
	private boolean dragImage(View v, MotionEvent event) {
		int eid = event.getAction();
		PointF DownPT = new PointF(); // Record Mouse Position When Pressed Down
		PointF StartPT = new PointF();
		switch (eid) {
		case MotionEvent.ACTION_MOVE:
			PointF mv = new PointF(event.getX() - DownPT.x, event.getY() - DownPT.y);
			v.setX((int) (StartPT.x + mv.x));
			v.setY((int) (StartPT.y + mv.y));
			StartPT = new PointF(v.getX(), oneUnitLeveler.getY());
			break;
		case MotionEvent.ACTION_DOWN:
			DownPT.x = event.getX();
			DownPT.y = event.getY();
			StartPT = new PointF(v.getX(), v.getY());
			break;
		case MotionEvent.ACTION_UP:
			// Nothing have to do
			break;
		default:
			break;
		}
		return true;

	}

	/**
	 * Sets the animation listener.
	 */
	public void setAnimationListener() {

		fadeOut.setAnimationListener(new Animation.AnimationListener() {
			@Override
			public void onAnimationStart(Animation arg0) {
				if (!isFadeOutBoundariesAnimation)
					isFadeOutAnimation = true;
			}

			@Override
			public void onAnimationRepeat(Animation arg0) {
			}

			@Override
			public void onAnimationEnd(Animation arg0) {
				if (!isFadeOutBoundariesAnimation) {
					isFadeOutAnimation = false;
					if (horizontalLeveler.getVisibility() == View.VISIBLE && isHorizontalUnitLeveler && horizontalLeveler.isFadeAnimationEnable())
						horizontalLeveler.setVisibility(View.GONE);
					if (verticalLeveler.getVisibility() == View.VISIBLE && isVerticalUnitLeveler && verticalLeveler.isFadeAnimationEnable())
						verticalLeveler.setVisibility(View.GONE);

					if (oneUnitLeveler.getVisibility() == View.VISIBLE && isOneUnitLeveler && oneUnitLeveler.isFadeAnimationEnable()) {

						oneUnitLeveler.setVisibility(View.GONE);
					}
				} else
					isFadeOutBoundariesAnimation = false;
			}
		});

	}

	/**
	 * Update leveler size.
	 */
	public void updateLevelerSize() {
		
		
		if (horizontalLeveler.getUpperMainRectSize() != null) {
			horizontalLeveler
					.setLayoutParams(new RelativeLayout.LayoutParams((int) horizontalLeveler.getUpperMainRectSize()[0], (int) horizontalLeveler.getUpperMainRectSize()[1]));

			verticalLeveler.setLayoutParams(new RelativeLayout.LayoutParams((int) verticalLeveler.getLeftRightRectSize()[0], (int) verticalLeveler.getLeftRightRectSize()[1]));
		}

	}

	/**
	 * Reset camera overlay.
	 *
	 * @param captureMode the capture mode
	 */
	public void resetCameraOverlay(CaptureMode captureMode) {

		hideIndicator();
		showCounter(false, -1);
		hideErrorMessage();
		showProcessingOverlay(false);
		setCaptureCaption(captureMode);
	}

}