/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import android.Manifest;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import com.topimagesystems.Common.OCRType;
import com.topimagesystems.Config;
import com.topimagesystems.Constants;
import com.topimagesystems.R;
import com.topimagesystems.controllers.BaseController;
import com.topimagesystems.controllers.NavigationManager;
import com.topimagesystems.controllers.imageanalyze.BarcodeReader.BarcodeResult;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISBarcodeType;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowErrorMessage;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowGeneralMessages;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowUIMessages;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.data.TISLicenseParameters;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.intent.CaptureIntent.LevelerType;
import com.topimagesystems.intent.CaptureIntent.SessionType;
import com.topimagesystems.intent.CaptureIntent.TISDocumentType;
import com.topimagesystems.intent.CaptureIntent.TISScanBarcodeLocation;
import com.topimagesystems.intent.IQASettingsIntent;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.CryptLib;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

import static com.topimagesystems.controllers.imageanalyze.CameraController.TAG;

//import net.sourceforge.zbar.Symbol;

// TODO: Auto-generated Javadoc
/**
 * The Class CameraManagerController.
 */
public class CameraManagerController extends BaseController {

    /** The Constant INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS. */
    public final static String INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS = "INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS";
    
    /** The Constant CONTINUE_ANYWAY_APPROVED. */
    public final static String CONTINUE_ANYWAY_APPROVED = "FIND_RECT_ON_HIGH_RES_IMAGE";
    
    /** The Constant IMAGE_PATH_AFTER_FALIURE. */
    public final static String IMAGE_PATH_AFTER_FALIURE = "IMAGE_PATH_AFTER_FALIURE";
    
    /** The Constant OCR_TEST_RESULT. */
    public static final int OCR_TEST_RESULT = 111;
    
    /** The Constant RESULT_FINISH_MAX_TRIES. */
    public static final int RESULT_FINISH_MAX_TRIES = 112;
    
    /** The Constant RESULT_CLOSE_SESSION. */
    public static final int RESULT_CLOSE_SESSION = 113;

    
    /** The Constant RESULT_CANCELED_FROM_ALERT. */
    public static final int RESULT_CANCELED_FROM_ALERT = 114;
    
    /** The Constant RESULT_FINISH_WITH_SESSION_RESULT. */
    public static final int RESULT_FINISH_WITH_SESSION_RESULT = 117;
    
    /** The Constant RESULT_MULTI_CAPTURE_FINISH. */
    public static final int RESULT_MULTI_CAPTURE_FINISH = 118;
    
    /** The Constant RESULT_LIBRARY_ERROR. */
    public static final int RESULT_LIBRARY_ERROR = 119;
    public static final int RESULT_CAMERA_PERMISSION_ACSSES_DENIED = 120;
	public static final int RESULT_LICENSE_INVALID = 121;
	public final static String INVALID_LISENSE_KEY = " Invalid License (b)";
	public final static String VALID_LISENSE_KEY = "Valid License Key";
	public final static String INVALID_LISENSE = "Invalid License (a)";
	public final static String INVALID_SDK_VERSION = "Invalid License (c)";
	public final static String INVALID_EXPERATION_DATE = "License Expired";
	public final static String INVALID_LISENSE_GENERAL = "Invalid License";

    /**/
    /** The tag. */
    private String tag = Logger.makeLogTag("CameraManagerController");
    //
    /** The base controller. */
    private BaseController baseController = this;
    
    /** The processing overlay. */
    private View processingOverlay;

    /** The handler. */
    private Handler handler;
    
    /** The is debug. */
    public static boolean isDebug;
    
    /** The ocr analyze session. */
    public static OCRAnalyzeSession ocrAnalyzeSession;
    
    /** The indicator string. */
    public static String[] indicatorString;
    
    /** The scan front only. */
    public static boolean scanFrontOnly;
    
    /** The scan back only. */
    public static boolean scanBackOnly;
    
    /** The front image rect array. */
    public static int[] frontImageRectArray;

    /** The should output grayscale image. */
    public static boolean shouldOutputGrayscaleImage;
    
    /** The should output original image. */
    public static boolean shouldOutputOriginalImage;
    
    /** The should output colored image. */
    public static boolean shouldOutputColoredImage;
    
    /** The should output bw image. */
    public static boolean shouldOutputBWImage;
    
    /** The is still mode. */
    public static boolean isStillMode = true; // boolean capture still mode or video mode    	    
    
    /** The is info screen enable. */
    private boolean isInfoScreenEnable = true;
    
    /** The info screen interval. */
    private long infoScreenInterval;
    
    /** The is blur enabled. */
    public static boolean isBlurEnabled;

	public static boolean isBlurOnBackEnabled;
    
    /** The max video frames to process. */
    public static int maxVideoFramesToProcess;
	public static int BarcodeDetectionTries;
	public static int maxBarcodeTries = 13;
    /** The image type. */
    public static TISDocumentType imageType;
    public static OCRType ocrType;
    
    /** The session type. */
    public static SessionType sessionType;
    
    /** The levler type. */
    public static LevelerType levlerType = null;
    
    /** The save original image to disk. */
    
    
    /** The show guidelines indicators. */
    public static boolean showGuidelinesIndicators = true;
    
    /** The capture high res images. */
    public static boolean captureHighResImages = false;
    
    /** The Constant enableSoftCaptureAndImageAligment. */
     public static boolean enableSoftCaptureAndImageAligment;

	public static boolean showMicrOverlay = false;
    
    /** The dynamic strings. */
    public static HashMap<String, String> dynamicStrings;
    
    /** The call back. */
    private static CaptureIntent.callbackReturnMessage callBack;
    public static int binarizationType;
    public static float binarizationThreshold;
    
    
    /** The gray scale size. */
    public static int[] grayScaleSize = null;
    
    public static boolean doOcrOnImage;
    
    /** The count down sound. */
    public static boolean countDownSound = false;
    
    /** The device modal. */
    public static String deviceModal = null;
    
    /** The device brand. */
    public static String deviceBrand;
    
    /** The device name. */
    public static String deviceName;
    
    /** The continue not supported hw. */
    public static boolean continueNotSupportedHw = false;
    
    /** The is multi capture. */
    public static boolean isMultiCapture = false;
    
    /** The is custom view. */
    public static boolean isCustomView = false;
    
    /** The enable processing view. */
    public static boolean enableProcessingView = true;
    
    /** The session results. */
    private SessionResultParams sessionResults;
    
    /** The false recognition video frames. */
    public static int falseRecognitionVideoFrames;

	/** The tap to focus */
	public static boolean tapToFocus = true;

	/** The show count down. */
    public static boolean showCountDown = false;
    Bundle savedState;
    /** The is session starts in stills. */
    public static boolean isSessionStartsInStills = false;
    
    public static boolean isDynamicCapture = false;
	public static boolean useCameraAPI2 = false;
	public static boolean invertedCamera = false;
    private float minRatioHW;
    private float maxRatioHW;

    /** The barcode location. */
    protected static TISScanBarcodeLocation scanBarcodeLocation = TISScanBarcodeLocation.BARCODE_NONE;

    /** The enable of the barcode location. */
    protected static boolean enableBarcodeDetection = true;

    /** The barcode types. */
    protected static ArrayList<TISBarcodeType> barcodeTypes = null;

    /** The barcode frame. */
    protected static boolean useQRFrameForBarcode = false;

    /** The cropped color image compression. */
    protected static float colorImageCompression = 1.0f;
    /** The gray color image compression. */
    protected static float grayScaleImageCompression = 1.0f;
    
    
    public static boolean useMaxResolutionStills = false;


	/////// to delete ////////
	/** The desired aspect ratio for the video frame. */
	protected static float videoFrameRectFoundAR = 0.4f;

	/** The desired aspect ratio for the preview rect. */
	protected static float prevRectToCurrentAR = 0.6f;

	/** How many rectangles to compare */
	protected static int identicalRectanglesToCapture = 3;
	protected static boolean enableTransitionBetweenRectangles = true;
	/** The max position height error. */
	protected static float softCaptureThreshold = 0;


    /* (non-Javadoc)
     * 
     * @see
     * com.topimagesystems.controllers.BaseController#onCreate(android.os.Bundle
     * ) */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState, isCustomView ? R.layout.custom_mbck_camera_manager_layout : R.layout.mbck_camera_manager_layout);


		Bundle data = getIntent().getExtras();
		if (data != null && data.containsKey(CaptureIntent.TIS_LICENSE_CLASS)) {
			try {
				TISLicenseParameters licenseOblect = (TISLicenseParameters) data.getParcelable(CaptureIntent.TIS_LICENSE_CLASS);
				String licenseResult = checkLicenseValidation(licenseOblect);
				if (!licenseResult.equals(VALID_LISENSE_KEY)) {
					Intent intentData = new Intent();
					intentData.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, licenseResult);
					Toast.makeText(getBaseContext(), licenseResult, Toast.LENGTH_SHORT).show();
					setResult(RESULT_LICENSE_INVALID, intentData);
					finish();
					return;

				}
			} catch (Exception e) {
				Log.e(tag,"Cannot read License class");
				Intent intentData = new Intent();
				intentData.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, "Failed to Parse License");
				Toast.makeText(getBaseContext(), "Failed to Parse License", Toast.LENGTH_SHORT).show();
				setResult(RESULT_LICENSE_INVALID, intentData);
				finish();
				return;
			}
		}


		if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
		     // only for gingerbread and newer versions
			savedState = savedInstanceState;
			if(askPermission()){
			}	
			else{							
				return;
			}
		}
		initSession();
    }
	
	private void initSession(){
		try{
			deviceModal = FileUtils.getDeviceModel();
			deviceBrand = FileUtils.getDeviceBrand();
			deviceName = FileUtils.getDeviceName();
			handler = new Handler();
		processingOverlay = findViewById(isCustomView ? R.id.customProcessingOverlay : R.id.processingOverlay);
		//processingOverlay.setVisibility(View.VISIBLE);
		ocrType = OCRType.OFF;
		isDebug = Config.IS_DEBUG;
		int maxNumberOfRetries = 1000;//Config.MAXIMUM_NUMBER_OF_MICR_RETRIES;
		 minRatioHW = Config.DEFAULT_VALIDATION_MIN_RATIO_HEIGHT_WIDTH;
		 maxRatioHW = Config.DEFAULT_VALIDATION_MAX_RATIO_HEIGHT_WIDTH;
		boolean isManualCapture = false;
		//callBack = this;
		boolean isUseCustomAlgorithmOnBack = true;
		boolean isBinarizeBackSameAsFront = false;
		float outputHeightInInch = -1.0f;
		float outputWidthInInch = -1.0f;
		float minRatioHWBack = -1.0f;
		float maxRatioHWBack = -1.0f;
		int txtValidFrom = 10;
		int txtValidTo = 50;
		boolean isIQAEnabled = false;
			int maxBarcodeTriesVal = getResources().getInteger(R.integer.max_barcode_tries);
			if (maxBarcodeTriesVal > 2){
				maxBarcodeTries = maxBarcodeTriesVal;
			}
		captureHighResImages = false;
		IQASettingsIntent iqaSettings = null;

			checkExceptionalDevices();
		    
		 // Here, thisActivity is the current activity

		
		if (getIntent() != null) {
			FileUtils.internalStorageLocation =  this.getFilesDir().getPath(); 
			///data/user/0/com.topimagesystems.sample/files/.mobiflow/
			FileUtils.logFilePath = FileUtils.internalStorageLocation+"/.mobiflow/log.txt";    
			FileUtils.clearMemory();
		    // get the data passed to library.	
		    isDebug = getIntent().getBooleanExtra(CaptureIntent.INTENT_IS_DEBUG, Config.IS_DEBUG);	   
		    String micrTypeName = getIntent().getStringExtra(CaptureIntent.INTENT_OCR_TYPE);

		    if (!StringUtils.isEmptyOrNull(micrTypeName)) {
			ocrType = OCRType.valueOf(micrTypeName);		
		
			// set screen orientation.		
			captureHighResImages = true; // for CMC 7 and document - need high res images.

		    } else {
			ocrType = OCRType.OFF;
		    }	
			doOcrOnImage = true;
			if (ocrType == OCRType.OFF || ocrType == OCRType.UNKNOWN){
				doOcrOnImage = false;
			}		
		    // choose whenever to start in portriat Mode or Landscape mode.
		    if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == SessionType.PORTRAIT) {
			setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

		    } else {
			setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
		    }

		    scanFrontOnly = getIntent().getBooleanExtra(CaptureIntent.SCAN_FRONT_ONLY, false) || imageType == TISDocumentType.PASSPORT;
		    scanBackOnly = getIntent().getBooleanExtra(CaptureIntent.SCAN_BACK_ONLY, false);
		    scanFrontOnly = scanBackOnly ? false : scanFrontOnly; // is scan back only set to true set scan front only to false
		    isDynamicCapture = getIntent().getBooleanExtra(CaptureIntent.ENABLE_DYNAMIC_CAPTURE, false) && imageType!= TISDocumentType.PASSPORT;
		    deviceName = FileUtils.getDeviceName();
		    
		    maxNumberOfRetries = 1000;getIntent().getIntExtra(CaptureIntent.INTENT_MAX_NUMBER_OF_RETRIES, Config.MAXIMUM_NUMBER_OF_MICR_RETRIES);
		    minRatioHW = getIntent().getFloatExtra(CaptureIntent.INTENT_MIN_RATIO_HEIGHT_WIDTH, Config.DEFAULT_VALIDATION_MIN_RATIO_HEIGHT_WIDTH);
		    maxRatioHW = getIntent().getFloatExtra(CaptureIntent.INTENT_MAX_RATIO_HEIGHT_WIDTH, Config.DEFAULT_VALIDATION_MAX_RATIO_HEIGHT_WIDTH);
		    isManualCapture = getIntent().getBooleanExtra(CaptureIntent.INTENT_IS_MANUAL_CAPTURE, false);
		    isBlurEnabled = getIntent().getBooleanExtra(CaptureIntent.IS_BLUR_ENABLED, false);
			isBlurOnBackEnabled = getIntent().getBooleanExtra(CaptureIntent.IS_BLUR_ENABLED_ON_BACK_SIDE, false);


		    /** license */
		    isUseCustomAlgorithmOnBack = false;	    
		    outputHeightInInch = -1.0f;
		    outputWidthInInch = -1.0f;
		    txtValidFrom = getIntent().getIntExtra(CaptureIntent.INTENT_TXT_VALID_FROM, 10);
		    txtValidTo = getIntent().getIntExtra(CaptureIntent.INTENT_TXT_VALID_TO, 50);
		    shouldOutputGrayscaleImage = getIntent().getBooleanExtra(CaptureIntent.GRAY_SCALE, false);
		    shouldOutputOriginalImage = getIntent().getBooleanExtra(CaptureIntent.OUTPUT_ORIGINAL_IMAGE, false);
		    shouldOutputColoredImage = getIntent().getBooleanExtra(CaptureIntent.OUTPUT_COLORED_IMAGE, false);
		    shouldOutputBWImage = getIntent().getBooleanExtra(CaptureIntent.OUTPUT_BW_IMAGE, true);
		    showGuidelinesIndicators = getIntent().getBooleanExtra(CaptureIntent.GUIDLINES_INDICATOR, true);
		    enableProcessingView = getIntent().getBooleanExtra(CaptureIntent.ENABLE_PROCESSING_VIEW, true);
		    maxVideoFramesToProcess = getIntent().getIntExtra(CaptureIntent.MAX_VIDEO_FRAMES_TO_CAPTURE, 7);
		    isBinarizeBackSameAsFront = getIntent().getBooleanExtra(CaptureIntent.IS_BINARIZE_BACK_SAME_AS_FRONT, false);
		    isCustomView = getIntent().getBooleanExtra(CaptureIntent.IS_CUSTOM_VIEW, false);
		    isMultiCapture = getIntent().getBooleanExtra(CaptureIntent.ENABLE_MULTI_CAPTURE, false);	    
		    grayScaleSize = getIntent().getIntArrayExtra(CaptureIntent.GRAY_SCALE_SIZE);//getBooleanExtra(MICRIntent.SCAN_BACK_ONLY, false);
		    isIQAEnabled = getIntent().getBooleanExtra(CaptureIntent.INTENT_IQA_ENABLED, false);
		    countDownSound = getIntent().getBooleanExtra(CaptureIntent.ENABLE_COUNTDOWN_SOUND, false);	    
		    binarizationType = getIntent().getIntExtra(CaptureIntent.BINARIZATION_TYPE, 0);
		    enableSoftCaptureAndImageAligment = getIntent().getBooleanExtra(CaptureIntent.ENABLE_SOFT_CAPTURE, false);
			enableTransitionBetweenRectangles =  getIntent().getBooleanExtra(CaptureIntent.ENABLE_TRANSIATION_BETWEEN_ANIMATION, true);
			showMicrOverlay = getIntent().getBooleanExtra(CaptureIntent.INTENT_SHOW_MICR_OVERALY, false) && (imageType == TISDocumentType.CHECK && ocrType == OCRType.CMC7);
		    if (imageType == TISDocumentType.CHECK){
		    	binarizationType = Constants.TIS_CHECK_BINARIZATION;
		    }		    
		    useMaxResolutionStills  = getIntent().getBooleanExtra(CaptureIntent.USE_MAX_RESOLUTION_STILLS, false);
			useCameraAPI2  = getIntent().getBooleanExtra(CaptureIntent.USE_CAMERA_API2, false);
			if (android.os.Build.VERSION.SDK_INT < android.os.Build.VERSION_CODES.LOLLIPOP || isDynamicCapture){
				useCameraAPI2 = false;
			}
			binarizationThreshold = getIntent().getFloatExtra(CaptureIntent.BINARIZATION_TRASHOLD, 30);
			if (binarizationThreshold > 0 && binarizationThreshold < 1){
				binarizationThreshold*=100;
			}
		    scanBarcodeLocation = TISScanBarcodeLocation.getEnum(
		    			getIntent().getIntExtra(CaptureIntent.SCAN_BARCODE_LOCATION, TISScanBarcodeLocation.BARCODE_NONE.getValue())
		    			);
		    
		    enableBarcodeDetection = (scanBarcodeLocation != TISScanBarcodeLocation.BARCODE_NONE);
		    
		    if (enableBarcodeDetection){
		    	barcodeTypes = TISBarcodeType.getEnumArrayListFromIntegerList(getIntent().getIntegerArrayListExtra(CaptureIntent.BARCODE_TYPES));
		    	if (barcodeTypes == null || barcodeTypes.size() == 0)
		    		barcodeTypes = BarcodeReader.getAllTISBarcodeTypes();
			    useQRFrameForBarcode = false;
			    typesLoop:for (TISBarcodeType barcodeType : barcodeTypes)
			    	if (barcodeType == TISBarcodeType.QR_CODE || barcodeType == TISBarcodeType.DATA_MATRIX_CODE
			    			|| barcodeType == TISBarcodeType.AZTEC_CODE){

			    		useQRFrameForBarcode = true;
			    		break typesLoop;
			    	}
		    }

		    colorImageCompression = getIntent().getFloatExtra(CaptureIntent.COLOR_IMAGE_COMPRESSION, 1.0f);
		    colorImageCompression = Math.max(colorImageCompression, 0);
		    colorImageCompression = Math.min(colorImageCompression, 1.0f);

			if (CameraManagerController.enableSoftCaptureAndImageAligment)
				softCaptureThreshold = getIntent().getFloatExtra(CaptureIntent.TIS_SOFT_CAPTURE_THRESHOLD, 0);
			else
				softCaptureThreshold = 0;

		    if (CameraManagerController.sessionType == SessionType.TEST) { // if test activated go to Test
			// Flow.
			initOcrAnalyzeSession(getApplicationContext(), ocrType, maxNumberOfRetries, minRatioHW, maxRatioHW, isManualCapture, isUseCustomAlgorithmOnBack,
				isBinarizeBackSameAsFront, outputHeightInInch, outputWidthInInch, minRatioHWBack, maxRatioHWBack, txtValidFrom, txtValidTo, isIQAEnabled, iqaSettings,
				false);
			//FileUtils.deleteFile(FileUtils.logFilePath);
			String folderLocation = getIntent().getStringExtra(CaptureIntent.FOLDER_LOCATION);
			Bundle extras = new Bundle();
			extras.putString(CaptureIntent.FOLDER_LOCATION, folderLocation);
			Intent i; 
			if (!isDynamicCapture){
				i = new Intent(getBaseContext(), CameraController.class);
			}else{
				i = new Intent(getBaseContext(),  DynamicCaptureCameraController.class);
			}
			isDebug = true;
			i.putExtras(extras);
			startActivityForResult(i, OCR_TEST_RESULT);

		    }
		    isInfoScreenEnable = getIntent().getBooleanExtra(CaptureIntent.INFO_SCREEN_ENABLED, true);
		
		    infoScreenInterval = getIntent().getLongExtra(CaptureIntent.INFO_SCREEN_INTERVAL, 10000);

			tapToFocus = getIntent().getBooleanExtra(CaptureIntent.TAP_TO_FOCUS, true);

		    iqaSettings = populateIQASettings();
		    
//			if (!CameraManagerController.isDebug){ // don't delete image folder on Test mode.
//			      FileUtils.clearSessionImages(this);
//			}
		
		    setIndicatorsString();
		}
		
	    colorImageCompression = getIntent().getFloatExtra(CaptureIntent.COLOR_IMAGE_COMPRESSION, 1.0f);
	    colorImageCompression = Math.max(colorImageCompression, 0);
	    colorImageCompression = Math.min(colorImageCompression, 1.0f);
	    
	    grayScaleImageCompression = getIntent().getFloatExtra(CaptureIntent.GRAY_SCALE_IMAGE_COMPRESSION, 1.0f);
	    grayScaleImageCompression = Math.max(grayScaleImageCompression, 0);
	    grayScaleImageCompression = Math.min(grayScaleImageCompression, 1.0f);
		
		Logger.setIsDebugMode(isDebug);
		Logger.setMinLogLevel(Logger.ERROR);// set deug log level
		initOcrAnalyzeSession(getApplicationContext(), ocrType, maxNumberOfRetries, minRatioHW, maxRatioHW, isManualCapture, isUseCustomAlgorithmOnBack,
			isBinarizeBackSameAsFront, outputHeightInInch, outputWidthInInch, minRatioHWBack, maxRatioHWBack, txtValidFrom, txtValidTo, isIQAEnabled, iqaSettings,
			isBlurEnabled);
	    isStillMode   = !(getIntent().getBooleanExtra(CaptureIntent.ENABLE_VIDEO_MODE, false) && imageType != TISDocumentType.FULL_PAGE && CameraConfigurationManager.isVideoModeSupported(this));
	    isSessionStartsInStills = isStillMode;
	    showCountDown = getIntent().getBooleanExtra(CaptureIntent.SHOW_COUNT_DOWN, false) && isStillMode;// contdown disabled on video mode.
	  
	    if (isIQAEnabled || isStillMode || imageType!=TISDocumentType.CHECK) {
		shouldOutputBWImage = true;
	    }
		if (scanBackOnly) {
			int[] size = getIntent().getIntArrayExtra(CaptureIntent.FRONT_IMAGE_RECT);
			if (size != null) {
				getOcrAnalyzeSession(this).frontImageRect = FileUtils.arrayToRect(new int[]{0, 0, size[0], size[1]});//getBooleanExtra(MICRIntent.SCAN_BACK_ONLY, false);
			}


			openCameraForBackCapture(false);
		}
		
		   
		else if (sessionType != SessionType.TEST) {
			if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
			     // only for gingerbread and newer versions
				if(askPermission()){
					openCameraForFrontCapture(false);	
				}			
			}		
			else{
				openCameraForFrontCapture(false);
			}
		}
		CameraController.timeVideoCaptureEnd = false;
//		if (showInstructionsSlides) {
//		    startActivity(new Intent(this, ViewPagerFragmentActivity.class));
//		}
		if (isDebug){
			saveIncomingParametersToLogFile();
		}
		}catch(Exception e){		
			String errorMessage = Log.getStackTraceString(e);
			if (errorMessage == null){
				errorMessage = "";
			}
			if (CameraManagerController.isDebug){
				FileUtils.addToLogFile(tag+" Exception ",errorMessage ,getApplicationContext());	
			}				
			Intent data = new Intent();			
			Log.e(tag,  errorMessage);			
			data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS,errorMessage);
			setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
			finish();
		}

	}

    /**
     * Populate iqa settings.
     *
     * @return the IQA settings intent
     */
    private IQASettingsIntent populateIQASettings() {
	IQASettingsIntent iqaSettings;
	if (getIntent().hasExtra(CaptureIntent.INTENT_IQA_SETTINGS)) {
	    final Bundle bundleIQASettings = getIntent().getBundleExtra(CaptureIntent.INTENT_IQA_SETTINGS);
	    iqaSettings = new IQASettingsIntent(bundleIQASettings);
	    return iqaSettings;
	} else {
	    iqaSettings = new IQASettingsIntent();
	}
	return iqaSettings;
    }

    /* (non-Javadoc)
     * @see android.app.Activity#onRestoreInstanceState(android.os.Bundle)
     */
    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
	super.onRestoreInstanceState(savedInstanceState);

	isDebug = savedInstanceState.getBoolean("isDebug");
	
	ocrAnalyzeSession = new OCRAnalyzeSession(savedInstanceState.getBundle("ocrAnalyzeSession"));
    }

    /* (non-Javadoc)
     * @see android.app.Activity#onSaveInstanceState(android.os.Bundle)
     */
    @Override
    protected void onSaveInstanceState(Bundle outState) {
	super.onSaveInstanceState(outState);

	outState.putBoolean("isDebug", isDebug);
	if (ocrAnalyzeSession != null){
		outState.putBundle("ocrAnalyzeSession", ocrAnalyzeSession.toBundle());
	}
    }

	private void checkExceptionalDevices() {
		try {
			String[] invertedCameraList;
			String[] useAPI2DevicesList;
			CameraManagerController.invertedCamera = false;
			String all = "all";

			invertedCameraList = getResources().getStringArray(R.array.calculateVideoToScreenAspectRatio);
			useAPI2DevicesList = getResources().getStringArray(R.array.exception_devices_use_cameraAPI2);
			//ig th
			if ( (invertedCameraList == null || invertedCameraList.length == 0) && (useAPI2DevicesList == null || useAPI2DevicesList.length == 0)){
				return;
			}
			if (invertedCameraList != null && invertedCameraList.length > 0) {
				for (int i = 0; i < invertedCameraList.length; i++) {
					invertedCameraList[i] = invertedCameraList[i].trim().toLowerCase();
					if (invertedCameraList[i].equals(all.trim())){
						CameraManagerController.invertedCamera = true;
						return;
					}
				}
				if (Arrays.asList(invertedCameraList).contains(CameraManagerController.deviceName.trim().toLowerCase())) {
					CameraManagerController.invertedCamera = true;
					return;
				}

			}
			if (useAPI2DevicesList != null && useAPI2DevicesList.length > 0 && !CameraManagerController.isDynamicCapture && !CameraManagerController.useCameraAPI2) {

				for (int i = 0; i < useAPI2DevicesList.length; i++) {
					useAPI2DevicesList[i] = useAPI2DevicesList[i].trim().toLowerCase();
					if (useAPI2DevicesList[i].toLowerCase(Locale.US).equals(all.trim())){
						CameraManagerController.useCameraAPI2 = true;
						return;
					}

				}
				if (Arrays.asList(useAPI2DevicesList).contains(CameraManagerController.deviceName.trim().toLowerCase())) {
					CameraManagerController.useCameraAPI2 = true;
					return;
				}


			}}catch(Exception e){
			Logger.e(TAG, Log.getStackTraceString(e));
		}
	}

    /**
     * Open camera for front capture.
     *
     * @param isProcessCurrentImage the is process current image
     */
    private void openCameraForFrontCapture(boolean isProcessCurrentImage) {
	Bundle extras = new Bundle();
	extras.putBoolean(CaptureIntent.INFO_SCREEN_ENABLED, isInfoScreenEnable);
	extras.putLong(CaptureIntent.INFO_SCREEN_INTERVAL, infoScreenInterval);
	if (isProcessCurrentImage) {
	    extras.putBoolean(INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS, isProcessCurrentImage);
	}
	ocrAnalyzeSession.captureMode = CaptureMode.FRONT;
	
	ocrAnalyzeSession.isBarcodeSession = CameraManagerController.enableBarcodeDetection && 
	(CameraManagerController.scanBarcodeLocation == TISScanBarcodeLocation.BARCODE_FRONT ||
			CameraManagerController.scanBarcodeLocation == TISScanBarcodeLocation.BARCODE_FRONT_AND_BACK);
	
	Class<?> activityToUse;
	if (!CameraManagerController.isDynamicCapture){		
		activityToUse = com.topimagesystems.controllers.imageanalyze.CameraController.class;
	}
	else{
		activityToUse =  com.topimagesystems.controllers.imageanalyze.DynamicCaptureCameraController.class; 
	}
	NavigationManager.getInstance().showNewScreen(baseController, activityToUse, extras, Constants.CAMERA_REQUEST_CODE,
		false);
    }

    /**
     * Open camera for back capture.
     *
     * @param isProcessCurrentImage the is process current image
     */
    public void openCameraForBackCapture(boolean isProcessCurrentImage) {
	Bundle extras = new Bundle();	
	extras.putBoolean(CaptureIntent.INFO_SCREEN_ENABLED, isInfoScreenEnable);
	extras.putLong(CaptureIntent.INFO_SCREEN_INTERVAL, infoScreenInterval);
	if (isProcessCurrentImage) {
	    extras.putBoolean(INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS, isProcessCurrentImage);
	}
	ocrAnalyzeSession.captureMode = CaptureMode.BACK;

	
	ocrAnalyzeSession.isBarcodeSession = CameraManagerController.enableBarcodeDetection && 
	(CameraManagerController.scanBarcodeLocation == TISScanBarcodeLocation.BARCODE_BACK ||
			CameraManagerController.scanBarcodeLocation == TISScanBarcodeLocation.BARCODE_FRONT_AND_BACK);
	
	if(CameraManagerController.isBlurOnBackEnabled) {
		CameraManagerController.isBlurEnabled = true;
	}
	else {
		CameraManagerController.isBlurEnabled = false;
	}
	//isBlurEnabled = false;
	Class<?> activityToUse;
	if (!CameraManagerController.isDynamicCapture){		
		activityToUse = com.topimagesystems.controllers.imageanalyze.CameraController.class;
	}
	else{
		activityToUse =  com.topimagesystems.controllers.imageanalyze.DynamicCaptureCameraController.class; 
	}
	NavigationManager.getInstance().showNewScreen(baseController, activityToUse, extras, Constants.CAMERA_REQUEST_CODE,
			false);
    }

    /**
     * Finish activity for result.
     *
     * @param isSuccess the is success
     * @param resultCode the result code
     */
    private void finishActivityForResult(boolean isSuccess, int resultCode) {
	Logger.i(tag, "create session params");
	Intent data = new Intent();
	setResult(resultCode, data);
	String[] ocrData = null;
	String[] barcodeData = null;
	if (isSuccess) {
	    Logger.i(tag, "finishActivityForResult " + isSuccess);
	    ocrData = new String[4];

	    if (ocrAnalyzeSession.getOCRAnalyzeResult().getOcrResult() != null) {
		final OCRResult ocrResult = ocrAnalyzeSession.getOCRAnalyzeResult().getOcrResult();
		Logger.i(tag, "add ocr parameters to SessionResultParams");
		if (ocrResult != null) {
		    ocrData[0] = String.valueOf(ocrResult.digitalRowLength);
		    ocrData[1] = ocrResult.ocrResultWithDelimiter;
		    ocrData[2] = ocrResult.ocrRawResult;
		    ocrData[3] = ocrResult.scoreResult;
		}

	    } else {
		ocrData = null;
		Logger.i(tag, "no OCR Results found");
	    }
	    
	    barcodeData = new String[4];
	    final BarcodeResult barcodeResult = ocrAnalyzeSession.getBarcodeResult();
	    if (!barcodeResult.isEmpty()) {
	    	barcodeData[0] = String.valueOf(barcodeResult.getBarcodeTypeFrontForBundle());
	    	barcodeData[1] = barcodeResult.getBarcodeDataFront();
	    	barcodeData[2] = String.valueOf(barcodeResult.getBarcodeTypeBackForBundle());
	    	barcodeData[3] = barcodeResult.getBarcodeDataBack();
		}
	    else
	    	barcodeData = null;
	    
	    sessionResults = new SessionResultParams(ocrData, FileUtils.rectToIntArray(ocrAnalyzeSession.frontImageRect), ocrAnalyzeSession.frontRetries,
		    ocrAnalyzeSession.backRetries, barcodeData);
	    data.putExtra(CaptureIntent.CURRENT_SESSION_PARAMS, sessionResults);
	    Logger.i(tag, "cameraManager result OK");
	    //add ocr data

	} else {
	    Logger.i(tag, "finishActivityForResult " + isSuccess);
	}
	finish();

    }
    
    
    /* (non-Javadoc)
     * @see android.app.Activity#onActivityResult(int, int, android.content.Intent)
     */
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
	Logger.i(tag, "Enter CameraManager on");

	if (CameraManagerController.sessionType == SessionType.TEST) {
	    Logger.i(tag, "finish test session");

	    finish();
	    // finishActivityForResult(true, false);
	}
		
	switch (resultCode) {
	case RESULT_CANCELED:
	    Logger.i(tag, "onActivityResult CAMERA_REQUEST_CODE");
	    clearOcrAnalyzeSession();
	    sessionResults.originalFront = null;
	    sessionResults.originalBack = null;
	    setResult(RESULT_CANCELED);
	    finish();
	    break;

	case RESULT_OK:
	    setResult(RESULT_OK, data);
	    finishActivityForResult(true, resultCode);
	    break;

	case RESULT_CANCELED_FROM_ALERT:
	    finishActivityForResult(false, resultCode);
	    break;

	case RESULT_CLOSE_SESSION:
	    finishActivityForResult(true, resultCode);
	    break;

	case RESULT_FINISH_MAX_TRIES:
	    finishActivityForResult(true, resultCode);
	    break;
	case RESULT_LIBRARY_ERROR: // exception from camera controller set result.
		setResult(resultCode,data);
		finish();
		break;
	default:
	    finishActivityForResult(true, resultCode);
	    break;

	}

    }
    
    /**
     * Gets the version number.
     *
     * @return the version number
     */
    private void getVersionNumber(){
    	try{
    	    PackageInfo pInfo = getPackageManager().getPackageInfo(getPackageName(), 0);
    	    String version = getResources().getString(R.string.TISVersion);
    	    Logger.i(tag, version);
    	    if (isDebug){
    	    	FileUtils.addToLogFile(tag, "Version Number is " + version, getApplicationContext());	    	
    	    }
    		}catch(Exception e){
    			if (isDebug){
    		    	FileUtils.addToLogFile(tag, "Version Number Not found ",getApplicationContext());	    	
    		    }    			
    		}
    	
    }

    /**
     * Gets the image result.
     *
     * @return the image result
     */
    public SessionResultParams getImageResult() {
	return sessionResults;
    }

    /**
     * Gets the ocr analyze session.
     *
     * @param context the context
     * @return the ocr analyze session
     */
    public static OCRAnalyzeSession getOcrAnalyzeSession(Context context) {
	return ocrAnalyzeSession;
    }

    /**
     * Sets the ocr analyze session.
     *
     * @param ocrAnalyzeSession the new ocr analyze session
     */
    public static void setOcrAnalyzeSession(OCRAnalyzeSession ocrAnalyzeSession) {
	CameraManagerController.ocrAnalyzeSession = ocrAnalyzeSession;
    }

    /**
     * Inits the ocr analyze session.
     *
     * @param context the context
     * @param micrType the micr type
     * @param maxNumberOfRetries the max number of retries
     * @param minimumRatioHeightWidth the minimum ratio height width
     * @param maxRatioHeightWidth the max ratio height width
     * @param isManualCapture the is manual capture
     * @param isUseCustomAlgorithmOnBack the is use custom algorithm on back
     * @param isBinarizeBakSameAsFront the is binarize bak same as front
     * @param outputHeightInInch the output height in inch
     * @param outputWidthInInch the output width in inch
     * @param minRatioHWBack the min ratio hw back
     * @param maxRatioHWBack the max ratio hw back
     * @param txtValidFrom the txt valid from
     * @param txtValidTo the txt valid to
     * @param isIQAEnabled the is iqa enabled
     * @param iqaSettings the iqa settings
     * @param isBlurEnabled the is blur enabled
     * @return the OCR analyze session
     */
    public static OCRAnalyzeSession initOcrAnalyzeSession(Context context, OCRType micrType, int maxNumberOfRetries, float minimumRatioHeightWidth, float maxRatioHeightWidth,
	    boolean isManualCapture, boolean isUseCustomAlgorithmOnBack, boolean isBinarizeBakSameAsFront, float outputHeightInInch, float outputWidthInInch, float minRatioHWBack,
	    float maxRatioHWBack, int txtValidFrom, int txtValidTo, boolean isIQAEnabled, IQASettingsIntent iqaSettings, boolean isBlurEnabled) {
	setOcrAnalyzeSession(new OCRAnalyzeSession(context, micrType, maxNumberOfRetries, minimumRatioHeightWidth, maxRatioHeightWidth, isManualCapture,
		isUseCustomAlgorithmOnBack, isBinarizeBakSameAsFront, outputHeightInInch, outputWidthInInch, minRatioHWBack, maxRatioHWBack, txtValidFrom, txtValidTo,
		isIQAEnabled, iqaSettings, null, isBlurEnabled));
	return ocrAnalyzeSession;
    }

    /**
     * Clear ocr analyze session.
     */
    public void clearOcrAnalyzeSession() {
	if (ocrAnalyzeSession != null) {
	    ocrAnalyzeSession.clear();
	    ocrAnalyzeSession = null;
	}
    }

    /* (non-Javadoc)
     * @see com.topimagesystems.controllers.BaseController#onResume()
     */
    @Override
    protected void onResume() {
	// TODO Auto-generated method stub
	super.onResume();

    }

    /**
     * Sets the indicators string.
     *
     * @return the string[]
     */
    public String[] setIndicatorsString() {
	indicatorString = new String[15];
	indicatorString[0] = StringUtils.dynamicString(this, "TISFlowIndicatorTop");
	indicatorString[1] = StringUtils.dynamicString(this, "TISFlowIndicatorDown");
	indicatorString[2] = StringUtils.dynamicString(this, "TISFlowIndicatorLeft");
	indicatorString[3] = StringUtils.dynamicString(this, "TISFlowIndicatorRight");
	indicatorString[4] = StringUtils.dynamicString(this, "TISFlowIndicatorHold");
	indicatorString[5] = StringUtils.dynamicString(this, "TISFlowIndicatorAlign");

	indicatorString[6] = StringUtils.dynamicString(this, "TISFlowIndicatorRotateLeft");
	indicatorString[7] = StringUtils.dynamicString(this, "TISFlowIndicatorRotateRight");
	indicatorString[8] = StringUtils.dynamicString(this, "TISFlowIndicatorZoomIn");
	indicatorString[9] = StringUtils.dynamicString(this, "TISFlowIindicatorZoomOut");
	indicatorString[10] = StringUtils.dynamicString(this, "TISFlowIndicatorLight");
	indicatorString[11] = StringUtils.dynamicString(this, "ic_indicator_blur");
	indicatorString[12] = StringUtils.dynamicString(this, "TISFlowIndicatorAlignFlat");
	indicatorString[13] = StringUtils.dynamicString(this, "TISFlowIndicatorScanBarcode");
	indicatorString[14] = StringUtils.dynamicString(this, "TISAspectRatioError");
	return indicatorString;

    }
    
    /**
     * Save incoming parameters to log file.
     */

    private void saveIncomingParametersToLogFile(){  
    	try{
		FileUtils.addToLogFile("device: "+ deviceName, this);
    	FileUtils.addToLogFile("Version Number "+ getString(R.string.TISVersion), this);
        FileUtils.addToLogFile("Debug "+ isDebug, this);
        FileUtils.addToLogFile("scanBackOnly "+ scanBackOnly, this);
        FileUtils.addToLogFile("scanFrontOnly "+ scanFrontOnly, this);
        FileUtils.addToLogFile("frontImageRectArray "+ frontImageRectArray, this);
        FileUtils.addToLogFile("shouldOutputGrayscaleImage "+ shouldOutputGrayscaleImage, this);
        FileUtils.addToLogFile("shouldOutputOriginalImage "+ shouldOutputOriginalImage, this);
        FileUtils.addToLogFile("shouldOutputColoredImage "+ shouldOutputColoredImage, this);
        FileUtils.addToLogFile("shouldOutputBWImage "+ shouldOutputBWImage, this);
        FileUtils.addToLogFile("isStillMode "+ isStillMode, this);
        FileUtils.addToLogFile("isInfoScreenEnable "+ isInfoScreenEnable, this);
        FileUtils.addToLogFile("infoScreenInterval "+ infoScreenInterval, this);
        FileUtils.addToLogFile("isBlurEnabled "+ isBlurEnabled, this);
			FileUtils.addToLogFile("isBlurOnBackSideEnabled "+ isBlurOnBackEnabled, this);
        FileUtils.addToLogFile("maxVideoFramesToProcess "+ maxVideoFramesToProcess, this);
        if (imageType != null && imageType.name()!=null){
        	FileUtils.addToLogFile("imageType "+ imageType.name(), this);
        }
        if (sessionType != null && sessionType.name()!=null){
        	FileUtils.addToLogFile("sessionType "+ sessionType.name(), this);
        }
        FileUtils.addToLogFile("showGuidelinesIndicators "+ showGuidelinesIndicators, this);
        FileUtils.addToLogFile("enableSoftCaptureAndImageAligment " + enableSoftCaptureAndImageAligment, this);
        FileUtils.addToLogFile("countDownSound "+countDownSound, this);
        FileUtils.addToLogFile("continueNotSupportedHw "+ continueNotSupportedHw, this);
        FileUtils.addToLogFile("isMultiCapture "+ isMultiCapture, this);
        FileUtils.addToLogFile("isCustomView "+ isCustomView, this);
        FileUtils.addToLogFile("enableProcessingView "+ enableProcessingView, this);
        FileUtils.addToLogFile("falseRecognitionVideoFrames "+ falseRecognitionVideoFrames, this);        
        FileUtils.addToLogFile("enableProcessingView "+ enableProcessingView, this);
        FileUtils.addToLogFile("showCountDown "+ showCountDown, this);
        FileUtils.addToLogFile("isSessionStartsInStills "+ isSessionStartsInStills, this);
        FileUtils.addToLogFile("isDynamicCapture "+ isDynamicCapture, this);
        FileUtils.addToLogFile("enableBarcodeDetection "+ enableBarcodeDetection, this);
        FileUtils.addToLogFile("useMaxResolutionStills "+ useMaxResolutionStills, this);
        FileUtils.addToLogFile("AspectRatioMax "+ maxRatioHW + " AspectRatioMin " + minRatioHW, this);
        
    	}catch(Exception e){
    		String errorMessage = Log.getStackTraceString(e);
    		if (errorMessage == null){
    			errorMessage = "";
    		}
    		if (CameraManagerController.isDebug){
    			FileUtils.addToLogFile(tag+" Exception ",errorMessage ,getApplicationContext());	
    		}				
    		Intent data = new Intent();			
    		Log.e(tag,  errorMessage);			
    		data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS,errorMessage);
    		setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);    		    		
    	}   
    }

    /**
     * Sets the screen orientation.
     */
    public static int getDocumentAsInt(TISDocumentType image){    	
    	switch(image){
    	case CHECK:
    		return 0;
    		
    	case PAYMENT:
    		return 1;
    	case FULL_PAGE:
    		return 2;
    		
    	case CUSTOM:
    		return 3;
    		
    	case PASSPORT:
    		return 4;
    		
    	case CARD:
    		return 5;    		    		
    	
    	}
    	return -1;
    }
    private void setScreenOrientation() {
	if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == SessionType.PORTRAIT) {
	    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

	} else {

	    int rotation = getWindowManager().getDefaultDisplay().getRotation();
	    if (rotation == Surface.ROTATION_0) {
		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
	    } else if (rotation == Surface.ROTATION_270) {
		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE);
	    } else if (rotation == Surface.ROTATION_90) {
		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);

	    } else if (rotation == Surface.ROTATION_180) {
		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE);

	    }

	}
    }

    /**
     * The Interface callBackMessage.
     */
    public interface TISMobiFlowMessages {
	
	/**
	 * On flow message receive.
	 *
	 * @param message the message
	 * @param extraData the extra data
	 * @param context the context
	 */
	public void onMobiFlowGeneralMessageReceived(TISFlowGeneralMessages message, Object[] extraData, Context context);

	/**
	 * On error message receive.
	 *
	 * @param error the error
	 * @param extraData the extra data
	 * @param context the context
	 */
	public void onMobiFlowErrorMessageReceived(TISFlowErrorMessage error, Object[] extraData, Context context);
	
	
	/**
	 * On camera UI event.
	 *
	 * @param message the message
	 * @param cameraOverlayView the camera overlay view
	 */
	public void onMobiFlowUIEventMessageReceived(TISFlowUIMessages message, ViewGroup cameraOverlayView);
	
	
	/**
	 * On failed.
	 */
	public void onFailed();
    }
 

    /* (non-Javadoc)
     * @see android.app.Activity#onDestroy()
     */
    @Override
    protected void onDestroy() {
    	try{
	// TODO Auto-generated method stub
	super.onDestroy();
	Logger.i(tag, "enter onDestroy");
	CameraController.getInstance().releaseCameraAndResources();
	CameraSessionManager.clearCameraSessionManager();
	CameraController.unregisterListener();	
    	}
    	catch(Exception e){
    		if (CameraManagerController.isDebug){
    			Logger.e(tag, Log.getStackTraceString(e));
    			FileUtils.addToLogFile(Log.getStackTraceString(e),this);
    		}
    	}
		
    }
	@TargetApi(23)
	private boolean askPermission(){		

	    PackageManager pm = this.getPackageManager();
	    String permission = "android.permission.CAMERA";
	    int res = pm.checkPermission(permission,this.getPackageName());
	     if (res == PackageManager.PERMISSION_GRANTED){	    	 
	    	 return true;    	 
	     }  
	     else{
	         requestPermissions(
	                    new String[]{Manifest.permission.CAMERA},
	                    Constants.CAMERA_PERMISSIONS_REQUEST);
	     }
	    	return false;
	}


	@Override
	public void onRequestPermissionsResult(int requestCode,
	        String permissions[], int[] grantResults) {
	    switch (requestCode) {
	        case Constants.CAMERA_PERMISSIONS_REQUEST: {
	            // If request is cancelled, the result arrays are empty.
	            if (grantResults.length > 0
	                && grantResults[0] == PackageManager.PERMISSION_GRANTED) {	  
	            	initSession();
	                // permission was granted, yay! Do the
	                // contacts-related task you need to do.

	            } else {
	            	Intent data = new Intent();
	            	String errorMessage =  "Camera Permission was not Aprroved";	    			
	    			data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, errorMessage);
	    			setResult(CameraManagerController.RESULT_CAMERA_PERMISSION_ACSSES_DENIED, data);
	            	finish();
	                // permission denied, boo! Disable the
	                // functionality that depends on this permission.
	            }
	            return;
	        }

	        // other 'case' lines to check for other
	        // permissions this app might request
	    }
	}
	public String checkLicenseValidation(TISLicenseParameters lisenceData){
		String lisenceResult = INVALID_LISENSE_GENERAL;
		try {
			if (getPackageName().equals("com.topimagesystems.sample")){
				lisenceResult = VALID_LISENSE_KEY;
				return lisenceResult;
			}
			if (lisenceData.getLicense().length() < 1){
				lisenceResult = INVALID_LISENSE_GENERAL;
				return lisenceResult;
			}

			if (lisenceData == null || lisenceData.getLicense() == null || lisenceData.getLicenseKey() == null || lisenceData.getActiveLicense() == null){
				return lisenceResult;
			}
			String iv = "9Image!Systems1%";
			byte[] ivBytes = iv.getBytes("US-ASCII");
			CryptLib crypt = new CryptLib();
			crypt._iv = ivBytes;
			String licenseKey = lisenceData.getLicenseKey().substring(0,32);
			String decryptedLicense = crypt.decrypt(lisenceData.getActiveLicense(),licenseKey,null);

			String[] decryptValues;
			decryptValues = decryptedLicense.split(";");
			if (!decryptValues[0].equals(lisenceData.getLicense())){
				return lisenceResult = INVALID_LISENSE;
			}
			if (!decryptValues[1].equals(lisenceData.getLicenseKey())){
				return lisenceResult = INVALID_LISENSE_KEY;
			}
			// parse license to major minor hot fix, only service pack shouldnt use different license that's way comapring only first char!
			String currVersion = getResources().getString(R.string.TISVersion).substring(0,5);
			String licenseVersion = decryptValues[2].substring(0,5);
			if (!currVersion.equals(licenseVersion)){
				return lisenceResult = INVALID_SDK_VERSION;
			}
			lisenceResult =  VALID_LISENSE_KEY;
			if (decryptValues[3].equals("00000000") ){
				return VALID_LISENSE_KEY;
			}
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
			String currentDateAndTime = dateFormat.format(new Date());
			if (decryptValues[3].length() != 8){
				return lisenceResult = INVALID_EXPERATION_DATE;
			}
			Date strDate = dateFormat.parse(decryptValues[3]);
			if (currentDateAndTime.equals(decryptValues[3])){
				return lisenceResult = VALID_LISENSE_KEY;
			}
			if (new Date().after(strDate)) {
				return lisenceResult = INVALID_EXPERATION_DATE;
			}


		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (NoSuchPaddingException e) {
			e.printStackTrace();
		} catch (InvalidKeyException e) {
			e.printStackTrace();
		} catch (InvalidAlgorithmParameterException e) {
			e.printStackTrace();
		} catch (IllegalBlockSizeException e) {
			e.printStackTrace();
		} catch (BadPaddingException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (ParseException e) {
			e.printStackTrace();
		}

		return lisenceResult;
	}
	
	
    @Override
    protected void ensureActionBar() {
	// TODO Auto-generated method stub

    }

}