/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.topimagesystems.Config;
import com.topimagesystems.Constants;
import com.topimagesystems.R;
import com.topimagesystems.camera2.CameraAPI2Manager;
import com.topimagesystems.controllers.BaseController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController.TISMobiFlowMessages;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager.State;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.HintIndicator;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.NEXT_ACTION;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.OCRAnalyzeErrorCode;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowErrorMessage;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowGeneralMessages;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowInputMessages;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowUIMessages;
import com.topimagesystems.data.Preferences;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.intent.CaptureIntent.SessionType;
import com.topimagesystems.intent.CaptureIntent.TISDocumentType;
import com.topimagesystems.intent.CaptureIntent.TISScanBarcodeLocation;
import com.topimagesystems.micr.BoundingBoxResult;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.micr.OCRCommon.ErrorCode;
import com.topimagesystems.micr.OCRCommon.OCRDetectorStatus;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.micr.TISPassportProcessingResults;
import com.topimagesystems.ui.InfoScreenActivity;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.OcrValidationUtils;
import com.topimagesystems.util.StringUtils;

import org.opencv.android.OpenCVLoader;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

/**
 * The Class CameraController.
 */
@SuppressLint("NewApi")
public class CameraController extends BaseController implements SurfaceHolder.Callback, CaptureIntent.callbackReturnMessage {

	/** The Constant TAG. */
	protected static final String TAG = Logger.makeLogTag("CameraController");

	//
	/** The is debug. */
	protected boolean isDebug;

	/** The is initalized. */
	protected static boolean isInitalized;

	/** The handler. */
	protected CameraActivityHandler handler;

	/** The is surface created. */
	protected boolean isSurfaceCreated;

	/** The mobi checkocr. */
	protected MobiCHECKOCR mobiCHECKOCR;

	/** The layout root. */
	public RelativeLayout layoutRoot;

	/** The surface view. */
	public SurfaceView surfaceView;

	/** The camera overlay view. */
	public  CameraOverlayLayout cameraOverlayView;
	public CameraAPI2Manager camera2Instance;

	protected DynamicCameraOverlayLayout dynamicCameraOverlayView;
	/** The is valid orientation. */
	protected boolean isValidOrientation = true;

	/** The config manager. */
	private CameraConfigurationManager configManager;

	/** The sensor manager. */
	public SensorManager sensorManager;

	/** The camera session manager. */
	protected CameraSessionManager cameraSessionManager;

	/** The is binarize current image as is. */
	protected boolean isBinarizeCurrentImageAsIs;

	/** The capture still started. */
	public static boolean captureStillStarted = false;

	/** The preferences. */
	private Preferences preferences;

	/** The info screen timer. */
	private Timer infoScreenTimer;

	/** The is info screen enable. */
	protected boolean isInfoScreenEnable = true;

	/** The info screen interval. */
	protected long infoScreenInterval;

	/** The info screen interval. */
	public static boolean dontShowActivityInfoScreen = false;

	/** The do ocr only. */
	public static boolean doOcrOnly = false;

	/** The camera. */
	protected Camera camera;

	/** The mat yuv. */
	private Mat matYuv;

	/** The activity. */
	protected static CameraController activity;

	/** The check rect. */
	public static Rect checkRect;

	/** The context. */
	private Context context;

	/** The is blur enabled. */
	boolean isBlurEnabled;

	/** The current image. */
	public static int currentImage = 0;

	/** The initialized. */
	private boolean initialized = false;

	/** The input files path. */
	private String[] inputFilesPath;

	/** The Image number title. */
	private TextView ImageNumberTitle;

	/** The Image number counter. */
	private TextView ImageNumberCounter;

	/** The current activity. */
	private Activity currentActivity;

	/** The video image taken. */
	public static boolean videoImageTaken = false;

	/** The time video capture end. */
	public static boolean timeVideoCaptureEnd = false;

	/** The draw founded rectangle. */
	public static boolean drawFoundedRectangle = false;

	/** The session result. */
	private int sessionResult = -1;

	/** The current call back. */
	protected TISFlowGeneralMessages currentCallBack;

	/** The current error. */
	protected TISFlowErrorMessage currentError;

	/** The listener. */
	public static TISMobiFlowMessages listener;

	/** The back pressed. */
	public static boolean backPressed = false;

	/** The process start. */
	public static boolean processStart = false;

	/** The use custom alert. */
	protected static boolean useCustomAlert = false;

	protected static boolean isCameraFlashSupported = true;

	//public static boolean isCameraOpenShouldBeOpen = true;	

	/** The extra data to calling app. */
	protected String[] extraDataToCallingApp = new String[10];

	/** The call back. */
	protected static CaptureIntent.callbackReturnMessage callBack;


	private static boolean inTouchFocusMode = false;



	/** The check boundaries. */
	private CheckBoundaries checkBoundaries;


	/** The m progress. */
	private ProgressBar mProgress;

	static {
		if (!OpenCVLoader.initDebug()) {
			// initialization error
			isInitalized = false;
		} else {
			isInitalized = true;
		}
	}

	protected synchronized void handleTouchForFocus(boolean isActionDown) {
		if (isActionDown && !inTouchFocusMode) {
			if (cameraSessionManager != null && cameraSessionManager.getCamera() != null)
				cameraSessionManager.requestAutoFocus(getHandler(), CameraTypes.MESSAGE_AUTO_FOCUS);

		}

		inTouchFocusMode = isActionDown;
	}


	/**
	 * Gets the single instance of CameraController.
	 *
	 * @return single instance of CameraController
	 */
	public static CameraController getInstance() {
		return activity;
	}

	/* (non-Javadoc)
	 * @see com.topimagesystems.controllers.BaseController#onCreate(android.os.Bundle)
	 */
	@Override
	public void onCreate(Bundle bundle) {
		super.onCreate(bundle);

		try {
			CameraManagerController.falseRecognitionVideoFrames = 0;
			CameraManagerController.BarcodeDetectionTries = 0;



			// setScreenOrientation();
			final OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
			FileUtils.makeAppDirExists(this);
			Logger.i(TAG, "onCreate started");
			activity = this;
			isDebug = CameraManagerController.isDebug;

			getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);

			requestWindowFeature(Window.FEATURE_NO_TITLE);
			callBack = this;
			// CameraManagerController.imageType = documentType.FULL_PAGE;
			currentActivity = this;


			if (getIntent() != null) {
				doOcrOnly = getIntent().getBooleanExtra(CameraManagerController.CONTINUE_ANYWAY_APPROVED, false);
			}
			backPressed = false;

			CameraController.processStart = false;
			if (ocrAnalyzeSession != null && ocrAnalyzeSession.getCheckBoundaries() != null) {
				checkBoundaries = ocrAnalyzeSession.getCheckBoundaries();
			}else{
				Intent data = new Intent();
				Logger.e(TAG, getResources().getString(R.string.TISFlowFailedToOpenCamera));
				data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, getResources().getString(R.string.TISFlowFailedToOpenCamera));
				setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
				finish();
				return;
			}

			CameraSessionManager.init(currentActivity, checkBoundaries, ocrAnalyzeSession.minRatioHW, ocrAnalyzeSession.maxRatioHW);
			Logger.i(TAG, "verifyMobiHWOCR started");
			cameraSessionManager = CameraSessionManager.getInstance();
			final CheckBoundaries checkBoundariesRect = cameraSessionManager.getCheckBoundariesRect();
			verifyMobiCHeckOCR();
			Logger.i(
					TAG,
					"ValidationRect is: x= " + checkBoundariesRect.getValidationRect().x + "y=" + checkBoundariesRect.getValidationRect().y + "width="
							+ checkBoundariesRect.getValidationRect().width + "height=" + checkBoundariesRect.getValidationRect().height);
			Logger.i(
					TAG,
					"MinCheckRect is: x= " + checkBoundariesRect.getMinCheckRect().x + "y=" + checkBoundariesRect.getMinCheckRect().y + "width="
							+ checkBoundariesRect.getMinCheckRect().width + "height=" + checkBoundariesRect.getMinCheckRect().height);
			if (CameraManagerController.sessionType == SessionType.PORTRAIT) {
				final CheckBoundaries checkBoundariesRectView = (CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).getCheckBoundariesDisp());
				mobiCHECKOCR.setValidationCheckRect(checkBoundariesRectView.getValidationRect(), checkBoundariesRectView.getMinCheckRect(),
						checkBoundariesRectView.getValidationRectBack(), checkBoundariesRectView.getMinCheckRectBack());
			} else {
				mobiCHECKOCR.setValidationCheckRect(checkBoundariesRect.getValidationRect(), checkBoundariesRect.getMinCheckRect(), checkBoundariesRect.getValidationRectBack(),
						checkBoundariesRect.getMinCheckRectBack());

			}
			Window window = getWindow();
			window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
			if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == SessionType.PORTRAIT) {
				setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

			} else {
				setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
			}

			if (doOcrOnly) {
				final String imagePath = getIntent().getStringExtra(CameraManagerController.IMAGE_PATH_AFTER_FALIURE);
				ProceedAfterMaxRetries();
				startBinarizationAfterFaliure(imagePath);
			}
			if (CameraManagerController.sessionType == SessionType.TEST) { // start
				setContentView(R.layout.run_ocr_library);
				final String libLocation = getIntent().getStringExtra(CaptureIntent.FOLDER_LOCATION);
				ImageNumberTitle = (TextView) findViewById(R.id.ImageNumberTitle);
				ImageNumberCounter = (TextView) findViewById(R.id.ImageNumberCounter);

				configManager = new CameraConfigurationManager(this);
				if (camera == null) {
					camera = Camera.open();
				}
				if (!initialized) { // init the screen size for creating the
					// rect
					initialized = true;
				//	configManager.initFromCameraParameters(camera);

				}
				configManager.setDesiredCameraParameters(camera, false);

				camera.release();
				// showProgressDialog(true);
				new TestOcrTask().execute(libLocation);
				return;

			}

			initUI();

			if (isBinarizeCurrentImageAsIs) {
				// cameraOverlayView.showProcessingOverlay(true);
			}
			Logger.i(TAG, "verifyMobiCHeckOCR ended");

			preferences = Preferences.getInstance(this);
			if (!preferences.getIsNoInfoDisplay()) {
				showInfoActivity();
			}
			captureStillStarted = false;
			Logger.i(TAG, "scan front only parameter set to " + CameraManagerController.scanFrontOnly);
			checkMinHWConditions();
		//	CheckDeviceHW minHW = new CheckDeviceHW();
	//		new Thread(minHW).start();
		} catch (Exception e) {
			String errorMessage = Log.getStackTraceString(e);
			if (errorMessage == null) {
				errorMessage = "";
			}
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile(TAG + " Exception ", errorMessage, getApplicationContext());
			}
			Intent data = new Intent();
			Logger.e(TAG, errorMessage);
			data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, errorMessage);
			setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
			finish();
		} catch (Throwable e) {
			
		}

	}



	@Override
	protected void onStart() {
		super.onStart();
//		if (CameraManagerController.useCameraAPI2) {
//		 getFragmentManager().beginTransaction()
//					.add(R.layout.activity_camera, CameraAPI2Manager.newInstance())
//					.commit();
//		}
	}

	public void startCameraAPI2(){
		if (android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
			mobiCHECKOCR.setHandler(handler);
			handleProcessPreviouslyCapturedImage();
			sensorManager.registerListener(CameraManagerController.isDynamicCapture ? dynamicCameraOverlayView : cameraOverlayView,
					sensorManager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD), SensorManager.SENSOR_DELAY_FASTEST);
			sensorManager.registerListener(CameraManagerController.isDynamicCapture ? dynamicCameraOverlayView : cameraOverlayView,
					sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER), SensorManager.SENSOR_DELAY_FASTEST);
			camera2Instance = new CameraAPI2Manager();
			camera2Instance.startCamera();
//			CameraController.getInstance().getFragmentManager().beginTransaction()
//					.replace(R.id.container, CameraAPI2Manager.newInstance()).addToBackStack(CameraAPI2Manager.TAG)
//					.commit();
			//	View root = context.getWindow().getDecorView().getRootView();
		}
	}

	/**
	 * Unregister listener.
	 */
	public static void unregisterListener() {
		listener = null;
	}

	/**
	 * On refresh camera overlay.
	 */
	public void onSentUIEventMessage(TISFlowUIMessages message) {
		if (listener != null)
			listener.onMobiFlowUIEventMessageReceived(message, cameraOverlayView);
	}

	/**
	 * Continue video mode or show alert.
	 *
	 * @return true, if successful
	 */
	protected boolean continueVideoModeOrShowAlert() {
		// final OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
		try {
			ErrorCode error = CameraManagerController.getOcrAnalyzeSession(context).ocrErrorCode;
			
			if (CameraManagerController.getOcrAnalyzeSession(context).analyzeErrorCode == OCRAnalyzeErrorCode.ERROR_MICR_LENGTH){
				return true;
			}
			switch (error) {
			case errorNoValidBoundingBox:
				return true;
			case errorBlurDetectionFailed:
				//				if (!CameraManagerController.isStillMode){					
				//					CameraManagerController.falseRecognitionVideoFrames++;
				//				}
				cameraSessionManager.requestAutoFocus(handler, CameraTypes.MESSAGE_AUTO_FOCUS);

				Logger.e(TAG, "taking focus!!");
				if (CameraManagerController.isStillMode) {
					return false;
				}

				return true;
			case notValidBoundaries:
				return true;
			case errorPanNotFound:
				return true;
			case errorOcrReading:
				return true;			
			default:
				return false;

			}
		} catch (Exception e) {

		}
		return false;
	}

	/**
	 * Inits the ui.
	 */
	protected void initUI() {
		layoutRoot = new RelativeLayout(this);
		RelativeLayout.LayoutParams rlp = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
		layoutRoot.setLayoutParams(rlp);

		RelativeLayout.LayoutParams previewSurfaceParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);


		surfaceView = new SurfaceView(getApplicationContext());
		surfaceView.setLayoutParams(previewSurfaceParams);
		layoutRoot.addView(surfaceView);
		Logger.i(TAG, "surfaceView added");

		cameraOverlayView = (CameraOverlayLayout) getLayoutInflater().inflate(
				CameraManagerController.isCustomView ? R.layout.custom_mbck_camera_layout : R.layout.mbck_camera_layout, null);
		cameraOverlayView.setIsTorchOn(CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).isTorchOn);
		cameraOverlayView.setIsManualCapture(CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).isManualCapture);

		if (CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).isBarcodeSession)
			//cameraOverlayView.setCheckBoundariesRect(CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).getBarcodeBoundariesRectDisp());
			cameraOverlayView.setCheckBoundariesRect(CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).getCheckBoundariesDisp());
		else
			cameraOverlayView.setCheckBoundariesRect(CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).getCheckBoundariesDisp());

		cameraOverlayView.setActionClickListener(new ActionClickListenerImpl());
		//cameraOverlayView.setCameraController(this);

		videoImageTaken = false;

		layoutRoot.addView(cameraOverlayView);
		if (doOcrOnly) {
			// cameraOverlayView.showProcessingOverlay(true);
		}
	//	if (!CameraManagerController.useCameraAPI2)
			setContentView(layoutRoot);
		// sensor manager for orientation
		sensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);

		handler = null;
		isSurfaceCreated = false;
		if (getIntent() != null) {
			isBinarizeCurrentImageAsIs = getIntent().getBooleanExtra(CameraManagerController.INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS, false);
			isInfoScreenEnable = getIntent().getBooleanExtra(CaptureIntent.INFO_SCREEN_ENABLED, isInfoScreenEnable);
			infoScreenInterval = getIntent().getLongExtra(CaptureIntent.INFO_SCREEN_INTERVAL, infoScreenInterval

			);
		}

		if (listener != null)
			listener.onMobiFlowUIEventMessageReceived(TISFlowUIMessages.INIT_LAYOUT, cameraOverlayView);

	}

	/**
	 * Start test flow.
	 */
	private void startTestFlow() {
		try {
			currentImage = 0;
			if (inputFilesPath == null || inputFilesPath.length == 0 || inputFilesPath[currentImage] == null) {
				Toast.makeText(getBaseContext(), "Files Not Found in destenation folder", Toast.LENGTH_SHORT).show();
				setResult(RESULT_CANCELED);
				finish();
			}
			ImageNumberTitle.setText("Process Image " + inputFilesPath[currentImage]);

			ImageNumberCounter.setText(currentImage + "/" + inputFilesPath.length);
			mProgress = (ProgressBar) findViewById(R.id.progress_bar);
			mProgress.setMax(inputFilesPath.length + 1);
			mProgress.setProgress(currentImage);

			startBinarizationAfterFaliure(inputFilesPath[currentImage]);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Show info activity.
	 */
	private void showInfoActivity() {
		if (!isInfoScreenEnable)
			return;

		if (infoScreenTimer != null) {
			infoScreenTimer.cancel();
			infoScreenTimer = null;
		}

		infoScreenTimer = new Timer();
		TimerTask timerTask = new TimerTask() {

			@Override
			public void run() {
				try {
					if (CameraManagerController.getOcrAnalyzeSession(getApplicationContext()) != null
							&& CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode != null) {								
						if (!processStart && !dontShowActivityInfoScreen && !captureStillStarted ) {
							startActivity(new Intent(CameraController.this, InfoScreenActivity.class));
							dontShowActivityInfoScreen = true;
						}
					}
				} catch (Exception e) {
					Logger.e(TAG, "Failed to open info screen");
				}
			}
		};
		infoScreenTimer.schedule(timerTask, infoScreenInterval);

	}

	/**
	 * Gets the checks if is dont show info checked.
	 *
	 * @return the checks if is dont show info checked
	 */
	public boolean getIsDontShowInfoChecked() {
		return preferences.getIsNoInfoDisplay();
	}

	/**
	 * Verify mobi c heck ocr.
	 *
	 * @return true, if successful
	 * @throws Throwable 
	 */
	protected boolean verifyMobiCHeckOCR() throws Throwable {
		int numberOfFaliures = 0;
		try {

			if (!isInitalized) {
				displayFrameworkBugMessageAndExit(StringUtils.dynamicString(this, "TISFlowErrorReadingImageGeneral"));
				return false;
			}

			final OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
			if (ocrAnalyzeSession == null) {
				displayFrameworkBugMessageAndExit(StringUtils.dynamicString(this, "TISFlowErrorReadingImageGeneral"));
				return false;
			}
			if (doOcrOnly || ocrAnalyzeSession.captureMode == CaptureMode.BACK) {
				CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).isBluredEnabled = false; // set blur false if coming from last try.
			}

			if (mobiCHECKOCR == null && !isFinishing()) {
				try {
					//System.loadLibrary(Config.LIBGNUSTL_NAME);
					System.loadLibrary(Config.MOBICHECK_LIBRARY_NAME);
				} catch (Exception e) {
					displayFrameworkBugMessageAndExit(StringUtils.dynamicString(this, "TISFlowErrorReadingImageGeneral"));
					return false;
				}

				mobiCHECKOCR = new MobiCHECKOCR(getApplicationContext(), isDebug, ocrAnalyzeSession.minRatioHW, ocrAnalyzeSession.maxRatioHW,
						ocrAnalyzeSession.currentMICRType.getId(), ocrAnalyzeSession.isUseCustomAlgorithmOnBack, ocrAnalyzeSession.isBinarizeBackSameAsFront,
						ocrAnalyzeSession.outputHeightInInch, ocrAnalyzeSession.outputWidthInInch, ocrAnalyzeSession.minRatioHWBack, ocrAnalyzeSession.maxRatioHWBack,
						ocrAnalyzeSession.isIQAEnabled, ocrAnalyzeSession.iqaSettings, ocrAnalyzeSession.isBluredEnabled);
			}
			return true;
		}

		catch (NoSuchFieldException e) { // after any fail try another 3 times
			e.printStackTrace();
			Logger.e(TAG, "Failed to init MobiCHECKOCR (NoSuchFieldException)");
			Intent data = new Intent();
			data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, getResources().getString(R.string.TISFlowFailedToOpenResources));
			setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
			finish();
			throw e;

		}

		catch (Throwable e) { // after any fail try another 3 times
			e.printStackTrace();
			Logger.e(TAG, "Failed to init MobiCHECKOCR");
			Intent data = new Intent();
			data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, getResources().getString(R.string.TISFlowFailedToOpenCamera));
			setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
			finish();
			throw e;
		}
		//return true;
	}

	/**
	 * Checks if is debug.
	 *
	 * @return true, if is debug
	 */
	public boolean isDebug() {
		return isDebug;
	}

	/**
	 * The listener interface for receiving actionClick events.
	 * The class that is interested in processing a actionClick
	 * event implements this interface, and the object created
	 * with that class is registered with a component using the
	 * component's <code>addActionClickListener<code> method. When
	 * the actionClick event occurs, that object's appropriate
	 * method is invoked.
	 *
	 * @see ActionClickEvent
	 */
	public interface ActionClickListener {

		/**
		 * Quit.
		 */
		public void quit();

		/**
		 * Capture.
		 */
		public void capture();

		/**
		 * Info.
		 */
		public void info();
	}

	/**
	 *	
	 *
	 */
	public class ActionClickListenerImpl implements ActionClickListener {

		/* (non-Javadoc)
		 * @see com.topimagesystems.controllers.imageanalyze.CameraController.ActionClickListener#quit()
		 */
		@Override
		public void quit() {
			quitActivity();
		}

		/* (non-Javadoc)
		 * @see com.topimagesystems.controllers.imageanalyze.CameraController.ActionClickListener#capture()
		 */
		public void capture() {
			handler.removeLowPriorityMessages();

			Message message = handler.obtainMessage(CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE);
			message.sendToTarget();
		}

		/* (non-Javadoc)
		 * @see com.topimagesystems.controllers.imageanalyze.CameraController.ActionClickListener#info()
		 */
		@Override
		public void info() {
		}
	}

	/**
	 * Quit activity.
	 */
	public void quitActivity() {
		if (handler != null) {
			handler.removeAllMessages();
		}
		if (mobiCHECKOCR != null) {
			mobiCHECKOCR.release();
			mobiCHECKOCR = null;
		}
		setResult(RESULT_CANCELED);
		finish();
	}

	/**
	 * Checks if is previewing.
	 *
	 * @return true, if is previewing
	 */
	public boolean isPreviewing() {
		if (CameraManagerController.useCameraAPI2){
			if (camera2Instance != null && !camera2Instance.isSessionClosed){
				return true;
			}
			return false;
		}
		return (cameraSessionManager.getState() == State.PREVIEW);
	}

	/**
	 * Gets the handler.
	 *
	 * @return the handler
	 */
	public CameraActivityHandler getHandler() {
		return handler;
	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onRestoreInstanceState(android.os.Bundle)
	 */
	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);

		isDebug = savedInstanceState.getBoolean("isDebug");
		OCRAnalyzeSession ocrAnalyzeSession = new OCRAnalyzeSession(savedInstanceState.getBundle("ocrAnalyzeSession"));
		if (CameraManagerController.getOcrAnalyzeSession(getApplicationContext()) == null) {
			CameraManagerController.setOcrAnalyzeSession(ocrAnalyzeSession);
		}
	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onSaveInstanceState(android.os.Bundle)
	 */
	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);

		OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());

		outState.putBoolean("isDebug", isDebug);
		try {
			outState.putBundle("ocrAnalyzeSession", ocrAnalyzeSession.toBundle());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/* (non-Javadoc)
	 * @see com.topimagesystems.controllers.BaseController#onResume()
	 */
	@Override
	protected void onResume() {
		super.onResume();
		backPressed = false;
		PreviewCallback.processingVideo = false;
		if (!doOcrOnly && CameraManagerController.sessionType != SessionType.TEST) {
			//	if(isCameraOpenShouldBeOpen){
			try {

				if (!CameraManagerController.useCameraAPI2) // we dont start teh camera from here when using cameraAPI2
					startCamera();
				else{// just register the listener.
					handler = new CameraActivityHandler(this, true);
					startCameraAPI2();

					//cameraOverlayView = camera2Instance.cameraLayout;
				}
			} catch (Throwable e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				Logger.e(TAG, "Failed to init MobiCHECKOCR (NoSuchFieldException)");
				Intent data = new Intent();
				data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, getResources().getString(R.string.TISFlowFailedToOpenResources));
				setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
				finish();

			}
			//}			
		}
	}

	/**
	 * Start camera.
	 * @throws Throwable 
	 */
	private void startCamera() throws Throwable {
		if (verifyMobiCHeckOCR()) {
			resetCameraOverlay(CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode);
			SurfaceHolder surfaceHolder = surfaceView.getHolder();
			if (isSurfaceCreated) {
				// The activity was paused but not stopped, so the surface still
				// exists. Therefore
				// surfaceCreated() won't be called, so init the camera here.
				initCamera(surfaceHolder, CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).isTorchOn);

			} else {
				// Install the callback and wait for surfaceCreated() to init
				// the
				// camera.

				surfaceHolder.addCallback(this);
				surfaceHolder.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);
				// cameraOverlayView.drawLeveler(surfaceHolder);
			}
			sensorManager.registerListener(CameraManagerController.isDynamicCapture ? dynamicCameraOverlayView : cameraOverlayView,
					sensorManager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD), SensorManager.SENSOR_DELAY_FASTEST);
			sensorManager.registerListener(CameraManagerController.isDynamicCapture ? dynamicCameraOverlayView : cameraOverlayView,
					sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER), SensorManager.SENSOR_DELAY_FASTEST);
		} else {
			CloseSession();
			displayFrameworkBugMessageAndExit(StringUtils.dynamicString(this, "failedConnectToCamera"));
		}

	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onStop()
	 */
	@Override
	protected void onStop() {
		isInfoScreenEnable = false;
		if (infoScreenTimer != null) {
			infoScreenTimer.cancel();
			infoScreenTimer = null;
		}
		if (CameraManagerController.useCameraAPI2 && camera2Instance!= null){
			camera2Instance.closeSessionAndResources();
		}
		super.onStop();
	}

	/* (non-Javadoc)
	 * @see com.topimagesystems.controllers.BaseController#onPause()
	 */
	@Override
	protected void onPause() {
		Logger.i(TAG, "onPause");
		PreviewCallback.processingVideo = true;
		if (CameraManagerController.useCameraAPI2 && handler != null) {
			handler.removeAllMessages();
		}
		if (!doOcrOnly && CameraManagerController.sessionType != SessionType.TEST) {
			releaseCameraAndResources();
			Logger.i(TAG, "onPause Camera Closed");
		}
		isInfoScreenEnable = false;
		super.onPause();

	}

	/**
	 * Close session.
	 */
	private void CloseSession() {
		Logger.i(TAG, "onPause");

		if (sensorManager != null) {
			//	sensorManager.unregisterListener(cameraOverlayView);
		}
		if (!doOcrOnly && CameraManagerController.sessionType != SessionType.TEST) {
			releaseCameraAndResources();
			Logger.i(TAG, "onPause Camera Closed");
		}
		isInfoScreenEnable = false;
	}

	/**
	 * Release camera and resources.
	 */
	public void releaseCameraAndResources() {
		Logger.i(TAG, "releasing camera");
		if (handler != null) {
			handler.quitSynchronously();
			handler = null;
		}
		if (sensorManager != null) {
			sensorManager.unregisterListener(cameraOverlayView);
			sensorManager.unregisterListener(dynamicCameraOverlayView);
		}

		if (CameraManagerController.useCameraAPI2 && camera2Instance != null){
			camera2Instance.closeSession();
		}
		else {
			if (cameraSessionManager != null) {
				cameraSessionManager.closeCamera();
			}
		}

	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onDestroy()
	 */
	@Override
	protected void onDestroy() {

		if (camera != null) {
			camera.release();
		}
		activity = null;
		callBack = null;
		releaseCameraAndResources();

		try {
			if (mobiCHECKOCR != null) {
				mobiCHECKOCR.release();
				mobiCHECKOCR = null;

			}
			super.onDestroy();
		} catch (Exception e) {
			if (CameraManagerController.isDebug) {
				Logger.e(TAG, Log.getStackTraceString(e));
				FileUtils.addToLogFile(Log.getStackTraceString(e), this);
			}
		}

	}

	/* (non-Javadoc)
	 * @see com.topimagesystems.controllers.BaseController#onCreateOptionsMenu(android.view.Menu)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);
		return true;
	}

	// Don't display the share menu item if the result overlay is showing.
	/* (non-Javadoc)
	 * @see android.app.Activity#onPrepareOptionsMenu(android.view.Menu)
	 */
	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		super.onPrepareOptionsMenu(menu);
		return true;
	}

	/* (non-Javadoc)
	 * @see com.topimagesystems.controllers.BaseController#onOptionsItemSelected(android.view.MenuItem)
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {

		}
		return super.onOptionsItemSelected(item);
	}

	/* (non-Javadoc)
	 * @see android.view.SurfaceHolder.Callback#surfaceCreated(android.view.SurfaceHolder)
	 */
	public void surfaceCreated(SurfaceHolder holder) {

		if (!isSurfaceCreated) {
			isSurfaceCreated = true;

			Logger.i(TAG, "isSurfaceCreated  init camera");
			initCamera(holder, CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).isTorchOn);

		}
	}

	/* (non-Javadoc)
	 * @see android.view.SurfaceHolder.Callback#surfaceDestroyed(android.view.SurfaceHolder)
	 */
	public void surfaceDestroyed(SurfaceHolder holder) {
		isSurfaceCreated = false;
	}

	/* (non-Javadoc)
	 * @see android.view.SurfaceHolder.Callback#surfaceChanged(android.view.SurfaceHolder, int, int, int)
	 */
	public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
	}

	/**
	 * Sets the checks if is valid orientation.
	 *
	 * @param isValidOrientation the new checks if is valid orientation
	 */
	public void setIsValidOrientation(boolean isValidOrientation) {
		this.isValidOrientation = isValidOrientation;
	}

	/**
	 * Checks if is valid orientation.
	 *
	 * @return true, if is valid orientation
	 */
	public boolean isValidOrientation() {
		return isValidOrientation;
	}

	/**
	 * Inits the camera.
	 *
	 * @param surfaceHolder the surface holder
	 * @param isTorchOn the is torch on
	 */
	protected void initCamera(SurfaceHolder surfaceHolder, boolean isTorchOn) {
		try {

			Logger.i(TAG, "isSurfaceCreated  init camera");

			if (CameraManagerController.deviceName.equals("LGE Nexus 5X") || CameraManagerController.invertedCamera){
				cameraSessionManager.openDriver(surfaceHolder);
			}
			else{
				cameraSessionManager.openCamera(surfaceHolder,isTorchOn);
			}
			// Creating the handler starts the preview, which can also throw a
			// RuntimeException.

			handleFlashSupport();

			if (handler == null) {
				if (!CameraManagerController.isDynamicCapture)
					handler = new CameraActivityHandler(this, true);
			}
			mobiCHECKOCR.setHandler(handler);
			handleProcessPreviouslyCapturedImage();
		} catch (IOException ioe) {
			Logger.w(TAG, "IOException", ioe);
			displayFrameworkBugMessageAndExit(StringUtils.dynamicString(this, "failedConnectToCamera"));
		} catch (RuntimeException e) {
			// Barcode Scanner has seen crashes in the wild of this variety:
			// java.?lang.?RuntimeException: Fail to connect to camera service
			Logger.w(TAG, "Unexpected error initializating camera", e);
			displayFrameworkBugMessageAndExit(StringUtils.dynamicString(this, "failedConnectToCamera"));
		}
	}


	protected void handleFlashSupport() {
		boolean supported = true;
		Camera sessionCamera = cameraSessionManager.getCamera();
		if (sessionCamera == null)
			supported =  false;
		else {
			Camera.Parameters parameters = sessionCamera.getParameters();
			if (parameters.getFlashMode() == null)
				supported = false;

			List<String> supportedFlashModes = parameters.getSupportedFlashModes();
			if (supportedFlashModes == null ||
					supportedFlashModes.isEmpty() ||
					supportedFlashModes.size() == 1 && supportedFlashModes.get(0).equals(Camera.Parameters.FLASH_MODE_OFF))
				supported = false;
		}
		isCameraFlashSupported = supported;
		if (cameraOverlayView != null)
			cameraOverlayView.handleCameraFlashSupport();
		if (dynamicCameraOverlayView != null)
			dynamicCameraOverlayView.handleCameraFlashSupport();

	}



	/**
	 * Handle process previously captured image.
	 */
	protected void handleProcessPreviouslyCapturedImage() {
		if (isBinarizeCurrentImageAsIs) {
			// cameraOverlayView.showProcessingOverlay(true);

			Message message = handler.obtainMessage(CameraTypes.MESSAGE_PROCESS_PRE_CAPTURED_IMAGE);
			final OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
			message.obj = (ocrAnalyzeSession.captureMode == CaptureMode.FRONT) ? ocrAnalyzeSession.getFrontImagePath() : ocrAnalyzeSession.getBackImagePath();
			// we r skipping the message queue here
			handler.handleMessage(message);
		}
	}

	/**
	 * Display framework bug message and exit.
	 *
	 * @param message the message
	 */
	private void displayFrameworkBugMessageAndExit(final String message) {
		quitActivity();
	}

	/**
	 * Reset camera overlay.
	 *
	 * @param captureMode the capture mode
	 */
	private void resetCameraOverlay(CaptureMode captureMode) {
		if (!CameraManagerController.isDynamicCapture) { // init UI elements for normal capture
			cameraOverlayView.resetCameraOverlay(captureMode);
//				camera2Instance.cameraLayout.resetCameraOverlay(captureMode);

		}
	}

	/**
	 * Activity result finish.
	 *
	 * @param result the result
	 */
	protected void activityResultFinish(boolean result) {
		try {
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile(String.valueOf(result), getBaseContext());
			}
			cameraSessionManager.resetRectComapreCounter();
			Logger.i(TAG, "activity result finish result: " + result);
			if (CameraManagerController.sessionType == SessionType.TEST) { // for test
				onTestActionFinish(result);
				return;
			}
			if (cameraSessionManager != null) {
				if (CameraManagerController.isDynamicCapture) {
					cameraSessionManager.resetRectComapreCounter();
				}
				cameraSessionManager.setState(State.DONE);
			}

			Intent data = new Intent();
			data.putExtra(Constants.INTENT_RESULT, result);
			if ((CameraManagerController.sessionType == SessionType.TEST || sessionResult == RESULT_CANCELED || doOcrOnly) && result) {
				finish(); // camera manager will handle.
			} else {
				onCameraControllerSessionResult(result);
			}
		} catch (Exception e) {
			setResult(CameraManagerController.RESULT_LIBRARY_ERROR);
			String errorMessage = Log.getStackTraceString(e);
			Intent data = new Intent();
			Logger.e(TAG, errorMessage);
			data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, errorMessage);
			setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
			finish();
		}

	}

	/**
	 * On camera controller session result.
	 *
	 * @param result the result
	 */
	protected void onCameraControllerSessionResult(boolean result) {
		Logger.i(TAG, "Enter CameraManager onCameraControllerSessionResult");
		onSentUIEventMessage(TISFlowUIMessages.AFTER_PROCESSING);
		cameraSessionManager.stopPreview();
		currentError = null;
		if (CameraManagerController.isDebug) {
			FileUtils.addToLogFile("onCameraControllerSessionResult - build result object", getBaseContext());
		}
		OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());

		if (ocrAnalyzeSession.getFrontImagePath() != null) {
			extraDataToCallingApp[0] = ocrAnalyzeSession.getFrontImagePath();
		}
		if (ocrAnalyzeSession.getBackImagePath() != null) {
			if (ocrAnalyzeSession.getFrontImagePath() != null)
				extraDataToCallingApp[1] = ocrAnalyzeSession.getBackImagePath();
			else
				extraDataToCallingApp[0] = ocrAnalyzeSession.getBackImagePath();
		}

		// get ocr data for checks multi capture.
		if (CameraManagerController.isMultiCapture && // add Micr to multi capture session after current session has finished.
				(CameraManagerController.scanFrontOnly || ((CameraManagerController.doOcrOnImage) && CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode == CaptureMode.BACK))) {
			currentCallBack = TISFlowGeneralMessages.MULTI_CAPTURE;
			currentError = null;
			if (extraDataToCallingApp != null && extraDataToCallingApp[0] != null) {
				if (ocrAnalyzeSession.getOCRAnalyzeResult().getOcrResult() != null) {
					final OCRResult ocrResult = ocrAnalyzeSession.getOCRAnalyzeResult().getOcrResult();
					if (ocrResult != null) {
						extraDataToCallingApp[2] = String.valueOf(ocrResult.digitalRowLength);
						extraDataToCallingApp[3] = ocrResult.ocrResultWithDelimiter;
						extraDataToCallingApp[4] = ocrResult.ocrRawResult;
						extraDataToCallingApp[5] = ocrResult.scoreResult;
					}

				}
			}

			//	return;
		}
		if (!result) { // if result == false we got error message go the calling app for instructions
			// stop preview on Error.
			sendMessageToCallingApp();

		} else {
			// continue flow result OK.
			if (!CameraManagerController.scanFrontOnly && CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode == CaptureMode.FRONT) { // ask the
																																									// calling to																																									// approve back																																									// capture.
				currentCallBack = TISFlowGeneralMessages.CAPTURE_BACK;
				currentError = null;
				listener.onMobiFlowGeneralMessageReceived(currentCallBack, null, !CameraManagerController.isDynamicCapture ? cameraOverlayView.getContext()
						: dynamicCameraOverlayView.getContext());
			} else {
				if (CameraManagerController.isMultiCapture) {
					currentCallBack = TISFlowGeneralMessages.MULTI_CAPTURE;
					currentError = null;

					listener.onMobiFlowGeneralMessageReceived(currentCallBack, extraDataToCallingApp, !CameraManagerController.isDynamicCapture ? cameraOverlayView.getContext()
							: dynamicCameraOverlayView.getContext());
				} else {
					setResult(RESULT_OK);
					finish();
				}
			}
		}
	}

	/**
	 * Send message to calling app.
	 */
	protected void sendMessageToCallingApp() {
		// get error code
		final OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
		TISFlowErrorMessage errorCode = null;
		ocrAnalyzeSession.AddToErrorCounter();
		if (ocrAnalyzeSession.ocrErrorCode != null) {

			switch (ocrAnalyzeSession.ocrErrorCode) {
			case errorNoValidBoundingBox:
				errorCode = TISFlowErrorMessage.ERROR_NO_VALID_BOUNDING_BOX;
				break;
			case errorIQACornerData:
				errorCode = TISFlowErrorMessage.ERROR_IQA_CORNER_DATA;
				break;
			case errorIQAEdgeData:
				errorCode = TISFlowErrorMessage.ERROR_IQA_EDGE_DATA;
				break;
			case errorIQASkew:
				errorCode = TISFlowErrorMessage.ERROR_IQA_SKEW;
				break;
			case errorIQADarkness:
				errorCode = TISFlowErrorMessage.ERROR_IQA_DARKNESS;
				break;
			case errorIQANumSpots:
				errorCode = TISFlowErrorMessage.ERROR_IQA_NUM_SPOTS;
				break;
			case errorIQAPiggyBack:
				errorCode = TISFlowErrorMessage.ERROR_IQA_PIGGY_BACK;
				break;
			case errorIQACarbonStrip:
				errorCode = TISFlowErrorMessage.ERROR_IQA_CARBON_STRIP;
				break;

			case errorIQAHorizontalStreak:
				errorCode = TISFlowErrorMessage.ERROR_IQA_HORIZONTAL_STREAK;
				break;
			case errorBlurDetectionFailed:
				errorCode = TISFlowErrorMessage.ERROR_BLUR_DETECTED;
				break;
			case detectableColor:
				errorCode = TISFlowErrorMessage.ERROR_IMAGE_CONTRAST;
				break;
			case errorMicrInterrupted:
				errorCode = TISFlowErrorMessage.ERROR_MICR_INTERUPPTED;
				break;

			case errorMICRDetectedOnCheckBack:
				errorCode = TISFlowErrorMessage.ERROR_MICR_ON_BACK;
				break;


			default:
				break;
			}

		}
		if (errorCode == null && CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).analyzeErrorCode != OCRAnalyzeErrorCode.NONE) {
			switch (CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).analyzeErrorCode) {		
			case FAILED_READING_OCR_GENERAL:
				errorCode = TISFlowErrorMessage.ERROR_OCR_READING;
				break;
			case TISFlowErrorMaxRetries:
				errorCode = TISFlowErrorMessage.ERROR_MAX_RETRIES;
				break;
			case ERROR_MICR_LENGTH:
				errorCode = TISFlowErrorMessage.ERROR_MICR_LENGHT;
				break;
			case FAILED_PREPARING_IMAGE:
				errorCode = TISFlowErrorMessage.ERROR_NO_VALID_BOUNDING_BOX;
				break;
			default:
				errorCode = TISFlowErrorMessage.ERROR_GENERAL_FAIL;
				break;
			}

		}
		CameraManagerController.isStillMode = CameraManagerController.isSessionStartsInStills;
		CameraManagerController.falseRecognitionVideoFrames = 0;
		CameraManagerController.BarcodeDetectionTries = 0;
		extraDataToCallingApp = new String[10];
		currentError = errorCode;
		listener.onMobiFlowErrorMessageReceived(errorCode, null, !CameraManagerController.isDynamicCapture ? cameraOverlayView.getContext() : dynamicCameraOverlayView.getContext());
	}

	/**
	 * Register listener.
	 *
	 * @param _listener the _listener
	 */
	public static void registerListener(TISMobiFlowMessages _listener) {
		listener = _listener;
	}

	/**
	 * Show ocr reading error.
	 *
	 * @param title the title
	 * @param message the message
	 * @param confirmText the confirm text
	 * @param cancelText the cancel text
	 */
	protected void showOCRReadingError(String title, String message, String confirmText, String cancelText) {
		handler.stopPreview();
		showProcessImageErrorDialog(title, message, confirmText, cancelText, new DialogInterface.OnClickListener() {

			public void onClick(DialogInterface dialog, final int which) {
				dialog.dismiss();
				if (handler == null) {
					return;
				}
				handler.postDelayed(new Runnable() {
					@Override
					public void run() {

						if (which == DialogInterface.BUTTON_POSITIVE) {
								if (!CameraManagerController.isDynamicCapture) {
									cameraOverlayView.finishCapture();
									cameraOverlayView.invalidate();
								} else {
									dynamicCameraOverlayView.removeCaptureElements();

								}
									handler.startPreview();

						}// BUTTON_NEGATIVE
						else {
							Intent data = new Intent();
							if (!CameraManagerController.isMultiCapture) {// on multi capture the cancel button is not error, it's indicate session ends.
								setResult(CameraManagerController.RESULT_CANCELED_FROM_ALERT, data);
							} else {
								setResult(CameraManagerController.RESULT_MULTI_CAPTURE_FINISH, data);
							}
							finish();
						}
					}
				}, 100);
			}
		});
	}

	/**
	 * Show process image error dialog.
	 *
	 * @param title the title
	 * @param message the message
	 * @param positiveText the positive text
	 * @param cancelText the cancel text
	 * @param clickListener the click listener
	 */
	private void showProcessImageErrorDialog(final String title, final String message, final String positiveText, final String cancelText,
			final DialogInterface.OnClickListener clickListener) {
		if (handler == null) {
			return;
		}
		handler.post(new Runnable() {
			@Override
			public void run() {
				if (!isFinishing()) {

					AlertDialog ad = new AlertDialog.Builder(CameraController.this).create();
					ad.setCancelable(false); // This blocks the 'BACK' button
					ad.setTitle(title);
					ad.setMessage(message);
					ad.setButton(AlertDialog.BUTTON_POSITIVE, positiveText, clickListener);
					ad.setButton(AlertDialog.BUTTON_NEGATIVE, cancelText, clickListener);
					Logger.i(TAG, "positiveText is " + positiveText + " cancelText " + cancelText);

					//	ad.setButton(AlertDialog.BUTTON_POSITIVE, StringUtils.dynamicString(getBaseContext(), "TISFlowOK"), clickListener);
					//	ad.setButton(AlertDialog.BUTTON_NEGATIVE, StringUtils.dynamicString(getBaseContext(), "TISFlowCancel"), clickListener);

					ad.show();
					//CameraController.isCameraOpenShouldBeOpen = false;
				}
			}
		});
	}

	/**
	 * Parses the result.
	 *
	 * @param result the result
	 */
	protected void parseErrorResult(boolean result) {
		Logger.i(TAG, "enter parse result camera controller activity");
		OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
		if (!result && CameraManagerController.isDynamicCapture) {
			cameraSessionManager.resetRectComapreCounter();
			dynamicCameraOverlayView.removeCaptureElements();
		}
		if (ocrAnalyzeSession == null || ocrAnalyzeSession.captureMode == null){
			return;
		}
		switch (ocrAnalyzeSession.captureMode) {

		case FRONT:
			if (ocrAnalyzeSession.analyzeErrorCode == null) {
				ocrAnalyzeSession.analyzeErrorCode = OCRAnalyzeErrorCode.NONE;
			}
			if (!useCustomAlert) {
				showErrorAlert();
			} else {
				cameraOverlayView.finishCapture();
				cameraOverlayView.invalidate();
				if (!CameraManagerController.useCameraAPI2)
					handler.startPreview();
			}
			break;

		case BACK:
			if (!useCustomAlert) {
				showErrorAlert();
			} else {
				cameraOverlayView.finishCapture();
				cameraOverlayView.invalidate();
				if (!CameraManagerController.useCameraAPI2)
					handler.startPreview();
			}
			break;
		default:
			break;
		}
		CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).clearErrorCode();

	}

	/**
	 * Show proceeding dialog.
	 *
	 * @param title the title
	 * @param message the message
	 * @param nextAction the next action
	 */
	protected void showProceedingDialog(String title, String message, final NEXT_ACTION nextAction) {
//		if (CameraManagerController.useCameraAPI2){
//			camera2Instance.closeSession();
//		}
		handler.stopPreview();
		showProcessImageErrorDialog(title, message, StringUtils.dynamicString(getBaseContext(), "TISFlowOK"), StringUtils.dynamicString(getBaseContext(), "TISFlowCancel"),
				new DialogInterface.OnClickListener() {

					public void onClick(DialogInterface dialog, final int which) {
						dialog.dismiss();

						handler.postDelayed(new Runnable() {
							@Override
							public void run() {
								if (which == DialogInterface.BUTTON_POSITIVE) {
									//	CameraController.isCameraOpenShouldBeOpen = true;
									if (nextAction == NEXT_ACTION.CAPTURE_FRONT) {
										handler.startPreview();
										cameraOverlayView.finishCapture();
										cameraOverlayView.invalidate();

										openCameraForFrontCapture(false);
									} else if (nextAction == NEXT_ACTION.CAPTURE_BACK) {
										// starting point of stage 2
										handler.startPreview();
										if (!CameraManagerController.isDynamicCapture)
											cameraOverlayView.finishCapture();

										openCameraForBackCapture(false);
										if (!CameraManagerController.isDynamicCapture)
											cameraOverlayView.invalidate();
									} else if (nextAction == NEXT_ACTION.PROCESS_IMAGE_FOR_SERVER) {
										doImageBinarizationOnly();

									}
								}// BUTTON_NEGATIVE
								else {
									//	CameraController.isCameraOpenShouldBeOpen = true;
									setResult(CameraManagerController.RESULT_CANCELED_FROM_ALERT);
									finish();
								}
							}
						}, 100);
					}
				});
	}

	/**
	 * On test action finish.
	 *
	 * @param result the result
	 */
	private void onTestActionFinish(boolean result) {
		saveImagesToDevice();
		String imageNumber = String.valueOf(CameraController.currentImage);
		OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());

		OCRResult c = ocrAnalyzeSession.getOcrResult();
		String message = null;
		String res;
		res = result ? "PASS" : "FAIL";
		String externalStorge = Environment.getExternalStorageDirectory().toString();
		File externalStorageFile = new File( externalStorge ) ;

		String baseImagesFolder = externalStorageFile.getAbsolutePath() + "/" + ".mobiflow/LOG.txt";
		FileUtils.createTestLogFile("", "image name: " + inputFilesPath[CameraController.currentImage] + "  RESULT :" + res,baseImagesFolder, getApplicationContext());
		FileUtils.modifySingleImgeLogFile("", "image name: " + inputFilesPath[CameraController.currentImage] + "  RESULT :" + res, null, getApplicationContext());
		if (!result) {
			if (ocrAnalyzeSession.analyzeErrorCode != null && ocrAnalyzeSession.analyzeErrorCode.name() != null) {
				message = ocrAnalyzeSession.analyzeErrorCode.name();
				FileUtils.modifySingleImgeLogFile("", message, null, getApplicationContext());
			}
			if (ocrAnalyzeSession.ocrErrorCode != null) {
				message = getResources().getString(ocrAnalyzeSession.ocrErrorCode.getResourceId());
				final String errorMessage = ocrAnalyzeSession.ocrErrorMessage;
				if (CameraManagerController.isDebug) {
					if (errorMessage != null) {
						message += " | error message: " + errorMessage;
						FileUtils.modifySingleImgeLogFile("", message, null, getApplicationContext());
					}

				}
			}
			if (ocrAnalyzeSession.ocrErrorCode != null && ocrAnalyzeSession.ocrErrorCode.name() != null) {
				message += " | error message: " + ocrAnalyzeSession.ocrErrorCode.name().toString();
				FileUtils.modifySingleImgeLogFile("Error Message : ", message, null, getApplicationContext());
			}
			if (message != null)
				FileUtils.modifySingleImgeLogFile("", message, inputFilesPath[CameraController.currentImage], getApplicationContext());
		} else if (c != null && c.scoreResult != null && c.scoreResult.length() > 0 && c.ocrRawResult != null && c.ocrRawResult.length() > 0) {
			if (c.scoreResult != null) {// .toString();
				// FileUtils.addToLogFile("", c.ocrRawResult, null);
				FileUtils.modifySingleImgeLogFile("Raw Result: ", c.ocrRawResult, inputFilesPath[CameraController.currentImage], getApplicationContext());
				FileUtils.modifySingleImgeLogFile("Score Result: ", c.scoreResult, inputFilesPath[CameraController.currentImage], getApplicationContext());
			}
			if (c.ocrRawResult != null) {
				// FileUtils.addToLogFile("", "" + c.ocrResultWithDelimiter, null);
				FileUtils.modifySingleImgeLogFile("Raw Result With Delimiter", c.ocrResultWithDelimiter, inputFilesPath[CameraController.currentImage], getApplicationContext());
			}

		} else {
			FileUtils.modifySingleImgeLogFile("", "okay", inputFilesPath[CameraController.currentImage], getApplicationContext());
		}
		Logger.i(TAG, "Image number return is " + currentImage);
		currentImage++;
		if (currentImage < inputFilesPath.length) {
			ImageNumberTitle.setText("Process Image " + inputFilesPath[currentImage]);
			ImageNumberCounter.setText(currentImage + "/" + inputFilesPath.length);
			mProgress.setProgress(currentImage + 1);
			startBinarizationAfterFaliure(inputFilesPath[currentImage]);
			Logger.i(TAG, "MobiTest processing image number " + currentImage);
		} else {
			Toast.makeText(this, "Finish binarization of " + String.valueOf(currentImage) + " images", Toast.LENGTH_SHORT).show();
			Intent data = new Intent();
			setResult(CameraManagerController.OCR_TEST_RESULT, data);
			finish();
		}
	}
	public Camera getCamera(){
		return camera;
	}

	/**
	 * Save images to device.
	 */
	private void saveImagesToDevice() {
		if (inputFilesPath[currentImage] == null) {
			return;
		}
		String fileName = inputFilesPath[currentImage];
		if (CameraManagerController.isDebug) {
			//FileUtils.addToLogFile("current Test image is "+ inputFilesPath[currentImage], context);
			FileUtils.addToLogFile("Test Mode", "current Test image is  " + inputFilesPath[currentImage], getApplicationContext());
		}
//		String baseFile = fileName.substring(0,fileName.lastIndexOf("/")+1);
//		String currentFileName = fileName.substring(fileName.lastIndexOf("/")+1,fileName.length());
		String imageType = ".jpg";
		//fileName = fileName.toLowerCase(Locale.US);
		if (fileName.contains("_original")) {
			fileName = fileName.replace("original", "");
		}
		if (fileName.contains("jpeg")) {
			imageType = ".jpeg";
		}
		FileUtils.writeToFile(SessionResultParams.tiffFront, fileName.replace(imageType, "bin.tiff")); // write the decoded image to device if needed.
		FileUtils.writeToFile(SessionResultParams.jpegBWFront, fileName.replace(imageType, "bin.jpg"));
		FileUtils.writeToFile(SessionResultParams.colorFront, fileName.replace(imageType, "colored.jpg"));
		FileUtils.writeToFile(SessionResultParams.originalFront, fileName);
		FileUtils.writeToFile(SessionResultParams.grayscaleFront, fileName.replace(imageType, "gray.jpg"));

		//		FileUtils.writeToFile(SessionResultParams.tiffBack, fileName.replace(imageType, "_bin.tiff"));
		//		FileUtils.writeToFile(SessionResultParams.jpegBWBack, fileName.replace(imageType, "_bin.jpg"));
		//		FileUtils.writeToFile(SessionResultParams.colorBack, fileName.replace(imageType, "_colored.jpg"));

		//		FileUtils.writeToFile(SessionResultParams.grayscaleBack, fileName.replace(imageType, "_gray.jpg"));

	}

	/**
	 * Update processing message from jni.
	 *
	 * @param ocrDetectorStatus the ocr detector status
	 */
	public void updateProcessingMessageFromJNI(final OCRDetectorStatus ocrDetectorStatus) {
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				// String text = getString(ocrDetectorStatus.getResourceId());
				String srcName = getResources().getResourceEntryName(ocrDetectorStatus.getResourceId());
				String text = StringUtils.dynamicString(getBaseContext(), srcName);
				if (cameraOverlayView != null)
					cameraOverlayView.updateProcessingMessage(text);
			}
		});
	}

	/**
	 * Process captured image.
	 *
	 * @param imagePath the image path
	 */
	public void processCapturedImage(String imagePath) {
		CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).setImagePath(imagePath);
		int timestamp = CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).timestamp;
		if (CameraManagerController.isDynamicCapture) {
			handler = DynamicCaptureCameraController.getInstance().getHandler();
		}

		ProcessStillImageThread processStillImageThread = new ProcessStillImageThread(getApplicationContext(), handler, mobiCHECKOCR, isDebug, timestamp);
		processStillImageThread.start();
	}

	/**
	 * The Class TestOcrTask.
	 */
	private class TestOcrTask extends AsyncTask<String, Void, String> {

		/* (non-Javadoc)
		 * @see android.os.AsyncTask#doInBackground(java.lang.Object[])
		 */
		@Override
		protected String doInBackground(String... params) {
			String directory = params[0];
			if (directory == null) {
				directory = FileUtils.getTempFilePath(getBaseContext());
			}
			ArrayList<String> filesPath = new ArrayList<String>();
			File parentDir = new File(directory);
			File[] files = parentDir.listFiles();
			if (files == null) {

				return null;

			}
			for (File file : files) {
				if ((file.getName().toLowerCase(Locale.US).endsWith("jpg") || file.getName().toLowerCase(Locale.US).endsWith("jpeg")) && !file.getName().contains("binar")) {
					filesPath.add(file.getPath());
				}
			}
			// FileUtils.clearLogFile(parentDir + File.separator + "log.txt");
			inputFilesPath = filesPath.toArray(new String[filesPath.size()]);
			return directory;
		}

		/* (non-Javadoc)
		 * @see android.os.AsyncTask#onPostExecute(java.lang.Object)
		 */
		@Override
		protected void onPostExecute(String result) {
			if (result == null) {
				Toast.makeText(getBaseContext(), "Files Not Found in destenation folder", Toast.LENGTH_SHORT).show();
				setResult(RESULT_CANCELED);
				finish();
			}
			if (inputFilesPath != null) {
				startTestFlow();
			}
		}

		/* (non-Javadoc)
		 * @see android.os.AsyncTask#onPreExecute()
		 */
		@Override
		protected void onPreExecute() {
		}

		/* (non-Javadoc)
		 * @see android.os.AsyncTask#onProgressUpdate(java.lang.Object[])
		 */
		@Override
		protected void onProgressUpdate(Void... values) {
		}
	}

	/**
	 * Proceed after max retries.
	 */
	public void ProceedAfterMaxRetries() {
		final OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
		final CheckBoundaries checkBoundaries = ocrAnalyzeSession.getCheckBoundaries();
		CameraSessionManager.init(currentActivity, checkBoundaries, ocrAnalyzeSession.minRatioHW, ocrAnalyzeSession.maxRatioHW);
		cameraSessionManager = CameraSessionManager.getInstance();
		final CheckBoundaries checkBoundariesRect = cameraSessionManager.getCheckBoundariesRect();
		mobiCHECKOCR.setValidationCheckRect(checkBoundariesRect.getValidationRect(), checkBoundariesRect.getMinCheckRect(), checkBoundariesRect.getValidationRectBack(),
				checkBoundariesRect.getMinCheckRectBack());
		handler = new CameraActivityHandler(getInstance(), false);
		mobiCHECKOCR.setHandler(handler);
		configManager = new CameraConfigurationManager(this);
		try {
			if (camera == null) {
				camera = Camera.open();
			}
			configManager.initFromCameraParameters(camera);

			configManager.setDesiredCameraParameters(camera, false);

			camera.release();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/**
	 * Start binarization after faliure.
	 *
	 * @param imagePath the image path
	 */
	public void startBinarizationAfterFaliure(String imagePath) {

		matYuv = new Mat();

		byte[] imageData = FileUtils.getByteArray(imagePath);
		if (imageData == null) { // no Files saved on disk get image from the memory.
			matYuv.put(0, 0, CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode == CaptureMode.FRONT ? SessionResultParams.originalFront
					: SessionResultParams.originalBack);
		} else {
			matYuv.put(0, 0, imageData);
		}
		// Imgproc.cvtColor(matYuv, matRgba, Imgproc.COLOR_YUV420sp2RGB, 4);
		long defaultAspectRatio = 1;
		if (imagePath != null && imagePath.contains("BACK")) {
			// CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode = CaptureMode.BACK;
			//isBlurEnabled = false;
		} else {
			CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode = CaptureMode.FRONT;
		}
		BoundingBoxResult boundingBoxResult = mobiCHECKOCR.findCheckBoundingBoxContinueAnyway(matYuv, defaultAspectRatio);
		checkRect = boundingBoxResult.getRect();
		CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).setImagePath(imagePath);
		int timestamp = CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).timestamp;
		if (CameraManagerController.sessionType == SessionType.TEST || CameraManagerController.scanBackOnly) {
			handler = new CameraActivityHandler(getInstance(), false);
			mobiCHECKOCR.setHandler(handler);
			CameraManagerController.getOcrAnalyzeSession(context).checkRect = checkRect;
		}

		ProcessStillImageThread processStillImageThread = new ProcessStillImageThread(getApplicationContext(), handler, mobiCHECKOCR, isDebug, timestamp);
		processStillImageThread.start();

	}

	/**
	 *	
	 *
	 */
	public static class CameraActivityHandler extends Handler {

		/** The next frame delay max interval. */
		final int NEXT_FRAME_DELAY_MAX_INTERVAL = 100000;// 1000;

		/** The next frame delay counter step trigger. */
		final int NEXT_FRAME_DELAY_COUNTER_STEP_TRIGGER = 2;// 10

		/** The next frame delay counter step mulitplier. */
		final int NEXT_FRAME_DELAY_COUNTER_STEP_MULITPLIER = 100;

		/** The next frame max delay. */
		final int NEXT_FRAME_MAX_DELAY = 1000;
		//
		/** The looper activity. */
		final WeakReference<CameraController> looperActivity;

		/** The last time wasreceived. */
		protected long lastTimeWasreceived;

		/** The not optimal state counter. */
		protected long notOptimalStateCounter = 0;

		/** The proceeding to next frame delay. */
		protected long proceedingToNextFrameDelay = 0;

		/**
		 * Instantiates a new camera activity handler.
		 *
		 * @param cameraController the camera controller
		 * @param startPreview the start preview
		 */
		public CameraActivityHandler(CameraController cameraController, boolean startPreview) {
			looperActivity = new WeakReference<CameraController>(cameraController);
			initProceedingToNextFrameDelay();
			if (startPreview)
				startPreview();
		}

		/* (non-Javadoc)
		 * @see android.os.Handler#handleMessage(android.os.Message)
		 */
		@Override
		public void handleMessage(Message message) {
			// if (returnAfterMaxTry){
			// CameraManagerController.
			// }
			final Bundle messageData = message.getData();

			CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "handleMessage cameraController reference is null");
				return;
			}
			Logger.i(TAG, "handler processing message:" + message.what);
			//Logger.e(TAG, "type is " + String.valueOf(message.what));
			switch (message.what) {

			case CameraTypes.MESSAGE_SHOW_COUNTER:
				Logger.i(TAG, "MESSAGE_SHOW_COUNTER");
				int elapsedTime = message.arg1;
				cameraController.cameraOverlayView.showCounter(true, elapsedTime);
				if (CameraManagerController.isDebug && cameraController != null && cameraController.getBaseContext() != null) {
					FileUtils.addToLogFile("MESSAGE_SHOW_COUNTER", cameraController.getBaseContext());
				}
				break;

			case CameraTypes.MESSAGE_HIDE_HINT_INDICATOR:
				cameraController.cameraOverlayView.showIndicator(null, false);
				if (CameraManagerController.isDebug && cameraController != null && cameraController.getBaseContext() != null) {
					FileUtils.addToLogFile("MESSAGE_HIDE_HINT_INDICATOR", cameraController.getBaseContext());
				}

				break;

			case CameraTypes.MESSAGE_SHOW_PROCESSING_LABEL:
				Logger.i(TAG, "MESSAGE_SHOW_PROCESSING_LABEL");
				
			
					
				cameraController.onSentUIEventMessage(TISFlowUIMessages.BEFORE_PROCESSING);				
				String text = (String) message.obj;

				if (!CameraManagerController.isStillMode) {
					if (text.toLowerCase(Locale.getDefault()).contains("processing")) {
						Logger.d(TAG, "debug");
					}
					if (cameraController.cameraOverlayView != null) {
						cameraController.cameraOverlayView.updateProcessingMessage(text);
					}
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_SHOW_PROCESSING_LABEL", cameraController.getBaseContext());
				}

				break;

			case CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT:
				Logger.i(TAG, "MESSAGE_HIDE_BOUNDARIES_RECT");
				if (cameraController.isDebug || drawFoundedRectangle) {
					cameraController.cameraOverlayView.showCheckBoundyRect(false, null);

				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_HIDE_BOUNDARIES_RECT", cameraController.getBaseContext());
				}
				break;

			case CameraTypes.MESSAGE_HIDE_ERROR_MESSAGE:

				Logger.i(TAG, "MESSAGE_HIDE_ERROR_MESSAGE");
				cameraController.cameraOverlayView.hideErrorMessage();
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_HIDE_ERROR_MESSAGE", cameraController.getBaseContext());
				}
				break;

			case CameraTypes.MESSAGE_AUTO_FOCUS:
				Logger.i(TAG, "MESSAGE_AUTO_FOCUS");
				// continuous auto focus
				if (cameraController.cameraSessionManager.getState() == State.PREVIEW) {
					cameraController.cameraSessionManager.requestAutoFocus(this, CameraTypes.MESSAGE_AUTO_FOCUS);
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_AUTO_FOCUS", cameraController.getBaseContext());
				}
				break;
			case CameraTypes.MESSAGE_RESTART_PREVIEW:
				Logger.i(TAG, "MESSAGE_RESTART_PREVIEW");
				Logger.d(TAG, "Got restart preview message");
				restartPreviewAndDecode();
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_RESTART_PREVIEW", cameraController.getBaseContext());
				}
				break;
			case CameraTypes.MESSAGE_PROCESS_NOT_VALID:
				final String hintName = messageData.getString(Constants.INTENT_HINT_NAME);
				final String errorCodeName = messageData.getString(Constants.INTENT_ERROR_CODE);
				final Bundle checkRectBundle = messageData.getBundle(Constants.INTENT_CHECK_RECT);
				final double orientation = messageData.getDouble(Constants.INTENT_ORIENTATION, 0);

				if (!StringUtils.isEmptyOrNull(hintName)) {
					HintIndicator hintIndicator = HintIndicator.valueOf(hintName);
					// in no light cell phone may be lying and not in use.
					// if these messages comes in certain frequency in a row we
					// need to update
					// delay the proceeding to next frame.
					checkNextFrameDelay(hintIndicator);
					CameraController.getInstance().cameraOverlayView.showIndicator(hintIndicator, true);
					CameraController.getInstance().cameraOverlayView.showCheckBoundyRect(false, null);

				}

				if (!StringUtils.isEmptyOrNull(errorCodeName)) {
					final ErrorCode errorCode = ErrorCode.valueOf(errorCodeName);
					if (errorCode == ErrorCode.error_deviceMemory) {
						final String exception = messageData.getString(Constants.INTENT_EXCEPTION_ERROR);
						Intent data = new Intent();
						data.putExtra(CaptureIntent.MOBIFLOW_ERROR_DETAILS, exception);
						looperActivity.get().setResult(CameraManagerController.RESULT_LIBRARY_ERROR, data);
						looperActivity.get().finish();
						return;
					}
					// didn't find MRZ line continue
					if (errorCode == ErrorCode.errorPassportNotFound) {
						proceedWithProcessing();
						return;
					}


						cameraController.cameraOverlayView.showErrorMessage(errorCode);
						cameraController.cameraOverlayView.showCheckBoundyRect(false, null);

				}

				if (cameraController.isDebug || drawFoundedRectangle) {
					if (checkRectBundle != null) {
						Rect rect = OCRHelper.bundleToRect(checkRectBundle);
						cameraController.cameraOverlayView.showCheckBoundyRect(true, rect);
						dispatchHintIndicator(messageData);
						sendEmptyMessageDelayed(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT, CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY);
					}
				}

				proceedWithProcessing();
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_PROCESS_NOT_VALID", cameraController.getBaseContext());
				}
				break;

			case CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE:
				//				cameraController.currentCallBack = TISFlowActionCallback.START_PROCESSING_IMAGE;
				//				cameraController.currentError = null;
				//				listener.onMessageReceive(cameraController.currentCallBack, cameraController.currentError, null,looperActivity.get().cameraOverlayView.getContext());
				
				Logger.i(TAG, "MESSAGE_CAPTURE_STILL_IMAGE");
				
				cameraController.cameraOverlayView.setConfirmationIndicators();
				initProceedingToNextFrameDelay();

				if (cameraController.isFinishing())
					return;

				Bundle bundleCaptureStillImage = messageData;
				if (cameraController.cameraSessionManager.getState() == State.PREVIEW) {
					// cameraSessionManager.update

					final Bundle checkRectCaptureBundle = bundleCaptureStillImage.getBundle(Constants.INTENT_CHECK_RECT);
					Rect rect = OCRHelper.bundleToRect(checkRectCaptureBundle);
					if (cameraController.isDebug || drawFoundedRectangle) {
						cameraController.cameraOverlayView.showCheckBoundyRect(true, rect);
					}
					CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectCaptureBundle);
					CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).orientation = bundleCaptureStillImage
							.getDouble(Constants.INTENT_ORIENTATION);

					// to be sure remove all messages
					removeAllMessages();

					captureStillImage();
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_CAPTURE_STILL_IMAGE", cameraController.getBaseContext());
				}

				break;

			case CameraTypes.MESSAGE_BARCODE_DETECTED:
				Logger.i(TAG, "MESSAGE_BARCODE_DETECTED");
				OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext());
				if (cameraController.cameraSessionManager.getState() == State.PREVIEW) {
					String barcodeType = messageData.getString(Constants.BAR_CODE_TYPE);
					String barcodeData = messageData.getString(Constants.BAR_CODE_DATA);

					if (ocrAnalyzeSession.captureMode == CaptureMode.FRONT) {
						ocrAnalyzeSession.setFrontBarcodeType(barcodeType);
						ocrAnalyzeSession.setFrontBarcodeData(barcodeData);
					} else {
						ocrAnalyzeSession.setBackBarcodeType(barcodeType);
						ocrAnalyzeSession.setBackBarcodeData(barcodeData);
					}
					if (CameraManagerController.isDebug) {
						FileUtils.addToLogFile("MESSAGE_BARCODE_DETECTED", cameraController.getBaseContext());
					}
					cameraController.cameraOverlayView.animateToCheckBoundariesRect(ocrAnalyzeSession.getCheckBoundariesDisp());

					ocrAnalyzeSession.isBarcodeSession = false;
				} else {
					cameraController.cameraOverlayView.setCaptureCaption(ocrAnalyzeSession.captureMode);
					proceedWithProcessing();
				}

				break;
			case CameraTypes.MESSAGE_BARCODE_ANIMATION_FINISHED:
				cameraController.cameraOverlayView.setCheckBoundariesRect(CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext())
						.getCheckBoundariesDisp());
				cameraController.cameraOverlayView.setCaptureCaption(CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).captureMode);
				proceedWithProcessing();
				break;
			case CameraTypes.PASSPORT_RESULT:
				TISPassportProcessingResults passportResult = new TISPassportProcessingResults();
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("PASSPORT_RESULT", cameraController.getBaseContext());
				}
				passportResult.ocrRawResult = messageData.getString(Constants.PASSPORT_OCR_RESULT);
				passportResult.ocrResultWithDelimiter = messageData.getString(Constants.PASSPORT_OCR_RESULT_WITH_DELIMETER);
				passportResult.digitalRowLength = messageData.getInt(Constants.PASSPORT_OCR_RESULT_LENGTH);

				int[] boundingBoxResult = messageData.getIntArray(Constants.INTENT_BOUNDING_BOX_RESULT);
				Logger.i(TAG, "PASSPORT_OCR_RESULT_WITH_DELIMETER" + passportResult.ocrResultWithDelimiter);

				CameraManagerController.getOcrAnalyzeSession(activity).setOcrResult(passportResult);
				boolean isPassportValid = OcrValidationUtils.validatePassport(passportResult.ocrResultWithDelimiter, passportResult.digitalRowLength);
				if (!isPassportValid) {
					proceedWithProcessing();
				} else {
					//listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, passportResult, looperActivity.get().cameraOverlayView.getContext());
									
					cameraController.currentError = null;
					Object ocrResult[] = new Object[5];
					passportResult.setPassportResult(OcrValidationUtils.parsePassportResult(passportResult.ocrResultWithDelimiter));
				//	OCRResult result = (OCRResult) message.obj;					
					ocrResult[0] = passportResult.ocrResultWithDelimiter;
					ocrResult[1] = String.valueOf(passportResult.digitalRowLength);
					ocrResult[2] = passportResult.ocrRawResult;
					ocrResult[3] = passportResult.scoreResult;
					ocrResult[4] = passportResult.passportResultsByField;														
					
					Mat originalImg = CameraManagerController.getOcrAnalyzeSession(activity).getVideoMat();
					Rect cvRect = new Rect(boundingBoxResult[0], boundingBoxResult[1], boundingBoxResult[2], boundingBoxResult[3]);
					Mat cropped = new Mat(originalImg, cvRect);				
					Mat grayImage = new Mat();
					if (CameraManagerController.shouldOutputBWImage) {
						//String model = FileUtils.getDeviceName() + " Android version " + Build.VERSION.RELEASE;
						//String make = context.getResources().getString(R.string.version);
						//activity.mobiCHECKOCR.BredlyBinarization(cropped, bradlyImage,null,null, model, make);
						String basePath = CameraController.activity.getFilesDir().getAbsolutePath() + "/" + FileUtils.tempPath + "/";
						String currentDateAndTime = FileUtils.getCurrentTime();
						String path = basePath + "FRONT" + "_" + currentDateAndTime + "_" + ".jpg";
						Mat bradlyImage = new Mat();
						activity.mobiCHECKOCR.binarizeWithoutSearchingBoundingBox(cropped, grayImage, bradlyImage, path, boundingBoxResult, true);
						SessionResultParams.jpegBWFront = FileUtils.convertJpgMatToByte(bradlyImage);
						bradlyImage.release();
						bradlyImage = null;
					}
					if (CameraManagerController.shouldOutputColoredImage) {
						SessionResultParams.colorFront = FileUtils.convertJpgMatToByte(cropped, CameraManagerController.colorImageCompression);

					}
					if (CameraManagerController.shouldOutputGrayscaleImage) {

						Mat gray = cropped.clone();
						Imgproc.cvtColor(cropped, gray, Imgproc.COLOR_BGR2GRAY);
						SessionResultParams.grayscaleFront = FileUtils.convertJpgMatToByte(gray, CameraManagerController.grayScaleImageCompression);
						gray.release();
						gray = null;
					}
					if (CameraManagerController.shouldOutputOriginalImage) {
						SessionResultParams.originalFront = FileUtils.convertJpgMatToByte(originalImg);
					}
					cropped.release();
					cropped = null;
					grayImage.release();
					grayImage = null;
					cameraController.currentCallBack = TISFlowGeneralMessages.PASSPORT_OCR_RESULT;
					listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, ocrResult, looperActivity.get().cameraOverlayView.getContext());
					
				}

				break;
				case CameraTypes.ID_CARD_RESULT:
					if (CameraManagerController.isDebug) {
						FileUtils.addToLogFile("ID_CARD_RESULT", cameraController.getBaseContext());
					}
					cameraController.currentCallBack = TISFlowGeneralMessages.ID_CARD_OCR_RESULT;
					cameraController.currentError = null;
					String idResult[] = new String[4];
					OCRResult result = (OCRResult) message.obj;
					idResult[0] = String.valueOf(result.digitalRowLength);
					idResult[1] = result.ocrResultWithDelimiter;
					idResult[2] = result.ocrRawResult;
					idResult[3] = result.scoreResult;
					// for video first check internal validation after call callig app for OCR aproval.
					if (!CameraManagerController.isStillMode) {
						listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, idResult, looperActivity.get().cameraOverlayView.getContext());
					}
					// stills we can't ask another frame - close session.
					else {
						cameraController.activityResultFinish(result.isValidRead);
					}
					break;

				case CameraTypes.MESSAGE_ERROR:
				Logger.i(TAG, "MESSAGE_ERROR");
				if (!CameraManagerController.isStillMode) {
					proceedWithProcessing();
				} else {
					String errorMessage = (String) message.obj;
					cameraController.displayFrameworkBugMessageAndExit(errorMessage);
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_ERROR", cameraController.getBaseContext());
				}

				break;
			case CameraTypes.MESSAGE_PROCESS_PRE_CAPTURED_IMAGE:
				Logger.i(TAG, "MESSAGE_PROCESS_PRE_CAPTURED_IMAGE");
				cameraController.onSentUIEventMessage(TISFlowUIMessages.BEFORE_PROCESSING);
				if (CameraManagerController.isStillMode)
					stopPreview();
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_PROCESS_PRE_CAPTURED_IMAGE", cameraController.getBaseContext());
				}
				break;
			// and the rest as in MESSAGE_PROCESS_CAPTURED_IMAGE
			case CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE:
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_PROCESS_CAPTURED_IMAGE", cameraController.getBaseContext());
				}
				Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE");
				if (CameraManagerController.isStillMode) {
					cameraController.cameraSessionManager.stopPreviewOnly();
					if (CameraManagerController.useCameraAPI2){
						CameraController.getInstance().camera2Instance.closeSession();;
					}

					if (!CameraManagerController.enableProcessingView) {
						cameraController.cameraOverlayView.showProcessingOverlay(true);
					} else {
						cameraController.cameraOverlayView.switchToProcessingView(false);

					}

				}


				String imagePath = (String) message.obj;
				// to be sure, remove all messages
				if (CameraManagerController.isStillMode)
					removeAllMessages();

				if (CameraManagerController.scanBackOnly) { // only for back capture
					// cameraController.startBinarizationAfterFaliure(imagePath);
					cameraController.processCapturedImage(imagePath); // for front capture
					//	CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).frontImageRect = FileUtils.arrayToRect(getFrontImageArrayValues());
				} else {
					cameraController.processCapturedImage(imagePath); // for front capture
				}

				break;
			case CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT:
				Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT");
				//				cameraController.currentCallBack = TISFlowActionCallback.FINISH_PROCESSING_IMAGE;
				//				cameraController.currentError = null;
				//				listener.onMessageReceive(cameraController.currentCallBack, cameraController.currentError,null,looperActivity.get().cameraOverlayView.getContext());
				if (CameraManagerController.isStillMode){				
					//cameraController.onSentUIEventMessage(TISFlowUIMessages.AFTER_PROCESSING);
				}
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT", cameraController.getBaseContext());
				}
				 result = (OCRResult) message.obj;
				// processCapturedImageResult(result);
				if (!CameraManagerController.isStillMode && CameraManagerController.sessionType != SessionType.TEST) {
					if (result.isValidRead)
						cameraController.activityResultFinish(result.isValidRead);
					else {
						if (cameraController.continueVideoModeOrShowAlert() && !CameraManagerController.isStillMode)
							proceedWithProcessing();
						else
							cameraController.activityResultFinish(result.isValidRead);

					}

				} else {
					cameraController.activityResultFinish(result.isValidRead);
				}
				break;
			case CameraTypes.CHECK_MICR_RESULT:
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("CHECK_MICR_RESULT", cameraController.getBaseContext());
				}
				cameraController.currentCallBack = TISFlowGeneralMessages.CHECK_OCR_RESULT;
				cameraController.currentError = null;
				String ocrResult[] = new String[4];
				result = (OCRResult) message.obj;
				ocrResult[0] = String.valueOf(result.digitalRowLength);
				ocrResult[1] = result.ocrResultWithDelimiter;
				ocrResult[2] = result.ocrRawResult;
				ocrResult[3] = result.scoreResult;
				// for video first check internal validation after call callig app for OCR aproval.
				if (!CameraManagerController.isStillMode) {
					listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, ocrResult, looperActivity.get().cameraOverlayView.getContext());
				}
				// stills we can't ask another frame - close session.
				else {
					cameraController.activityResultFinish(result.isValidRead);
				}
				break;

			case CameraTypes.PAN_CARD_RESULT:
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("PAN_CARD_RESULT", cameraController.getBaseContext());
				}
				cameraController.currentCallBack = TISFlowGeneralMessages.PAN_CARD_OCR_RESULT;
				cameraController.currentError = null;
				String panResult[] = new String[4];
				result = (OCRResult) message.obj;
				panResult[0] = String.valueOf(result.digitalRowLength);
				panResult[1] = result.ocrResultWithDelimiter;
				panResult[2] = result.ocrRawResult;
				panResult[3] = result.scoreResult;
				// for video first check internal validation after call callig app for OCR aproval.
				if (!CameraManagerController.isStillMode) {
					if (OcrValidationUtils.validationPanCard(result.ocrResultWithDelimiter)) {
						listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, panResult, looperActivity.get().cameraOverlayView.getContext());
					} else { // ask focus on video when validation didn't pass
						cameraController.cameraSessionManager.requestAutoFocus(this, CameraTypes.MESSAGE_AUTO_FOCUS);
						proceedWithProcessing();
					}
				}
				// stills we can't ask another frame - close session.
				else {
					cameraController.activityResultFinish(result.isValidRead);
				}
				break;
			case CameraTypes.MESSAGE_CONTINUE_ANYWAY:
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_CONTINUE_ANYWAY", cameraController.getBaseContext());
				}
				cameraController.activityResultFinish(true);
				break;

			case CameraTypes.MESSAGE_TOGGLE_TORCH:
				if (CameraManagerController.isDebug) {
					FileUtils.addToLogFile("MESSAGE_TOGGLE_TORCH", cameraController.getBaseContext());
				}
				CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).isTorchOn = (Boolean) message.obj;
				restartPreview();
				cameraController.cameraOverlayView.enableTorchButton(true);
				break;
			}
		}

		/**
		 * Gets the front image array values.
		 *
		 * @return the front image array values
		 */
		private int[] getFrontImageArrayValues() {

			if (CameraManagerController.frontImageRectArray == null) {
				CameraManagerController.frontImageRectArray = new int[4];
				if (CameraManagerController.imageType == TISDocumentType.CHECK) {
					CameraManagerController.frontImageRectArray[0] = 0;
					CameraManagerController.frontImageRectArray[1] = 0;
					CameraManagerController.frontImageRectArray[2] = 1200;
					CameraManagerController.frontImageRectArray[3] = 600;
				}
			}

			return CameraManagerController.frontImageRectArray;

		}

		/**
		 * Inits the proceeding to next frame delay.
		 */
		protected void initProceedingToNextFrameDelay() {
			lastTimeWasreceived = 0;
			notOptimalStateCounter = 0;
			proceedingToNextFrameDelay = 0;
		}



		/**
		 * Check next frame delay.
		 *
		 * @param hintIndicator the hint indicator
		 */
		protected void checkNextFrameDelay(HintIndicator hintIndicator) {
			if (hintIndicator == HintIndicator.NoLight) {
				long currentTimeWasreceived = Calendar.getInstance().getTimeInMillis();
				long timeDelta = currentTimeWasreceived - lastTimeWasreceived;

				if (lastTimeWasreceived > 0 && timeDelta <= NEXT_FRAME_DELAY_MAX_INTERVAL) {
					if (notOptimalStateCounter > NEXT_FRAME_DELAY_COUNTER_STEP_TRIGGER) {
						long multiplier = notOptimalStateCounter / NEXT_FRAME_DELAY_COUNTER_STEP_TRIGGER;
						long nextDelay = NEXT_FRAME_DELAY_COUNTER_STEP_MULITPLIER * multiplier;
						nextDelay = nextDelay > NEXT_FRAME_MAX_DELAY ? NEXT_FRAME_MAX_DELAY : nextDelay;
						proceedingToNextFrameDelay = nextDelay;
					}
					notOptimalStateCounter++;
				}
				lastTimeWasreceived = currentTimeWasreceived;

			} else {
				initProceedingToNextFrameDelay();
			}
		}

		/**
		 * Dispatch hint indicator.
		 *
		 * @param messageData the message data
		 */
		private void dispatchHintIndicator(final Bundle messageData) {
			CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "dispatchHintIndicator cameraController reference is null");
				return;
			}
			if (messageData != null) {
				final String hintIndicatorName = messageData.getString(Constants.INTENT_HINT_NAME);
				if (!StringUtils.isEmptyOrNull(hintIndicatorName)) {
					HintIndicator indicator = HintIndicator.valueOf(hintIndicatorName);
					if (!CameraManagerController.isDynamicCapture)
						cameraController.cameraOverlayView.showIndicator(indicator, true);
				}
			}
		}

		/**
		 * Proceed with processing.
		 */
		private void proceedWithProcessing() {
			// delay next process if necessary
			final CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "proceedWithProcessing cameraController reference is null");
				return;
			}

			if (cameraController.isFinishing())
				return;

			postDelayed(new Runnable() {
				@Override
				public void run() {
					cameraController.cameraSessionManager.requestPreviewFrame(activity, cameraController.mobiCHECKOCR);
				}
			}, proceedingToNextFrameDelay);

		}

		/**
		 * Capture still image.
		 */
		private void captureStillImage() {
			Logger.i(TAG, "captureStillImage");
			captureStillStarted = true;
			final CameraController cameraController = looperActivity.get();
			// cameraController.cameraOverlayView.setConfirmationIndicators();
			if (!CameraManagerController.isDynamicCapture) {
				cameraController.cameraOverlayView.prepareForStillCapture();
			}

			postDelayed(new Runnable() {
				@Override
				public void run() {
					cameraController.cameraSessionManager.requestCaptureStillImage(cameraController.handler, CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE,
							CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).captureMode);
				}
			}, 100);
		}

		/**
		 * Restart preview.
		 */
		private void restartPreview() {
			stopPreview();
			startPreview();
		}

		/**
		 * Start preview.
		 */
		void startPreview() {
			CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "startPreview cameraController reference is null");
				return;
			}
			if (CameraManagerController.useCameraAPI2){
				CameraController.getInstance().startCameraAPI2();
				return;
			}
			cameraController.cameraSessionManager.startPreview(CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).isTorchOn);
			restartPreviewAndDecode();
		}

		/**
		 * Stop preview.
		 */
		public void stopPreview() {
			CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "stopPreview cameraController reference is null");
				return;
			}
			cameraController.cameraSessionManager.setState(State.DONE);
			cameraController.cameraSessionManager.stopPreview();
		}

		/**
		 * Quit synchronously.
		 */
		public void quitSynchronously() {
			stopPreview();
			// remove all queued messages
			removeAllMessages();
		}

		/**
		 * Removes the all messages.
		 */
		public void removeAllMessages() {
			removeMessages(CameraTypes.MESSAGE_QUIT);
			removeMessages(CameraTypes.MESSAGE_AUTO_FOCUS);
			removeMessages(CameraTypes.MESSAGE_RESTART_PREVIEW);
			removeMessages(CameraTypes.MESSAGE_PROCESS_NOT_VALID);
			removeMessages(CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE);
			removeMessages(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE);
			removeMessages(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT);
			removeMessages(CameraTypes.MESSAGE_SHOW_COUNTER);
			removeMessages(CameraTypes.MESSAGE_SHOW_PROCESSING_LABEL);
			removeMessages(CameraTypes.MESSAGE_HIDE_HINT_INDICATOR);
			removeMessages(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT);
			removeMessages(CameraTypes.MESSAGE_TOGGLE_TORCH);
			removeMessages(CameraTypes.MESSAGE_INFO);
			removeMessages(CameraTypes.MESSAGE_ERROR);
			removeMessages(CameraTypes.MESSAGE_BARCODE_DETECTED);
			removeMessages(CameraTypes.MESSAGE_BARCODE_ANIMATION_FINISHED);
			removeMessages(CameraTypes.PASSPORT_RESULT);
			removeMessages(CameraTypes.PAN_CARD_RESULT);
			removeMessages(CameraTypes.CHECK_MICR_RESULT);
			removeMessages(CameraTypes.ID_CARD_RESULT);


		}

		/**
		 * Removes the all preview processing messages.
		 */
		public void removeAllPreviewProcessingMessages() {
			removeMessages(CameraTypes.MESSAGE_RESTART_PREVIEW);
			removeMessages(CameraTypes.MESSAGE_PROCESS_NOT_VALID);
			removeMessages(CameraTypes.MESSAGE_CAPTURE_STILL_IMAGE);
			removeMessages(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE);
			removeMessages(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT);
			removeMessages(CameraTypes.MESSAGE_SHOW_COUNTER);
			removeMessages(CameraTypes.MESSAGE_SHOW_PROCESSING_LABEL);
			removeMessages(CameraTypes.MESSAGE_HIDE_HINT_INDICATOR);
			removeMessages(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT);
			removeMessages(CameraTypes.MESSAGE_INFO);
			removeMessages(CameraTypes.MESSAGE_ERROR);
			removeMessages(CameraTypes.MESSAGE_BARCODE_DETECTED);
			removeMessages(CameraTypes.MESSAGE_BARCODE_ANIMATION_FINISHED);
		}

		/**
		 * Restart preview and decode.
		 */
		private void restartPreviewAndDecode() {
			CameraController cameraController = looperActivity.get();
			if (cameraController == null) {
				Logger.e(TAG, "restartPreviewAndDecode cameraController reference is null");
				return;
			}
			if (cameraController.cameraSessionManager.getState() == State.NONE || cameraController.cameraSessionManager.getState() == State.PREVIEW
					|| cameraController.cameraSessionManager.getState() == State.SUCCESS) {
				cameraController.resetCameraOverlay(CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).captureMode);
				// in auto capture mode we r processing preview frame for check
				// boundaries
				if (!CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).isManualCapture) {
					postDelayed(new Runnable() {
						@Override
						public void run() {
							proceedWithProcessing();
						}
					}, 500);
				}
				cameraController.cameraSessionManager.requestAutoFocus(this, CameraTypes.MESSAGE_AUTO_FOCUS);
			}
		}

		/**
		 * Removes the low priority messages.
		 */
		public void removeLowPriorityMessages() {
			removeMessages(CameraTypes.MESSAGE_AUTO_FOCUS);
			removeMessages(CameraTypes.MESSAGE_SHOW_COUNTER);
			removeMessages(CameraTypes.MESSAGE_SHOW_PROCESSING_LABEL);
			removeMessages(CameraTypes.MESSAGE_HIDE_HINT_INDICATOR);
			removeMessages(CameraTypes.MESSAGE_HIDE_BOUNDARIES_RECT);
		}
	}

	/**
	 * Proceed successfull front.
	 *
	 * @param dialogTitleMessage the dialog title message
	 */
	protected void proceedSuccessfullFront(String dialogTitleMessage) {
		
		CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).isFrontSuccessfull = true;
		CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).frontRetries = CameraManagerController.getOcrAnalyzeSession(getApplicationContext())
				.getOcrErrorCounter();
		CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).initOcrErrorCounter();
		CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode = CaptureMode.BACK;
		if (!CameraManagerController.enableProcessingView)
			cameraOverlayView.showProcessingOverlay(true);
		else {
			//cameraOverlayView.switchToProcessingView(false);
		}
		if (!useCustomAlert) {
			showProceedingDialog(dialogTitleMessage, StringUtils.dynamicString(this, "TISFlowPleaseCaptureCheckBack"), NEXT_ACTION.CAPTURE_BACK);
		} else {
			// starting point of stage 2
			if (!CameraManagerController.useCameraAPI2)
				handler.startPreview();
			cameraOverlayView.finishCapture();
			openCameraForBackCapture(false);
		}
	}

	/**
	 * Start calling app activity.
	 *
	 * @param view the view
	 */
	public void startCallingAppActivity(View view) {
		if (captureStillStarted) {
			return;
		}
		try {
			String infoClass = getResources().getString(R.string.TISCallingAppActivityName);

			Class<?> infoActivity = null;
			if (infoClass != null) {
				try {
					infoActivity = Class.forName(infoClass);
				} catch (ClassNotFoundException e) { // TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			startActivity(new Intent(CameraController.this, infoActivity));
		} catch (Exception e) {
			Logger.e(TAG, "Failed to open Activity on runTime ");
		}
	}

	/**
	 * Show green indicator for video.
	 */
	public void showGreenIndicatorForVideo() {
		processStart = true;
		if (!CameraManagerController.isDynamicCapture){
			CameraController.getInstance().cameraOverlayView.setConfirmationIndicators();
		}
	}

	/**
	 * Show red indicator for video.
	 */
	public void showRedIndicatorForVideo() {
		processStart = false;
		if (!CameraManagerController.isDynamicCapture)
			this.cameraOverlayView.setNonConfirmationIndicators();
	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onConfigurationChanged(android.content.res.Configuration)
	 */
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);

		int rotation = getWindowManager().getDefaultDisplay().getRotation();
		if (rotation == Surface.ROTATION_0) {
			setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
		}

		else if (rotation == Surface.ROTATION_90) {
			setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);

		} else if (rotation == Surface.ROTATION_180) {
			setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE);

		}
		// Checks the orientation of the screen
		// return to previous activity if goes to portrait
		/*
		 * if (newConfig.orientation == Configuration.ORIENTATION_PORTRAIT && CameraManagerController.sessionType != SessionType.PORTRAIT) { if (rotation == Surface.ROTATION_0) {
		 * setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE); } else if (rotation == Surface.ROTATION_270) { currentActivity.setRequestedOrientation
		 * (ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE); } // setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE); }
		 */

	}

	/**
	 * Gets the manager listener.
	 *
	 * @return the manager listener
	 */
	public static CaptureIntent.callbackReturnMessage getManagerListener() {
		return callBack;
	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onBackPressed()
	 */
	@Override
	public void onBackPressed() {
		Logger.i(TAG,"onBackPressed start");
		if (!processStart && !backPressed) {
			Logger.i(TAG,"onBackPressed enter");
			backPressed = true;
			if (listener != null) {
				currentCallBack = TISFlowGeneralMessages.BACK_PRESSED;
				listener.onMobiFlowGeneralMessageReceived(currentCallBack, null, context);
			} else {
				quitActivity();
			}
			//quitActivity();
		}
	}

	/**
	 * On default back pressed.
	 */
	public void onDefaultBackPressed() {
		super.onBackPressed();
	}

	/* (non-Javadoc)
	 * @see com.topimagesystems.controllers.BaseController#ensureActionBar()
	 */
	@Override
	protected void ensureActionBar() {
	}

	/**
	 * Open camera for front capture.
	 *
	 * @param isProcessCurrentImage the is process current image
	 */
	protected void openCameraForFrontCapture(boolean isProcessCurrentImage) {
		Bundle extras = new Bundle();
		extras.putBoolean(CaptureIntent.INFO_SCREEN_ENABLED, isInfoScreenEnable);
		extras.putLong(CaptureIntent.INFO_SCREEN_INTERVAL, infoScreenInterval);
		CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode = CaptureMode.FRONT;
		cameraOverlayView.setCaptureCaption(CaptureMode.FRONT);
	}

	/**
	 * Open camera for back capture.
	 *
	 * @param isProcessCurrentImage the is process current image
	 */
	public void openCameraForBackCapture(boolean isProcessCurrentImage) {
		if (CameraManagerController.isDynamicCapture) {
			cameraSessionManager.resetRectComapreCounter();
			dynamicCameraOverlayView.removeCaptureElements();
		}

		OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());

		ocrAnalyzeSession.captureMode = CaptureMode.BACK;

		ocrAnalyzeSession.isBarcodeSession = CameraManagerController.enableBarcodeDetection
				&& (CameraManagerController.scanBarcodeLocation == TISScanBarcodeLocation.BARCODE_BACK || CameraManagerController.scanBarcodeLocation == TISScanBarcodeLocation.BARCODE_FRONT_AND_BACK);

		if (ocrAnalyzeSession.isBarcodeSession)
			//cameraOverlayView.forceNewCheckBoundariesRect(ocrAnalyzeSession.getBarcodeBoundariesRectDisp());

		if (!CameraManagerController.isDynamicCapture)
			cameraOverlayView.setCaptureCaption(ocrAnalyzeSession.captureMode);

		Bundle extras = new Bundle();
		extras.putBoolean(CaptureIntent.INFO_SCREEN_ENABLED, isInfoScreenEnable);
		extras.putLong(CaptureIntent.INFO_SCREEN_INTERVAL, infoScreenInterval);
		if (!CameraManagerController.isDynamicCapture)
			cameraOverlayView.setCaptureCaption(ocrAnalyzeSession.captureMode);
		showInfoActivity();
		captureStillStarted = false;
		ocrAnalyzeSession.initOcrErrorCounter();
		//isBlurEnabled = false;
		CameraManagerController.isStillMode = CameraManagerController.isSessionStartsInStills;
		CameraManagerController.falseRecognitionVideoFrames = 0;
		CameraManagerController.BarcodeDetectionTries = 0;
		cameraSessionManager.requestAutoFocus(getHandler(), CameraTypes.MESSAGE_AUTO_FOCUS);

	}

	/* (non-Javadoc)
	 * @see com.topimagesystems.intent.MICRIntent.callbackReturnMessage#onMessageReturn(com.topimagesystems.controllers.imageanalyze.CameraTypes.TISFlowActionCallback)
	 */
	@Override
	public void onMessageReturn(TISFlowInputMessages result) {
		Logger.i(TAG,result.toString());
		if (currentCallBack == TISFlowGeneralMessages.BACK_PRESSED) {
			if (result == TISFlowInputMessages.CONTINUE_CURRENT_SESSION) {
				handler.proceedWithProcessing();
				return;
			} else {
				quitActivity();
			}
		}
		if (result == TISFlowInputMessages.CONTINUE_MOBI_FLOW_CUSTOM_UI) {
			useCustomAlert = true;
			result = TISFlowInputMessages.CONTINUE_MOBI_FLOW;
		} else {
			useCustomAlert = false;
		}
		if (isDebug) {
			FileUtils.addToLogFile(result.name().toString(), getBaseContext());
		}
		if (result == null) {
			result = TISFlowInputMessages.CONTINUE_MOBI_FLOW;
		}
		
		if (result == TISFlowInputMessages.CONTINUE_MOBI_FLOW && currentCallBack == TISFlowGeneralMessages.CAPTURE_BACK & currentError == null) {
			proceedSuccessfullFront(StringUtils.dynamicString(this, "TISSuccessfulReadingTitle"));
			return;
		}
		if (result == TISFlowInputMessages.CANCEL_SESSION && currentCallBack == TISFlowGeneralMessages.CAPTURE_BACK) {
			setResult(CameraManagerController.RESULT_FINISH_WITH_SESSION_RESULT);
			finish();
			return;
		}
		if (currentCallBack == TISFlowGeneralMessages.PASSPORT_OCR_RESULT ){
			if(result == TISFlowInputMessages.OCR_RESULT_FAILED )				
			handler.proceedWithProcessing();
			else
			activity.activityResultFinish(true);
		}
		switch (result) {
		case CONTINUE_MOBI_FLOW:

			if (currentCallBack == TISFlowGeneralMessages.MULTI_CAPTURE) {
				if(CameraManagerController.enableBarcodeDetection){
					CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).isBarcodeSession = true;
				}
				if (!CameraManagerController.scanBackOnly) {
					CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode = CaptureMode.FRONT;
				} else {
					CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode = CaptureMode.BACK;
				}
				if (!useCustomAlert) {
					final OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
					if (ocrAnalyzeSession.analyzeErrorCode == null || ocrAnalyzeSession.analyzeErrorCode == OCRAnalyzeErrorCode.NONE) {
						// session passed with no error
						showOCRReadingError(StringUtils.dynamicString(this, "TISFlowMultiCaptureTitle"), StringUtils.dynamicString(this, "TISMultiCaptureShouldContinueCapture"),
								StringUtils.dynamicString(this, "TISFlowCapture"), StringUtils.dynamicString(this, "TISFlowFinish"));
					} else {
						parseErrorResult(false);
					}

				} else {
					cameraOverlayView.finishCapture();
					cameraOverlayView.invalidate();
					if (!CameraManagerController.useCameraAPI2)
						handler.startPreview();
				}
				currentCallBack = null;

			} else {
				parseErrorResult(false);
			}
			break;
		case OCR_RESULT_FAILED:
			CameraManagerController.falseRecognitionVideoFrames++;
			handler.proceedWithProcessing();
			break;
		case OCR_RESULT_OK:
			activityResultFinish(true);
			break;
		case CANCEL_SESSION:
			setResult(CameraManagerController.RESULT_CLOSE_SESSION);
			finish();
			break;
		default:
			parseErrorResult(false);
			break;
		}
		captureStillStarted = false;
		isInfoScreenEnable = false;

	}

	/*case START_PROCESSING_IMAGE:

		// has error code.
		switch (currentError) {

		case ERROR_MAX_RETRIES:

			parseErrorResult(false);
			break;
		case UNSPORTTED_CPU:
			CameraManagerController.continueNotSupportedHw = true;
			if (CameraManagerController.scanBackOnly) {
				openCameraForBackCapture(false);
			} else {
				openCameraForFrontCapture(false);
			}
		case UNSUPPORTED_CAMERA:
			CameraManagerController.continueNotSupportedHw = true;
			if (CameraManagerController.scanBackOnly) {
				openCameraForBackCapture(false);
			} else {
				openCameraForFrontCapture(false);
			}
			break;
		case UNSPORTTED_AUTO_FOCUS:

			CameraManagerController.continueNotSupportedHw = true;
			if (CameraManagerController.scanBackOnly) {
				openCameraForBackCapture(false);
			} else {
				openCameraForFrontCapture(false);
			}
			break;
		default:
			parseErrorResult(false);
			break;

		}
		break;*/

	/**
	 * Check min hw conditions.
	 *
	 * @return true, if successful
	 */


	class CheckDeviceHW implements Runnable{

		boolean isSucsses = true;

		public CheckDeviceHW(){
		}
		public void run(){
			isSucsses =  checkMinHWConditions();
		}
	}



	private boolean checkMinHWConditions() {

		try {
			if (!FileUtils.isMinimumCPUSpeed()) {

				Logger.e(TAG, "Device CPU not supported, application need minimum 1000 MHZ");
				if (listener != null) {
					currentError = TISFlowErrorMessage.UNSPORTTED_CPU;
					listener.onMobiFlowErrorMessageReceived(currentError, null, !CameraManagerController.isDynamicCapture ? cameraOverlayView.getContext()
							: dynamicCameraOverlayView.getContext());
				}

				return false;
			}

			if (!getPackageManager().hasSystemFeature(PackageManager.FEATURE_CAMERA_AUTOFOCUS)) { // check if camera autoFocus supported
				if (listener != null) {
					currentError = TISFlowErrorMessage.UNSPORTTED_AUTO_FOCUS;
					listener.onMobiFlowErrorMessageReceived(currentError, null, !CameraManagerController.isDynamicCapture ? cameraOverlayView.getContext()
							: dynamicCameraOverlayView.getContext());
				}
				return false;
			}
//			if (!CameraConfigurationManager.isCameraMegaPixelsSupported()) {// check if camera has more than minimum pixels required.
//				if (listener != null) {
//					currentError = TISFlowErrorMessage.UNSUPPORTED_CAMERA;
//					listener.onMobiFlowErrorMessageReceived(currentError, null, !CameraManagerController.isDynamicCapture ? cameraOverlayView.getContext()
//							: dynamicCameraOverlayView.getContext());
//				}
//				return false;
//			}
		} catch (Exception e) {
			Logger.e(TAG, "fail to get camera properties");
			return true;
		}

		return true;
	}

	/**
	 * Do image binarization only.
	 */
	private void doImageBinarizationOnly() {

		String imagePath = CameraManagerController.getOcrAnalyzeSession(getApplicationContext()).captureMode == CaptureMode.FRONT ? CameraManagerController
				.getOcrAnalyzeSession(getApplicationContext()).getOCRAnalyzeResult().getFrontImagePath() : CameraManagerController.getOcrAnalyzeSession(getApplicationContext())
				.getOCRAnalyzeResult().getBackImagePath();
		// ProceedAfterMaxRetries();

		startBinarizationAfterFaliure(imagePath);

	}

	/* (non-Javadoc)
	 * @see com.topimagesystems.intent.MICRIntent.callbackReturnMessage#onMessageReturnFailed()
	 */
	@Override
	public void onMessageReturnFailed() {
		// TODO Auto-generated method stub

	}

	/**
	 * Sets the screen orientation.
	 */
	private void setScreenOrientation() {
		if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == SessionType.PORTRAIT) {
			setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

		} else {

			int rotation = getWindowManager().getDefaultDisplay().getRotation();
			if (rotation == Surface.ROTATION_0) {
				setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
			} else if (rotation == Surface.ROTATION_270) {
				setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE);
			} else if (rotation == Surface.ROTATION_90) {
				setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);

			} else if (rotation == Surface.ROTATION_180) {
				setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE);

			}

		}

	}

	/**
	 * Show error alert.
	 */
	private void showErrorAlert() {
		String message = null;

		OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(getApplicationContext());
		if (ocrAnalyzeSession.ocrErrorCode != null) {
			message = getResources().getString(ocrAnalyzeSession.ocrErrorCode.getResourceId());
			final String errorMessage = ocrAnalyzeSession.ocrErrorMessage;
			if (CameraManagerController.isDebug) {
				if (errorMessage != null) {
					// show also the message from rsip exception
					//message += " | error message: " + errorMessage;
				}

			}
			switch (ocrAnalyzeSession.ocrErrorCode) {
			case errorBlurDetectionFailed:
				message = StringUtils.dynamicString(this, "TISErrorBlurFail");
				if (!CameraManagerController.isStillMode) {
					cameraSessionManager.requestAutoFocus(getHandler(), CameraTypes.MESSAGE_AUTO_FOCUS);
				}
				break;
			case errorIQADarkness:
				message = StringUtils.dynamicString(this, "TISFlowErrorIQADarkness");
				break;
			case errorIQANumSpots:
				message = StringUtils.dynamicString(this, "TISFlowErrorIQANumSpots");
				break;
			case errorIQAEdgeData:
				message = StringUtils.dynamicString(this, "TISFlowErrorIQAEdgeData");
				break;

			case errorIQACornerData:
				message = StringUtils.dynamicString(this, "TISFlowErrorIQACornerData");
				break;
			case errorIQASkew:
				message = StringUtils.dynamicString(this, "TISFlowErrorIQASkew");
				break;

				case errorIQAHorizontalStreak:
					message = StringUtils.dynamicString(this, "TISFlowErrorHorizontalStreaks");
					break;
				case errorIQACarbonStrip:
					message = StringUtils.dynamicString(this, "TISFlowErrorCarbonStrip");
					break;
				case errorIQAPiggyBack:
					message = StringUtils.dynamicString(this, "TISFlowErrorPiggyBack");
					break;
			case errorInializeOCR:
				message = StringUtils.dynamicString(this, "TISFlowErrorReadingOCRMessage");
				break;
			case errorMicrInterrupted:
				message = StringUtils.dynamicString(this, "TISFlowMicrInterrupted");
				break;
			case errorMICRDetectedOnCheckBack:
				message = StringUtils.dynamicString(this, "TISFlowWarningMICRDetectedOnCheckBack");
				break;
			case errorOcrReading:
				message = StringUtils.dynamicString(this, "TISFlowErrorReadingOCRMessage");
				break;
			case errorPanNotFound:
				message = StringUtils.dynamicString(this, "TISFlowErrorReadingOCRMessage");
				break;
			case errorPassportNotFound:
				message = StringUtils.dynamicString(this, "TISFlowErrorReadingOCRMessage");
				break;
			case errorNoValidBoundingBox:
				if (CameraManagerController.imageType == TISDocumentType.CHECK) {
					message = StringUtils.dynamicString(this, "TISFlowErrorNoValidBoundingBox");
				} else {
					message = StringUtils.dynamicString(this, "TISErrorImageGeneral");
				}

				break;

			default:
				break;
			}
		}
		if (message == null) {
			message = "";
			switch (ocrAnalyzeSession.analyzeErrorCode) {
			case FAILED_READING_OCR_GENERAL:
				message = StringUtils.dynamicString(this, "TISFlowErrorReadingOCRMessage");
				break;

			case ERROR_MICR_LENGTH:
				message = StringUtils.dynamicString(this, "TISFlowErrorMicrLength");
				break;
			case FAILED_PREPARING_IMAGE:
				if (CameraManagerController.imageType == TISDocumentType.CHECK) {
					message = StringUtils.dynamicString(this, "TISFlowErrorNoValidBoundingBox");

				} else {
					message = StringUtils.dynamicString(this, "TISErrorImageGeneral");
				}

				break;
			case TISFlowErrorMicrInterrupted:
				message = StringUtils.dynamicString(this, "TISFlowMicrInterrupted");
				break;

			default:
				break;
			}
		}
		Logger.i(TAG, "error message is " + message);
		if (message == null || message == ""){
			message = StringUtils.dynamicString(this, "TISErrorImageGeneral");
		}

		showOCRReadingError(StringUtils.dynamicString(this, "TISFlowErrorReadingImageGeneral"), message, StringUtils.dynamicString(this, "TISFlowOK"),
				StringUtils.dynamicString(this, "TISFlowCancel"));

	}

}