/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import java.util.List;
import org.opencv.android.CameraBridgeViewBase;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.highgui.VideoCapture;

public class NativeCameraView
extends CameraBridgeViewBase {
    public static final String TAG = "NativeCameraView";
    private boolean mStopThread;
    private Thread mThread;
    protected VideoCapture mCamera;
    protected NativeCameraFrame mFrame;

    public NativeCameraView(Context context, int cameraId) {
        super(context, cameraId);
    }

    public NativeCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected boolean connectCamera(int width, int height) {
        if (!this.initializeCamera(width, height)) {
            return false;
        }
        this.mThread = new Thread(new CameraWorker());
        this.mThread.start();
        return true;
    }

    @Override
    protected void disconnectCamera() {
        block6: {
            if (this.mThread != null) {
                try {
                    try {
                        this.mStopThread = true;
                        this.mThread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        this.mThread = null;
                        this.mStopThread = false;
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.mThread = null;
                    this.mStopThread = false;
                    throw throwable;
                }
                this.mThread = null;
                this.mStopThread = false;
            }
        }
        this.releaseCamera();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeCamera(int width, int height) {
        NativeCameraView nativeCameraView = this;
        synchronized (nativeCameraView) {
            block7: {
                block6: {
                    this.mCamera = this.mCameraIndex == -1 ? new VideoCapture(1000) : new VideoCapture(1000 + this.mCameraIndex);
                    if (this.mCamera != null) break block6;
                    return false;
                }
                if (this.mCamera.isOpened()) break block7;
                return false;
            }
            this.mFrame = new NativeCameraFrame(this.mCamera);
            List<Size> sizes = this.mCamera.getSupportedPreviewSizes();
            Size frameSize = this.calculateCameraFrameSize(sizes, new OpenCvSizeAccessor(), width, height);
            this.mFrameWidth = (int)frameSize.width;
            this.mFrameHeight = (int)frameSize.height;
            this.mScale = this.getLayoutParams().width == -1 && this.getLayoutParams().height == -1 ? Math.min((float)height / (float)this.mFrameHeight, (float)width / (float)this.mFrameWidth) : 0.0f;
            if (this.mFpsMeter != null) {
                this.mFpsMeter.setResolution(this.mFrameWidth, this.mFrameHeight);
            }
            this.AllocateCache();
            this.mCamera.set(3, frameSize.width);
            this.mCamera.set(4, frameSize.height);
        }
        Log.i((String)TAG, (String)("Selected camera frame size = (" + this.mFrameWidth + ", " + this.mFrameHeight + ")"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCamera() {
        NativeCameraView nativeCameraView = this;
        synchronized (nativeCameraView) {
            if (this.mFrame != null) {
                this.mFrame.release();
            }
            if (this.mCamera != null) {
                this.mCamera.release();
            }
        }
    }

    private class CameraWorker
    implements Runnable {
        private CameraWorker() {
        }

        @Override
        public void run() {
            do {
                if (!NativeCameraView.this.mCamera.grab()) {
                    Log.e((String)NativeCameraView.TAG, (String)"Camera frame grab failed");
                    break;
                }
                NativeCameraView.this.deliverAndDrawFrame(NativeCameraView.this.mFrame);
            } while (!NativeCameraView.this.mStopThread);
        }
    }

    private static class NativeCameraFrame
    implements CameraBridgeViewBase.CvCameraViewFrame {
        private VideoCapture mCapture;
        private Mat mRgba;
        private Mat mGray;

        @Override
        public Mat rgba() {
            this.mCapture.retrieve(this.mRgba, 4);
            return this.mRgba;
        }

        @Override
        public Mat gray() {
            this.mCapture.retrieve(this.mGray, 1);
            return this.mGray;
        }

        public NativeCameraFrame(VideoCapture capture) {
            this.mCapture = capture;
            this.mGray = new Mat();
            this.mRgba = new Mat();
        }

        public void release() {
            if (this.mGray != null) {
                this.mGray.release();
            }
            if (this.mRgba != null) {
                this.mRgba.release();
            }
        }
    }

    public static class OpenCvSizeAccessor
    implements CameraBridgeViewBase.ListItemAccessor {
        @Override
        public int getWidth(Object obj) {
            Size size = (Size)obj;
            return (int)size.width;
        }

        @Override
        public int getHeight(Object obj) {
            Size size = (Size)obj;
            return (int)size.height;
        }
    }
}

