/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.util;

import android.text.TextUtils;
import android.util.Log;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;

public class OcrValidationUtils {
    public static String TAG = "OcrValidationUtils";
    public static HashMap<String, String> countriesCode = new HashMap();
    private static Pattern lineSplit = Pattern.compile("[\r\n]+");
    private static Pattern alphabeitInvertedSet = Pattern.compile("[A-Z|(<)]+");
    private static Pattern numericInvertedSet = Pattern.compile("[\\d]+");
    private static Pattern sexInvertedSet = Pattern.compile("[FM]+");
    private static final String kTISCard_Type = "kTISCard_Type";
    private static final String kTISCard_IssuingCountry = "kTISCard_IssuingCountry";
    private static final String kTISCard_DocumentNumber = "kTISCard_DocumentNumber";
    private static final String kTISCard_DateOfBirth = "kTISCard_DateOfBirth";
    private static final String kTISCard_OptionalMiddle = "kTISCard_OptionalMiddle";
    private static final String kTISCard_Sex = "kTISCard_Sex";
    private static final String kTISCard_ExpirationDate = "kTISCard_ExpirationDate";
    private static final String kTISCard_Nationality = "kTISCard_Nationality";
    private static final String kTISCard_SureName = "kTISCard_SureName";
    private static final String kTISCard_FirstName = "kTISCard_FirstName";

    public static boolean validatePassport(String ocrResultWithDelimiter, int size) {
        String validUpperLineChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ<";
        if (countriesCode == null || countriesCode.size() < 10) {
            OcrValidationUtils.initCouriesCode();
        }
        if (size != 88) {
            return false;
        }
        String[] mrzLines = ocrResultWithDelimiter.split("\n");
        String upperLine = mrzLines[0];
        String lowerLine = mrzLines[1];
        if (upperLine.length() != 44 || lowerLine.length() != 44) {
            return false;
        }
        for (int i = 0; i < upperLine.length(); ++i) {
            if (validUpperLineChars.contains(String.valueOf(upperLine.charAt(i)))) continue;
            return false;
        }
        if (!String.valueOf(upperLine.charAt(0)).toLowerCase(Locale.US).equals("p")) {
            return false;
        }
        String countryCode = upperLine.substring(2, 5);
        if (countriesCode.get(countryCode) == null) {
            return false;
        }
        String nationality = lowerLine.substring(10, 13);
        if (countriesCode.get(nationality) == null) {
            return false;
        }
        String sex = lowerLine.substring(20, 21);
        if (!sex.equals("M") && !sex.equals("F")) {
            return false;
        }
        String passportNumber = lowerLine.substring(0, 9);
        String DOB = lowerLine.substring(13, 19);
        String EXD = lowerLine.substring(21, 27);
        String personalNumber = lowerLine.substring(28, 42);
        String checkDigit = lowerLine.substring(9, 10);
        boolean validatePassportNumber = OcrValidationUtils.validateCheckDigitFromString(passportNumber, checkDigit);
        checkDigit = lowerLine.substring(19, 20);
        boolean validateDOB = OcrValidationUtils.validateCheckDigitFromString(DOB, checkDigit);
        checkDigit = lowerLine.substring(27, 28);
        boolean validateEXD = OcrValidationUtils.validateCheckDigitFromString(EXD, checkDigit);
        checkDigit = lowerLine.substring(42, 43);
        boolean validatePersonalNumber = OcrValidationUtils.validateCheckDigitFromString(passportNumber, checkDigit);
        return validatePassportNumber && validateDOB && validateEXD && validatePersonalNumber;
    }

    public static boolean validateIDCard(OCRResult mrzResult) {
        String docNum;
        if (countriesCode == null || countriesCode.size() < 10) {
            OcrValidationUtils.initCouriesCode();
        }
        if (mrzResult.digitalRowLength != 90) {
            return false;
        }
        String[] mrzLines = lineSplit.split(mrzResult.ocrResultWithDelimiter);
        String upperLine = mrzLines[0];
        String middleLine = mrzLines[1];
        String lowerLine = mrzLines[2];
        boolean belIdIsForegin = false;
        if (upperLine.length() != 30 && middleLine.length() != 30 && lowerLine.length() != 30) {
            return false;
        }
        String docTypeAndIssueCountry = upperLine.substring(0, 5);
        if (!alphabeitInvertedSet.matcher(docTypeAndIssueCountry).matches()) {
            return false;
        }
        String idIssuingtCountry = docTypeAndIssueCountry.substring(2, 5);
        if (!countriesCode.containsKey(idIssuingtCountry)) {
            return false;
        }
        String docNumAndCheckDigit = upperLine.substring(5, 19);
        String dob = middleLine.substring(0, 6);
        String checkDigitDob = middleLine.substring(6, 7);
        String expiryDate = middleLine.substring(8, 14);
        String checkDigitExpiryDate = middleLine.substring(14, 15);
        String checkDigitMiddleLine = middleLine.substring(29);
        if (!(numericInvertedSet.matcher(dob).matches() && numericInvertedSet.matcher(checkDigitDob).matches() && numericInvertedSet.matcher(expiryDate).matches() && numericInvertedSet.matcher(checkDigitExpiryDate).matches() && numericInvertedSet.matcher(checkDigitMiddleLine).matches())) {
            return false;
        }
        String sex = middleLine.substring(7, 8);
        String nationality = middleLine.substring(15, 18);
        if (!sexInvertedSet.matcher(sex).matches()) {
            return false;
        }
        if (!alphabeitInvertedSet.matcher(lowerLine).matches()) {
            return false;
        }
        String docType = docTypeAndIssueCountry.substring(0, 1);
        if (!docType.equals("I")) {
            return false;
        }
        if (!countriesCode.containsKey(nationality)) {
            return false;
        }
        String checkDigitDocNum = null;
        if (idIssuingtCountry.equals("BEL")) {
            String belDocNum = upperLine.substring(5);
            String cleanDocNum = belDocNum.replaceAll("<", "");
            docNum = cleanDocNum.substring(0, cleanDocNum.length() - 1);
        } else {
            docNum = docNumAndCheckDigit.substring(0, 9);
            checkDigitDocNum = docNumAndCheckDigit.substring(9);
        }
        boolean validateDocumentNumber = true;
        boolean validateDOB = OcrValidationUtils.validateCheckDigitFromString(dob, checkDigitDob);
        boolean validateEXD = OcrValidationUtils.validateCheckDigitFromString(expiryDate, checkDigitExpiryDate);
        if (!(validateDocumentNumber && validateDOB && validateEXD)) {
            return false;
        }
        String optionalUpperLine = upperLine.substring(15, 30);
        String optionalMiddleLine = middleLine.substring(18, 29);
        String checkSumString = String.format("%s%s%s%s%s%s%s%s", docNum, checkDigitDocNum, optionalUpperLine, dob, checkDigitDob, expiryDate, checkDigitExpiryDate, optionalMiddleLine);
        String checkDigitFinal = middleLine.substring(29);
        boolean validateLastDigit = OcrValidationUtils.validateCheckDigitFromString(checkSumString, checkDigitFinal);
        return true;
    }

    public static HashMap<String, String> parseIDCardResult(String idCardResult) {
        String docNum;
        String fullCardIssuingtCountry;
        if (idCardResult == null || idCardResult.length() == 0) {
            return null;
        }
        String[] ocrResultWithDelimiterArr = lineSplit.split(idCardResult);
        HashMap<String, String> result = new HashMap<String, String>();
        if (countriesCode == null || countriesCode.size() < 10) {
            OcrValidationUtils.initCouriesCode();
        }
        String upperLine = ocrResultWithDelimiterArr[0];
        String middleLine = ocrResultWithDelimiterArr[1];
        String lowerLine = ocrResultWithDelimiterArr[2];
        String docTypeAndIssueCountry = upperLine.substring(0, 5);
        String docNumAndCheckDigit = upperLine.substring(5, 15);
        String dob = middleLine.substring(0, 6);
        String expiryDate = middleLine.substring(8, 14);
        String sex = middleLine.substring(7, 8);
        String nationality = middleLine.substring(15, 18);
        String docType = docTypeAndIssueCountry.substring(0, 2);
        String idIssuingtCountry = docTypeAndIssueCountry.substring(2, 5);
        String optionalUpperLine = upperLine.substring(15, 30);
        String optinalMiddleLine = middleLine.substring(18, 29);
        boolean belIdIsForegin = false;
        if (!docType.equals("") && docType.equals("<")) {
            result.put(kTISCard_Type, docType);
        }
        result.put(kTISCard_IssuingCountry, (fullCardIssuingtCountry = countriesCode.get(idIssuingtCountry)) != null ? fullCardIssuingtCountry : idIssuingtCountry);
        if (idIssuingtCountry.equals("BEL")) {
            String belDocNum = upperLine.substring(5);
            String cleanDocNum = belDocNum.replaceAll("<", "");
            docNum = cleanDocNum.substring(0, cleanDocNum.length() - 1);
        } else {
            docNum = docNumAndCheckDigit.substring(0, 9);
        }
        String[] arrFullName = lowerLine.split("<<");
        String sureName = arrFullName[0];
        String firstAndMiddleName = arrFullName[1];
        result.put(kTISCard_SureName, sureName.replaceAll("<", " "));
        result.put(kTISCard_FirstName, sureName.replaceAll("<", " "));
        String fullNationality = countriesCode.get(nationality);
        result.put(kTISCard_Nationality, fullNationality != null ? fullNationality : nationality);
        String option = optinalMiddleLine.replaceAll("<", " ");
        if (option.length() > 0) {
            result.put(kTISCard_OptionalMiddle, option);
        }
        result.put(kTISCard_Sex, sex);
        result.put(kTISCard_DocumentNumber, docNum.replaceAll("<", ""));
        SimpleDateFormat rawDate = new SimpleDateFormat("yymmdd");
        SimpleDateFormat parsedDate = new SimpleDateFormat("dd/mm/yy");
        Date dobDate = null;
        Date exdDate = null;
        try {
            dobDate = rawDate.parse(dob);
            exdDate = rawDate.parse(expiryDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        result.put(kTISCard_DateOfBirth, dobDate == null ? "" : parsedDate.format(dobDate));
        result.put(kTISCard_ExpirationDate, dobDate == null ? "" : parsedDate.format(exdDate));
        return result;
    }

    public static boolean correctMRZIDResults(OCRResult mrzResult) {
        String rawResFormated;
        if (mrzResult.digitalRowLength != 90) {
            return false;
        }
        String[] ocrResultWithDelimiterArr = lineSplit.split(mrzResult.ocrResultWithDelimiter);
        String upperLine = ocrResultWithDelimiterArr[0];
        String middleLine = ocrResultWithDelimiterArr[1];
        String lowerLine = ocrResultWithDelimiterArr[2];
        if (upperLine.length() != 30 || lowerLine.length() != 30 || middleLine.length() != 30) {
            return false;
        }
        String upperLineCorrected = String.valueOf(upperLine);
        String middleLineCorrected = String.valueOf(middleLine);
        String country = upperLineCorrected.substring(2, 5);
        String nationality = middleLineCorrected.substring(15, 18);
        if (country.equals("SEL") || country.equals("HEL")) {
            upperLineCorrected = upperLineCorrected.substring(0, 2) + "BEL" + upperLineCorrected.substring(5);
        }
        if (nationality.equals("SEL") || nationality.equals("HEL")) {
            middleLineCorrected = middleLineCorrected.substring(0, 15) + "BEL" + middleLineCorrected.substring(18);
        }
        mrzResult.ocrResultWithDelimiter = String.format("%s\n%s\n%s", upperLineCorrected, middleLineCorrected, lowerLine);
        mrzResult.ocrRawResult = rawResFormated = String.format("%s\n%s\n%s", upperLineCorrected, middleLineCorrected, lowerLine);
        return true;
    }

    private static boolean validateCheckDigitFromString(String passportNumber, String checkDigit) {
        try {
            int[] numMul = new int[]{7, 3, 1};
            int length = passportNumber.length();
            int sumMod = 0;
            char[] buffer = new char[length];
            for (int i = 0; i < length; ++i) {
                buffer[i] = new Character(passportNumber.charAt(i)).charValue();
            }
            int weightLocation = 0;
            int sumA = 0;
            int weight = 0;
            for (int n = 0; n < length; ++n) {
                char curChar = buffer[n];
                weight = 0;
                if (curChar == '<') {
                    weight = 0;
                }
                if (Character.isDigit(curChar)) {
                    weight = curChar;
                }
                if (Character.isLetter(curChar)) {
                    weight = curChar - 65 + 10;
                }
                sumA += weight * numMul[weightLocation];
                if (++weightLocation == 3) {
                    weightLocation = 0;
                }
                sumMod = sumA % 10;
            }
            if (checkDigit.equals(String.valueOf(sumMod))) {
                return true;
            }
            if (sumMod == 0 && checkDigit.equals("<")) {
                return true;
            }
            return true;
        }
        catch (Exception e) {
            Logger.i(TAG, Log.getStackTraceString((Throwable)e));
            return false;
        }
    }

    public static boolean validationPanCard(String panCardResult) {
        if (panCardResult == null) {
            return false;
        }
        String[] panCardResultArr = panCardResult.split("\n");
        if (panCardResultArr.length < 2) {
            return false;
        }
        String panNumber = panCardResultArr[panCardResultArr.length - 1];
        if (panNumber.length() < 2) {
            return false;
        }
        String panDate = panCardResultArr[panCardResultArr.length - 2];
        return panDate.length() == 10;
    }

    public static HashMap<String, String> parsePassportResult(String passportResult) {
        if (passportResult == null) {
            return null;
        }
        if (countriesCode == null || countriesCode.size() < 10) {
            OcrValidationUtils.initCouriesCode();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String[] resultByLines = passportResult.split("\n");
            String upperLine = resultByLines[0];
            String lowerLine = resultByLines[1];
            String passportType = upperLine.substring(0, 1);
            if (passportType.equals("") || passportType.equals("<")) {
                result.put("kTISPassport_Type", passportType);
            }
            String passportIssuingCountry = upperLine.substring(2, 5);
            String countryPassFullName = countriesCode.get(passportIssuingCountry);
            result.put("kTISPassport_IssuingCountry", countryPassFullName);
            String passportFullName = upperLine.substring(5, upperLine.length());
            String[] arr = upperLine.split("<<");
            int firstNamelocation = passportFullName.indexOf("<<");
            String sureName = passportFullName.substring(0, firstNamelocation);
            String firstAndMiddleName = arr[1];
            result.put("kTISPassport_SureName", sureName.replace("<", ""));
            result.put("kTISPassport_FirstName", firstAndMiddleName.replace("<", ""));
            String nationality = lowerLine.substring(10, 13);
            String fullNationality = countriesCode.get(nationality);
            result.put("kTISPassport_Nationality", fullNationality);
            String sex = lowerLine.substring(20, 21);
            result.put("kTISPassport_sex", sex);
            String passportNumber = lowerLine.substring(0, 9);
            result.put("kTISPassport_passportNumber", passportNumber.replace("<", ""));
            SimpleDateFormat fmt = new SimpleDateFormat("yymmdd");
            String DOB = lowerLine.substring(13, 19);
            String EXD = lowerLine.substring(21, 27);
            Date dobDate = fmt.parse(DOB);
            Date exdDate = fmt.parse(EXD);
            fmt = new SimpleDateFormat("dd/mm/yy");
            result.put("kTISPassport_DateOfBirth", fmt.format(dobDate));
            result.put("kTISPassport_ExpirationDate", fmt.format(exdDate));
            String personalNumber = lowerLine.substring(28, 42);
            result.put("kTISPassport_personalNumber", personalNumber.replace("<", ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String[] parsePanCardResult(String ocrResult) {
        if (ocrResult == null) {
            return null;
        }
        return ocrResult.split("\n");
    }

    private static void initCouriesCode() {
        countriesCode.put("AFG", "Afghanistan");
        countriesCode.put("ALB", "Albania");
        countriesCode.put("DZA", "Algeria");
        countriesCode.put("ASM", "American Samoa");
        countriesCode.put("AND", "Andorra");
        countriesCode.put("AGO", "Angola");
        countriesCode.put("AIA", "Anguilla");
        countriesCode.put("ATG", "Antigua and Barbuda");
        countriesCode.put("ARG", "Argentina");
        countriesCode.put("ARM", "Armenia");
        countriesCode.put("ABW", "Aruba");
        countriesCode.put("AUS", "Australia");
        countriesCode.put("AUT", "Austria");
        countriesCode.put("AZE", "Azerbaijan");
        countriesCode.put("BHS", "Bahamas");
        countriesCode.put("BHR", "Bahrain");
        countriesCode.put("BGD", "Bangladesh");
        countriesCode.put("BRB", "Barbados");
        countriesCode.put("BLR", "Belarus");
        countriesCode.put("BEL", "Belgium");
        countriesCode.put("BLZ", "Belize");
        countriesCode.put("BEN", "Benin");
        countriesCode.put("BLZ", "Belize");
        countriesCode.put("BMU", "Bermuda");
        countriesCode.put("BTN", "Bhutan");
        countriesCode.put("BOL", "Bolivia");
        countriesCode.put("BIH", "Bosnia and Herzegovina");
        countriesCode.put("BWA", "Botswana");
        countriesCode.put("BVT", "Bouvet Island");
        countriesCode.put("BRA", "Brazil");
        countriesCode.put("IOT", "British Indian Ocean Territory");
        countriesCode.put("BRN", "Brunei Darussalam");
        countriesCode.put("BGR", "Bulgaria");
        countriesCode.put("BFA", "Burkina Faso");
        countriesCode.put("BDI", "Burundi");
        countriesCode.put("KHM", "Cambodia");
        countriesCode.put("CMR", "Cameroon");
        countriesCode.put("CAN", "Canada");
        countriesCode.put("CPV", "Cape Verde");
        countriesCode.put("CYM", "Cayman Islands");
        countriesCode.put("CAF", "Central African Republic");
        countriesCode.put("TCD", "Chad");
        countriesCode.put("CHL", "Chile");
        countriesCode.put("CHN", "China");
        countriesCode.put("CXR", "Christmas Island");
        countriesCode.put("CCK", "Cocos (Keeling) Islands");
        countriesCode.put("CRI", "Costa Rica");
        countriesCode.put("CIV", "C\u00f4te d'Ivoire");
        countriesCode.put("CUB", "Cuba");
        countriesCode.put("CYP", "Cyprus");
        countriesCode.put("CZE", "Czech Republic");
        countriesCode.put("PRK", "Democratic People's Republic of Korea");
        countriesCode.put("COD", "Democratic Republic of the Congo");
        countriesCode.put("DNK", "Denmark");
        countriesCode.put("DJI", "Djibouti");
        countriesCode.put("DMA", "Dominica");
        countriesCode.put("DOM", "Dominican Republic");
        countriesCode.put("TMP", "East Timor");
        countriesCode.put("ECU", "Ecuador");
        countriesCode.put("EGY", "Egypt");
        countriesCode.put("SLV", "El Salvador");
        countriesCode.put("GNQ", "Equatorial Guinea");
        countriesCode.put("ERI", "Eritrea");
        countriesCode.put("EST", "Estonia");
        countriesCode.put("ETH", "Ethiopia");
        countriesCode.put("FLK", "Falkland Islands (Malvinas)");
        countriesCode.put("FRO", "Faeroe Islands");
        countriesCode.put("FJI", "Fiji");
        countriesCode.put("FIN", "Finland");
        countriesCode.put("FRA", "France");
        countriesCode.put("FXX", "France, Metropolitan");
        countriesCode.put("GUF", "French Guiana");
        countriesCode.put("PYF", "French Polynesia");
        countriesCode.put("GAB", "Gabon");
        countriesCode.put("GMB", "Gambia");
        countriesCode.put("GEO", "Georgia");
        countriesCode.put("D<<", "Germany");
        countriesCode.put("GIB", "Gibraltar");
        countriesCode.put("GRC", "Greece");
        countriesCode.put("GRL", "Greenland");
        countriesCode.put("GRD", "Grenada");
        countriesCode.put("GLP", "Guadeloupe");
        countriesCode.put("GUM", "Guam");
        countriesCode.put("GTM", "Guatemala");
        countriesCode.put("GIN", "Guinea");
        countriesCode.put("GUY", "Guyana");
        countriesCode.put("HTI", "Haiti");
        countriesCode.put("HMD", "Heard and McDonald Islands");
        countriesCode.put("VAT", "Holy See (Vatican City State)");
        countriesCode.put("HND", "Honduras");
        countriesCode.put("HKG", "Hong Kong");
        countriesCode.put("HUN", "Hungary");
        countriesCode.put("ISL", "Iceland");
        countriesCode.put("IND", "Guatemala");
        countriesCode.put("IND", "India");
        countriesCode.put("IDN", "Indonesia");
        countriesCode.put("IRN", "Iran, Islamic Republic of");
        countriesCode.put("IRQ", "Iraq");
        countriesCode.put("IRL", "Ireland");
        countriesCode.put("ISR", "Israel");
        countriesCode.put("ITA", "Italy");
        countriesCode.put("JAM", "Jamaica");
        countriesCode.put("JPN", "Japan");
        countriesCode.put("JOR", "Jordan");
        countriesCode.put("KAZ", "Kazakhstan");
        countriesCode.put("KEN", "Kenya");
        countriesCode.put("KWT", "Kuwait");
        countriesCode.put("KGZ", "Kyrgyzstan");
        countriesCode.put("LAO", "Lao People's Democratic Republic");
        countriesCode.put("LVA", "Latvia");
        countriesCode.put("LBN", "Lebanon");
        countriesCode.put("LSO", "Lesotho");
        countriesCode.put("LBY", "Libyan Arab Jamahiriya");
        countriesCode.put("LBR", "Liberia");
        countriesCode.put("LBY", "Libyan Arab Jamahiriya");
        countriesCode.put("LIE", "Liechtenstein");
        countriesCode.put("LTU", "Lithuania");
        countriesCode.put("LUX", "Kazakhstan");
        countriesCode.put("LUX", "Luxembourg");
        countriesCode.put("MDG", "Madagascar");
        countriesCode.put("MWI", "Malawi");
        countriesCode.put("MYS", "Malaysia");
        countriesCode.put("MDV", "Maldives");
        countriesCode.put("MLI", "Mali");
        countriesCode.put("MLT", "Malta");
        countriesCode.put("MHL", "Marshall Islands");
        countriesCode.put("MTQ", "Martinique");
        countriesCode.put("MRT", "Mauritania");
        countriesCode.put("MUS", "Mauritius");
        countriesCode.put("MYT", "Mayotte");
        countriesCode.put("MEX", "Mexico");
        countriesCode.put("FSM", "Micronesia, Federated States of");
        countriesCode.put("MCO", "Monaco");
        countriesCode.put("MNG", "Mongolia");
        countriesCode.put("MSR", "Montserrat");
        countriesCode.put("MAR", "Morocco");
        countriesCode.put("MOZ", "Mozambique");
        countriesCode.put("MMR", "Myanmar");
        countriesCode.put("NAM", "Namibia");
        countriesCode.put("NRU", "Nauru");
        countriesCode.put("NPL", "Nepal");
        countriesCode.put("NLD", "Netherlands, Kingdom of the");
        countriesCode.put("ANT", "Netherlands Antilles");
        countriesCode.put("NTZ", "Neutral Zone");
        countriesCode.put("NCL", "New Caledonia");
        countriesCode.put("NZL", "New Zealand");
        countriesCode.put("NIC", "Nicaragua");
        countriesCode.put("NER", "Niger");
        countriesCode.put("NGA", "Nigeria");
        countriesCode.put("NIU", "Nauru");
        countriesCode.put("NRU", "Niue");
        countriesCode.put("NFK", "Norfolk Island");
        countriesCode.put("MNP", "Northern Mariana Islands");
        countriesCode.put("NOR", "Norway");
        countriesCode.put("OMN", "Oman");
        countriesCode.put("NOR", "Norway");
        countriesCode.put("PAK", "Pakistan");
        countriesCode.put("PAN", "Papua New Guinea");
        countriesCode.put("PNG", "Norway");
        countriesCode.put("PRY", "Paraguay");
        countriesCode.put("NOR", "Norway");
        countriesCode.put("PER", "Peru");
        countriesCode.put("PHL", "Philippines");
        countriesCode.put("PCN", "Pitcairn");
        countriesCode.put("POL", "Poland");
        countriesCode.put("PRT", "Portugal");
        countriesCode.put("PRI", "Puerto Rico");
        countriesCode.put("QAT", "Qatar");
        countriesCode.put("KOR", "Republic of Korea");
        countriesCode.put("MDA", "Republic of Moldova");
        countriesCode.put("REU", "R\u00e9union");
        countriesCode.put("ROM", "Romania");
        countriesCode.put("RUS", "Russian Federation");
        countriesCode.put("RWA", "Rwanda");
        countriesCode.put("SHN", "Saint Helena");
        countriesCode.put("KNA", "Saint Kitts and Nevis");
        countriesCode.put("LCA", "Saint Lucia");
        countriesCode.put("SPM", "Saint Pierre and Miquelon");
        countriesCode.put("VCT", "Saint Vincent and the Grenadines");
        countriesCode.put("WSM", "Samoa");
        countriesCode.put("SMR", "San Marino");
        countriesCode.put("STP", "Sao Tome and Principe");
        countriesCode.put("SAU", "Saudi Arabia");
        countriesCode.put("SEN", "Portugal");
        countriesCode.put("SEN", "Senegal");
        countriesCode.put("SYC", "Seychelles");
        countriesCode.put("SLE", "Sierra Leone");
        countriesCode.put("SGP", "Singapore");
        countriesCode.put("SVK", "Slovakia");
        countriesCode.put("SVN", "Slovenia");
        countriesCode.put("SLB", "Solomon Islands");
        countriesCode.put("SOM", "Somalia");
        countriesCode.put("ZAF", "South Africa");
        countriesCode.put("SGS", "South Georgia and the South Sandwich Island");
        countriesCode.put("ESP", "Spain");
        countriesCode.put("LKA", "Sri Lanka");
        countriesCode.put("SDN", "Sudan");
        countriesCode.put("SUR", "Suriname");
        countriesCode.put("SJM", "Svalbard and Jan Mayen Islands");
        countriesCode.put("SWZ", "Swaziland");
        countriesCode.put("CHE", "Switzerland");
        countriesCode.put("SYR", "Syrian Arab Republic");
        countriesCode.put("TWN", "Taiwan Province of China");
        countriesCode.put("TJK", "Tajikistan");
        countriesCode.put("THA", "Thailand");
        countriesCode.put("MKD", "The former Yugoslav Republic of Macedonia");
        countriesCode.put("TGO", "Togo");
        countriesCode.put("TKL", "Tokelau");
        countriesCode.put("TON", "Tonga");
        countriesCode.put("TTO", "Trinidad and Tobago");
        countriesCode.put("TUN", "Tunisia");
        countriesCode.put("TUR", "Turkey");
        countriesCode.put("TKM", "Turkmenistan");
        countriesCode.put("TCA", "Turks and Caicos Islands");
        countriesCode.put("TUV", "Tuvalu");
        countriesCode.put("UGA", "Uganda");
        countriesCode.put("UKR", "Ukraine");
        countriesCode.put("ARE", "United Arab Emirate");
        countriesCode.put("GBR", "- Citizen");
        countriesCode.put("GBD", "Dependent territories citizen");
        countriesCode.put("GBN", "National (overseas)");
        countriesCode.put("GBO", "Overseas citizen");
        countriesCode.put("GBP", "Protected Person");
        countriesCode.put("TZA", "United Republic of Tanzania");
        countriesCode.put("USA", "United States of America");
        countriesCode.put("UMI", "United States of America Minor Outlying Islands");
        countriesCode.put("URY", "Uruguay");
        countriesCode.put("UZB", "Uzbekistan");
        countriesCode.put("VUT", "Vanuatu");
        countriesCode.put("VEN", "Venezuela");
        countriesCode.put("VNM", "Viet Nam");
        countriesCode.put("VGB", "Virgin Islands (Great Britian)");
        countriesCode.put("VIR", "Virgin Islands (United States)");
        countriesCode.put("WLF", "Wallis and Futuna Islands");
        countriesCode.put("ESH", "Western Sahara");
        countriesCode.put("YEM", "Yemen");
        countriesCode.put("ZAR", "Zaire");
        countriesCode.put("ZMB", "Zambia");
        countriesCode.put("ZWE", "Zimbabwe");
        countriesCode.put("UNO", "United Nations Organization");
        countriesCode.put("UNA", "United Nations");
        countriesCode.put("XXA", "Stateless (per\u00a0Article 1 of 1954 convention)");
        countriesCode.put("XXB", "Refugee");
        countriesCode.put("XXC", "Refugee (non-convention)");
        countriesCode.put("XXX", "Unspecified / Unknown");
    }

    public static class DLBarcodeParser {
        private static final String FIRST_NAME = "First Name";
        private static final String MIDDLE_NAME = "Middle Name";
        private static final String LAST_NAME = "Last Name";
        private static final String NAME_SUFFIX = "Name Suffix";
        private static final String ADDRESS = "Address";
        private static final String CITY = "City";
        private static final String STATE = "State";
        private static final String POSTAL_CODE = "Postal Code";
        private static final String ID_NUMBER = "ID Number";
        private static final String CLASS = "Class";
        private static final String HEIGHT = "Height";
        private static final String WEIGHT = "Weight";
        private static final String EYE_COLOR = "Eye Color";
        private static final String HAIR_COLOR = "Hair Color";
        private static final String EXPIRATION_DATE = "Expiration Date";
        private static final String DATE_OF_BIRTH = "Date Of Birth";
        private static final String SEX = "Sex";
        private static final String ISSUE_DATE = "Issue Date";
        private static final String RESTRICTION_CODE = "Restriction Code";
        private static final String ENDORSEMENT_CODE = "Endorsement Code";
        private static final String LIMITED_DURATION_DOCUMENT_INDICATOR = "Limited Duration Document Indicator";
        private static final String DOCUMENT_NUMBER = "Document Number";
        private static final String COUNTRY = "Country";
        private static final String COUNTRY_ID = "Country ID";
        private static final String INVENTORY_CONTROL_NUMBER = "Inventor Control Number";
        private static final String CARD_REVISION_DATE = "Card Revision Date";
        private static final String TEMP_VISITOR = "Temp Visitor";
        private static final String ADDRESS_ADDITIONAL = "Address Additional info";
        private static final String DUPLICATES = "Duplicates";
        private static final String ORGAN_DONOR = "Organ Donor";
        private static final String AUDIT_INFORMATION = "Audit Information";
        private static final String ETHNICITY = "Ethnicity";
        private static final String COMPLIANCE_TYPE = "Compliance Type";
        private static final String FIRST_NAME_TRUNCATION = "First Name Truncation";
        private static final String MIDDLE_NAME_TRUNCATION = "Middle Name Truncation";
        private static final String LAST_NAME_TRUNCATION = "Last Name Truncation";
        private static final String FEDERAL_COMMERCIAL_VEHICLE_CODES = "Federal Commercial Vehicle Codes";
        private static final String CUSTOMER_SPECIFIC_CONTROL_NUMBER = "Customer Specific Control Number";
        private static final String WA_SPECIFIC_ENDORSEMENT = "WA Specific Endorsements";
        private static final String TRANSACTION_TYPES = "Transaction Types";
        private static final String UNDER_18_UNTIL = "Under 18 Until";
        private static final String UNDER_21_UNTIL = "Under 21 Until";
        private static final String REVISION_DATE = "Revision Date";
        private static final String SOCIAL_SECURITY_NUMBER = "Social Security Number";
        private static HashMap<String, String> parsedDictionary;
        private static HashMap<String, String> keysDictionary;
        private static HashMap<String, HashMap> stateDictionaries;
        private static Pattern dlSplit;
        private static Pattern lineSplit;
        private static Pattern whiteSpaceTrim;
        private static Pattern commaTrim;

        public static HashMap<String, String> parseDLBarcode(String barcodeString) {
            int firstLineIndex;
            if (barcodeString == null || barcodeString.length() == 0) {
                return null;
            }
            if (keysDictionary == null) {
                keysDictionary = DLBarcodeParser.getKeysDictionary();
            }
            if (stateDictionaries == null) {
                stateDictionaries = DLBarcodeParser.getStateDictionaries();
            }
            String[] lines = lineSplit.split(barcodeString);
            String firstLine = "";
            String[] firstLineParsed = null;
            for (firstLineIndex = 0; firstLineIndex < lines.length && (firstLine = whiteSpaceTrim.matcher(lines[firstLineIndex]).replaceAll("")).length() <= 3; ++firstLineIndex) {
            }
            String[] valueList = null;
            if (firstLine.toUpperCase().contains("ANSI") || firstLine.toUpperCase().contains("AAMVA")) {
                firstLineParsed = dlSplit.split(firstLine);
                valueList = new String[firstLineParsed.length + lines.length - firstLineIndex - 1];
                System.arraycopy(firstLineParsed, 0, valueList, 0, firstLineParsed.length);
                if (firstLineIndex < lines.length - 1) {
                    System.arraycopy(lines, firstLineIndex + 1, valueList, firstLineParsed.length, lines.length - firstLineIndex - 1);
                }
            } else {
                valueList = lines;
            }
            parsedDictionary = new HashMap();
            String state = DLBarcodeParser.getState(valueList);
            DLBarcodeParser.identifyAndParse(valueList, state);
            return parsedDictionary;
        }

        private static String getState(String[] valueList) {
            for (int i = 0; i < valueList.length; ++i) {
                String line = commaTrim.matcher(valueList[i]).replaceAll("");
                if (line.length() <= 3) continue;
                String key = line.substring(0, 3);
                String value = commaTrim.matcher(line.substring(3).trim()).replaceAll("");
                if (!key.equals("DAJ")) continue;
                return value;
            }
            return null;
        }

        private static void identifyAndParse(String[] valueList, String state) {
            HashMap specificStateDictionary = stateDictionaries.get(state);
            for (int i = 0; i < valueList.length; ++i) {
                String resultKey;
                String line = commaTrim.matcher(valueList[i].trim()).replaceAll("");
                if ((line = whiteSpaceTrim.matcher(line).replaceAll("")).length() <= 3) continue;
                String key = line.substring(0, 3);
                String value = commaTrim.matcher(line.substring(3).trim()).replaceAll("");
                if ((value = whiteSpaceTrim.matcher(value).replaceAll("")).length() == 0 || value.toUpperCase(Locale.US).equals("NONE")) continue;
                if (specificStateDictionary != null && specificStateDictionary.containsKey(key)) {
                    resultKey = (String)specificStateDictionary.get(key);
                    if (resultKey == null) continue;
                    parsedDictionary.put(resultKey, value);
                    continue;
                }
                if (key.equals("DCT") || key.equals("DAC")) {
                    value = value.replace(',', ' ');
                    int indexMiddle = (value = value.replaceAll(" +", " ").trim()).indexOf(32);
                    if (indexMiddle == -1) {
                        parsedDictionary.put(FIRST_NAME, value);
                        continue;
                    }
                    parsedDictionary.put(FIRST_NAME, value.substring(0, indexMiddle));
                    parsedDictionary.put(MIDDLE_NAME, value.substring(indexMiddle));
                    continue;
                }
                if (key.equals("DAA")) {
                    String[] name = (value = value.replace(',', ' ')).split(" +");
                    if (name.length > 0 && name[0].length() > 0) {
                        parsedDictionary.put(LAST_NAME, name[0].trim());
                    }
                    if (name.length > 1 && name[1].length() > 0) {
                        parsedDictionary.put(FIRST_NAME, name[1].trim());
                    }
                    if (name.length <= 2 || name[2].length() <= 0) continue;
                    if (name.length > 3) {
                        Object[] middleName = new String[name.length - 2];
                        System.arraycopy(name, 2, middleName, 0, name.length - 2);
                        parsedDictionary.put(MIDDLE_NAME, TextUtils.join((CharSequence)" ", (Object[])middleName).trim());
                        continue;
                    }
                    parsedDictionary.put(MIDDLE_NAME, name[2].trim());
                    continue;
                }
                resultKey = keysDictionary.get(key);
                if (resultKey == null) continue;
                parsedDictionary.put(resultKey, value);
            }
        }

        private static HashMap<String, String> getKeysDictionary() {
            HashMap<String, String> keysDictionary = new HashMap<String, String>();
            keysDictionary.put("DCB", MIDDLE_NAME);
            keysDictionary.put("DAA", null);
            keysDictionary.put("DAB", LAST_NAME);
            keysDictionary.put("DAC", FIRST_NAME);
            keysDictionary.put("DCS", LAST_NAME);
            keysDictionary.put("DAD", MIDDLE_NAME);
            keysDictionary.put("DAE", NAME_SUFFIX);
            keysDictionary.put("DCT", null);
            keysDictionary.put("DAG", ADDRESS);
            keysDictionary.put("DAI", CITY);
            keysDictionary.put("DAJ", STATE);
            keysDictionary.put("DAK", POSTAL_CODE);
            keysDictionary.put("DAL", ADDRESS);
            keysDictionary.put("DAH", ADDRESS_ADDITIONAL);
            keysDictionary.put("DAM", ADDRESS_ADDITIONAL);
            keysDictionary.put("DAN", CITY);
            keysDictionary.put("DAO", STATE);
            keysDictionary.put("DAP", POSTAL_CODE);
            keysDictionary.put("DAQ", ID_NUMBER);
            keysDictionary.put("DAR", CLASS);
            keysDictionary.put("DAS", RESTRICTION_CODE);
            keysDictionary.put("DAT", ENDORSEMENT_CODE);
            keysDictionary.put("DAV", HEIGHT);
            keysDictionary.put("DAU", HEIGHT);
            keysDictionary.put("DAW", WEIGHT);
            keysDictionary.put("DAY", EYE_COLOR);
            keysDictionary.put("DAZ", HAIR_COLOR);
            keysDictionary.put("DBA", EXPIRATION_DATE);
            keysDictionary.put("DBB", DATE_OF_BIRTH);
            keysDictionary.put("DBC", SEX);
            keysDictionary.put("DBD", ISSUE_DATE);
            keysDictionary.put("DBF", DUPLICATES);
            keysDictionary.put("DBH", ORGAN_DONOR);
            keysDictionary.put("DBK", SOCIAL_SECURITY_NUMBER);
            keysDictionary.put("DCA", CLASS);
            keysDictionary.put("DCB", RESTRICTION_CODE);
            keysDictionary.put("DCD", ENDORSEMENT_CODE);
            keysDictionary.put("DCE", LIMITED_DURATION_DOCUMENT_INDICATOR);
            keysDictionary.put("DCF", DOCUMENT_NUMBER);
            keysDictionary.put("DCG", COUNTRY_ID);
            keysDictionary.put("DCH", FEDERAL_COMMERCIAL_VEHICLE_CODES);
            keysDictionary.put("DCJ", AUDIT_INFORMATION);
            keysDictionary.put("DCK", INVENTORY_CONTROL_NUMBER);
            keysDictionary.put("DCL", ETHNICITY);
            keysDictionary.put("DCU", NAME_SUFFIX);
            keysDictionary.put("DDA", COMPLIANCE_TYPE);
            keysDictionary.put("DDB", CARD_REVISION_DATE);
            keysDictionary.put("DDD", LIMITED_DURATION_DOCUMENT_INDICATOR);
            keysDictionary.put("DDE", LAST_NAME_TRUNCATION);
            keysDictionary.put("DDF", FIRST_NAME_TRUNCATION);
            keysDictionary.put("DDG", MIDDLE_NAME_TRUNCATION);
            keysDictionary.put("DDK", ORGAN_DONOR);
            keysDictionary.put("ZNE", TEMP_VISITOR);
            keysDictionary.put("ZWA", CUSTOMER_SPECIFIC_CONTROL_NUMBER);
            keysDictionary.put("ZWB", WA_SPECIFIC_ENDORSEMENT);
            keysDictionary.put("ZWC", TRANSACTION_TYPES);
            keysDictionary.put("ZWD", UNDER_18_UNTIL);
            keysDictionary.put("ZWE", UNDER_21_UNTIL);
            keysDictionary.put("ZWF", REVISION_DATE);
            keysDictionary.put("DDH", null);
            keysDictionary.put("DDI", null);
            keysDictionary.put("DDJ", null);
            keysDictionary.put("ZCB", null);
            keysDictionary.put("ZCC", null);
            keysDictionary.put("ZCD", null);
            keysDictionary.put("ZCZ", null);
            keysDictionary.put("ZFC", null);
            keysDictionary.put("ZFD", null);
            keysDictionary.put("ZFZ", null);
            keysDictionary.put("ZGB", null);
            keysDictionary.put("ZGC", null);
            keysDictionary.put("ZGD", null);
            keysDictionary.put("ZGE", null);
            keysDictionary.put("ZGF", null);
            keysDictionary.put("ZGG", null);
            keysDictionary.put("ZGH", null);
            keysDictionary.put("ZGI", null);
            keysDictionary.put("ZGJ", null);
            keysDictionary.put("ZGK", null);
            keysDictionary.put("ZGL", null);
            keysDictionary.put("ZGM", null);
            keysDictionary.put("ZMZ", null);
            return keysDictionary;
        }

        private static HashMap<String, HashMap> getStateDictionaries() {
            HashMap<String, HashMap> stateDictionaries = new HashMap<String, HashMap>();
            HashMap<String, String> _WA_Dictionary = new HashMap<String, String>();
            _WA_Dictionary.put("DCB", RESTRICTION_CODE);
            _WA_Dictionary.put("DCE", WEIGHT);
            stateDictionaries.put("WA", _WA_Dictionary);
            HashMap<String, String> _NY_Dictionary = new HashMap<String, String>();
            _NY_Dictionary.put("DCB", RESTRICTION_CODE);
            stateDictionaries.put("NY", _NY_Dictionary);
            return stateDictionaries;
        }

        static {
            dlSplit = Pattern.compile("DL");
            lineSplit = Pattern.compile("[\r\n]+");
            whiteSpaceTrim = Pattern.compile("^[\\s]+|[\\s]+$");
            commaTrim = Pattern.compile("^[,]+|[,]+$");
        }
    }
}

