/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.zxing.Result;
import com.topimagesystems.Common;
import com.topimagesystems.controllers.imageanalyze.BarcodeReader;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.controllers.imageanalyze.DynamicCaptureCameraController;
import com.topimagesystems.controllers.imageanalyze.OCRHelper;
import com.topimagesystems.controllers.imageanalyze.ProcessStillImageThread;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.BoundingBoxResult;
import com.topimagesystems.micr.GenericBoundingBoxResult;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.UserInterfaceUtils;
import java.util.Date;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

public class PreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = Logger.makeLogTag("PreviewCallback");
    private CameraConfigurationManager configManager;
    private MobiCHECKOCR mobiCHECKOCR;
    private Mat matYuv;
    private Mat matRgba;
    private Mat passMat;
    Mat croppedImageResult;
    public Bitmap boxBitmap;
    public static boolean processingVideo = false;
    private CameraController activity;
    boolean isFront;
    private long lastFocusRequestTime = 0L;
    private boolean isFocus;
    private byte[] buffer;
    private BarcodeReader barcodeReader;
    Bundle messageBundle = new Bundle();
    BoundingBoxResult boundingBoxResult = null;
    GenericBoundingBoxResult genericBoundingBoxResult = null;
    int orientation = 0;
    OCRCommon.ErrorCode errorCode = null;

    PreviewCallback(CameraConfigurationManager configManager) {
        this.configManager = configManager;
        processingVideo = false;
        if (CameraController.getInstance() != null && CameraManagerController.enableBarcodeDetection) {
            CheckBoundaries cb = CameraManagerController.getOcrAnalyzeSession((Context)this.activity).getBarcodeBoundariesRectDisp();
            Rect rect = cb.getValidationRect();
            this.barcodeReader = new BarcodeReader(CameraManagerController.barcodeTypes, rect.x, rect.y, rect.width, rect.height);
        }
    }

    private void verifyMats(int width, int height) {
        if (this.matYuv == null) {
            this.matYuv = new Mat(height + height / 2, width, CvType.CV_8UC1);
        }
        if (this.matRgba == null) {
            this.matRgba = new Mat();
        }
    }

    public void setActivity(CameraController cameraController, MobiCHECKOCR mobiCHECKOCR, byte[] buffer, int bufferSize) {
        this.mobiCHECKOCR = mobiCHECKOCR;
        this.activity = cameraController;
        PreviewCallback previewCallback = this;
        PreviewCallback previewCallback2 = this;
        this.verifyMats(previewCallback.configManager.getCameraPreviewResolution().x, previewCallback2.configManager.getCameraPreviewResolution().y);
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        PreviewCallback previewCallback = this;
        final Point cameraResolution = previewCallback.configManager.getCameraPreviewResolution();
        final byte[] imgData = data;
        final Camera c = camera;
        Thread thread = new Thread(){

            @Override
            public void run() {
                PreviewCallback.this.processFrame(imgData, c, cameraResolution.x, cameraResolution.y, null);
            }
        };
        thread.start();
        data = null;
    }

    public synchronized void processMat(final byte[] data, final Camera camera, final int width, final int height, final Mat image) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                PreviewCallback.this.processFrame(data, camera, width, height, image);
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFrame(byte[] data, final Camera camera, int width, int height, Mat incomingMat) {
        processingVideo = true;
        if (this.activity == null) {
            this.activity = CameraController.getInstance();
        }
        if (data == null && incomingMat == null || this.activity == null) {
            return;
        }
        this.errorCode = null;
        try {
            if (!this.activity.isValidOrientation()) {
                this.sendNotValidMessage(CameraTypes.HintIndicator.Align, this.errorCode, null, this.orientation, null);
                return;
            }
            if (incomingMat == null) {
                this.verifyMats(width, height);
                this.matYuv.put(0, 0, data);
                Imgproc.cvtColor((Mat)this.matYuv, (Mat)this.matRgba, (int)92, (int)4);
            } else {
                this.matRgba = incomingMat;
            }
            if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
                this.matRgba = FileUtils.rotateMat(this.matRgba, 90);
            }
            if (CameraManagerController.deviceName.equals("LGE Nexus 5X")) {
                this.matRgba = FileUtils.rotateMat(this.matRgba, 90);
                this.matRgba = FileUtils.rotateMat(this.matRgba, 90);
                data = FileUtils.convertJpgMatToByte(this.matRgba);
                if (!CameraManagerController.useCameraAPI2 && !CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession) {
                    Imgproc.cvtColor((Mat)this.matRgba, (Mat)this.matRgba, (int)4, (int)4);
                }
            } else if (!CameraManagerController.isStillMode) {
                Imgproc.cvtColor((Mat)this.matRgba, (Mat)this.matRgba, (int)4, (int)4);
            }
            Mat originalVideoMat = this.matRgba;
            if (this.mobiCHECKOCR == null) {
                this.mobiCHECKOCR = CameraController.getInstance().mobiCHECKOCR;
            }
            if (this.mobiCHECKOCR == null) {
                Logger.e(TAG, "mobichecOCR is null !!");
                this.sendNotValidMessage(null, OCRCommon.ErrorCode.errorInializeOCR, null, this.orientation, null);
                if (camera != null) {
                    camera.addCallbackBuffer(this.buffer);
                }
                return;
            }
            if (this.matRgba == null || this.matRgba.rows() == 0 || this.matRgba.cols() == 0) {
                Logger.e(TAG, "process frame, couldn't create Mat");
                this.sendNotValidMessage(null, OCRCommon.ErrorCode.emptyImage, null, this.orientation, null);
                return;
            }
            boolean isValidContrast = this.mobiCHECKOCR.isValidContrast(this.matRgba);
            if (!isValidContrast) {
                this.sendNotValidMessage(CameraTypes.HintIndicator.NoLight, this.errorCode, null, this.orientation, null);
                return;
            }
            if (this.mobiCHECKOCR != null) {
                boolean bl = this.isFront = CameraManagerController.getOcrAnalyzeSession((Context)this.activity).captureMode == CameraTypes.CaptureMode.FRONT;
                if (CameraManagerController.isDynamicCapture) {
                    this.croppedImageResult = new Mat();
                    this.genericBoundingBoxResult = this.mobiCHECKOCR.findGenericBoundingBox(this.matRgba, this.croppedImageResult);
                    if (this.genericBoundingBoxResult.errorCodeId != -1 || this.genericBoundingBoxResult.width == 0) {
                        this.errorCode = this.genericBoundingBoxResult.getErrorCode();
                    } else {
                        this.errorCode = OCRCommon.ErrorCode.ok;
                        this.boundingBoxResult = new BoundingBoxResult();
                        this.boundingBoxResult.setRect(this.genericBoundingBoxResult.x, this.genericBoundingBoxResult.y, this.genericBoundingBoxResult.width, this.genericBoundingBoxResult.height);
                        this.boundingBoxResult.setRect(this.genericBoundingBoxResult.x, this.genericBoundingBoxResult.y, this.genericBoundingBoxResult.width, this.genericBoundingBoxResult.height);
                    }
                    if (this.genericBoundingBoxResult.bottomLeftX != 0.0f && this.genericBoundingBoxResult.bottomLeftY != 0.0f && this.genericBoundingBoxResult.topLeftX != 0.0f && this.genericBoundingBoxResult.topLeftY != 0.0f) {
                        this.boundingBoxResult.bottomLeft[0] = this.genericBoundingBoxResult.bottomLeftX;
                        this.boundingBoxResult.bottomLeft[1] = this.genericBoundingBoxResult.bottomLeftY;
                        this.boundingBoxResult.bottomRight[0] = this.genericBoundingBoxResult.bottomRightX;
                        this.boundingBoxResult.bottomRight[1] = this.genericBoundingBoxResult.bottomRightY;
                        this.boundingBoxResult.topLeft[0] = this.genericBoundingBoxResult.topLeftX;
                        this.boundingBoxResult.topLeft[1] = this.genericBoundingBoxResult.topLeftY;
                        this.boundingBoxResult.topRight[0] = this.genericBoundingBoxResult.topRightX;
                        this.boundingBoxResult.topRight[1] = this.genericBoundingBoxResult.topRightY;
                        this.messageBundle.putBundle("checkRect", OCRHelper.rectToBundle(this.boundingBoxResult.getRect(), this.boundingBoxResult.bottomLeft, this.boundingBoxResult.bottomRight, this.boundingBoxResult.topLeft, this.boundingBoxResult.topRight));
                    }
                } else if (CameraManagerController.imageType != CaptureIntent.TISDocumentType.PASSPORT) {
                    this.boundingBoxResult = this.mobiCHECKOCR.findCheckBoundingBox(this.matRgba, this.isFront, true);
                    if (this.boundingBoxResult == null) {
                        Logger.e(TAG, "locateBorderUsingApproximateKmeans returned null boundingBoxResult");
                        this.sendNotValidMessage(null, OCRCommon.ErrorCode.notValidBoundaries, null, this.orientation, null);
                    }
                    this.errorCode = this.boundingBoxResult.getErrorCode();
                } else {
                    Rect screenRect = CameraManagerController.getOcrAnalyzeSession((Context)this.activity).getCheckBoundariesDisp().getValidationRect();
                    this.boundingBoxResult = new BoundingBoxResult();
                    this.boundingBoxResult.setRect(screenRect.x, screenRect.y, screenRect.width, screenRect.height);
                }
            }
            if (this.errorCode != null && this.errorCode != OCRCommon.ErrorCode.ok) {
                if (this.errorCode == OCRCommon.ErrorCode.detectableColor) {
                    this.sendNotValidMessage(CameraTypes.HintIndicator.NoLight, this.errorCode, null, this.orientation, null);
                } else {
                    this.sendNotValidMessage(null, this.errorCode, null, this.orientation, null);
                }
            }
            if (CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession && this.barcodeReader != null) {
                Mat detectBarcode;
                if (CameraManagerController.BarcodeDetectionTries > CameraManagerController.maxBarcodeTries) {
                    CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession = false;
                    this.sendNotValidMessage(CameraTypes.HintIndicator.MoveToBARCODE, null, null, 0.0, null);
                }
                Mat mat = detectBarcode = CameraManagerController.isDynamicCapture ? this.croppedImageResult : this.matRgba;
                if (CameraManagerController.useCameraAPI2 && !CameraManagerController.isDynamicCapture) {
                    final byte[] finalData = data;
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            processingVideo = true;
                            if (!PreviewCallback.this.readBarcode(camera, finalData, detectBarcode)) {
                                PreviewCallback.this.sendNotValidMessage(CameraTypes.HintIndicator.MoveToBARCODE, null, null, 0.0, null);
                                ++CameraManagerController.BarcodeDetectionTries;
                                processingVideo = false;
                            } else {
                                PreviewCallback.this.sendValidMessage(PreviewCallback.this.messageBundle, 0.0, 20);
                                processingVideo = false;
                            }
                        }
                    };
                    thread.start();
                } else if (!this.readBarcode(camera, data, detectBarcode)) {
                    this.sendNotValidMessage(CameraTypes.HintIndicator.MoveToBARCODE, null, null, 0.0, null);
                    ++CameraManagerController.BarcodeDetectionTries;
                } else {
                    this.sendValidMessage(this.messageBundle, 0.0, 20);
                }
            } else {
                if (this.boundingBoxResult == null || this.boundingBoxResult.getRect() == null) {
                    this.sendNotValidMessage(null, OCRCommon.ErrorCode.notValidBoundaries, null, this.orientation, null);
                    return;
                }
                Rect checkRect = this.boundingBoxResult.getRect();
                CameraSessionManager.CheckInPLaceResult checkInPlace = new CameraSessionManager.CheckInPLaceResult();
                if (CameraManagerController.isDynamicCapture) {
                    double currentBoxAR = (double)checkRect.height / (double)checkRect.width;
                    if (CameraManagerController.ocrAnalyzeSession.maxRatioHW > 0.0f && CameraManagerController.ocrAnalyzeSession.minRatioHW > 0.0f && currentBoxAR > (double)CameraManagerController.ocrAnalyzeSession.maxRatioHW * 1.1 || currentBoxAR < (double)CameraManagerController.ocrAnalyzeSession.minRatioHW * 0.9) {
                        checkInPlace.isInPlace = false;
                        checkInPlace.hintIndicator = CameraTypes.HintIndicator.None;
                    } else {
                        CameraSessionManager.getInstance();
                        checkInPlace.hintIndicator = CameraSessionManager.validateImageOreintation(this.boundingBoxResult.bottomLeft, this.boundingBoxResult.topLeft, this.boundingBoxResult.bottomRight, this.boundingBoxResult.topRight, 6.0f);
                        if (checkInPlace.hintIndicator != CameraTypes.HintIndicator.Hold) {
                            checkInPlace.isInPlace = false;
                        } else {
                            checkInPlace = CameraSessionManager.getInstance().isCheckInPlace(checkRect, this.boundingBoxResult.sizeIndicator, width, height);
                        }
                        if (checkInPlace.hintIndicator != CameraTypes.HintIndicator.Hold) {
                            checkInPlace.isInPlace = false;
                            CameraSessionManager.getInstance().resetRectComapreCounter();
                        }
                    }
                } else {
                    checkInPlace = CameraSessionManager.getInstance().isCheckInPlace(checkRect, this.boundingBoxResult.sizeIndicator, width, height);
                }
                if (checkInPlace.isInPlace || CameraManagerController.imageType == CaptureIntent.TISDocumentType.PASSPORT) {
                    boolean isBlur;
                    int timestamp;
                    CameraManagerController.getOcrAnalyzeSession((Context)this.activity).timestamp = timestamp = Math.abs((int)new Date().getTime() / 1000);
                    CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setVideoMat(originalVideoMat);
                    CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setVideoBoundingBox(checkRect);
                    this.orientation = UserInterfaceUtils.getScreenOrientation((Context)this.activity);
                    String path = PreviewCallback.getImagePath(this.isFront);
                    CameraManagerController.getOcrAnalyzeSession((Context)this.activity).checkRect = checkRect;
                    if (this.isFront) {
                        CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setFrontImagePath(path);
                        CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setFrontImageTIFFPath(path.replace(".jpg", ".tiff"));
                    } else {
                        CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setBackImagePath(path);
                        CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setBackImageTIFFPath(path.replace(".jpg", ".tiff"));
                    }
                    if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.PASSPORT) {
                        this.readPassport();
                        return;
                    }
                    Mat croppedVideoMat = originalVideoMat.submat(checkRect);
                    if (CameraManagerController.falseRecognitionVideoFrames >= CameraManagerController.maxVideoFramesToProcess) {
                        CameraManagerController.isStillMode = true;
                    }
                    if (FileUtils.isSamsungS5() && this.isFront && CameraManagerController.ocrType == Common.OCRType.OFF && CameraManagerController.imageType == CaptureIntent.TISDocumentType.PAYMENT && (isBlur = this.mobiCHECKOCR.detectBlur(croppedVideoMat, CameraManagerController.isDebug, CameraManagerController.imageType.ordinal(), CameraConfigurationManager.captureResolutionHeight * CameraConfigurationManager.captureResolutionWidth, this.isFront))) {
                        long currentTime = System.currentTimeMillis();
                        long estimatedTime = currentTime - this.lastFocusRequestTime;
                        checkInPlace.hintIndicator = CameraTypes.HintIndicator.Blur;
                        this.sendNotValidMessage(checkInPlace.hintIndicator, this.errorCode, this.messageBundle, this.orientation, null);
                        if (!FileUtils.isSamsungS5() && CameraManagerController.imageType != CaptureIntent.TISDocumentType.CHECK) {
                            ++CameraManagerController.falseRecognitionVideoFrames;
                        }
                        if (estimatedTime >= 3000L) {
                            CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
                            this.lastFocusRequestTime = System.currentTimeMillis();
                            return;
                        }
                        return;
                    }
                    if (CameraManagerController.isStillMode) {
                        this.sendValidMessage(this.messageBundle, this.orientation, 7);
                    } else {
                        CameraController.getInstance().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                CameraController.getInstance().showGreenIndicatorForVideo();
                            }
                        });
                        if (!CameraManagerController.isStillMode) {
                            Imgproc.cvtColor((Mat)originalVideoMat, (Mat)originalVideoMat, (int)0, (int)4);
                        }
                        if (this.isFront) {
                            SessionResultParams.originalFront = FileUtils.convertJpgMatToByte(originalVideoMat);
                        } else {
                            SessionResultParams.originalBack = FileUtils.convertJpgMatToByte(originalVideoMat);
                        }
                        CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setImagePath(path);
                        CameraController.CameraActivityHandler handler = !CameraManagerController.isDynamicCapture ? CameraController.getInstance().handler : DynamicCaptureCameraController.getInstance().getHandler();
                        this.mobiCHECKOCR.setHandler(handler);
                        if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.PASSPORT && CameraManagerController.getOcrAnalyzeSession((Context)this.activity).captureMode == CameraTypes.CaptureMode.FRONT) {
                            this.readPassport();
                            return;
                        }
                        ProcessStillImageThread processStillImageThread = new ProcessStillImageThread((Context)this.activity, handler, this.mobiCHECKOCR, true, timestamp);
                        processStillImageThread.start();
                    }
                } else {
                    if (!CameraManagerController.isStillMode && !CameraManagerController.isDynamicCapture) {
                        CameraController.getInstance().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                CameraController.getInstance().showRedIndicatorForVideo();
                                CameraController.getInstance().cameraOverlayView.invalidate();
                            }
                        });
                    }
                    if (this.activity != null && this.activity.isDebug()) {
                        int timestamp = Math.abs((int)new Date().getTime() / 1000);
                        FileUtils.addToLogFile(timestamp + " | video invalid rect:" + checkRect.toString(), (Context)this.activity);
                    }
                    this.sendNotValidMessage(checkInPlace.hintIndicator, this.errorCode, this.messageBundle, this.orientation, null);
                }
            }
        }
        catch (Exception e) {
            this.matRgba = null;
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile(TAG, Log.getStackTraceString((Throwable)e), (Context)this.activity);
            }
            this.sendNotValidMessage(CameraTypes.HintIndicator.None, OCRCommon.ErrorCode.error_deviceMemory, null, 1.0, Log.getStackTraceString((Throwable)e));
        }
        finally {
            processingVideo = false;
        }
    }

    private void checkForFocusBeforeCapture() {
        CameraController.getInstance().cameraSessionManager.requestAutoFocus(null, 0);
    }

    public void release() {
        if (this.activity != null) {
            this.activity = null;
        }
        if (this.mobiCHECKOCR != null) {
            this.mobiCHECKOCR = null;
        }
        if (this.matYuv != null) {
            this.matYuv.release();
            this.matYuv = null;
        }
        if (this.matRgba != null) {
            this.matRgba.release();
            this.matRgba = null;
        }
        if (this.buffer != null) {
            this.buffer = null;
        }
    }

    private void readPassport() {
        Imgproc.cvtColor((Mat)this.matRgba, (Mat)this.matRgba, (int)0, (int)4);
        Rect PassRect = CameraConfigurationManager.videoResolutionHeight >= 1080 || CameraConfigurationManager.videoResolutionWidth >= 1080 ? new Rect(0, (int)((double)this.matRgba.rows() * 0.7), this.matRgba.cols(), (int)((double)this.matRgba.rows() * 0.25) - 1) : new Rect(0, (int)((double)this.matRgba.rows() * 0.6), this.matRgba.cols(), (int)((double)this.matRgba.rows() * 0.3) - 1);
        this.passMat = new Mat(this.matRgba, PassRect);
        OCRResult PassRes = this.mobiCHECKOCR.readPassport(this.passMat);
        this.errorCode = PassRes.getErrorCode();
        CameraManagerController.getOcrAnalyzeSession((Context)this.activity).setVideoMat(this.matRgba);
        Logger.i(TAG, "pass res " + PassRes.ocrRawResult + "delimeter " + PassRes.ocrResultWithDelimiter);
        if (PassRes.errorCodeId == -1 && PassRes.ocrRawResult.length() > 1) {
            this.messageBundle.putString("PASSPORT_OCR_RESULT", PassRes.ocrRawResult);
            this.messageBundle.putString("PASSPORT_OCR_RESULT_WITH_DELIMETER", PassRes.ocrResultWithDelimiter);
            this.messageBundle.putInt("PASSPORT_OCR_RESULT_LENGTH", PassRes.digitalRowLength);
            Logger.i(TAG, "found pass " + PassRes.ocrRawResult);
            Logger.i(TAG, "found pass  delemetere " + PassRes.ocrResultWithDelimiter);
            float VideoToScreenWidthAR = (float)CameraConfigurationManager.videoResolutionWidth / (float)CameraConfigurationManager.screenResolution.x;
            float VideoToScreenHeightAR = (float)CameraConfigurationManager.videoResolutionHeight / (float)CameraConfigurationManager.screenResolution.y;
            int[] boundingBox = new int[]{(int)((float)this.boundingBoxResult.x * VideoToScreenWidthAR), (int)((float)this.boundingBoxResult.y * VideoToScreenHeightAR), (int)((float)this.boundingBoxResult.width * VideoToScreenWidthAR), (int)((float)this.boundingBoxResult.height * VideoToScreenHeightAR)};
            this.messageBundle.putIntArray("INTENT_BOUNDING_BOX_RESULT", boundingBox);
            this.sendValidMessage(this.messageBundle, this.orientation, 22);
            processingVideo = false;
            return;
        }
        long currentTime = System.currentTimeMillis();
        long estimatedTime = currentTime - this.lastFocusRequestTime;
        if (estimatedTime >= 3000L) {
            CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
            this.lastFocusRequestTime = System.currentTimeMillis();
        }
        this.sendNotValidMessage(CameraTypes.HintIndicator.HoldFlat, OCRCommon.ErrorCode.errorPassportNotFound, null, this.orientation, null);
        processingVideo = false;
    }

    private boolean readBarcode(Camera camera, byte[] data, Mat img) {
        if (CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession && this.barcodeReader != null) {
            this.orientation = UserInterfaceUtils.getScreenOrientation((Context)this.activity);
            Result result = this.barcodeReader.scanImage(data, CameraConfigurationManager.videoResolutionWidth, CameraConfigurationManager.videoResolutionHeight, this.orientation, img);
            if (result != null && this.barcodeReader.getFormats().contains(result.getBarcodeFormat())) {
                CameraManagerController.BarcodeDetectionTries = 0;
                this.boundingBoxResult = new BoundingBoxResult();
                this.messageBundle.putString("barCodeType", result.getBarcodeFormat().toString());
                this.messageBundle.putString("barCodeData", result.getText());
                this.messageBundle.putBoolean("proceedWithProcessing", true);
                int[] boundingBox = new int[]{this.boundingBoxResult.x, this.boundingBoxResult.y, this.boundingBoxResult.width, this.boundingBoxResult.height};
                this.messageBundle.putIntArray("INTENT_BOUNDING_BOX_RESULT", boundingBox);
                return true;
            }
            long currentTime = System.currentTimeMillis();
            long estimatedTime = currentTime - this.lastFocusRequestTime;
            if (estimatedTime >= 3000L) {
                CameraSessionManager.getInstance().requestAutoFocus(CameraController.getInstance().handler, 3);
                this.lastFocusRequestTime = System.currentTimeMillis();
            }
            if (CameraManagerController.BarcodeDetectionTries >= CameraManagerController.maxBarcodeTries) {
                CameraManagerController.getOcrAnalyzeSession((Context)this.activity).isBarcodeSession = false;
            }
        }
        return false;
    }

    private void sendValidMessage(Bundle messageBundle, double orientation, int messageToHandle) {
        if (this.activity == null) {
            this.activity = CameraController.getInstance();
        }
        this.activity.getHandler().removeAllMessages();
        Message message = Message.obtain((Handler)this.activity.getHandler(), (int)messageToHandle);
        if (message != null) {
            message.obj = true;
            messageBundle.putDouble("orientation", orientation);
            messageBundle.putBoolean("proceedWithProcessing", false);
            message.setData(messageBundle);
            message.sendToTarget();
        }
        this.activity = null;
    }

    private void sendNotValidMessage(CameraTypes.HintIndicator hintIndicator, OCRCommon.ErrorCode errorCode, Bundle messageBundle, double orientation, String exception) {
        if (errorCode == null || errorCode.name() != null) {
            // empty if block
        }
        if (this.activity == null) {
            this.activity = CameraController.getInstance();
        }
        if (CameraController.getInstance().getHandler() == null) {
            return;
        }
        Message message = Message.obtain((Handler)CameraController.getInstance().getHandler(), (int)6);
        if (this.activity.getHandler() != null) {
            this.activity.getHandler().removeAllPreviewProcessingMessages();
        }
        if (message != null) {
            if (messageBundle == null) {
                messageBundle = new Bundle();
            }
            message.obj = false;
            if (hintIndicator != null) {
                messageBundle.putString("hintName", hintIndicator.name());
            }
            if (errorCode != null) {
                messageBundle.putString("analyzeErrorCode", errorCode.name());
            }
            if (exception != null) {
                messageBundle.putString("exceptionError", exception);
            }
            messageBundle.putDouble("orientation", orientation);
            message.setData(messageBundle);
            if (this.activity != null && message != null) {
                if (this.activity.getHandler() == null) {
                    this.activity.handler = new CameraController.CameraActivityHandler(CameraController.getInstance(), true);
                }
                this.activity.getHandler().sendMessage(message);
            }
        }
        this.activity = null;
    }

    public static String getImagePath(boolean isFront) {
        String basePath = CameraController.activity.getFilesDir().getAbsolutePath() + "/" + FileUtils.tempPath + "/";
        String currentDateAndTime = FileUtils.getCurrentTime();
        String path = isFront ? basePath + "FRONT" + "_" + currentDateAndTime + "_" + ".jpg" : basePath + "BACK" + "_" + currentDateAndTime + "_" + ".jpg";
        return path;
    }
}

