/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.os.Bundle;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.util.UserInterfaceUtils;
import org.opencv.core.Rect;

public class CheckBoundaries {
    private static final int CHECK_SIZE_THRESHOLD_WIDTH = 30;
    private static final int CHECK_SIZE_THRESHOLD_HEIGHT = 35;
    private static final int DEFAULT_REFERENCE_CHECK_BOUNDARY_SCREEN_WIDTH = 480;
    private static final int CHECK_SIZE_MIN_WIDTH = 430;
    public static final Rect defaultRect = new Rect(10, 38, 460, 230);
    public static final Rect defaultA4Rect = new Rect(45, 10, 240, 650);
    public static final Rect defaultA4RectView = new Rect(10, 55, 150, 600);
    private Rect minCheckRect;
    private Rect validationRect;
    private Rect portaritViewRect;
    private Rect minCheckRectBack;
    private Rect validationRectBack;
    private float aspectRatioWidth;
    private float aspectRatioHeight;
    public static float treshholdWidth;
    public static float treshholdHeight;
    private int minCheckWidth;
    private int minCheckWidthBack;
    private static float validationRectWidth;
    private static float validationRectHeight;
    private CameraTypes.CaptureMode captureMode;
    private float defaultRectScale = 1.0f;

    public CheckBoundaries(Context context, CameraTypes.CaptureMode captureMode, boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack) {
        this(context, captureMode, isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax, hwRatioMinBack, hwRatioMaxBack, 1.0f);
    }

    public CheckBoundaries(Context context, CameraTypes.CaptureMode captureMode, boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack, float scale) {
        this.defaultRectScale = scale;
        this.updateValidationRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax, hwRatioMinBack, hwRatioMaxBack);
        this.updateMinCheckRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax, hwRatioMinBack, hwRatioMaxBack);
        this.captureMode = captureMode;
        float ocrValidationRatio = (float)CheckBoundaries.defaultRect.height * this.defaultRectScale / ((float)CheckBoundaries.defaultRect.width * this.defaultRectScale);
        this.aspectRatioWidth = (float)displayWidth / (480.0f * this.defaultRectScale);
        this.aspectRatioHeight = this.aspectRatioWidth * ocrValidationRatio;
        treshholdWidth = 30.0f * this.aspectRatioWidth;
        treshholdHeight = 35.0f * this.aspectRatioWidth;
        this.updateValidationRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax, hwRatioMinBack, hwRatioMaxBack);
        this.updateMinCheckRect(isUseCustomAlgorithmForBack, displayWidth, displayHeight, hwRatioMin, hwRatioMax, hwRatioMinBack, hwRatioMaxBack);
    }

    public void setValidationRect(Rect rect) {
        this.validationRect = rect;
    }

    private void updateMinCheckRect(boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack) {
        this.minCheckRect = new Rect();
        float scaleFactor = (float)this.validationRect.width * this.defaultRectScale / ((float)CheckBoundaries.defaultRect.width * this.defaultRectScale);
        float minWidth = 430.0f * scaleFactor;
        float minHeight = minWidth * hwRatioMin;
        this.updateRect(displayWidth, displayHeight, minWidth, minHeight, this.minCheckRect);
        this.minCheckRectBack = new Rect(this.minCheckRect.x, this.minCheckRect.y, this.minCheckRect.width, this.minCheckRect.height);
        if (isUseCustomAlgorithmForBack) {
            float hwRatioMidBack = (hwRatioMaxBack + hwRatioMinBack) / 2.0f;
            float heightBack = minWidth * hwRatioMidBack;
            float widthBack = minWidth;
            if (heightBack > minHeight) {
                float scaleHRatio = heightBack / minHeight;
                widthBack = (heightBack /= scaleHRatio) / hwRatioMaxBack;
            }
            this.updateRect(displayWidth, displayHeight, widthBack, heightBack, this.minCheckRectBack);
        }
    }

    private void updateValidationRect(boolean isUseCustomAlgorithmForBack, int displayWidth, int displayHeight, float hwRatioMin, float hwRatioMax, float hwRatioMinBack, float hwRatioMaxBack) {
        this.validationRect = new Rect();
        this.validationRect.x = (int)((float)CheckBoundaries.defaultRect.x / this.defaultRectScale * this.aspectRatioWidth);
        this.validationRect.y = (int)((float)CheckBoundaries.defaultRect.y / this.defaultRectScale * this.aspectRatioHeight);
        float hwRatioMid = (hwRatioMax + hwRatioMin) / 2.0f;
        validationRectWidth = displayWidth - this.validationRect.x * 2;
        if (validationRectHeight == 0.0f) {
            validationRectHeight = displayHeight - (this.validationRect.y * 2 + (int)(100.0f * this.aspectRatioHeight));
        } else if (CameraManagerController.deviceName != null && !CameraManagerController.deviceName.equals("LGE Nexus 4")) {
            validationRectHeight = displayHeight - (this.validationRect.y * 2 + (int)(100.0f * this.aspectRatioHeight));
        }
        float currentRatio = validationRectHeight / validationRectWidth;
        if (currentRatio > hwRatioMid) {
            validationRectHeight = hwRatioMid * validationRectWidth;
        } else {
            validationRectWidth = validationRectHeight / hwRatioMid;
        }
        this.updateRect(displayWidth, displayHeight, validationRectWidth, validationRectHeight, this.validationRect);
        this.validationRectBack = new Rect(this.validationRect.x, this.validationRect.y, this.validationRect.width, this.validationRect.height);
        if (isUseCustomAlgorithmForBack) {
            float hwRatioMidBack = (hwRatioMaxBack + hwRatioMinBack) / 2.0f;
            float heightBack = validationRectWidth * hwRatioMidBack;
            float widthBack = validationRectWidth;
            if (heightBack > validationRectHeight) {
                float scaleHRatio = heightBack / validationRectHeight;
                widthBack = (heightBack /= scaleHRatio) / hwRatioMidBack;
            }
            this.updateRect(displayWidth, displayHeight, widthBack, heightBack, this.validationRectBack);
        }
    }

    public CheckBoundaries(Bundle bundle) {
        this.validationRect = UserInterfaceUtils.bundleToRect(bundle.getBundle("validationRect"));
        this.minCheckRect = UserInterfaceUtils.bundleToRect(bundle.getBundle("minCheckRect"));
        this.validationRectBack = UserInterfaceUtils.bundleToRect(bundle.getBundle("validationRectBack"));
        this.minCheckRectBack = UserInterfaceUtils.bundleToRect(bundle.getBundle("minCheckRectBack"));
        this.aspectRatioWidth = bundle.getFloat("aspectRatioWidth");
        this.aspectRatioHeight = bundle.getFloat("aspectRatioHeight");
        treshholdWidth = bundle.getFloat("treshholdWidth");
        treshholdHeight = bundle.getFloat("treshholdHeight");
        this.minCheckWidth = bundle.getInt("minCheckWidth");
    }

    public void setCaptureMode(CameraTypes.CaptureMode captureMode) {
        this.captureMode = captureMode;
    }

    private void updateRect(int displayWidth, int displayHeight, float width, float height, Rect rect) {
        rect.width = (int)width;
        rect.height = (int)height;
        rect.x = (displayWidth - rect.width) / 2;
        rect.y = (int)((double)(displayHeight - rect.height) / 2.5);
    }

    public Rect getValidationBoundariesRectByCaptureMode() {
        return this.captureMode == CameraTypes.CaptureMode.FRONT ? this.validationRect : this.validationRectBack;
    }

    public Rect getPortraitViewRect() {
        return this.portaritViewRect;
    }

    public Rect getValidationRect() {
        return this.validationRect;
    }

    public Rect getScaledValidationRect() {
        Rect ajustedRect = new Rect();
        ajustedRect.width = this.validationRect.width = (int)((float)this.validationRect.width * CameraConfigurationManager.screenAndVideoRatioWidth);
        ajustedRect.height = this.validationRect.height = (int)((float)this.validationRect.height * CameraConfigurationManager.screenAndVideoRatioHeight);
        ajustedRect.x = this.validationRect.height = (int)((float)this.validationRect.height * CameraConfigurationManager.screenAndVideoRatioWidth);
        ajustedRect.y = this.validationRect.height = (int)((float)this.validationRect.height * CameraConfigurationManager.screenAndVideoRatioHeight);
        return ajustedRect;
    }

    public Rect getValidationRectBack() {
        return this.validationRectBack;
    }

    public Rect getMinCheckRectByCaptureMode() {
        return this.captureMode == CameraTypes.CaptureMode.FRONT ? this.minCheckRect : this.minCheckRectBack;
    }

    public Rect getMinCheckRect() {
        return this.minCheckRect;
    }

    public Rect getMinCheckRectBack() {
        return this.minCheckRectBack;
    }

    public float getAspectRatio() {
        return this.aspectRatioWidth;
    }

    public int getMinCheckWidth() {
        return this.captureMode == CameraTypes.CaptureMode.FRONT ? this.minCheckWidth : this.minCheckWidthBack;
    }

    public int getMinBoundaryX(boolean isTreshhold) {
        if (this.captureMode == CameraTypes.CaptureMode.FRONT) {
            return (int)(isTreshhold ? (float)this.validationRect.x - treshholdWidth : (float)this.validationRect.x);
        }
        return (int)(isTreshhold ? (float)this.validationRectBack.x - treshholdWidth : (float)this.validationRectBack.x);
    }

    public int getMaxBoundaryX(boolean isTreshhold) {
        if (this.captureMode == CameraTypes.CaptureMode.FRONT) {
            return (int)(isTreshhold ? (float)(this.validationRect.x + this.validationRect.width) + treshholdWidth : (float)(this.validationRect.x + this.validationRect.width));
        }
        return (int)(isTreshhold ? (float)(this.validationRectBack.x + this.validationRectBack.width) + treshholdWidth : (float)(this.validationRectBack.x + this.validationRectBack.width));
    }

    public int getMinBoundaryY(boolean isTreshhold) {
        if (this.captureMode == CameraTypes.CaptureMode.FRONT) {
            return (int)(isTreshhold ? (float)this.validationRect.y - treshholdHeight : (float)this.validationRect.y);
        }
        return (int)(isTreshhold ? (float)this.validationRectBack.y - treshholdHeight : (float)this.validationRectBack.y);
    }

    public int getMaxBoundaryY(boolean isTreshhold) {
        if (this.captureMode == CameraTypes.CaptureMode.FRONT) {
            return (int)(isTreshhold ? (float)(this.validationRect.y + this.validationRect.height) + treshholdHeight : (float)(this.validationRect.y + this.validationRect.height));
        }
        return (int)(isTreshhold ? (float)(this.validationRectBack.y + this.validationRectBack.height) + treshholdHeight : (float)(this.validationRectBack.y + this.validationRectBack.height));
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putBundle("validationRect", UserInterfaceUtils.rectToBundle(this.validationRect));
        bundle.putBundle("minCheckRect", UserInterfaceUtils.rectToBundle(this.minCheckRect));
        bundle.putBundle("validationRectBack", UserInterfaceUtils.rectToBundle(this.validationRectBack));
        bundle.putBundle("minCheckRectBack", UserInterfaceUtils.rectToBundle(this.minCheckRectBack));
        bundle.putFloat("aspectRatioWidth", this.aspectRatioWidth);
        bundle.putFloat("aspectRatioHeight", this.aspectRatioHeight);
        bundle.putFloat("treshholdWidth", treshholdWidth);
        bundle.putFloat("treshholdHeight", treshholdHeight);
        bundle.putInt("minCheckWidth", this.minCheckWidth);
        return bundle;
    }

    static {
        validationRectWidth = 0.0f;
        validationRectHeight = 0.0f;
    }
}

