/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.camera2;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.topimagesystems.R;
import com.topimagesystems.camera2.AutoFitTextureView;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraOverlayLayout;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.PreviewCallback;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.util.Logger;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

@TargetApi(value=21)
public class CameraAPI2Manager
implements View.OnClickListener {
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();
    private static final int REQUEST_CAMERA_PERMISSION = 1;
    private static final String FRAGMENT_DIALOG = "dialog";
    public static final String TAG = "CameraAPI2Manager";
    private static final int STATE_PREVIEW = 0;
    private static final int STATE_WAITING_LOCK = 1;
    private static final int STATE_WAITING_PRECAPTURE = 2;
    private static final int STATE_WAITING_NON_PRECAPTURE = 3;
    private static final int STATE_PICTURE_TAKEN = 4;
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    public CameraOverlayLayout cameraLayout;
    private ViewGroup cameraView;
    private PreviewCallback processCallback;
    public boolean isSessionClosed = false;
    public static boolean stillCaptureStarted;
    private static boolean convertImageToMatInProcess;
    private Image image;
    private final TextureView.SurfaceTextureListener mSurfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture texture, int width, int height) {
            CameraAPI2Manager.this.openCamera(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture texture, int width, int height) {
            CameraAPI2Manager.this.configureTransform(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture texture) {
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture texture) {
        }
    };
    private String mCameraId;
    private AutoFitTextureView mTextureView;
    private CameraCaptureSession mCaptureSession;
    private CameraDevice mCameraDevice;
    private static Size mPreviewSize;
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            CameraAPI2Manager.this.mCameraOpenCloseLock.release();
            CameraAPI2Manager.this.mCameraDevice = cameraDevice;
            CameraAPI2Manager.this.createCameraPreviewSession();
        }

        public CameraOverlayLayout getcameraOverlayView() {
            return CameraAPI2Manager.this.cameraLayout;
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            CameraAPI2Manager.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            CameraAPI2Manager.this.mCameraDevice = null;
        }

        public void onError(CameraDevice cameraDevice, int error) {
            CameraAPI2Manager.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            CameraAPI2Manager.this.mCameraDevice = null;
            CameraController activity = CameraController.getInstance();
            if (null != activity) {
                activity.finish();
            }
        }
    };
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private ImageReader mImageReader;
    private ImageReader mStillsImageReader;
    private File mFile;
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            block6: {
                try {
                    CameraAPI2Manager.this.image = reader.acquireLatestImage();
                    if (CameraAPI2Manager.this.image == null || CameraAPI2Manager.this.isSessionClosed) break block6;
                    if (CameraAPI2Manager.this.image.getWidth() > 1920 && !CameraController.processStart) {
                        Logger.e(CameraAPI2Manager.TAG, "got stills Image");
                        new convertFrameToMat().execute(new Image[]{CameraAPI2Manager.this.image});
                        break block6;
                    }
                    if (!(CameraController.processStart || PreviewCallback.processingVideo || CameraAPI2Manager.this.isSessionClosed)) {
                        Logger.e(CameraAPI2Manager.TAG, "image processed");
                        new convertFrameToMat().execute(new Image[]{CameraAPI2Manager.this.image});
                        break block6;
                    }
                    CameraAPI2Manager.this.image.close();
                    Logger.e(CameraAPI2Manager.TAG, "image not processed");
                }
                catch (Exception e) {
                    Logger.e(CameraAPI2Manager.TAG, Log.getStackTraceString((Throwable)e));
                }
            }
        }
    };
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private CaptureRequest mPreviewRequest;
    private int mState = 0;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private boolean mFlashSupported;
    private CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult result) {
            switch (CameraAPI2Manager.this.mState) {
                case 0: {
                    CameraAPI2Manager.this.processVideo();
                    break;
                }
                case 1: {
                    Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (afState == null) {
                        CameraAPI2Manager.this.captureStillPicture();
                        break;
                    }
                    if (4 != afState && 5 != afState) break;
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState == null || aeState == 2) {
                        CameraAPI2Manager.this.mState = 4;
                        CameraAPI2Manager.this.captureStillPicture();
                        break;
                    }
                    CameraAPI2Manager.this.runPrecaptureSequence();
                    break;
                }
                case 2: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState != null && aeState != 5 && aeState != 4) break;
                    CameraAPI2Manager.this.mState = 3;
                    break;
                }
                case 3: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState != null && aeState == 5) break;
                    CameraAPI2Manager.this.mState = 4;
                    CameraAPI2Manager.this.captureStillPicture();
                    break;
                }
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };
    int mPictureCounter = 0;
    CameraCaptureSession.CaptureCallback cameraCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            ++CameraAPI2Manager.this.mPictureCounter;
        }
    };

    public void setCameraOverlayView(ViewGroup v) {
        this.cameraView = v;
    }

    public void closeSession() {
        this.isSessionClosed = true;
        PreviewCallback.processingVideo = false;
        stillCaptureStarted = false;
        this.closeCamera();
        this.stopBackgroundThread();
    }

    public void stopRepeating() {
        try {
            this.mCaptureSession.stopRepeating();
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void processVideo() {
        try {
            if (this.mPreviewRequestBuilder != null && this.mImageReader != null && this.mImageReader.getSurface() != null) {
                try {
                    ArrayList<CaptureRequest> captureList = new ArrayList<CaptureRequest>();
                    this.mPreviewRequestBuilder.addTarget(this.mImageReader.getSurface());
                    for (int i = 0; i < 10; ++i) {
                        captureList.add(this.mPreviewRequestBuilder.build());
                    }
                    this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.cameraCaptureCallback, this.mBackgroundHandler);
                }
                catch (CameraAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showToast(final String text) {
        final CameraController activity = CameraController.getInstance();
        if (activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)activity, (CharSequence)text, (int)0).show();
                }
            });
        }
    }

    private static Size chooseOptimalSize(Size[] choices, int textureViewWidth, int textureViewHeight, int maxWidth, int maxHeight, Size aspectRatio) {
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        ArrayList<Size> notBigEnough = new ArrayList<Size>();
        int w = aspectRatio.getWidth();
        int h = aspectRatio.getHeight();
        for (Size option : choices) {
            if (option.getWidth() > maxWidth || option.getHeight() > maxHeight || option.getHeight() != option.getWidth() * h / w) continue;
            if (option.getWidth() >= textureViewWidth && option.getHeight() >= textureViewHeight) {
                bigEnough.add(option);
                continue;
            }
            notBigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            return Collections.min(bigEnough, new CompareSizesByArea());
        }
        if (notBigEnough.size() > 0) {
            return Collections.max(notBigEnough, new CompareSizesByArea());
        }
        Log.e((String)TAG, (String)"Couldn't find any suitable preview size");
        return choices[0];
    }

    public static CameraAPI2Manager newInstance() {
        return new CameraAPI2Manager();
    }

    public void startCamera() {
        this.mTextureView = (AutoFitTextureView)CameraController.getInstance().findViewById(R.id.texture);
        this.startBackgroundThread();
        if (this.mTextureView.isAvailable()) {
            this.openCamera(this.mTextureView.getWidth(), this.mTextureView.getHeight());
        } else {
            this.mTextureView.setSurfaceTextureListener(this.mSurfaceTextureListener);
        }
    }

    public void closeSessionAndResources() {
        this.closeCamera();
        this.stopBackgroundThread();
    }

    private void requestCameraPermission() {
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    private void setUpCameraOutputs(int width, int height) {
        CameraController activity = CameraController.getInstance();
        CameraManager manager = (CameraManager)activity.getSystemService("camera");
        try {
            for (String cameraId : manager.getCameraIdList()) {
                int orientation;
                Size stillsCaptureSize;
                StreamConfigurationMap map;
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
                Integer facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (facing != null && facing == 0 || (map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)) == null) continue;
                Object largest = null;
                StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                Size[] mSizes = streamConfigurationMap.getOutputSizes(SurfaceTexture.class);
                ArrayList<Size> validPreviewSizes = new ArrayList<Size>();
                for (Size s : mSizes) {
                    if (s.getWidth() > 1920 || s.getHeight() > 1080) continue;
                    validPreviewSizes.add(s);
                }
                mPreviewSize = Collections.max(validPreviewSizes, new CompareSizesByArea());
                if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.useMaxResolutionStills) {
                    map.getOutputSizes(256);
                    stillsCaptureSize = Collections.max(Arrays.asList(map.getOutputSizes(256)), new CompareSizesByArea());
                } else {
                    Size[] cameraSizes = map.getOutputSizes(256);
                    Point choosedCaptureSize = CameraConfigurationManager.chooseCaptureResolution(cameraSizes, (Context)CameraController.getInstance());
                    stillsCaptureSize = new Size(choosedCaptureSize.x, choosedCaptureSize.y);
                }
                this.mImageReader = ImageReader.newInstance((int)mPreviewSize.getWidth(), (int)mPreviewSize.getHeight(), (int)35, (int)3);
                this.mStillsImageReader = ImageReader.newInstance((int)stillsCaptureSize.getWidth(), (int)stillsCaptureSize.getHeight(), (int)35, (int)3);
                CameraConfigurationManager.stillHeightRes = stillsCaptureSize.getHeight();
                CameraConfigurationManager.captureResolutionWidth = CameraConfigurationManager.stillWidthRes = stillsCaptureSize.getWidth();
                CameraConfigurationManager.captureResolutionHeight = CameraConfigurationManager.stillHeightRes;
                CameraConfigurationManager.videoResolutionHeight = mPreviewSize.getHeight();
                CameraConfigurationManager.videoResolutionWidth = mPreviewSize.getWidth();
                this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mBackgroundHandler);
                this.mStillsImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mBackgroundHandler);
                int displayRotation = activity.getWindowManager().getDefaultDisplay().getRotation();
                int sensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                boolean swappedDimensions = false;
                switch (displayRotation) {
                    case 0: 
                    case 2: {
                        if (sensorOrientation != 90 && sensorOrientation != 270) break;
                        swappedDimensions = true;
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (sensorOrientation != 0 && sensorOrientation != 180) break;
                        swappedDimensions = true;
                        break;
                    }
                    default: {
                        Log.e((String)TAG, (String)("Display rotation is invalid: " + displayRotation));
                    }
                }
                Point displaySize = new Point();
                activity.getWindowManager().getDefaultDisplay().getSize(displaySize);
                int rotatedPreviewWidth = width;
                int rotatedPreviewHeight = height;
                int maxPreviewWidth = displaySize.x;
                int maxPreviewHeight = displaySize.y;
                CameraConfigurationManager.screenResolution = new Point();
                CameraConfigurationManager.screenResolution.x = displaySize.x;
                CameraConfigurationManager.screenResolution.y = displaySize.y;
                if (swappedDimensions) {
                    rotatedPreviewWidth = height;
                    rotatedPreviewHeight = width;
                    maxPreviewWidth = displaySize.y;
                    maxPreviewHeight = displaySize.x;
                }
                if (maxPreviewWidth > 1920) {
                    maxPreviewWidth = 1920;
                }
                if (maxPreviewHeight > 1080) {
                    maxPreviewHeight = 1080;
                }
                if ((orientation = CameraController.getInstance().getResources().getConfiguration().orientation) == 2) {
                    this.mTextureView.setAspectRatio(mPreviewSize.getWidth(), mPreviewSize.getHeight());
                } else {
                    this.mTextureView.setAspectRatio(mPreviewSize.getHeight(), mPreviewSize.getWidth());
                }
                Boolean available = (Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                this.mFlashSupported = available == null ? false : available;
                this.mCameraId = cameraId;
                return;
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=21)
    private void openCamera(int width, int height) {
        this.setUpCameraOutputs(width, height);
        this.configureTransform(width, height);
        this.isSessionClosed = false;
        CameraManager manager = (CameraManager)CameraController.getInstance().getSystemService("camera");
        CameraController.getInstance().getSystemService("camera");
        try {
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            manager.openCamera(this.mCameraId, this.mStateCallback, this.mBackgroundHandler);
            if (Build.VERSION.SDK_INT >= 23 && CameraController.getInstance().checkSelfPermission("android.permission.CAMERA") == 0) return;
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", e);
        }
    }

    private void closeCamera() {
        try {
            this.isSessionClosed = true;
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
            if (null != this.mImageReader) {
                this.mImageReader.close();
                this.mImageReader = null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        if (this.mBackgroundThread != null) {
            this.mBackgroundThread.quitSafely();
            try {
                this.mBackgroundThread.join();
                this.mBackgroundThread = null;
                this.mBackgroundHandler = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void createCameraPreviewSession() {
        try {
            if (this.mBackgroundHandler == null) {
                return;
            }
            SurfaceTexture texture = this.mTextureView.getSurfaceTexture();
            assert (texture != null);
            texture.setDefaultBufferSize(mPreviewSize.getWidth(), mPreviewSize.getHeight());
            Surface surface = new Surface(texture);
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            CameraManager cameraManager = (CameraManager)CameraController.getInstance().getSystemService("camera");
            CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(this.mCameraId);
            Range[] fps = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
            this.mPreviewRequestBuilder.addTarget(surface);
            ArrayList<Surface> surfacesList = new ArrayList<Surface>();
            surfacesList.add(this.mImageReader.getSurface());
            surfacesList.add(this.mStillsImageReader.getSurface());
            surfacesList.add(surface);
            this.mCameraDevice.createCaptureSession(surfacesList, new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    if (null == CameraAPI2Manager.this.mCameraDevice) {
                        return;
                    }
                    CameraAPI2Manager.this.mCaptureSession = cameraCaptureSession;
                    try {
                        CameraAPI2Manager.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        MeteringRectangle[] focusArea = new MeteringRectangle[]{new MeteringRectangle(new Rect(0, 0, CameraConfigurationManager.videoResolutionWidth, CameraConfigurationManager.videoResolutionWidth), 1)};
                        CameraAPI2Manager.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)focusArea);
                        CameraAPI2Manager.this.setAutoFlash(CameraAPI2Manager.this.mPreviewRequestBuilder);
                        CameraAPI2Manager.this.mPreviewRequest = CameraAPI2Manager.this.mPreviewRequestBuilder.build();
                        CameraAPI2Manager.this.mCaptureSession.setRepeatingRequest(CameraAPI2Manager.this.mPreviewRequest, CameraAPI2Manager.this.mCaptureCallback, CameraAPI2Manager.this.mBackgroundHandler);
                    }
                    catch (CameraAccessException e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                }
            }, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void configureTransform(int viewWidth, int viewHeight) {
        CameraController activity = CameraController.getInstance();
        if (null == this.mTextureView || null == mPreviewSize || null == activity) {
            return;
        }
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)mPreviewSize.getHeight(), (float)mPreviewSize.getWidth());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        if (1 == rotation || 3 == rotation) {
            bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
            matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
            float scale = Math.max((float)viewHeight / (float)mPreviewSize.getHeight(), (float)viewWidth / (float)mPreviewSize.getWidth());
            matrix.postScale(scale, scale, centerX, centerY);
            matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
        } else if (2 == rotation) {
            matrix.postRotate(180.0f, centerX, centerY);
        }
        this.mTextureView.setTransform(matrix);
    }

    public void takePicture() {
        if (!stillCaptureStarted) {
            this.lockFocus();
        }
    }

    private void lockFocus() {
        try {
            if (this.mBackgroundHandler == null) {
                return;
            }
            if (this.mCaptureSession != null && this.mPreviewRequestBuilder != null) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                this.mState = 1;
                this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mBackgroundHandler);
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void runPrecaptureSequence() {
        try {
            if (this.mBackgroundHandler == null || this.mCaptureSession == null || this.mCaptureCallback == null || this.isSessionClosed) {
                return;
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.mState = 2;
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void captureStillPicture() {
        try {
            Log.e((String)TAG, (String)"captureStillPicture started");
            CameraController activity = CameraController.getInstance();
            if (null == activity || null == this.mCameraDevice || this.isSessionClosed) {
                return;
            }
            CaptureRequest.Builder captureBuilder = this.mCameraDevice.createCaptureRequest(2);
            captureBuilder.addTarget(this.mStillsImageReader.getSurface());
            captureBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            this.setAutoFlash(captureBuilder);
            int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)ORIENTATIONS.get(rotation));
            CameraCaptureSession.CaptureCallback CaptureCallback2 = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
                    CameraAPI2Manager.this.unlockFocus();
                }
            };
            if (this.mCaptureSession != null && !this.isSessionClosed) {
                this.mCaptureSession.stopRepeating();
                this.mCaptureSession.capture(captureBuilder.build(), CaptureCallback2, null);
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public void unlockFocus() {
        try {
            if (this.mBackgroundHandler == null || this.mCaptureSession == null || this.isSessionClosed) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 23 && !this.mCaptureSession.isReprocessable()) {
                return;
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            this.setAutoFlash(this.mPreviewRequestBuilder);
            this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mBackgroundHandler);
            this.mState = 0;
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, this.mCaptureCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public void onClick(View view) {
    }

    private void setAutoFlash(CaptureRequest.Builder requestBuilder) {
        if (this.mFlashSupported) {
            requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
        }
    }

    public static Mat imageToMat(Image image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int offset = 0;
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[image.getWidth() * image.getHeight() * ImageFormat.getBitsPerPixel((int)35) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        for (int i = 0; i < planes.length; ++i) {
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            int w = i == 0 ? width : width / 2;
            int h = i == 0 ? height : height / 2;
            for (int row = 0; row < h; ++row) {
                int bytesPerPixel = ImageFormat.getBitsPerPixel((int)35) / 8;
                if (pixelStride == bytesPerPixel) {
                    int length = w * bytesPerPixel;
                    buffer.get(data, offset, length);
                    if (h - row != 1) {
                        buffer.position(buffer.position() + rowStride - length);
                    }
                    offset += length;
                    continue;
                }
                if (h - row == 1) {
                    buffer.get(rowData, 0, width - pixelStride + 1);
                } else {
                    buffer.get(rowData, 0, rowStride);
                }
                for (int col = 0; col < w; ++col) {
                    data[offset++] = rowData[col * pixelStride];
                }
            }
        }
        Mat mat = new Mat(height + height / 2, width, CvType.CV_8UC1);
        mat.put(0, 0, data);
        return mat;
    }

    @TargetApi(value=23)
    private boolean askPermission() {
        String permission2;
        PackageManager pm = CameraController.getInstance().getPackageManager();
        int res = pm.checkPermission(permission2 = "android.permission.CAMERA", CameraController.getInstance().getPackageName());
        if (res == 0) {
            return true;
        }
        CameraController.getInstance().requestPermissions(new String[]{"android.permission.CAMERA"}, 111);
        return false;
    }

    static {
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
        stillCaptureStarted = false;
        convertImageToMatInProcess = false;
    }

    public static class ConfirmationDialog
    extends DialogFragment {
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            final Fragment parent = this.getParentFragment();
            return new AlertDialog.Builder((Context)this.getActivity()).setMessage((CharSequence)"permission").setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Activity activity = parent.getActivity();
                    if (activity != null) {
                        activity.finish();
                    }
                }
            }).create();
        }
    }

    public static class ErrorDialog
    extends DialogFragment {
        private static final String ARG_MESSAGE = "message";

        public static ErrorDialog newInstance(String message) {
            ErrorDialog dialog = new ErrorDialog();
            Bundle args = new Bundle();
            args.putString(ARG_MESSAGE, message);
            dialog.setArguments(args);
            return dialog;
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            final Activity activity = this.getActivity();
            return new AlertDialog.Builder((Context)activity).setMessage((CharSequence)this.getArguments().getString(ARG_MESSAGE)).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    activity.finish();
                }
            }).create();
        }
    }

    static class CompareSizesByArea
    implements Comparator<Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }

    private static class ImageSaver
    implements Runnable {
        private final Mat mImage;
        private final File mFile;

        public ImageSaver(Mat image, File file) {
            this.mImage = image;
            this.mFile = file;
        }

        @Override
        public void run() {
            try {
                if (this.mImage != null) {
                    CameraConfigurationManager.cameraCaptureResolution = new Point(this.mImage.cols(), this.mImage.rows());
                }
                if (this.mImage.cols() > CameraConfigurationManager.videoResolutionWidth || this.mImage.rows() > CameraConfigurationManager.videoResolutionWidth) {
                    if (!CameraController.processStart && CameraController.captureStillStarted) {
                        stillCaptureStarted = true;
                        CameraSessionManager.getInstance().startStillsFlow(this.mImage);
                    }
                } else {
                    CameraSessionManager.getInstance().previewCallback.processMat(null, null, mPreviewSize.getWidth(), mPreviewSize.getHeight(), this.mImage);
                }
            }
            finally {
                Object buffer = null;
                Object bytes = null;
            }
        }
    }

    private class convertFrameToMat
    extends AsyncTask<Image, Void, Mat> {
        private convertFrameToMat() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Mat doInBackground(Image ... params) {
            try (Image img = params[0];){
                convertImageToMatInProcess = true;
                PreviewCallback.processingVideo = true;
                Mat mYuvMat = CameraAPI2Manager.imageToMat(img);
                Mat bgrMat = new Mat(img.getHeight(), img.getWidth(), CvType.CV_8UC4);
                Imgproc.cvtColor((Mat)mYuvMat, (Mat)bgrMat, (int)101);
                Mat rgbaMatOut = new Mat();
                Imgproc.cvtColor((Mat)bgrMat, (Mat)rgbaMatOut, (int)2, (int)0);
                Mat mat = rgbaMatOut;
                return mat;
            }
        }

        protected void onPostExecute(Mat mat) {
            if (CameraAPI2Manager.this.mBackgroundHandler != null) {
                super.onPostExecute((Object)mat);
                CameraAPI2Manager.this.mBackgroundHandler.post((Runnable)new ImageSaver(mat, CameraAPI2Manager.this.mFile));
                convertImageToMatInProcess = false;
            }
        }

        protected void onProgressUpdate(Void ... values) {
        }
    }
}

