package com.topimagesystems.util;

import org.opencv.core.Rect;

import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.content.res.Configuration;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;


// TODO: Auto-generated Javadoc
/**
 * The Class UIUtils.
 */
public class UserInterfaceUtils {

	/** The Constant tag. */
	private final static String tag = Logger.makeLogTag("UIUtils");
	
	/** The stub. */
	private static String STUB = "payment";
	
	/** The check. */
	private static String CHECK = "check";
	
	/**
	 * Gets the display dimensions.
	 *
	 * @param context the context
	 * @return the display dimensions
	 */
	public static Point getDisplayDimensions(Context context) {
		Point size = new Point();
		WindowManager wm;
		if (context != null)
		 wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
		else{
			wm = (WindowManager) CameraController.getInstance().getSystemService(Context.WINDOW_SERVICE);
		}

		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
			getSizeAboveAPI13(size, wm);
		}
		else {
			getSizePriorApi13(size, wm);
		}
		return size;
	}
	public static boolean hasHardwareAcceleration(Activity activity) {
		// Has HW acceleration been enabled manually in the current window?
		try {
			Window window = activity.getWindow();
			if (window != null) {
				if ((window.getAttributes().flags
						& WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED) != 0) {
					return true;
				}
			}

			// Has HW acceleration been enabled in the manifest?
			try {
				ActivityInfo info = activity.getPackageManager().getActivityInfo(
						activity.getComponentName(), 0);
				if ((info.flags & ActivityInfo.FLAG_HARDWARE_ACCELERATED) != 0) {
					return true;
				}
			} catch (PackageManager.NameNotFoundException e) {
				Log.e("hasHardwareAcceleration", "getActivityInfo(self) should not fail");
			}

			return false;
		}catch(Exception e){
			Logger.e("hasHardwareAcceleration",Log.getStackTraceString(e));
			return false;
		}
	}

	/**
	 * Gets the camera preview resolution.
	 *
	 * @param context the context
	 * @param parameters the parameters
	 * @return the camera preview resolution
	 */
	public static Point getCameraPreviewResolution(Context context, Camera.Parameters parameters) {		
		return CameraConfigurationManager.getCameraPreviewResolution(parameters, getDisplayDimensions(context),context);
	}

	/**
	 * Gets the version name.
	 *
	 * @param context the context
	 * @return the version name
	 */
	public static String getVersionName(Context context) {
			String app_ver = "unknown";
		
		try {
			app_ver = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
		}
		catch (NameNotFoundException e) {
			Logger.v(tag, e.getMessage());
		}
	
		return app_ver;
	}

	
	/**
	 * Gets the size prior api13.
	 *
	 * @param size the size
	 * @param wm the wm
	 * @return the size prior api13
	 */
	@SuppressWarnings("deprecation")
	private static void getSizePriorApi13(Point size, WindowManager wm) {
		Display d = wm.getDefaultDisplay();
		size.x = d.getWidth();
		size.y = d.getHeight();
	}

	/**
	 * Gets the size above ap i13.
	 *
	 * @param size the size
	 * @param wm the wm
	 * @return the size above ap i13
	 */
	@TargetApi(13)
	private static void getSizeAboveAPI13(Point size, WindowManager wm) {
		wm.getDefaultDisplay().getSize(size);
	}

	/**
	 * Gets the display metrics.
	 *
	 * @param context the context
	 * @return the display metrics
	 */
	public static DisplayMetrics getDisplayMetrics(Context context) {
		WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
		DisplayMetrics metrics = new DisplayMetrics();
		wm.getDefaultDisplay().getMetrics(metrics);
		return metrics;
	}

	/**
	 * Gets the API level.
	 *
	 * @return the API level
	 */
	public static int getAPILevel() {
		return Build.VERSION.SDK_INT;
	}
	
	/**
	 * Rect to bundle.
	 *
	 * @param rect the rect
	 * @return the bundle
	 */
	public static Bundle rectToBundle(Rect rect){
		Bundle bundle = new Bundle();
		if ( rect != null){
			bundle.putInt("x", rect.x);
			bundle.putInt("y", rect.y);
			bundle.putInt("width", rect.width);
			bundle.putInt("height", rect.height);
		}
		return bundle;
	}
	
	/**
	 * Bundle to rect.
	 *
	 * @param bundle the bundle
	 * @return the rect
	 */
	public static Rect bundleToRect(Bundle bundle){
		Rect rect = new Rect();
		if ( bundle != null){
			rect.x = bundle.getInt("x");
			rect.y = bundle.getInt("y");
			rect.width = bundle.getInt("width");
			rect.height = bundle.getInt("height");
		}
		return rect;
	}
	
	/**
	 * Get screen orientation
	 *
	 * @param context the context
	 * @return the orientation
	 */
	public static int getScreenOrientation(Context context) {
		WindowManager wm = (WindowManager) CameraController.getInstance().getSystemService(Context.WINDOW_SERVICE);
		Display display = wm.getDefaultDisplay();

		int orientation = Configuration.ORIENTATION_UNDEFINED;
		if (display.getWidth() == display.getHeight()) {
			orientation = Configuration.ORIENTATION_SQUARE;
		} else {
			if (display.getWidth() < display.getHeight()) {
				orientation = Configuration.ORIENTATION_PORTRAIT;
			} else {
				orientation = Configuration.ORIENTATION_LANDSCAPE;
			}
		}
		return orientation;
	}
}