/*
 * 
 */
package com.topimagesystems.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;

import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;

import org.opencv.core.Rect;

// TODO: Auto-generated Javadoc
/**
 * The Class CheckBounderiesView.
 */
public class CheckBounderiesView extends View {

    /** The paint. */
    private Paint paint;
    
    /** The boundery top. */
    private Bitmap bounderyTop;
    
    /** The boundery top v. */
    private Bitmap bounderyTopV;
    
    /** The boundery bottom. */
    private Bitmap bounderyBottom;
    
    /** The boundery bottom v. */
    private Bitmap bounderyBottomV;

    /** The boundery bottom right. */
    private Bitmap bounderyBottomRight;
    
    /** The boundery bottom v right. */
    private Bitmap bounderyBottomVRight;
    
    /** The boundery top right. */
    private Bitmap bounderyTopRight;
    
    /** The boundery top v right. */
    private Bitmap bounderyTopVRight;

    /** The is valid. */
    private boolean isValid = false;
    
    /** The tl offset. */
    private float tlOffset;
    
    /** The tt offset. */
    private float ttOffset;
    
    /** The bl offset. */
    private float blOffset;
    
    /** The bb offset. */
    private float bbOffset;

    /** The tl offset right. */
    private float tlOffsetRight;
    
    /** The tt offset right. */
    private float ttOffsetRight;
    
    /** The bl offset right. */
    private float blOffsetRight;
    
    /** The bb offset right. */
    private float bbOffsetRight;

    /** The validation boundaries rect. */
    private Rect validationBoundariesRect;
    
    /** The display dimensions. */
    private Point displayDimensions;
    
    /** The draw green rect. */
    private boolean drawGreenRect = false;
    
    /** The show boundries. */
    private boolean showBoundries = true;

    /** The is animating. */
    private boolean isAnimating = false;

    /** The animation helper. */
    private BoundariesAnimationHelper animationHelper;

    /** The series animation helper. */
    private SeriesAnimationHelper seriesAnimationHelper;
    
    static private class BoundariesAnimationHelper{
       public int counter = 0;
       public double left = 0;
       public double top = 0;
       public double width = 0;
       public double height = 0;
       public int numberOfFrames = 30;
       public CheckBoundaries newCheckBoundariesRect;
       public Rect newRect;
	   public Handler handler;
	   public int endAnimationMessageCode;
    }
    
    
	static private class SeriesAnimationHelper {
		public Rect[] rectangles;
		public CheckBoundaries finalCheckBoundaries;
		public int rectanglesCounter = 0;
		public Handler finalHandler;
		public int finalMessageCode;
	}
    
    
    /**
     * Instantiates a new check bounderies view.
     *
     * @param context the context
     */
    public CheckBounderiesView(Context context) {
	super(context);
	init();
    }

    /**
     * Instantiates a new check bounderies view.
     *
     * @param context the context
     * @param attrs the attrs
     */
    public CheckBounderiesView(Context context, AttributeSet attrs) {
	super(context, attrs);
	TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.captureOverlay);
	drawGreenRect = a.getBoolean(R.styleable.captureOverlay_drawGreenRectangle, false);	
	init();
    }

    /**
     * Instantiates a new check bounderies view.
     *
     * @param arg0 the arg0
     * @param arg1 the arg1
     * @param arg2 the arg2
     */
    public CheckBounderiesView(Context arg0, AttributeSet arg1, int arg2) {
	super(arg0, arg1, arg2);
	init();
    }

    /**
     * Inits the.
     */
    private void init() {
	if (!isInEditMode()) {
	    paint = new Paint();
	    paint.setAntiAlias(true);

	    bounderyBottom = ((BitmapDrawable) getResources().getDrawable(R.drawable.ic_boundary_bottom)).getBitmap();
	    bounderyBottomV = ((BitmapDrawable) getResources().getDrawable(R.drawable.ic_boundary_bottom_v)).getBitmap();
	    bounderyTop = ((BitmapDrawable) getResources().getDrawable(R.drawable.ic_boundary_top)).getBitmap();
	    bounderyTopV = ((BitmapDrawable) getResources().getDrawable(R.drawable.ic_boundary_top_v)).getBitmap();

	    bounderyBottomRight = ((BitmapDrawable) getResources().getDrawable(R.drawable.ic_boundary_bottom_lr)).getBitmap();
	    bounderyBottomVRight = ((BitmapDrawable) getResources().getDrawable(R.drawable.ic_boundary_bottom_v_rl)).getBitmap();
	    bounderyTopRight = ((BitmapDrawable) getResources().getDrawable(R.drawable.ic_boundary_top_rt)).getBitmap();
	    bounderyTopVRight = ((BitmapDrawable) getResources().getDrawable(R.drawable.ic_boundary_top_v_rt)).getBitmap();
	}
    }
    
    


	public void clearView() {
		validationBoundariesRect = null;
	}

    /**
     * Sets the check bounderies.
     *
     * @param displayDimensions the display dimensions
     * @param checkBoundariesRect the check boundaries rect
     */
    public void setCheckBounderies(Point displayDimensions, CheckBoundaries checkBoundariesRect) {
    	seriesAnimationHelper = null;
	this.validationBoundariesRect = checkBoundariesRect.getValidationBoundariesRectByCaptureMode();
	this.displayDimensions = displayDimensions;
	updateOffsets();

    }
    
    private void updateOffsets() {
    	tlOffset = validationBoundariesRect.x - 3;
    	ttOffset = validationBoundariesRect.y - 3;

    	blOffset = validationBoundariesRect.x + validationBoundariesRect.width - bounderyBottom.getWidth() + 3;
    	bbOffset = validationBoundariesRect.y + validationBoundariesRect.height - bounderyBottom.getHeight() + 3;

    	blOffsetRight = validationBoundariesRect.x - 3;
    	bbOffsetRight = bbOffset;

    	tlOffsetRight = blOffset + 4;
    	ttOffsetRight = ttOffset;
    }
   
    /**
     * Animate to check boundaries
     *
     * @param checkBoundariesRect the new boundaries
     */
    public void animateToCheckBoundaries(final CheckBoundaries checkBoundariesRect) {
    	animateToCheckBoundaries(checkBoundariesRect, null, 0);
    }
    
    
    
    /**
     * Animate to rectangles series
     *
     * @param checkBoundariesRect the new boundaries
     * @param handler the handler
     * @param messageCode the message code
     * @param rectangles the rectangles
     */
    public void animateRectanglesSeries(final CheckBoundaries checkBoundariesRect, Handler handler, int messageCode, Rect[] rectangles) {
    	isAnimating = true;
    	
    	this.isValid = false;
    	this.showBoundries = true;
    	seriesAnimationHelper = null;
    	if (rectangles != null && rectangles.length > 0)
    	{
    		seriesAnimationHelper = new SeriesAnimationHelper();
    		seriesAnimationHelper.rectangles = rectangles;
    		seriesAnimationHelper.finalCheckBoundaries = checkBoundariesRect;
    		seriesAnimationHelper.finalHandler = handler;
    		seriesAnimationHelper.finalMessageCode = messageCode;
    		seriesAnimationHelper.rectanglesCounter = 0;
    		
    		Rect newBoundariesRect = rectangles[0];
    		updateAnimationHelper(newBoundariesRect);
    		
    		invalidate();
    	}
    	
    	
    }
    
    
    private void updateAnimationHelper(Rect rect){
    	animationHelper = new BoundariesAnimationHelper();
    	animationHelper.counter = 0;
    	animationHelper.left = (rect.x - validationBoundariesRect.x)/animationHelper.numberOfFrames;
    	animationHelper.top = (rect.y - validationBoundariesRect.y)/animationHelper.numberOfFrames;;
    	animationHelper.width = (rect.width - validationBoundariesRect.width)/animationHelper.numberOfFrames;
    	animationHelper.height = (rect.height - validationBoundariesRect.height)/animationHelper.numberOfFrames;
    	animationHelper.newCheckBoundariesRect = null;
    	animationHelper.newRect = rect;
    	animationHelper.handler = null;
    	animationHelper.endAnimationMessageCode = 0;
    }
    
    
    private void updateAnimationHelper(CheckBoundaries checkBoundariesRect, Handler handler, int messageCode){
    	Rect newBoundariesRect = checkBoundariesRect.getValidationBoundariesRectByCaptureMode();
    	
    	animationHelper = new BoundariesAnimationHelper();
    	animationHelper.counter = 0;
    	animationHelper.left = (newBoundariesRect.x - validationBoundariesRect.x)/animationHelper.numberOfFrames;
    	animationHelper.top = (newBoundariesRect.y - validationBoundariesRect.y)/animationHelper.numberOfFrames;;
    	animationHelper.width = (newBoundariesRect.width - validationBoundariesRect.width)/animationHelper.numberOfFrames;
    	animationHelper.height = (newBoundariesRect.height - validationBoundariesRect.height)/animationHelper.numberOfFrames;
    	animationHelper.newCheckBoundariesRect = checkBoundariesRect;
    	animationHelper.newRect = newBoundariesRect;
    	animationHelper.handler = handler;
    	animationHelper.endAnimationMessageCode = messageCode;
    }
    
    
    /**
     * Animate to check boundaries
     *
     * @param checkBoundariesRect the new boundaries
     * @param handler the handler
     * @param messageCode the message code
     */
    public void animateToCheckBoundaries(final CheckBoundaries checkBoundariesRect, Handler handler, int messageCode) {
    	isAnimating = true;
    	
    	this.isValid = false;
    	this.showBoundries = true;
    	seriesAnimationHelper = null;
    	updateAnimationHelper(checkBoundariesRect, handler, messageCode);
    	
    	
    	invalidate();
    }
    

    /**
     * Show bounderies.
     *
     * @param isValid the is valid
     * @param isVisible the is visible
     */
    public void showBounderies(boolean isValid,boolean isVisible) {
    	if (isAnimating)
    		return;
	this.isValid = isValid;
	this.showBoundries = isVisible;
//	invalidate();
    }
   
    

    /**
     * Gets the validation rect.
     *
     * @return the validation rect
     */
    public Rect getValidationRect() {
	return validationBoundariesRect;
    }

    /* (non-Javadoc)
     * @see android.view.View#onDraw(android.graphics.Canvas)
     */
    @Override
    protected void onDraw(Canvas canvas) {
	super.onDraw(canvas);
	if (!isInEditMode() && validationBoundariesRect != null) {
	    
	    // Draw the exterior (i.e. outside the framing rect) darkened
	    paint.setColor(getResources().getColor(R.color.camera_overlay_color));
	    canvas.drawRect(0, 0, displayDimensions.x, validationBoundariesRect.y, paint);
	    canvas.drawRect(0, validationBoundariesRect.y, validationBoundariesRect.x, validationBoundariesRect.y + validationBoundariesRect.height + 1, paint);
	    canvas.drawRect(validationBoundariesRect.x + validationBoundariesRect.width + 1, validationBoundariesRect.y, displayDimensions.x, validationBoundariesRect.y
		    + validationBoundariesRect.height + 1, paint);
	    canvas.drawRect(0, validationBoundariesRect.y + validationBoundariesRect.height + 1, displayDimensions.x, displayDimensions.y, paint);

	    Bitmap topD = (isValid || isAnimating) ? bounderyTopV : bounderyTop;
	    Bitmap bottomD = (isValid || isAnimating) ? bounderyBottomV : bounderyBottom;

	    Bitmap topR = (isValid || isAnimating) ? bounderyTopVRight : bounderyTopRight;
	    Bitmap bottomR = (isValid || isAnimating) ? bounderyBottomVRight : bounderyBottomRight;

	    paint.setColor(isValid ? Color.argb(255, 0, 255, 0) : Color.argb(255, 255, 0, 0));
	    paint.setAntiAlias(true);
	    
	    if (showBoundries) {
	    	if (!isValid || !drawGreenRect || !CameraManagerController.isStillMode || isAnimating) {
	    		canvas.drawBitmap(topD, tlOffset, ttOffset, paint);
			    canvas.drawBitmap(bottomD, blOffset, bbOffset, paint);

			    canvas.drawBitmap(topR, tlOffsetRight, ttOffsetRight, paint);
			    canvas.drawBitmap(bottomR, blOffsetRight, bbOffsetRight, paint);
	    	}
	    	else {
	    		Paint rectanglePaintContainer = new Paint();
			    rectanglePaintContainer.setColor(Color.GREEN);
			    rectanglePaintContainer.setStyle(Paint.Style.STROKE);
			    rectanglePaintContainer.setStrokeWidth(9);		   
			    RectF validationRect = new RectF(validationBoundariesRect.x, validationBoundariesRect.y, validationBoundariesRect.x + validationBoundariesRect.width,
				    validationBoundariesRect.y + validationBoundariesRect.height);
			    canvas.drawRoundRect(validationRect, 15f, 15f, rectanglePaintContainer);
	    	}
	    }
	    
	    if (isAnimating)
	    {
	    	if (animationHelper.counter == animationHelper.numberOfFrames) {
	    		handleFinishAnimation();
	 		}
	    	else {
	    		animationHelper.counter++;
		    	int diff = animationHelper.numberOfFrames - animationHelper.counter;
		 		validationBoundariesRect.x = (int) (animationHelper.newRect.x - (animationHelper.left*diff));
		 		validationBoundariesRect.y = (int) (animationHelper.newRect.y - (animationHelper.top*diff));
		 		validationBoundariesRect.width = (int) (animationHelper.newRect.width - (animationHelper.width*diff));
		 		validationBoundariesRect.height = (int) (animationHelper.newRect.height - (animationHelper.height*diff));
		 		updateOffsets();
			 	invalidate();
	    	}
	    }
	   
	   

	}
    }
    
    private void handleFinishAnimation()
    {
    	if (animationHelper.newCheckBoundariesRect != null) {
    		isAnimating = false;
         	setCheckBounderies(displayDimensions, animationHelper.newCheckBoundariesRect);
         	if (animationHelper.handler != null) {
         		final Message message = animationHelper.handler.obtainMessage(animationHelper.endAnimationMessageCode);
         		message.sendToTarget();
         	}
         	animationHelper = null;
    		invalidate();
    	}
    	else if (seriesAnimationHelper != null){
	 		validationBoundariesRect.x = animationHelper.newRect.x;
	 		validationBoundariesRect.y = animationHelper.newRect.y;
	 		validationBoundariesRect.width = animationHelper.newRect.width;
	 		validationBoundariesRect.height = animationHelper.newRect.height;
	 		updateOffsets();
    		
	 		invalidate();
    		
    		seriesAnimationHelper.rectanglesCounter++;
    		if (seriesAnimationHelper.rectanglesCounter >= seriesAnimationHelper.rectangles.length)
    			updateAnimationHelper(seriesAnimationHelper.finalCheckBoundaries, seriesAnimationHelper.finalHandler,
    					seriesAnimationHelper.finalMessageCode);
    		else
    			updateAnimationHelper(seriesAnimationHelper.rectangles[seriesAnimationHelper.rectanglesCounter]);
    		invalidate();
    	}
    	else
    		isAnimating = false;
    	
    	
    }
}
