/*
 * 
 */
package com.topimagesystems.data;


import android.content.Context;
import android.content.SharedPreferences;

// TODO: Auto-generated Javadoc
/**
 * The Class Preferences.
 */
public class Preferences {

	/** The m instance. */
	private static Preferences mInstance;
	
	/** The m preferences. */
	private SharedPreferences mPreferences;
	
	/** The Constant PREF_FILE_NAME. */
	public static final String PREF_FILE_NAME = "Prefs_filename";
	
	/** The Constant PREF_IS_DONT_SHOW_INFO. */
	public static final String PREF_IS_DONT_SHOW_INFO = "PREF_IS_DONT_SHOW_INFO";
	
	/**
	 * Instantiates a new preferences.
	 *
	 * @param context the context
	 */
	private Preferences(Context context) {
		mPreferences = context.getSharedPreferences(PREF_FILE_NAME, Context.MODE_PRIVATE);
	}

	// TODO: check for syncronize
	/**
	 * Gets the single instance of Preferences.
	 *
	 * @param context the context
	 * @return single instance of Preferences
	 */
	public static Preferences getInstance(Context context) {
		if (mInstance == null) {
			mInstance = new Preferences(context.getApplicationContext());
		}

		return mInstance;
	}
	
	/**
	 * Sets the checks if is dont show info checked.
	 *
	 * @param isTermsApproved the new checks if is dont show info checked
	 */
	public void setIsDontShowInfoChecked(boolean isNoInfoDisplay)
	{
		SharedPreferences.Editor editor=mPreferences.edit();
		editor.putBoolean(PREF_IS_DONT_SHOW_INFO, isNoInfoDisplay);
		editor.commit();
	}

	/**
	 * Gets the checks if is terms approved.
	 *
	 * @return the checks if is terms approved
	 */
	public boolean getIsNoInfoDisplay()
	{
		return mPreferences.getBoolean(PREF_IS_DONT_SHOW_INFO, false);
	}

}
