/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Point;
import android.hardware.Camera;
import android.hardware.Camera.PictureCallback;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.view.SurfaceHolder;

import com.topimagesystems.Common;
import com.topimagesystems.camera.CameraConfigurationManagerNew;
import com.topimagesystems.camera.OpenCamera;
import com.topimagesystems.camera.OpenCameraInterface;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.HintIndicator;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent.SessionType;
import com.topimagesystems.intent.CaptureIntent.TISDocumentType;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;

import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

import java.io.IOException;

// TODO: Auto-generated Javadoc
/**
 * The Class CameraSessionManager.
 */

public final class CameraSessionManager {

	/** The Constant TAG. */
	private static final String TAG = Logger.makeLogTag("CameraSessionManager");

	/** The max size error. */
	private static float MAX_SIZE_ERROR = 0.045f; // Size error relatively to
	// image size
	/** The max position error. */
	private static float MAX_POSITION_ERROR = 0.045f; // Center position error
	// relatively to image
	// size
	/** The left to right error. */
	private static float LEFT_TO_RIGHT_ERROR = 0.035f;

	/** The max position width error. */
	private static float MAX_POSITION_WIDTH_ERROR = 0.07f;

	/** The max position height error. */
	private static float MAX_POSITION_HEIGHT_ERROR = 0.07f;

	/** The has focus. */
	public static boolean hasFocus = false;
	private int matchRectsCounter = 0;

	private float videoFrameRectFoundAR = 0.4f;
	private float prevRectToCurrentAR = 0.6f;
	public static int IDENTICAL_RECTS_TO_CAPTURE = 3;
	static double M_PI = 3.14159265358979323846264338327950288;
	private int requestedCameraId = OpenCameraInterface.NO_REQUESTED_CAMERA;
	private OpenCamera cameraInstance;


	public Rect rectTocompare;
	boolean isFlashOn  = false;

	/**
	 * The Enum State.
	 */
	public static enum State {

		/** The none. */
		NONE,
		/** The preview. */
		PREVIEW,
		/** The capturing image. */
		CAPTURING_IMAGE,
		/** The success. */
		SUCCESS,
		/** The done. */
		DONE
	}

	//
	/**
	 * The Enum SizeIndicator.
	 */
	public enum SizeIndicator {

		/** The smaller. */
		SMALLER(-1),
		/** The bigger. */
		BIGGER(1),
		/** The match. */
		MATCH(0);

		/** The id. */
		public int id;

		/**
		 * Instantiates a new size indicator.
		 *
		 * @param id
		 *            the id
		 */
		private SizeIndicator(int id) {
			this.id = id;
		}

		/**
		 * Instance of.
		 *
		 * @param id
		 *            the id
		 * @return the size indicator
		 */
		public static SizeIndicator instanceOf(int id) {
			if (SMALLER.id == id) {
				return SMALLER;
			} else if (BIGGER.id == id) {
				return BIGGER;
			} else if (MATCH.id == id) {
				return MATCH;
			}
			return SMALLER;
		}
	};

	//
	/** The instance. */
	private static CameraSessionManager instance;

	/** The state. */
	private State state = State.NONE;

	/** The context. */
	private final Context context;

	/** The config manager. */
	public  CameraConfigurationManager configManager;


	private final CameraConfigurationManagerNew configManagerNew;

	/** The camera. */
	private Camera camera;

	/** The video rect. */
	private Rect videoRect;

	/** The initialized. */
	private boolean initialized;

	/** The previewing. */
	private boolean previewing;

	/** The valid check boundaries rect. */
	private CheckBoundaries validCheckBoundariesRect;

	/** The min boundary x. */
	private int minBoundaryX;

	/** The max boundary x. */
	private int maxBoundaryX;

	/** The min boundary y. */
	private int minBoundaryY;

	/** The max boundary y. */
	private int maxBoundaryY;
	// private float minAspectRatio;
	// private float maxAspectRatio;
	/** The minimum ratio height width. */
	private float minimumRatioHeightWidth;

	/** The max ratio height width. */
	private float maxRatioHeightWidth;

	/** The preview callback. */
	public final PreviewCallback previewCallback;


	/** The error callback. */
	private final ErrorCallback errorCallback;

	/** The periodic auto focus callback. */
	private final PeriodicAutoFocusCallback periodicAutoFocusCallback;

	/** The buffer size. */
	private int bufferSize;

	/** The is debug. */
	private boolean isDebug = CameraManagerController.isDebug;

	/**
	 * Inits the.
	 *
	 * @param context
	 *            the context
	 * @param boundariesRect
	 *            the boundaries rect
	 * @param minimumRatioHeightWidth
	 *            the minimum ratio height width
	 * @param maxRatioHeightWidth
	 *            the max ratio height width
	 */
	public static void init(Activity context, CheckBoundaries boundariesRect, float minimumRatioHeightWidth, float maxRatioHeightWidth) {
		if (instance == null) {
			instance = new CameraSessionManager(context, boundariesRect, minimumRatioHeightWidth, maxRatioHeightWidth);

		}
		if (CameraManagerController.enableSoftCaptureAndImageAligment || CameraManagerController.sessionType == SessionType.PORTRAIT) {
			MAX_SIZE_ERROR = 0.3f; // Size error relatively to
			// image size
			MAX_POSITION_ERROR = 0.2f; // Center position error
			// relatively to image
			// size
			LEFT_TO_RIGHT_ERROR = 0.17f;
			MAX_POSITION_WIDTH_ERROR = 0.3f;
			MAX_POSITION_HEIGHT_ERROR = 0.07f;

		}

	}

	/**
	 * Gets the single instance of CameraSessionManager.
	 *
	 * @return single instance of CameraSessionManager
	 */
	public static CameraSessionManager getInstance() {
		return instance;
	}

	/**
	 * Clear camera session manager.
	 */
	public static void clearCameraSessionManager() {
		instance = null;
	}

	/**
	 * Instantiates a new camera session manager.
	 *
	 * @param context
	 *            the context
	 * @param boundariesRect
	 *            the boundaries rect
	 * @param minimumRatioHeightWidth
	 *            the minimum ratio height width
	 * @param maxRatioHeightWidth
	 *            the max ratio height width
	 */


	private CameraSessionManager(Activity context, CheckBoundaries boundariesRect, float minimumRatioHeightWidth, float maxRatioHeightWidth) {

		this.context = context;
		this.configManager = new CameraConfigurationManager(context);
		this.validCheckBoundariesRect = boundariesRect;
		this.previewCallback = new PreviewCallback(configManager);
		this.periodicAutoFocusCallback = new PeriodicAutoFocusCallback();
		this.errorCallback = new ErrorCallback();
		this.minimumRatioHeightWidth = minimumRatioHeightWidth;
		this.maxRatioHeightWidth = maxRatioHeightWidth;
		this.configManagerNew = new CameraConfigurationManagerNew(context);



		// LEFT_TO_RIGHT_ERROR =
		// Float.valueOf(context.getResources().getString(R.string.left_right_hint_trashold));
		// MAX_POSITION_WIDTH_ERROR =
		// Float.valueOf(context.getResources().getString(R.string.move_lower_higher_trashold));
		// LEFT_TO_RIGHT_ERROR =
		// Float.valueOf(context.getResources().getString(R.string.move_top_bottom_document_trashold));
	}

	/**
	 * Inits the min max bounderies.
	 */
	private void initMinMaxBounderies() { // set the screen with and height size
		minBoundaryX = Math.max(0, validCheckBoundariesRect.getMinBoundaryX(true));
		maxBoundaryX = Math.min(getScreenResolution().x, validCheckBoundariesRect.getMaxBoundaryX(true));
		minBoundaryY = Math.max(0, validCheckBoundariesRect.getMinBoundaryY(true));
		maxBoundaryY = Math.min(getScreenResolution().y, validCheckBoundariesRect.getMaxBoundaryY(true));
		// float aspectRatio =
		// validCheckBoundariesRect.getValidationRect().width/validCheckBoundariesRect.getValidationRect().height;
		// minAspectRatio = aspectRatio*(1-MAX_ASPECT_RATIO_ERROR);
		// maxAspectRatio = aspectRatio*(1+MAX_ASPECT_RATIO_ERROR);
	}

	boolean compareRects(Rect currentRect, Rect rectToCompare, float aspectRatio) {
		if (rectToCompare == null) {
			return false;
		}
		if (CameraManagerController.sessionType == SessionType.PORTRAIT || CameraManagerController.imageType == TISDocumentType.FULL_PAGE){
			if (rectToCompare.width > rectToCompare.height){
				int tmp = rectToCompare.width;
				rectToCompare.width = rectToCompare.height;
				rectToCompare.height = tmp;
			}
		}
		float widthDiffMax = currentRect.width * (1 + aspectRatio);
		float HeightDiffMax = currentRect.height * (1 + aspectRatio);
		float xDiffMax = currentRect.x * (1 + aspectRatio);
		float yDiffMax = currentRect.y * (1 + aspectRatio);
		if (widthDiffMax > rectToCompare.size().width || HeightDiffMax > rectToCompare.size().height) {
			if (rectToCompare.x != 0 && rectToCompare.y != 0) {
				if ( (CameraManagerController.sessionType == SessionType.PORTRAIT || CameraManagerController.imageType == TISDocumentType.FULL_PAGE) && currentRect.width > currentRect.height){
					if (xDiffMax < rectToCompare.x && yDiffMax < rectToCompare.y) { // if sesison in portrait and the doc on landscape we need to
						return false;
					}
				}
				if (xDiffMax < rectToCompare.x || yDiffMax < rectToCompare.y) {
					return false;
				}

			}
			return true;
		}
		return false;
	}

	/**
	 * Gets the check boundaries rect.
	 *
	 * @return the check boundaries rect
	 */
	public CheckBoundaries getCheckBoundariesRect() {
		return validCheckBoundariesRect;
	}

	public void setCheckBoundariesRect(Rect rect) {
		validCheckBoundariesRect.setValidationRect(rect);
	}

	public void resetRectComapreCounter() {
		matchRectsCounter = 0;
	}

	public int getMatchRectsCounter() {
		return matchRectsCounter;
	}

	/**
	 * Open camera.
	 *
	 * @param holder
	 *            the holder
	 * @param isTorchOn
	 *            the is torch on
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */


	public void openCamera(SurfaceHolder holder, boolean isTorchOn) throws IOException {
		try {
			if (camera == null) {
				Logger.i(TAG, "openCamera Camera was null");
				camera = Camera.open();
				if (camera == null) {
					throw new IOException();
				}
			} else {
				Logger.i(TAG, "openCamera Camera not null dont open");
			}

			camera.setPreviewDisplay(holder);

			// init the screen size for creating the rect
			initialized = true;
			configManager.initFromCameraParameters(camera);
			initMinMaxBounderies();
			configManager.setDesiredCameraParameters(camera, isTorchOn);

			/* Now allocate the buffer */
			Camera.Parameters parameters = camera.getParameters();
			bufferSize = parameters.getPreviewSize().width * parameters.getPreviewSize().height;
			bufferSize = bufferSize * ImageFormat.getBitsPerPixel(parameters.getPreviewFormat());
		} catch (Exception e) {

			Logger.e(TAG, "Failed open camera");
		}

		// point = UIUtils.getCameraPreviewResolution(context,
		// camera.getParameters());
	}
	public void openCamera2Api(boolean isTorchOn){
		initialized = true;
		configManager.initFromCameraParameters(camera);
		initMinMaxBounderies();
		configManager.setDesiredCameraParameters(camera, isTorchOn);



	}


	/**
	 * Opens the camera driver and initializes the hardware parameters.
	 *
	 * @param holder The surface object which the camera will draw preview frames into.
	 * @throws IOException Indicates the camera driver failed to open.
	 */
	public synchronized void openDriver(SurfaceHolder holder) throws IOException {
		Log.e(TAG, "openDriver for camera");
		//if (cameraInstance == null) {
			cameraInstance = OpenCameraInterface.open(requestedCameraId);
			if (cameraInstance == null) {
				throw new IOException("Camera.open() failed to return object from driver");
			}
			camera = cameraInstance.getCamera();
	//	}

		if (!initialized) {
			initialized = true;
			configManagerNew.initFromCameraParameters(cameraInstance);
//			if (requestedFramingRectWidth > 0 && requestedFramingRectHeight > 0) {
//				setManualFramingRect(requestedFramingRectWidth, requestedFramingRectHeight);
//				requestedFramingRectWidth = 0;
//				requestedFramingRectHeight = 0;
//			}
		}

		Camera cameraObject = cameraInstance.getCamera();
		Camera.Parameters parameters = cameraObject.getParameters();
		String parametersFlattened = parameters == null ? null : parameters.flatten(); // Save these, temporarily
		try {
			configManagerNew.setDesiredCameraParameters(cameraInstance, false,configManager);

		} catch (RuntimeException re) {
			// Driver failed
			Log.w(TAG, "Camera rejected parameters. Setting only minimal safe-mode parameters");
			Log.i(TAG, "Resetting to saved camera params: " + parametersFlattened);
			// Reset:
			if (parametersFlattened != null) {
				parameters = cameraObject.getParameters();
				initMinMaxBounderies();
				parameters.unflatten(parametersFlattened);
				try {
					cameraObject.setParameters(parameters);
					configManagerNew.setDesiredCameraParameters(cameraInstance, true,configManager);
				} catch (RuntimeException re2) {
					// Well, darn. Give up
					Log.w(TAG, "Camera rejected even safe-mode parameters! No configuration");
				}
			}
		}
		cameraObject.setPreviewDisplay(holder);

	}

	/**
	 * Close camera.
	 */

	public void closeCamera() {
		Logger.i(TAG, "closeCamera");

//		if (CameraManagerController.useCameraAPI2 && CameraController.getInstance().camera2Instance!= null){
//			CameraController.getInstance().camera2Instance.closeSession();
//			return;
//		}
		if (camera != null) {

			FlashlightManager.disableFlashlight();
			camera.release();
			previewCallback.release();
			camera = null;
			videoRect = null;
		}
	}

	/**
	 * Start preview.
	 *
	 * @param isTorchOn
	 *            the is torch on
	 */
	public void startPreview(boolean isTorchOn) {
		Logger.i(TAG, "startPreview");
		if (CameraManagerController.useCameraAPI2 && CameraController.getInstance().camera2Instance!= null){
			PreviewCallback.processingVideo = false;
			CameraController.getInstance().camera2Instance.startCamera();
			return;
		}
		if (camera != null && !previewing) {
			state = State.PREVIEW;
			//configManager.setDesiredCameraParameters(camera, isTorchOn);
			if (isTorchOn){
				Camera.Parameters p = camera.getParameters();
				p.setFlashMode(Camera.Parameters.FLASH_MODE_TORCH);
				camera.setParameters(p);
				isFlashOn = true;
			}
			else if(!isTorchOn && isFlashOn){
				Camera.Parameters p = camera.getParameters();
				p.setFlashMode(Camera.Parameters.FLASH_MODE_OFF);
				camera.setParameters(p);
			}

			camera.startPreview();
			previewing = true;
		}
	}

	/**
	 * Stop preview.
	 */
	public void stopPreview() {
		if (CameraManagerController.useCameraAPI2){
			CameraController.getInstance().camera2Instance.closeSession();
			return;
		}
		Logger.i(TAG, "stopPreview");
		if (camera != null && previewing) {
			camera.stopPreview();
			previewCallback.release();
			periodicAutoFocusCallback.setHandler(null, 0);
			previewing = false;
		}
	}

	/**
	 * Stop preview only.
	 */
	public void stopPreviewOnly() {
	if (CameraManagerController.useCameraAPI2) {
		CameraController.getInstance().camera2Instance.closeSession();
	}
	else {
		if (camera != null && previewing) {
			camera.stopPreview();
		}
	  }
	}

	/**
	 * Sets the state.
	 *
	 * @param state
	 *            the new state
	 */
	public void setState(State state) {
		this.state = state;
	}

	public State getState() {
		return state;
	}

	/**
	 * single preview frame.
	 *
	 * @param cameraController
	 *            the camera controller
	 * @param mobiCHECKOCR
	 *            the mobi checkocr
	 */

	public void requestPreviewFrame(CameraController cameraController, MobiCHECKOCR mobiCHECKOCR) {
		// Logger.i(TAG, "requestPreviewFrame");
		state = State.PREVIEW;
		if (camera != null && previewing) {
			previewCallback.setActivity(cameraController, mobiCHECKOCR, null, bufferSize);
			errorCallback.setHandler(cameraController.getHandler(), CameraTypes.MESSAGE_ERROR);
			camera.setErrorCallback(errorCallback);
			camera.setOneShotPreviewCallback(previewCallback);
			camera.setErrorCallback(errorCallback);
		}
	}

	/** The taking picture. */
	boolean takingPicture = false;

	/**
	 * Request capture still image.
	 *
	 * @param handler
	 *            the handler
	 * @param message
	 *            the message
	 * @param captureMode
	 *            the capture mode
	 */
	@SuppressWarnings("deprecation")
	public void requestCaptureStillImage(final Handler handler, final int message, final CaptureMode captureMode) {
//		if (FileUtils.isSamsungS5()) {
//			Logger.i(TAG, "requestCaptureStillImage");
//			// activity can be finishing and camer will be closed at that point
//			if (camera == null)
//				return;
//			SystemClock.sleep(CameraConfigurationManager.TAKE_PICTURE_INTERVAL);
//			takePicture(handler, message, captureMode);
//			return;
//		}

		// stopAutoFocus(handler);
		if (CameraManagerController.useCameraAPI2){
			CameraController.getInstance().camera2Instance.takePicture();
		}
		else {
			camera.autoFocus(new Camera.AutoFocusCallback() {
				@SuppressLint("NewApi")
				@Override
				public void onAutoFocus(boolean paramBoolean, Camera cameraParameter) {
					try {

						Logger.i(TAG, "on Auto focus");
						if (CameraManagerController.isDebug) {
							FileUtils.addToLogFile("focus mode passed? ", paramBoolean ? "PASS" : "FAIL", context);
						}

						// }

						hasFocus = false;
						Logger.i(TAG, "taking stills");
						SystemClock.sleep(CameraConfigurationManager.TAKE_PICTURE_INTERVAL);
						takePicture(handler, message, captureMode);

					} catch (Exception e) {

						final String errorMessageText = StringUtils.dynamicString(context, "failedToTakePicture");
						Logger.e(TAG, errorMessageText, e);
						Message errorMessage = handler.obtainMessage(CameraTypes.MESSAGE_ERROR);
						errorMessage.obj = errorMessageText;
						errorMessage.sendToTarget();
					}
				}

			});
		}
	}



	/**
	 * Take picture.
	 *
	 * @param handler
	 *            the handler
	 * @param message
	 *            the message
	 * @param captureMode
	 *            the capture mode
	 */
	private void takePicture(final Handler handler, final int message, final CaptureMode captureMode) {
		startPreview(true);
		state = State.CAPTURING_IMAGE;
		camera.setPreviewCallback(null);
		try {
			Logger.i(TAG, "takePicture");
			camera.takePicture(null, null, new PictureCallbackImpl(handler, message, captureMode));
		} catch (Exception e) {
			if (FileUtils.getDeviceName().contains("WIKO")) {
				return;
			}
			final String errorMessageText = StringUtils.dynamicString(context, "failedToTakePicture");
			Logger.e(TAG, errorMessageText, e);
			Message errorMessage = handler.obtainMessage(CameraTypes.MESSAGE_ERROR);
			errorMessage.obj = errorMessageText;
			errorMessage.sendToTarget();
		}
	}

	public void startStillsFlow(Mat image){
		Imgproc.cvtColor(image, image, Imgproc.COLOR_BGR2RGB);
		Logger.e(TAG, "onPictureTaken");
		boolean isFront = true;
		Point cameraResolution = configManager.getCameraCaptureResolution();
		byte[] data = FileUtils.convertJpgMatToByte(image,1);
		if (CameraController.getInstance().getHandler() != null) {

			if (data != null) {
				if (CameraManagerController.sessionType == SessionType.TEST) {
				//	new StoreDataTask().execute(data);
				} else {
					Message message = CameraController.getInstance().getHandler().obtainMessage(CameraTypes.MESSAGE_PROCESS_CAPTURED_IMAGE);

					if (CameraManagerController.getOcrAnalyzeSession(context).captureMode == CaptureMode.FRONT) {
						SessionResultParams.originalFront = data;
						isFront = true;
					} else {
						SessionResultParams.originalBack = data;
						isFront = false;
					}
					String filePath = PreviewCallback.getImagePath(isFront);
					message.obj = filePath;
					message.arg1 = cameraResolution.x;
					message.arg2 = cameraResolution.y;
					message.sendToTarget();
					//handler = null;
				}
				// we can't send captured image's bytes in handler too much
				// data
				// new StoreDataTask().execute(data);

			} else {
				Logger.d(TAG, "In picture callback, received data is null");
				data = null;
			//	handler = null;
			}
		} else {
			Logger.d(TAG, "In picture callback, handler is null");
		}


	}

	/**
	 *	
	 *
	 */
	class PictureCallbackImpl implements PictureCallback {

		/** The handler. */
		private Handler handler;

		/** The capture message. */
		private int captureMessage;

		/** The capture mode. */
		private CaptureMode captureMode;

		/** The camera resolution. */
		private Point cameraResolution;

		/**
		 * Instantiates a new picture callback impl.
		 *
		 * @param handler
		 *            the handler
		 * @param captureMessage
		 *            the capture message
		 * @param captureMode
		 *            the capture mode
		 */
		public PictureCallbackImpl(Handler handler, int captureMessage, CaptureMode captureMode) {
			this.handler = handler;
			this.captureMessage = captureMessage;
			this.captureMode = captureMode;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see android.hardware.Camera.PictureCallback#onPictureTaken(byte[],
		 * android.hardware.Camera)
		 */
		@Override
		public void onPictureTaken(byte[] data, Camera paramCamera) {

			Logger.i(TAG, "onPictureTaken");
			boolean isFront = true;
			cameraResolution = configManager.getCameraCaptureResolution();

			if (handler != null) {

				if (data != null) {
					if (CameraManagerController.sessionType == SessionType.TEST) {
						new StoreDataTask().execute(data);
					} else {
						Message message = handler.obtainMessage(captureMessage);

						if (CameraManagerController.getOcrAnalyzeSession(context).captureMode == CaptureMode.FRONT) {
							SessionResultParams.originalFront = data;
							isFront = true;
						} else {
							SessionResultParams.originalBack = data;
							isFront = false;
						}
						String filePath = PreviewCallback.getImagePath(isFront);																																					
						message.obj = filePath;
						message.arg1 = CameraConfigurationManager.videoResolutionWidth;
						message.arg2 = CameraConfigurationManager.videoResolutionHeight;
						message.sendToTarget();
						handler = null;
					}
					// we can't send captured image's bytes in handler too much
					// data
					// new StoreDataTask().execute(data);

				} else {
					Logger.d(TAG, "In picture callback, received data is null");
					data = null;
					handler = null;
				}
			} else {
				Logger.d(TAG, "In picture callback, handler is null");
			}

		}



		/**
		 * The Class StoreDataTask.
		 */
		private class StoreDataTask extends AsyncTask<byte[], Void, String> {

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.os.AsyncTask#doInBackground(java.lang.Object[])
			 */
			protected String doInBackground(byte[]... data) {
				return FileUtils.storeByteArrayImageInTempFolder(context, data[0], "capturedImage_" + captureMode.name(), isDebug);
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see android.os.AsyncTask#onPostExecute(java.lang.Object)
			 */
			protected void onPostExecute(String imagePath) {
				Message message = handler.obtainMessage(captureMessage);
				message.obj = imagePath;
				message.arg1 = cameraResolution.x;
				message.arg2 = cameraResolution.y;
				message.sendToTarget();
				handler = null;
			}
		}
	}

	/**
	 * Request auto focus.
	 *
	 * @param handler
	 *            the handler
	 * @param message
	 *            the message
	 */
	public void requestAutoFocus(Handler handler, int message) {
		if (CameraController.captureStillStarted) {
			return;
		}
		try {
			if (CameraManagerController.useCameraAPI2){

			}
			periodicAutoFocusCallback.setHandler(handler, message);
			camera.autoFocus(periodicAutoFocusCallback);
		} catch (Exception e) {
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("requestAutoFocus Callback auto focus Error: ", e.getMessage().toString(), context);
			}
			Logger.e(TAG, "requestAutoFocus Callback auto focus Error");
		}
		// take automatic focus
		//disablwe auto focus interval!
		if (CameraManagerController.ocrType != Common.OCRType.OFF || CameraManagerController.isBlurEnabled || CameraController.captureStillStarted || CameraController.processStart) {
			periodicAutoFocusCallback.setHandler(handler, 0);
		}

		// }
	}

	/**
	 * Gets the video rect.
	 *
	 * @return the video rect
	 */
	public Rect getVideoRect() {
		if (videoRect == null) {
//			if (!CameraManagerController.useCameraAPI2 && camera == null) {
//				return null;
//			}
		//	final Point cameraResolution = configManager.getCameraPreviewResolution();
			videoRect = new Rect(0, 0, CameraConfigurationManager.videoResolutionWidth,CameraConfigurationManager.videoResolutionHeight);
		}
		return videoRect;
	}

	/**
	 * Gets the screen resolution.
	 *
	 * @return the screen resolution
	 */
	public Point getScreenResolution() {
		return configManager.getScreenResolution();
	}

	/**
	 * Gets the camera.
	 *
	 * @return the camera
	 */
	public Camera getCamera() {
		return camera;
	}

	/**
	 * The Class CheckInPLaceResult.
	 */
	public static class CheckInPLaceResult {

		/** The hint indicator. */
		HintIndicator hintIndicator;

		/** The is in place. */
		boolean isInPlace;
	}

	/**
	 * Checks if is debug.
	 *
	 * @return true, if is debug
	 */
	public boolean isDebug() {
		return isDebug;
	}

	/**
	 * Custom view instructions.
	 *
	 * @param comapredTo
	 *            the comapred to
	 * @param rectfond
	 *            the rectfond
	 * @param widthTrashHold
	 *            the width trash hold
	 * @param heightTrashHold
	 *            the height trash hold
	 * @param yTrashHold
	 *            the y trash hold
	 * @return the check in p lace result
	 */
	public CheckInPLaceResult customViewInstructions(Rect comapredTo, Rect rectfond, double widthTrashHold, double heightTrashHold, double yTrashHold) {
		CheckInPLaceResult result = new CheckInPLaceResult();
		if (rectfond.width == 0 || rectfond.height == 0) {
			result.hintIndicator = HintIndicator.Align;
			result.isInPlace = false;
			return result;
		}
		// if ((Math.abs(comapredTo.width - rectfond.width) > widthTrashHold *
		// comapredTo.width)) {
		// Logger.i(TAG, "fail on rectfond.width");
		// result.hintIndicator = HintIndicator.ZoomOut;
		// result.isInPlace = false;
		// return result;
		// }
		if ((Math.abs(comapredTo.height - rectfond.height) > heightTrashHold * comapredTo.height)) {
			Logger.i(TAG, "fail on rectfond.height");
			result.hintIndicator = HintIndicator.ZoomIn;
			result.isInPlace = false;
			return result;
		}

		if ((Math.abs(comapredTo.y - rectfond.y) > yTrashHold * comapredTo.y)) {
			Logger.i(TAG, "fail on rectfond.y");
			result.hintIndicator = HintIndicator.Align;
			result.isInPlace = false;
			return result;
		}
		result.hintIndicator = HintIndicator.Hold;
		result.isInPlace = true;
		return result;
	}

	/**
	 * Portrait view instructions.
	 *
	 * @param validCheckRect
	 *            the valid check rect
	 * @param checkRect
	 *            the check rect
	 * @return the check in p lace result
	 */

	public CheckInPLaceResult portraitCustomViewInstructions(Rect validCheckRect, Rect checkRect) {
		double widthTrahHold = 1.45;
		double heightTrahHold = 1.25;
		CheckInPLaceResult result = new CheckInPLaceResult();
		if (checkRect.width == 0 || checkRect.height == 0) {
			Logger.i(TAG, "fail on found rectangle is 0");
			result.hintIndicator = HintIndicator.Align;
			result.isInPlace = false;
			return result;
		}

		if ((checkRect.y * heightTrahHold < validCheckRect.y)) {
			Logger.i(TAG, "fail on rectfond.y");
			result.hintIndicator = HintIndicator.CheckToTop;
			result.isInPlace = false;
			return result;
		}

		if (checkRect.y > validCheckRect.y * heightTrahHold) {
			Logger.i(TAG, "fail on rectfond.y");
			result.hintIndicator = HintIndicator.CheckToBottom;
			result.isInPlace = false;
			return result;
		}
		if (checkRect.width * heightTrahHold < validCheckRect.width) {
			Logger.i(TAG, "fail on rectfond.height");
			result.hintIndicator = HintIndicator.ZoomIn;
			result.isInPlace = false;
			return result;
		}
		if (checkRect.width > validCheckRect.width * heightTrahHold) {
			Logger.i(TAG, "fail on rectfond.height");
			result.hintIndicator = HintIndicator.ZoomOut;
			result.isInPlace = false;
			return result;
		}

		if (checkRect.x > validCheckRect.x * widthTrahHold) {
			Logger.i(TAG, "fail on rectfond.x");
			result.hintIndicator = HintIndicator.CheckToRight;
			result.isInPlace = false;
			return result;
		}

		if (checkRect.x * widthTrahHold < validCheckRect.x) {
			Logger.i(TAG, "fail on rectfond.x");
			result.hintIndicator = HintIndicator.CheckToLeft;
			result.isInPlace = false;
			return result;
		}

		result.hintIndicator = HintIndicator.Align;
		result.isInPlace = true;
		return result;

	}

	public CheckInPLaceResult portraitViewInstructions(Rect validCheckRect, Rect checkRect) {
		double widthTrahHold = 0.2;
		double heightTrahHold = 0.15;
		// valid.height*=2;
		// valid.width*=2;

		float sizeCorrection = 2.0f;
		if (CameraManagerController.sessionType == SessionType.PORTRAIT)
			sizeCorrection = 1.2f;

		float fixedHeight = validCheckRect.height * sizeCorrection;
		float fixedY = validCheckRect.y * sizeCorrection;

		CheckInPLaceResult result = new CheckInPLaceResult();
		if (checkRect.width == 0 || checkRect.height == 0) {
			Logger.e(TAG, "fail on found rectangle is 0");
			result.hintIndicator = HintIndicator.Align;
			result.isInPlace = false;
			return result;
		}

		if (fixedHeight - checkRect.height > heightTrahHold * fixedHeight) {
			Logger.e(TAG, "fail on rectfond.height");
			result.hintIndicator = HintIndicator.ZoomIn;
			result.isInPlace = false;
			return result;
		}
		if (checkRect.height - fixedHeight > heightTrahHold * fixedHeight) {
			Logger.e(TAG, "fail on rectfond.height");
			result.hintIndicator = HintIndicator.ZoomOut;
			result.isInPlace = false;
			return result;
		}

		if ((fixedY - checkRect.y > (0.1 * fixedY)) && CameraManagerController.imageType == TISDocumentType.FULL_PAGE) {
			Logger.e(TAG, "fail on rectfond.y");
			result.hintIndicator = HintIndicator.CheckToTop;
			result.isInPlace = false;
			return result;
		}

		if (checkRect.y - fixedY > 0.1 * fixedY && CameraManagerController.imageType == TISDocumentType.FULL_PAGE) {
			Logger.e(TAG, "fail on rectfond.y");
			result.hintIndicator = HintIndicator.CheckToBottom;
			result.isInPlace = false;
			return result;
		}

		result.hintIndicator = HintIndicator.Align;
		result.isInPlace = true;
		return result;
	}

	// /
	/**
	 * Checks if is check in place.
	 *
	 * @param checkRect
	 *            the check rect
	 * @param sizeIndicator
	 *            the size indicator
	 * @param width
	 *            the width
	 * @param height
	 *            the height
	 * @return the check in p lace result
	 */
	public static HintIndicator validateImageOreintation(float[] firstPoint, float[] secondPoint, float[] thirdPoint, float[] forthPoint, float trashold) {
		double angleTopLine = calAngleBetweenPoints(firstPoint, thirdPoint);
		double angleBottomLine = calAngleBetweenPoints(secondPoint, forthPoint);
		if (CameraManagerController.isDebug) {
			Logger.i(TAG, "angleTopLine is " + angleTopLine);
			Logger.i(TAG, "angleBottomLine is " + angleBottomLine);
		}
		if (Math.abs(angleTopLine) < trashold && Math.abs(angleBottomLine) < trashold) {
			return HintIndicator.Hold;
		}
		if (angleTopLine < 0) {
			return HintIndicator.RotateLeft;
		} else {
			return HintIndicator.RotateRight;
		}

	}

	public static double calAngleBetweenPoints(float[] first, float[] second) {
		float heigth1 = (second[1] - first[1]);
		float width1 = (second[0] - first[0]);
		float rads = (float) Math.atan2(heigth1, width1);
		return (180.0 * rads / M_PI);
	}

	public CheckInPLaceResult isCheckInPlace(Rect checkRect, int sizeIndicator, int width, int height) {

		CheckInPLaceResult result = new CheckInPLaceResult();

		Rect validCheckRect = validCheckBoundariesRect.getValidationRect(); // screenAndVideoRatioHeight
		Logger.i(TAG, "Rect Found is " + " width " + checkRect.width + " height " + checkRect.height + " x " + checkRect.x + " y " + checkRect.y);
		Logger.i(TAG, "validCheckRect is " + " width " + validCheckRect.width + " height " + validCheckRect.height + " x " + validCheckRect.x + " y " + validCheckRect.y);

		if (CameraManagerController.isDynamicCapture) {
			Rect scaleCheckRect = new Rect();
			scaleCheckRect.width = (int) (checkRect.width * CameraConfigurationManager.screenAndVideoRatioWidth);
			scaleCheckRect.height = (int) (checkRect.height * CameraConfigurationManager.screenAndVideoRatioHeight);
			scaleCheckRect.x = (int) (checkRect.x * CameraConfigurationManager.screenAndVideoRatioWidth);
			scaleCheckRect.y = (int) (checkRect.y * CameraConfigurationManager.screenAndVideoRatioHeight);				
//			if (CameraManagerController.sessionType == SessionType.PORTRAIT) {
//				videoFrameRectFoundAR = 0.6f;
//				prevRectToCurrentAR = 0.5f;
//			}
			if (CameraManagerController.getOcrAnalyzeSession(context).captureMode == CaptureMode.BACK){
				prevRectToCurrentAR = 0.7f; // water shade algo has issues with white images
			}



			if (compareRects(scaleCheckRect, CameraConfigurationManager.getScreenRect(), videoFrameRectFoundAR)) {
				if (compareRects(scaleCheckRect, rectTocompare, prevRectToCurrentAR)) {

					matchRectsCounter++;
					result.isInPlace = false;
					rectTocompare.height = scaleCheckRect.height;
					rectTocompare.width = scaleCheckRect.width;
					rectTocompare.x = scaleCheckRect.x;
					rectTocompare.y = scaleCheckRect.y;
					result.hintIndicator = HintIndicator.Hold;
					result.isInPlace = true;
					
					if (!CameraManagerController.isStillMode && matchRectsCounter < IDENTICAL_RECTS_TO_CAPTURE) {
						result.isInPlace = false;
					}
					return result;
				} else {
					if (rectTocompare == null || rectTocompare.height == 0) {
						rectTocompare = scaleCheckRect;
					}

					result.hintIndicator = HintIndicator.None;
					result.isInPlace = false;
					matchRectsCounter = 0;
				}
			} else {
				matchRectsCounter = 0;
				result.hintIndicator = HintIndicator.ZoomIn;
				result.isInPlace = false;
			}
			return result;

		}
		Logger.i(TAG, "validCheckRect is " + " width " + validCheckRect.width + " height " + validCheckRect.height + " x " + validCheckRect.x + " y " + validCheckRect.y);
		if (CameraManagerController.imageType == TISDocumentType.CUSTOM || CameraManagerController.imageType == TISDocumentType.FULL_PAGE) {
			return portraitCustomViewInstructions(validCheckRect, checkRect);
		}
	
		SizeIndicator validCheckSize = SizeIndicator.instanceOf(sizeIndicator);
		boolean isCheckSize = (validCheckSize == SizeIndicator.MATCH);

		final float checkWidth = checkRect.width; // calculate the check width
		// base on screen
		// resolution.
		final float checkHeight = checkRect.height; // // calculate the check
		// height base on screen
		// resolution.
		final float centerX = (checkRect.x + checkRect.width) / 2;
		final float centerY = (checkRect.y + checkRect.height) / 2;

		final float checkWidthValidation = validCheckRect.width; // calculate
		// the check
		// width
		// base on
		// screen
		// resolution.
		final float checkHeightValidation = validCheckRect.height;
		final float centerXValidation = (validCheckRect.x + validCheckRect.width) / 2;
		final float centerYValidation = (validCheckRect.y + validCheckRect.height) / 2;

		final float aspectRatio = checkHeight / checkWidth;
		final float szErrMin = 1 - MAX_SIZE_ERROR;
		final float szErrMax = 1 + MAX_SIZE_ERROR;

		Logger.i(TAG, "prev: centerX: |" + centerX + "-" + width / 2.0f + "|<" + (MAX_POSITION_ERROR * (float) width));
		// final boolean isCenterX = Math.abs(centerX - width / 2.0f) <
		// (MAX_POSITION_ERROR * (float) width);

		final boolean isCenterX = centerX < ((1 + MAX_POSITION_ERROR) * centerXValidation); // calculate

		Logger.i(TAG, "prev: centerY: |" + centerY + "-" + height / 2.0f + "|<" + (MAX_POSITION_ERROR * (validCheckRect.x - validCheckRect.width / 2)));// calculate

		// place
		final boolean isCenterY = centerY < ((1 + MAX_POSITION_ERROR) * centerYValidation);
		// double checkHeightBuffer = CameraManagerController.scanFrontOnly ?
		// checkHeight : checkHeight + validCheckRect.height*0.1;
		final boolean isWidthOK = (checkWidthValidation > checkWidth * szErrMin) && (checkWidth < checkWidthValidation * szErrMax);
		final boolean isHeightOK = (checkHeight > checkHeightValidation * szErrMin) && (checkHeight < checkHeightValidation * szErrMax);
		Logger.i(TAG, "prev: aspect: " + aspectRatio + " [" + minimumRatioHeightWidth + "; " + maxRatioHeightWidth + "]");
		final boolean isAspectOK = (aspectRatio > minimumRatioHeightWidth) && (aspectRatio < maxRatioHeightWidth);
		boolean isInPlace = isCenterX && isCenterY && (isWidthOK || isHeightOK) && isAspectOK;
		boolean resultInPlaceFound = false;
		Logger.i(TAG, "prev: isInPlace=" + isInPlace);

		HintIndicator hintIndicator = HintIndicator.None;
		if (!isCheckSize && !resultInPlaceFound) {
			if (centerX == 0 && centerY == 0) { // if didn't find rectangle show
				// default Align as default
				// value.
				hintIndicator = hintIndicator.Align;
			} else {
				hintIndicator = (validCheckSize == SizeIndicator.BIGGER) ? HintIndicator.ZoomOut : HintIndicator.ZoomIn;
			}
		}
		if (CameraManagerController.imageType == TISDocumentType.CUSTOM) {
			LEFT_TO_RIGHT_ERROR = 0.12f;
		}
		if (CameraManagerController.deviceName.equals("LGE Nexus 4") || CameraManagerController.deviceName.equals("Samsung Nexus S")) {
			LEFT_TO_RIGHT_ERROR = 0.17f;
			MAX_POSITION_WIDTH_ERROR = 0.8f;
			MAX_POSITION_WIDTH_ERROR = LEFT_TO_RIGHT_ERROR;
		}

		if (centerY != 0 && centerX != 0) {
			resultInPlaceFound = false; // get the hint with trashold of 5%
			 if (centerX > (1 + LEFT_TO_RIGHT_ERROR) * centerXValidation) {
				hintIndicator = HintIndicator.CheckToRight;
			} else if (centerX < (1 - LEFT_TO_RIGHT_ERROR) * centerXValidation) {
				hintIndicator = HintIndicator.CheckToLeft;
			} else if (centerY < (1 - MAX_POSITION_HEIGHT_ERROR) * centerYValidation) {
				hintIndicator = HintIndicator.CheckToTop;
			} else if (centerY > (1 + MAX_POSITION_HEIGHT_ERROR) * centerYValidation) {
				hintIndicator = HintIndicator.CheckToBottom;
				if (checkWidth < checkWidthValidation * (1 - MAX_POSITION_WIDTH_ERROR)) {
					hintIndicator = HintIndicator.ZoomIn;
				} else if (checkWidth > (1 + MAX_POSITION_WIDTH_ERROR) * checkWidthValidation) {
					hintIndicator = HintIndicator.ZoomOut;
				}
			} else {
				resultInPlaceFound = true;
			}
		}

		Logger.i(TAG, "sizeIndicator:" + isInPlace);
		result.hintIndicator = hintIndicator;
		result.isInPlace = isInPlace && resultInPlaceFound;// && sizeIndicator;
		if (result.isInPlace && !CameraSessionManager.hasFocus && FileUtils.isSamsungS5()) {
			// requestAutoFocus(CameraController.getInstance().getHandler(),
			// CameraTypes.MESSAGE_AUTO_FOCUS);
		}
		return result;
	}

}