/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.micr;

import android.os.Bundle;
import com.topimagesystems.micr.JNIResultBase;

public class OCRResult
extends JNIResultBase {
    public int digitalRowLength;
    public String ocrResultWithDelimiter;
    public String ocrRawResult;
    public String scoreResult;
    public int meanDigitHeight;
    public boolean isValidRead;

    public OCRResult() {
    }

    public OCRResult(int _digitalRowLength, String _ocrResultWithDelimiter, String _ocrRawResult, int _meanDigitHeight) {
        this.digitalRowLength = _digitalRowLength;
        this.ocrResultWithDelimiter = _ocrResultWithDelimiter;
        this.scoreResult = _ocrRawResult;
        this.meanDigitHeight = _meanDigitHeight;
        this.isValidRead = true;
    }

    public OCRResult(Bundle bundle) {
        this.digitalRowLength = bundle.getInt("digitalRowLength");
        this.ocrResultWithDelimiter = bundle.getString("ocrResultWithDelimiter");
        this.ocrRawResult = bundle.getString("ocrRawResult");
        this.scoreResult = bundle.getString("scoreResult");
        this.meanDigitHeight = bundle.getInt("meanDigitHeight");
    }

    public OCRResult(OCRResult result) {
        this.digitalRowLength = result.digitalRowLength;
        this.ocrResultWithDelimiter = result.ocrResultWithDelimiter;
        this.ocrRawResult = result.ocrRawResult;
        this.scoreResult = result.scoreResult;
        this.meanDigitHeight = result.meanDigitHeight;
        this.isValidRead = result.isValidRead;
    }

    public OCRResult(String[] ocrDataArray) {
        if (ocrDataArray.length != 4) {
            return;
        }
        this.digitalRowLength = Integer.valueOf(ocrDataArray[0]);
        this.ocrResultWithDelimiter = ocrDataArray[1];
        this.ocrRawResult = ocrDataArray[2];
        this.scoreResult = ocrDataArray[3];
        this.isValidRead = true;
        this.meanDigitHeight = 0;
    }

    @Override
    public String toString() {
        return "OCRResult [digitalRowLength=" + this.digitalRowLength + ", ocrResultWithDelimiter=" + this.ocrResultWithDelimiter + ", ocrRawResult=" + this.ocrRawResult + ", scoreResult=" + this.scoreResult + ", meanDigitHeight=" + this.meanDigitHeight + "]";
    }

    public Bundle toBundle() {
        Bundle result = new Bundle();
        result.putInt("digitalRowLength", this.digitalRowLength);
        result.putString("ocrResultWithDelimiter", this.ocrResultWithDelimiter);
        result.putString("ocrRawResult", this.ocrRawResult);
        result.putString("scoreResult", this.scoreResult);
        result.putInt("meanDigitHeight", this.meanDigitHeight);
        return result;
    }
}

