/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.data;

import android.os.Parcel;
import android.os.Parcelable;

public class TISStaticCaptureSettings
implements Parcelable {
    public static final float MAX_SIZE_ERROR = 0.045f;
    public static final float MAX_POSITION_ERROR = 0.045f;
    public static final float LEFT_TO_RIGHT_ERROR = 0.035f;
    public static final float MAX_POSITION_WIDTH_ERROR = 0.07f;
    public static final float MAX_POSITION_HEIGHT_ERROR = 0.07f;
    public static final float MAX_SIZE_ERROR_PORTRAIT = 0.3f;
    public static final float MAX_POSITION_ERROR_PORTRAIT = 0.2f;
    public static final float LEFT_TO_RIGHT_ERROR_PORTRAIT = 0.17f;
    public static final float MAX_POSITION_WIDTH_ERROR_PORTRAIT = 0.3f;
    public static final float MAX_POSITION_HEIGHT_ERROR_PORTRAIT = 0.07f;
    private float maxHeightErrorFromCenterOfTheScreen;
    private float maxWidthErrorFromCenterOfTheScreen;
    private float moveLeftAndRightAR;
    private float moveLowerAR;
    private float moveTopAndBottomAR;
    public static final Parcelable.Creator<TISStaticCaptureSettings> CREATOR = new Parcelable.Creator<TISStaticCaptureSettings>(){

        public TISStaticCaptureSettings createFromParcel(Parcel in) {
            return new TISStaticCaptureSettings(in);
        }

        public TISStaticCaptureSettings[] newArray(int size) {
            return new TISStaticCaptureSettings[size];
        }
    };

    public TISStaticCaptureSettings() {
        this(true);
    }

    private TISStaticCaptureSettings(boolean isSoftCaptureOrPortrait) {
        if (isSoftCaptureOrPortrait) {
            this.maxHeightErrorFromCenterOfTheScreen = 0.3f;
            this.maxWidthErrorFromCenterOfTheScreen = 0.2f;
            this.moveLeftAndRightAR = 0.17f;
            this.moveLowerAR = 0.3f;
            this.moveTopAndBottomAR = 0.07f;
        }
    }

    protected TISStaticCaptureSettings(Parcel in) {
        this.maxHeightErrorFromCenterOfTheScreen = in.readFloat();
        this.maxWidthErrorFromCenterOfTheScreen = in.readFloat();
        this.moveLeftAndRightAR = in.readFloat();
        this.moveLowerAR = in.readFloat();
        this.moveTopAndBottomAR = in.readFloat();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.maxHeightErrorFromCenterOfTheScreen);
        dest.writeFloat(this.maxWidthErrorFromCenterOfTheScreen);
        dest.writeFloat(this.moveLeftAndRightAR);
        dest.writeFloat(this.moveLowerAR);
        dest.writeFloat(this.moveTopAndBottomAR);
    }

    public float getMaxHeightErrorFromCenterOfTheScreen() {
        return this.maxHeightErrorFromCenterOfTheScreen;
    }

    public float getMaxWidthErrorFromCenterOfTheScreen() {
        return this.maxWidthErrorFromCenterOfTheScreen;
    }

    public float getMoveLeftAndRightAR() {
        return this.moveLeftAndRightAR;
    }

    public void setMoveLeftAndRightAR(float moveLeftAndRightAR) {
        this.maxWidthErrorFromCenterOfTheScreen = this.maxHeightErrorFromCenterOfTheScreen * (this.maxWidthErrorFromCenterOfTheScreen / this.moveLeftAndRightAR);
        this.moveLeftAndRightAR = moveLeftAndRightAR;
    }

    public float getMoveLowerAR() {
        return this.moveLowerAR;
    }

    public void setMoveLowerAR(float moveLowerAR) {
        this.moveLowerAR = moveLowerAR;
    }

    public float getMoveTopAndBottomAR() {
        return this.moveTopAndBottomAR;
    }

    public void setMoveTopAndBottomAR(float moveTopAndBottomAR) {
        this.maxHeightErrorFromCenterOfTheScreen *= moveTopAndBottomAR / this.moveTopAndBottomAR;
        this.moveTopAndBottomAR = moveTopAndBottomAR;
    }
}

