/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.view.SurfaceHolder;
import com.topimagesystems.Common;
import com.topimagesystems.camera.CameraConfigurationManagerNew;
import com.topimagesystems.camera.OpenCamera;
import com.topimagesystems.camera.OpenCameraInterface;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.controllers.imageanalyze.ErrorCallback;
import com.topimagesystems.controllers.imageanalyze.FlashlightManager;
import com.topimagesystems.controllers.imageanalyze.PeriodicAutoFocusCallback;
import com.topimagesystems.controllers.imageanalyze.PreviewCallback;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import java.io.IOException;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

public final class CameraSessionManager {
    private static final String TAG = Logger.makeLogTag("CameraSessionManager");
    public static boolean hasFocus = false;
    private int matchRectsCounter = 0;
    static double M_PI = Math.PI;
    private int requestedCameraId = -1;
    private OpenCamera cameraInstance;
    public Rect rectTocompare;
    private static CameraSessionManager instance;
    private State state = State.NONE;
    private final Context context;
    public CameraConfigurationManager configManager;
    private final CameraConfigurationManagerNew configManagerNew;
    private Camera camera;
    private Rect videoRect;
    private boolean initialized;
    private boolean previewing;
    private CheckBoundaries validCheckBoundariesRect;
    private int minBoundaryX;
    private int maxBoundaryX;
    private int minBoundaryY;
    private int maxBoundaryY;
    private float minimumRatioHeightWidth;
    private float maxRatioHeightWidth;
    public final PreviewCallback previewCallback;
    private final ErrorCallback errorCallback;
    private final PeriodicAutoFocusCallback periodicAutoFocusCallback;
    private int bufferSize;
    private boolean isDebug = CameraManagerController.isDebug;
    private static TISDynamicCaptureSettings dynamicCaptureSettings;
    private static TISStaticCaptureSettings staticCaptureSettings;
    boolean takingPicture = false;

    public static void init(Activity context, CheckBoundaries boundariesRect, float minimumRatioHeightWidth, float maxRatioHeightWidth) {
        if (instance == null) {
            instance = new CameraSessionManager(context, boundariesRect, minimumRatioHeightWidth, maxRatioHeightWidth);
        }
        dynamicCaptureSettings = new TISDynamicCaptureSettings(CameraManagerController.enableSoftCaptureAndImageAligment ? CameraManagerController.softCaptureThreshold : 0.0f);
        staticCaptureSettings = new TISStaticCaptureSettings(CameraManagerController.enableSoftCaptureAndImageAligment || CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT, CameraManagerController.enableSoftCaptureAndImageAligment ? CameraManagerController.softCaptureThreshold : 0.0f);
    }

    public static CameraSessionManager getInstance() {
        return instance;
    }

    public static void clearCameraSessionManager() {
        instance = null;
    }

    private CameraSessionManager(Activity context, CheckBoundaries boundariesRect, float minimumRatioHeightWidth, float maxRatioHeightWidth) {
        this.context = context;
        this.configManager = new CameraConfigurationManager(context);
        this.validCheckBoundariesRect = boundariesRect;
        this.previewCallback = new PreviewCallback(this.configManager);
        this.periodicAutoFocusCallback = new PeriodicAutoFocusCallback();
        this.errorCallback = new ErrorCallback();
        this.minimumRatioHeightWidth = minimumRatioHeightWidth;
        this.maxRatioHeightWidth = maxRatioHeightWidth;
        this.configManagerNew = new CameraConfigurationManagerNew((Context)context);
    }

    private void initMinMaxBounderies() {
        this.minBoundaryX = Math.max(0, this.validCheckBoundariesRect.getMinBoundaryX(true));
        this.maxBoundaryX = Math.min(this.getScreenResolution().x, this.validCheckBoundariesRect.getMaxBoundaryX(true));
        this.minBoundaryY = Math.max(0, this.validCheckBoundariesRect.getMinBoundaryY(true));
        this.maxBoundaryY = Math.min(this.getScreenResolution().y, this.validCheckBoundariesRect.getMaxBoundaryY(true));
    }

    private boolean compareRects(Rect currentRect, Rect rectToCompare, float aspectRatio) {
        if (rectToCompare == null) {
            return false;
        }
        if ((CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT || CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE) && rectToCompare.width > rectToCompare.height) {
            int tmp = rectToCompare.width;
            rectToCompare.width = rectToCompare.height;
            rectToCompare.height = tmp;
        }
        float widthDiffMax = (float)currentRect.width * (1.0f + aspectRatio);
        float HeightDiffMax = (float)currentRect.height * (1.0f + aspectRatio);
        float xDiffMax = (float)currentRect.x * (1.0f + aspectRatio);
        float yDiffMax = (float)currentRect.y * (1.0f + aspectRatio);
        if ((double)widthDiffMax > rectToCompare.size().width || (double)HeightDiffMax > rectToCompare.size().height) {
            if (rectToCompare.x != 0 && rectToCompare.y != 0) {
                if ((CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT || CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE) && currentRect.width > currentRect.height && xDiffMax < (float)rectToCompare.x && yDiffMax < (float)rectToCompare.y) {
                    return false;
                }
                if (xDiffMax < (float)rectToCompare.x || yDiffMax < (float)rectToCompare.y) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public CheckBoundaries getCheckBoundariesRect() {
        return this.validCheckBoundariesRect;
    }

    public void setCheckBoundariesRect(Rect rect) {
        this.validCheckBoundariesRect.setValidationRect(rect);
    }

    public void resetRectComapreCounter() {
        this.matchRectsCounter = 0;
    }

    public int getMatchRectsCounter() {
        return this.matchRectsCounter;
    }

    public void openCamera(SurfaceHolder holder, boolean isTorchOn) throws IOException {
        try {
            if (this.camera == null) {
                Logger.i(TAG, "openCamera Camera was null");
                this.camera = Camera.open();
                if (this.camera == null) {
                    throw new IOException();
                }
            } else {
                Logger.i(TAG, "openCamera Camera not null dont open");
            }
            this.camera.setPreviewDisplay(holder);
            this.initialized = true;
            this.configManager.initFromCameraParameters(this.camera);
            this.initMinMaxBounderies();
            this.configManager.setDesiredCameraParameters(this.camera, isTorchOn);
            Camera.Parameters parameters = this.camera.getParameters();
            this.bufferSize = parameters.getPreviewSize().width * parameters.getPreviewSize().height;
            this.bufferSize *= ImageFormat.getBitsPerPixel((int)parameters.getPreviewFormat());
        }
        catch (Exception e) {
            Logger.e(TAG, "Failed open camera");
        }
    }

    public void openCamera2Api(boolean isTorchOn) {
        this.initialized = true;
        this.configManager.initFromCameraParameters(this.camera);
        this.initMinMaxBounderies();
        this.configManager.setDesiredCameraParameters(this.camera, isTorchOn);
    }

    public synchronized void openDriver(SurfaceHolder holder) throws IOException {
        Camera cameraObject;
        block7: {
            Camera.Parameters parameters;
            Log.e((String)TAG, (String)"openDriver for camera");
            if (this.cameraInstance == null) {
                this.cameraInstance = OpenCameraInterface.open(this.requestedCameraId);
                if (this.cameraInstance == null) {
                    throw new IOException("Camera.open() failed to return object from driver");
                }
                this.camera = this.cameraInstance.getCamera();
            }
            if (!this.initialized) {
                this.initialized = true;
                this.configManagerNew.initFromCameraParameters(this.cameraInstance);
            }
            String parametersFlattened = (parameters = (cameraObject = this.cameraInstance.getCamera()).getParameters()) == null ? null : parameters.flatten();
            try {
                this.configManagerNew.setDesiredCameraParameters(this.cameraInstance, false, this.configManager);
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Camera rejected parameters. Setting only minimal safe-mode parameters");
                Log.i((String)TAG, (String)("Resetting to saved camera params: " + parametersFlattened));
                if (parametersFlattened == null) break block7;
                parameters = cameraObject.getParameters();
                this.initMinMaxBounderies();
                parameters.unflatten(parametersFlattened);
                try {
                    cameraObject.setParameters(parameters);
                    this.configManagerNew.setDesiredCameraParameters(this.cameraInstance, true, this.configManager);
                }
                catch (RuntimeException re2) {
                    Log.w((String)TAG, (String)"Camera rejected even safe-mode parameters! No configuration");
                }
            }
        }
        cameraObject.setPreviewDisplay(holder);
    }

    public void closeCamera() {
        Logger.i(TAG, "closeCamera");
        if (this.camera != null) {
            FlashlightManager.disableFlashlight();
            this.camera.release();
            this.previewCallback.release();
            this.camera = null;
            this.videoRect = null;
        }
    }

    public void startPreview(boolean isTorchOn) {
        Logger.i(TAG, "startPreview");
        if (CameraManagerController.useCameraAPI2 && CameraController.getInstance().camera2Instance != null) {
            PreviewCallback.processingVideo = false;
            CameraController.getInstance().camera2Instance.startCamera();
            return;
        }
        if (this.camera != null && !this.previewing) {
            this.state = State.PREVIEW;
            this.camera.startPreview();
            this.previewing = true;
        }
    }

    public void stopPreview() {
        if (CameraManagerController.useCameraAPI2) {
            CameraController.getInstance().camera2Instance.closeSession();
            return;
        }
        Logger.i(TAG, "stopPreview");
        if (this.camera != null && this.previewing) {
            this.camera.stopPreview();
            this.previewCallback.release();
            this.periodicAutoFocusCallback.setHandler(null, 0);
            this.previewing = false;
        }
    }

    public void stopPreviewOnly() {
        if (CameraManagerController.useCameraAPI2) {
            CameraController.getInstance().camera2Instance.closeSession();
        } else if (this.camera != null && this.previewing) {
            this.camera.stopPreview();
        }
    }

    public void setState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public void requestPreviewFrame(CameraController cameraController, MobiCHECKOCR mobiCHECKOCR) {
        this.state = State.PREVIEW;
        if (this.camera != null && this.previewing) {
            this.previewCallback.setActivity(cameraController, mobiCHECKOCR, null, this.bufferSize);
            this.errorCallback.setHandler(cameraController.getHandler(), 18);
            this.camera.setErrorCallback((Camera.ErrorCallback)this.errorCallback);
            this.camera.setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            this.camera.setErrorCallback((Camera.ErrorCallback)this.errorCallback);
        }
    }

    public void requestCaptureStillImage(final Handler handler, final int message, final CameraTypes.CaptureMode captureMode) {
        if (CameraManagerController.useCameraAPI2) {
            CameraController.getInstance().camera2Instance.takePicture();
        } else {
            this.camera.autoFocus(new Camera.AutoFocusCallback(){

                @SuppressLint(value={"NewApi"})
                public void onAutoFocus(boolean paramBoolean, Camera cameraParameter) {
                    try {
                        Logger.i(TAG, "on Auto focus");
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("focus mode passed? ", paramBoolean ? "PASS" : "FAIL", CameraSessionManager.this.context);
                        }
                        hasFocus = false;
                        Logger.i(TAG, "taking stills");
                        SystemClock.sleep((long)CameraConfigurationManager.TAKE_PICTURE_INTERVAL);
                        CameraSessionManager.this.takePicture(handler, message, captureMode);
                    }
                    catch (Exception e) {
                        String errorMessageText = StringUtils.dynamicString(CameraSessionManager.this.context, "failedToTakePicture");
                        Logger.e(TAG, errorMessageText, e);
                        Message errorMessage = handler.obtainMessage(18);
                        errorMessage.obj = errorMessageText;
                        errorMessage.sendToTarget();
                    }
                }
            });
        }
    }

    private void takePicture(Handler handler, int message, CameraTypes.CaptureMode captureMode) {
        this.startPreview(true);
        this.state = State.CAPTURING_IMAGE;
        this.camera.setPreviewCallback(null);
        try {
            Logger.i(TAG, "takePicture");
            this.camera.takePicture(null, null, (Camera.PictureCallback)new PictureCallbackImpl(handler, message, captureMode));
        }
        catch (Exception e) {
            String errorMessageText = StringUtils.dynamicString(this.context, "failedToTakePicture");
            Logger.e(TAG, errorMessageText, e);
            Message errorMessage = handler.obtainMessage(18);
            errorMessage.obj = errorMessageText;
            errorMessage.sendToTarget();
        }
    }

    public void startStillsFlow(Mat image) {
        Imgproc.cvtColor((Mat)image, (Mat)image, (int)4);
        Logger.e(TAG, "onPictureTaken");
        boolean isFront = true;
        CameraSessionManager cameraSessionManager = this;
        Point cameraResolution = cameraSessionManager.configManager.getCameraCaptureResolution();
        byte[] data = FileUtils.convertJpgMatToByte(image, 1.0f);
        if (CameraController.getInstance().getHandler() != null) {
            if (data != null) {
                if (CameraManagerController.sessionType != CaptureIntent.SessionType.TEST) {
                    Message message = CameraController.getInstance().getHandler().obtainMessage(8);
                    if (CameraManagerController.getOcrAnalyzeSession((Context)this.context).captureMode == CameraTypes.CaptureMode.FRONT) {
                        SessionResultParams.originalFront = data;
                        isFront = true;
                    } else {
                        SessionResultParams.originalBack = data;
                        isFront = false;
                    }
                    String filePath = PreviewCallback.getImagePath(isFront);
                    message.obj = filePath;
                    message.arg1 = cameraResolution.x;
                    message.arg2 = cameraResolution.y;
                    message.sendToTarget();
                }
            } else {
                Logger.d(TAG, "In picture callback, received data is null");
                data = null;
            }
        } else {
            Logger.d(TAG, "In picture callback, handler is null");
        }
    }

    public void requestAutoFocus(Handler handler, int message) {
        if (CameraController.captureStillStarted) {
            return;
        }
        try {
            if (CameraManagerController.useCameraAPI2) {
                // empty if block
            }
            this.periodicAutoFocusCallback.setHandler(handler, message);
            this.camera.autoFocus((Camera.AutoFocusCallback)this.periodicAutoFocusCallback);
        }
        catch (Exception e) {
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile("requestAutoFocus Callback auto focus Error: ", e.getMessage().toString(), this.context);
            }
            Logger.e(TAG, "requestAutoFocus Callback auto focus Error");
        }
        if (CameraManagerController.ocrType != Common.OCRType.OFF || CameraManagerController.isBlurEnabled || CameraController.captureStillStarted || CameraController.processStart) {
            this.periodicAutoFocusCallback.setHandler(handler, 0);
        }
    }

    public Rect getVideoRect() {
        if (this.videoRect == null) {
            this.videoRect = new Rect(0, 0, CameraConfigurationManager.videoResolutionWidth, CameraConfigurationManager.videoResolutionHeight);
        }
        return this.videoRect;
    }

    public Point getScreenResolution() {
        return this.configManager.getScreenResolution();
    }

    public Camera getCamera() {
        return this.camera;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public CheckInPLaceResult customViewInstructions(Rect comapredTo, Rect rectfond, double widthTrashHold, double heightTrashHold, double yTrashHold) {
        CheckInPLaceResult result = new CheckInPLaceResult();
        if (rectfond.width == 0 || rectfond.height == 0) {
            result.hintIndicator = CameraTypes.HintIndicator.Align;
            result.isInPlace = false;
            return result;
        }
        if ((double)Math.abs(comapredTo.height - rectfond.height) > heightTrashHold * (double)comapredTo.height) {
            Logger.i(TAG, "fail on rectfond.height");
            result.hintIndicator = CameraTypes.HintIndicator.ZoomIn;
            result.isInPlace = false;
            return result;
        }
        if ((double)Math.abs(comapredTo.y - rectfond.y) > yTrashHold * (double)comapredTo.y) {
            Logger.i(TAG, "fail on rectfond.y");
            result.hintIndicator = CameraTypes.HintIndicator.Align;
            result.isInPlace = false;
            return result;
        }
        result.hintIndicator = CameraTypes.HintIndicator.Hold;
        result.isInPlace = true;
        return result;
    }

    public CheckInPLaceResult portraitCustomViewInstructions(Rect validCheckRect, Rect checkRect) {
        double widthTrahHold = 1.45;
        double heightTrahHold = 1.25;
        CheckInPLaceResult result = new CheckInPLaceResult();
        if (checkRect.width == 0 || checkRect.height == 0) {
            Logger.i(TAG, "fail on found rectangle is 0");
            result.hintIndicator = CameraTypes.HintIndicator.Align;
            result.isInPlace = false;
            return result;
        }
        if ((double)checkRect.y * heightTrahHold < (double)validCheckRect.y) {
            Logger.i(TAG, "fail on rectfond.y");
            result.hintIndicator = CameraTypes.HintIndicator.CheckToTop;
            result.isInPlace = false;
            return result;
        }
        if ((double)checkRect.y > (double)validCheckRect.y * heightTrahHold) {
            Logger.i(TAG, "fail on rectfond.y");
            result.hintIndicator = CameraTypes.HintIndicator.CheckToBottom;
            result.isInPlace = false;
            return result;
        }
        if ((double)checkRect.width * heightTrahHold < (double)validCheckRect.width) {
            Logger.i(TAG, "fail on rectfond.height");
            result.hintIndicator = CameraTypes.HintIndicator.ZoomIn;
            result.isInPlace = false;
            return result;
        }
        if ((double)checkRect.width > (double)validCheckRect.width * heightTrahHold) {
            Logger.i(TAG, "fail on rectfond.height");
            result.hintIndicator = CameraTypes.HintIndicator.ZoomOut;
            result.isInPlace = false;
            return result;
        }
        if ((double)checkRect.x > (double)validCheckRect.x * widthTrahHold) {
            Logger.i(TAG, "fail on rectfond.x");
            result.hintIndicator = CameraTypes.HintIndicator.CheckToRight;
            result.isInPlace = false;
            return result;
        }
        if ((double)checkRect.x * widthTrahHold < (double)validCheckRect.x) {
            Logger.i(TAG, "fail on rectfond.x");
            result.hintIndicator = CameraTypes.HintIndicator.CheckToLeft;
            result.isInPlace = false;
            return result;
        }
        result.hintIndicator = CameraTypes.HintIndicator.Align;
        result.isInPlace = true;
        return result;
    }

    public CheckInPLaceResult portraitViewInstructions(Rect validCheckRect, Rect checkRect) {
        double widthTrahHold = 0.2;
        double heightTrahHold = 0.15;
        float sizeCorrection = 2.0f;
        if (CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
            sizeCorrection = 1.2f;
        }
        float fixedHeight = (float)validCheckRect.height * sizeCorrection;
        float fixedY = (float)validCheckRect.y * sizeCorrection;
        CheckInPLaceResult result = new CheckInPLaceResult();
        if (checkRect.width == 0 || checkRect.height == 0) {
            Logger.e(TAG, "fail on found rectangle is 0");
            result.hintIndicator = CameraTypes.HintIndicator.Align;
            result.isInPlace = false;
            return result;
        }
        if ((double)(fixedHeight - (float)checkRect.height) > heightTrahHold * (double)fixedHeight) {
            Logger.e(TAG, "fail on rectfond.height");
            result.hintIndicator = CameraTypes.HintIndicator.ZoomIn;
            result.isInPlace = false;
            return result;
        }
        if ((double)((float)checkRect.height - fixedHeight) > heightTrahHold * (double)fixedHeight) {
            Logger.e(TAG, "fail on rectfond.height");
            result.hintIndicator = CameraTypes.HintIndicator.ZoomOut;
            result.isInPlace = false;
            return result;
        }
        if ((double)(fixedY - (float)checkRect.y) > 0.1 * (double)fixedY && CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE) {
            Logger.e(TAG, "fail on rectfond.y");
            result.hintIndicator = CameraTypes.HintIndicator.CheckToTop;
            result.isInPlace = false;
            return result;
        }
        if ((double)((float)checkRect.y - fixedY) > 0.1 * (double)fixedY && CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE) {
            Logger.e(TAG, "fail on rectfond.y");
            result.hintIndicator = CameraTypes.HintIndicator.CheckToBottom;
            result.isInPlace = false;
            return result;
        }
        result.hintIndicator = CameraTypes.HintIndicator.Align;
        result.isInPlace = true;
        return result;
    }

    public static CameraTypes.HintIndicator validateImageOreintation(float[] firstPoint, float[] secondPoint, float[] thirdPoint, float[] forthPoint, float trashold) {
        double angleTopLine = CameraSessionManager.calAngleBetweenPoints(firstPoint, thirdPoint);
        double angleBottomLine = CameraSessionManager.calAngleBetweenPoints(secondPoint, forthPoint);
        if (CameraManagerController.isDebug) {
            Logger.i(TAG, "angleTopLine is " + angleTopLine);
            Logger.i(TAG, "angleBottomLine is " + angleBottomLine);
        }
        if (Math.abs(angleTopLine) < (double)trashold && Math.abs(angleBottomLine) < (double)trashold) {
            return CameraTypes.HintIndicator.Hold;
        }
        if (angleTopLine < 0.0) {
            return CameraTypes.HintIndicator.RotateLeft;
        }
        return CameraTypes.HintIndicator.RotateRight;
    }

    public static double calAngleBetweenPoints(float[] first, float[] second) {
        float heigth1 = second[1] - first[1];
        float width1 = second[0] - first[0];
        float rads = (float)Math.atan2(heigth1, width1);
        return 180.0 * (double)rads / M_PI;
    }

    public CheckInPLaceResult isCheckInPlace(Rect checkRect, int sizeIndicator, int width, int height) {
        CheckInPLaceResult result = new CheckInPLaceResult();
        Rect validCheckRect = this.validCheckBoundariesRect.getValidationRect();
        Logger.i(TAG, "Rect Found is  width " + checkRect.width + " height " + checkRect.height + " x " + checkRect.x + " y " + checkRect.y);
        Logger.i(TAG, "validCheckRect is  width " + validCheckRect.width + " height " + validCheckRect.height + " x " + validCheckRect.x + " y " + validCheckRect.y);
        if (CameraManagerController.isDynamicCapture) {
            Rect scaleCheckRect = new Rect();
            scaleCheckRect.width = (int)((float)checkRect.width * CameraConfigurationManager.screenAndVideoRatioWidth);
            scaleCheckRect.height = (int)((float)checkRect.height * CameraConfigurationManager.screenAndVideoRatioHeight);
            scaleCheckRect.x = (int)((float)checkRect.x * CameraConfigurationManager.screenAndVideoRatioWidth);
            scaleCheckRect.y = (int)((float)checkRect.y * CameraConfigurationManager.screenAndVideoRatioHeight);
            float prevRectToCurrentAR = CameraSessionManager.dynamicCaptureSettings.currentToPrevRectangleComparisonThreshold;
            if (CameraManagerController.getOcrAnalyzeSession((Context)this.context).captureMode == CameraTypes.CaptureMode.BACK && prevRectToCurrentAR > 0.7f) {
                prevRectToCurrentAR = 0.7f;
            }
            if (this.compareRects(scaleCheckRect, CameraConfigurationManager.getScreenRect(), CameraSessionManager.dynamicCaptureSettings.heightDistanceThreshold)) {
                if (this.compareRects(scaleCheckRect, this.rectTocompare, prevRectToCurrentAR)) {
                    ++this.matchRectsCounter;
                    result.isInPlace = false;
                    this.rectTocompare.height = scaleCheckRect.height;
                    this.rectTocompare.width = scaleCheckRect.width;
                    this.rectTocompare.x = scaleCheckRect.x;
                    this.rectTocompare.y = scaleCheckRect.y;
                    result.hintIndicator = CameraTypes.HintIndicator.Hold;
                    result.isInPlace = true;
                    if (!CameraManagerController.isStillMode && this.matchRectsCounter < CameraSessionManager.dynamicCaptureSettings.numberOfIdenticalRectsToCompareBeforeCapture) {
                        result.isInPlace = false;
                    }
                    return result;
                }
                if (this.rectTocompare == null || this.rectTocompare.height == 0) {
                    this.rectTocompare = scaleCheckRect;
                }
                result.hintIndicator = CameraTypes.HintIndicator.None;
                result.isInPlace = false;
                this.matchRectsCounter = 0;
            } else {
                this.matchRectsCounter = 0;
                result.hintIndicator = CameraTypes.HintIndicator.ZoomIn;
                result.isInPlace = false;
            }
            return result;
        }
        Logger.i(TAG, "validCheckRect is  width " + validCheckRect.width + " height " + validCheckRect.height + " x " + validCheckRect.x + " y " + validCheckRect.y);
        if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CUSTOM || CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE) {
            return this.portraitCustomViewInstructions(validCheckRect, checkRect);
        }
        SizeIndicator validCheckSize = SizeIndicator.instanceOf(sizeIndicator);
        boolean isCheckSize = validCheckSize == SizeIndicator.MATCH;
        float checkWidth = checkRect.width;
        float checkHeight = checkRect.height;
        float centerX = (checkRect.x + checkRect.width) / 2;
        float centerY = (checkRect.y + checkRect.height) / 2;
        float checkWidthValidation = validCheckRect.width;
        float checkHeightValidation = validCheckRect.height;
        float centerXValidation = (validCheckRect.x + validCheckRect.width) / 2;
        float centerYValidation = (validCheckRect.y + validCheckRect.height) / 2;
        float aspectRatio = checkHeight / checkWidth;
        float szErrMin = 1.0f - CameraSessionManager.staticCaptureSettings.yDistanceFromCenterScreen;
        float szErrMax = 1.0f + CameraSessionManager.staticCaptureSettings.yDistanceFromCenterScreen;
        Logger.i(TAG, "prev: centerX: |" + centerX + "-" + (float)width / 2.0f + "|<" + CameraSessionManager.staticCaptureSettings.xDistanceFromCenterScreen * (float)width);
        boolean isCenterX = centerX < (1.0f + CameraSessionManager.staticCaptureSettings.xDistanceFromCenterScreen) * centerXValidation;
        Logger.i(TAG, "prev: centerY: |" + centerY + "-" + (float)height / 2.0f + "|<" + CameraSessionManager.staticCaptureSettings.xDistanceFromCenterScreen * (float)(validCheckRect.x - validCheckRect.width / 2));
        boolean isCenterY = centerY < (1.0f + CameraSessionManager.staticCaptureSettings.yDistanceFromCenterScreen) * centerYValidation;
        boolean isWidthOK = checkWidthValidation > checkWidth * szErrMin && checkWidth < checkWidthValidation * szErrMax;
        boolean isHeightOK = checkHeight > checkHeightValidation * szErrMin && checkHeight < checkHeightValidation * szErrMax;
        Logger.i(TAG, "prev: aspect: " + aspectRatio + " [" + this.minimumRatioHeightWidth + "; " + this.maxRatioHeightWidth + "]");
        boolean isAspectOK = aspectRatio > this.minimumRatioHeightWidth && aspectRatio < this.maxRatioHeightWidth;
        boolean isInPlace = isCenterX && isCenterY && (isWidthOK || isHeightOK) && isAspectOK;
        boolean resultInPlaceFound = false;
        Logger.i(TAG, "prev: isInPlace=" + isInPlace);
        CameraTypes.HintIndicator hintIndicator = CameraTypes.HintIndicator.None;
        if (!isCheckSize && !resultInPlaceFound) {
            if (centerX == 0.0f && centerY == 0.0f) {
                hintIndicator = CameraTypes.HintIndicator.Align;
            } else {
                CameraTypes.HintIndicator hintIndicator2 = hintIndicator = validCheckSize == SizeIndicator.BIGGER ? CameraTypes.HintIndicator.ZoomOut : CameraTypes.HintIndicator.ZoomIn;
            }
        }
        if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CUSTOM) {
            CameraSessionManager.staticCaptureSettings.moveRight = 0.12f;
            CameraSessionManager.staticCaptureSettings.moveLeft = 0.12f;
        }
        if (CameraManagerController.deviceName.equals("LGE Nexus 4") || CameraManagerController.deviceName.equals("Samsung Nexus S")) {
            CameraSessionManager.staticCaptureSettings.moveRight = 0.17f;
            CameraSessionManager.staticCaptureSettings.zoomIn = CameraSessionManager.staticCaptureSettings.zoomOut = (CameraSessionManager.staticCaptureSettings.moveLeft = 0.17f);
        }
        if (centerY != 0.0f && centerX != 0.0f) {
            resultInPlaceFound = false;
            if (centerX > (1.0f + CameraSessionManager.staticCaptureSettings.moveRight) * centerXValidation) {
                hintIndicator = CameraTypes.HintIndicator.CheckToRight;
            } else if (centerX < (1.0f - CameraSessionManager.staticCaptureSettings.moveLeft) * centerXValidation) {
                hintIndicator = CameraTypes.HintIndicator.CheckToLeft;
            } else if (centerY < (1.0f - CameraSessionManager.staticCaptureSettings.moveTop) * centerYValidation) {
                hintIndicator = CameraTypes.HintIndicator.CheckToTop;
            } else if (centerY > (1.0f + CameraSessionManager.staticCaptureSettings.moveBottom) * centerYValidation) {
                hintIndicator = CameraTypes.HintIndicator.CheckToBottom;
                if (checkWidth < checkWidthValidation * (1.0f - CameraSessionManager.staticCaptureSettings.zoomIn)) {
                    hintIndicator = CameraTypes.HintIndicator.ZoomIn;
                } else if (checkWidth > (1.0f + CameraSessionManager.staticCaptureSettings.zoomOut) * checkWidthValidation) {
                    hintIndicator = CameraTypes.HintIndicator.ZoomOut;
                }
            } else {
                resultInPlaceFound = true;
            }
        }
        Logger.i(TAG, "sizeIndicator:" + isInPlace);
        result.hintIndicator = hintIndicator;
        boolean bl = result.isInPlace = isInPlace && resultInPlaceFound;
        if (!result.isInPlace || hasFocus || FileUtils.isSamsungS5()) {
            // empty if block
        }
        return result;
    }

    private static class TISStaticCaptureSettings {
        private static final float Y_DISTANCE_FROM_CENTER_SCREEN = 0.045f;
        public static final float X_DISTANCE_FROM_CENTER_SCREEN = 0.045f;
        public static final float MOVE_LEFT_AND_RIGHT = 0.035f;
        public static final float ZOOM_IN_AND_OUT = 0.07f;
        public static final float MOVE_BOTTOM_AND_TOP = 0.07f;
        public static final float Y_DISTANCE_FROM_CENTER_SCREEN_PORTRAIT = 0.3f;
        public static final float THRESHOLD_RATIO_Y_DISTANCE_FROM_CENTER_SCREEN_PORTRAIT = 0.3f;
        public static final float X_DISTANCE_FROM_CENTER_SCREEN_PORTRAIT = 0.2f;
        public static final float THRESHOLD_RATIO_X_DISTANCE_FROM_CENTER_SCREEN_PORTRAIT = 0.3f;
        public static final float MOVE_LEFT_AND_RIGHT_PORTRAIT = 0.17f;
        public static final float THRESHOLD_RATIO_MOVE_LEFT_AND_RIGHT_PORTRAIT = 0.3f;
        public static final float ZOOM_IN_AND_OUT_PORTRAIT = 0.3f;
        public static final float MAX_ZOOM_IN_AND_OUT_PORTRAIT = 0.3f;
        public static final float MOVE_BOTTOM_AND_TOP_PORTRAIT = 0.07f;
        public static final float THRESHOLD_RATIO_MOVE_BOTTOM_AND_TOP_PORTRAIT = 0.3f;
        float yDistanceFromCenterScreen;
        float xDistanceFromCenterScreen;
        float moveLeft;
        float moveRight;
        float zoomIn;
        float zoomOut;
        float moveBottom;
        float moveTop;

        TISStaticCaptureSettings(boolean isPortraitOrSoftCapture, float threshold) {
            if (isPortraitOrSoftCapture) {
                this.yDistanceFromCenterScreen = 0.3f + 0.3f * threshold * 0.3f;
                this.xDistanceFromCenterScreen = 0.2f + 0.2f * threshold * 0.3f;
                this.moveLeft = this.moveRight = 0.17f + threshold * 0.17f * 0.3f;
                this.moveTop = this.moveBottom = 0.07f + threshold * 0.07f * 0.3f;
                this.zoomOut = 0.3f + threshold * 0.3f * 0.3f;
                this.zoomIn = 0.3f - threshold * 0.3f / 0.3f;
            } else {
                this.yDistanceFromCenterScreen = 0.045f;
                this.xDistanceFromCenterScreen = 0.045f;
                this.moveRight = 0.035f;
                this.moveLeft = 0.035f;
                this.zoomOut = 0.07f;
                this.zoomIn = 0.07f;
                this.moveTop = 0.07f;
                this.moveBottom = 0.07f;
            }
        }
    }

    private static class TISDynamicCaptureSettings {
        private static final int NUM_OF_IDENTICAL_RECTANGLES = 3;
        private static final int MAX_NUM_OF_IDENTICAL_RECTANGLES = 5;
        private static final float HEIGHT_DISTANCE_THRESHOLD = 0.4f;
        private static final float MAX_HEIGHT_DISTANCE_THRESHOLD = 0.7f;
        private static final float CURRENT_PREV_COMPARISON_THRESHOLD = 0.6f;
        private static final float MAX_CURRENT_PREV_COMPARISON_THRESHOLD = 1.0f;
        int numberOfIdenticalRectsToCompareBeforeCapture;
        float heightDistanceThreshold;
        float currentToPrevRectangleComparisonThreshold;

        TISDynamicCaptureSettings(float threshold) {
            this.numberOfIdenticalRectsToCompareBeforeCapture = 3 + Math.round(threshold * 2.0f);
            this.heightDistanceThreshold = 0.4f + threshold * 0.29999998f;
            this.currentToPrevRectangleComparisonThreshold = 0.6f + threshold * 0.39999998f;
        }
    }

    public static class CheckInPLaceResult {
        CameraTypes.HintIndicator hintIndicator;
        boolean isInPlace;
    }

    class PictureCallbackImpl
    implements Camera.PictureCallback {
        private Handler handler;
        private int captureMessage;
        private CameraTypes.CaptureMode captureMode;
        private Point cameraResolution;

        public PictureCallbackImpl(Handler handler, int captureMessage, CameraTypes.CaptureMode captureMode) {
            this.handler = handler;
            this.captureMessage = captureMessage;
            this.captureMode = captureMode;
        }

        public void onPictureTaken(byte[] data, Camera paramCamera) {
            Logger.i(TAG, "onPictureTaken");
            boolean isFront = true;
            CameraSessionManager cameraSessionManager = CameraSessionManager.this;
            this.cameraResolution = cameraSessionManager.configManager.getCameraCaptureResolution();
            if (this.handler != null) {
                if (data != null) {
                    if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST) {
                        new StoreDataTask().execute((Object[])new byte[][]{data});
                    } else {
                        Message message = this.handler.obtainMessage(this.captureMessage);
                        if (CameraManagerController.getOcrAnalyzeSession((Context)((CameraSessionManager)CameraSessionManager.this).context).captureMode == CameraTypes.CaptureMode.FRONT) {
                            SessionResultParams.originalFront = data;
                            isFront = true;
                        } else {
                            SessionResultParams.originalBack = data;
                            isFront = false;
                        }
                        String filePath = PreviewCallback.getImagePath(isFront);
                        message.obj = filePath;
                        message.arg1 = CameraConfigurationManager.videoResolutionWidth;
                        message.arg2 = CameraConfigurationManager.videoResolutionHeight;
                        message.sendToTarget();
                        this.handler = null;
                    }
                } else {
                    Logger.d(TAG, "In picture callback, received data is null");
                    data = null;
                    this.handler = null;
                }
            } else {
                Logger.d(TAG, "In picture callback, handler is null");
            }
        }

        private class StoreDataTask
        extends AsyncTask<byte[], Void, String> {
            private StoreDataTask() {
            }

            protected String doInBackground(byte[] ... data) {
                return FileUtils.storeByteArrayImageInTempFolder(CameraSessionManager.this.context, data[0], "capturedImage_" + PictureCallbackImpl.this.captureMode.name(), CameraSessionManager.this.isDebug);
            }

            protected void onPostExecute(String imagePath) {
                Message message = PictureCallbackImpl.this.handler.obtainMessage(PictureCallbackImpl.this.captureMessage);
                message.obj = imagePath;
                message.arg1 = ((PictureCallbackImpl)PictureCallbackImpl.this).cameraResolution.x;
                message.arg2 = ((PictureCallbackImpl)PictureCallbackImpl.this).cameraResolution.y;
                message.sendToTarget();
                PictureCallbackImpl.this.handler = null;
            }
        }
    }

    public static enum SizeIndicator {
        SMALLER(-1),
        BIGGER(1),
        MATCH(0);

        public int id;

        private SizeIndicator(int id2) {
            this.id = id2;
        }

        public static SizeIndicator instanceOf(int id2) {
            if (SizeIndicator.SMALLER.id == id2) {
                return SMALLER;
            }
            if (SizeIndicator.BIGGER.id == id2) {
                return BIGGER;
            }
            if (SizeIndicator.MATCH.id == id2) {
                return MATCH;
            }
            return SMALLER;
        }
    }

    public static enum State {
        NONE,
        PREVIEW,
        CAPTURING_IMAGE,
        SUCCESS,
        DONE;

    }
}

