/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.camera;

import android.hardware.Camera;
import android.util.Log;
import com.topimagesystems.camera.CameraFacing;
import com.topimagesystems.camera.OpenCamera;

public final class OpenCameraInterface {
    private static final String TAG = OpenCameraInterface.class.getName();
    public static final int NO_REQUESTED_CAMERA = -1;

    private OpenCameraInterface() {
    }

    public static OpenCamera open(int cameraId) {
        Camera camera;
        int index;
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            Log.w((String)TAG, (String)"No cameras!");
            return null;
        }
        boolean explicitRequest = cameraId >= 0;
        Camera.CameraInfo selectedCameraInfo = null;
        for (index = 0; index < numCameras; ++index) {
            if (cameraId != -1 && index != cameraId) continue;
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)cameraInfo);
            CameraFacing reportedFacing = CameraFacing.values()[cameraInfo.facing];
            if (reportedFacing != CameraFacing.BACK) continue;
            selectedCameraInfo = cameraInfo;
            break;
        }
        if (index < numCameras) {
            Log.i((String)TAG, (String)("Opening camera #" + index));
            camera = Camera.open((int)index);
        } else if (explicitRequest) {
            Log.w((String)TAG, (String)("Requested camera does not exist: " + cameraId));
            camera = null;
        } else {
            Log.i((String)TAG, (String)("No camera facing " + (Object)((Object)CameraFacing.BACK) + "; returning camera #0"));
            camera = Camera.open((int)0);
            selectedCameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)selectedCameraInfo);
        }
        if (camera == null) {
            return null;
        }
        return new OpenCamera(index, camera, CameraFacing.values()[selectedCameraInfo.facing], selectedCameraInfo.orientation);
    }
}

