/*
 * 
 */
package com.topimagesystems.util;

import android.content.Context;
import android.content.Intent;

// TODO: Auto-generated Javadoc
/**
 * The Class ActivityUtil.
 */
public class ActivityUtil {
	
	/**
	 * Gets the activity class.
	 *
	 * @param clazz the clazz
	 * @return the activity class
	 */
	private static Class getActivityClass(Class clazz) {

	    // Check for extended activity
	    String extClassName = clazz.getName() + "Extended";
	    try {
	        Class extClass = Class.forName(extClassName);
	        return extClass;
	    } catch (ClassNotFoundException e) {
//	        e.printStackTrace();
	        // Extended class is not found return base
	        return clazz;
	    }
	}

	/**
	 * Creates the intent.
	 *
	 * @param context the context
	 * @param clazz the clazz
	 * @return the intent
	 */
	public static Intent createIntent(Context context, Class clazz) {
	    Class activityClass = getActivityClass(clazz);
	    return new Intent(context, activityClass);
	}
}
