/*
 * 
 */
package com.topimagesystems.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.RectF;
import android.os.Build;
import android.provider.Contacts.Intents.UI;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;

import com.topimagesystems.R;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.UserInterfaceUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class TwoUnitsLeveler.
 *
 * @author Boaz.Garty
 */
public class TwoUnitsLeveler extends ImageView {

    /** The is valid orintation. */
    private boolean isValidOrintation = false;
    
    /** The stroke width container. */
    private int strokeWidthContainer = 5;
    
    /** The stroke width inner. */
    private int strokeWidthInner = 5;
    
    /** The circle paint. */
    private Paint circlePaint;
    
    /** The rectangle paint container. */
    private Paint rectanglePaintContainer;
    
    /** The rectangle paint inner. */
    private Paint rectanglePaintInner;
    
    /** The leveler trashold. */
    private float levelerTrashold = 0.0470f;
    
    /** The leveler trashold side. */
    private float levelerTrasholdSide = 0.036f;
    
    /** The leveler trashold side vertical. */
    private float levelerTrasholdSideVertical = 0.02f;
    
    /** The convert pixels to accelerometer upper. */
    private float convertPixelsToAccelerometerUpper;
    
    /** The convert pixels to accelerometer side. */
    private float convertPixelsToAccelerometerSide;
    
    /** The valid orientation x. */
    private boolean validOrientationX;
    
    /** The valid orientation y. */
    private boolean validOrientationY;
    
    /** The main rectangle upper. */
    private RectF mainRectangleUpper;
    
    /** The validation rectangle upper. */
    private RectF validationRectangleUpper;
    
    /** The main rectangle side. */
    private RectF mainRectangleSide;
    
    /** The validation rectangle side. */
    private RectF validationRectangleSide;
    
    /** The leveler width. */
    private float levelerWidth = 25f; // width of the main rect.
    
    /** The is horizontal level. */
    private boolean isHorizontalLevel;
    
    /** The color orientation pass container. */
    private int colorOrientationPassContainer;
    
    /** The color orientation fail container. */
    private int colorOrientationFailContainer;

    /** The color orientation pass inner. */
    private int colorOrientationPassInner;
    
    /** The color orientation fail inner. */
    private int colorOrientationFailInner;

    /** The color orientation pass circle. */
    private int colorOrientationPassCircle;
    
    /** The color orientation fail circle. */
    private int colorOrientationFailCircle;
    
    /** The default padding left and right. */
    private float defaultPaddingLeftAndRight; // default main rect padding for left and right
    
    /** The default padding top and bottom. */
    private float defaultPaddingTopAndBottom;
    
    /** The location. */
    private int location;
    
    /** The is fade animation enable. */
    private boolean isFadeAnimationEnable;
    
    /** The is dragging enable. */
    private boolean isDraggingEnable;
    
    /** The context. */
    private Context context;
    
    /** The x value. */
    private float xValue = 0;
    
    /** The y value. */
    private float yValue = 0;
    
    /** The is landscape mode. */
    private boolean isLandscapeMode = true;
    
    /** The validation rect top bottom trash hold. */
    private  float validationRectTopBottomTrashHold = 0.6f; // validation rects ratio.
    
    /** The validation rect left right trash hold. */
    private  float validationRectLeftRightTrashHold = 0.3f;
    
    /** The frame. */
    private org.opencv.core.Rect frame;

    /**
     * The Enum Location.
     */
    private enum Location {
	
	/** The top. */
	TOP, 
 /** The bottom. */
 BOTTOM, 
 /** The left. */
 LEFT, 
 /** The right. */
 RIGHT
    };

    /** The leveler location. */
    private Location levelerLocation;

    /**
     * Instantiates a new two units leveler.
     *
     * @param context the context
     * @param attrs the attrs
     */
    @SuppressLint("Recycle")
    public TwoUnitsLeveler(Context context, AttributeSet attrs) {
	super(context, attrs);
	this.context = context;
	TypedArray oneLevelerData = context.obtainStyledAttributes(attrs, R.styleable.OneUnitsLeveler);
	TypedArray twoLevelerData = context.obtainStyledAttributes(attrs, R.styleable.TwoUnitsLeveler);
	int defaultVal = isHorizontalLevel ? 0 : 2; // default value for horizontal leveler is top for vertical is left
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
			this.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
		}

	colorOrientationPassContainer = Color.GREEN;
	colorOrientationFailContainer = Color.RED;
	colorOrientationPassInner = Color.GREEN;
	colorOrientationFailInner = Color.RED;
	colorOrientationPassCircle = Color.GREEN;
	colorOrientationFailCircle = Color.RED;
	//strokeWidthContainer = oneLevelerData.getInteger(R.styleable.OneUnitsLeveler_levelerThicknessContainer, strokeWidthContainer);
	//strokeWidthInner = oneLevelerData.getInteger(R.styleable.OneUnitsLeveler_levelerThicknessInner, strokeWidthInner);

	defaultPaddingLeftAndRight = twoLevelerData.getDimension(R.styleable.TwoUnitsLeveler_paddingLeftAndRight, 0);
	defaultPaddingTopAndBottom = twoLevelerData.getDimension(R.styleable.TwoUnitsLeveler_paddingTopAndBottom, 0);
	
	location = twoLevelerData.getInteger(R.styleable.TwoUnitsLeveler_levelerLocation, 0);
	setDefaultValues(defaultPaddingLeftAndRight, defaultPaddingTopAndBottom);

	isHorizontalLevel = false;
	if (levelerLocation == Location.TOP || levelerLocation == Location.BOTTOM) {
	    isHorizontalLevel = true;
	}


	isDraggingEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isDraggingEnable, true);
	isFadeAnimationEnable = oneLevelerData.getBoolean(R.styleable.OneUnitsLeveler_isFadeOutEnable, true);	

	isHorizontalLevel = false;
	if (location == 0 || location == 1) {
	    isHorizontalLevel = true;
	}
	if (!isHorizontalLevel && defaultPaddingTopAndBottom > 140.0) {

	    validationRectLeftRightTrashHold = 0.15f;
	}
	else if(isHorizontalLevel && defaultPaddingTopAndBottom > 250.0){
	    validationRectTopBottomTrashHold = 0.3f;
	}

	oneLevelerData.recycle();
	twoLevelerData.recycle();
	init();
    }

    /**
     * Checks if is dragging enable.
     *
     * @return true, if is dragging enable
     */
    public boolean isDraggingEnable() {
	return isDraggingEnable;
    }

    /**
     * Checks if is fade animation enable.
     *
     * @return true, if is fade animation enable
     */
    public boolean isFadeAnimationEnable() {
	return isFadeAnimationEnable;
    }

    /**
     * Instantiates a new two units leveler.
     *
     * @param context the context
     * @param attrs the attrs
     * @param defStyle the def style
     */
    public TwoUnitsLeveler(Context context, AttributeSet attrs, int defStyle) {
	super(context, attrs, defStyle);
	this.context = context;

	init();
    }

    /**
     * Sets the frame.
     *
     * @param ValidationRect the new frame
     */
    public void setFrame(org.opencv.core.Rect ValidationRect) {
	frame = ValidationRect;

    }

    /**
     * Inits the.
     */
    private void init() {
	if (isInEditMode()) {
	    return;
	}

	circlePaint = new Paint();
	circlePaint.setStyle(Style.FILL);
	circlePaint.setAntiAlias(true);
	circlePaint.setColor(context.getResources().getColor(R.color.counter_background));

	rectanglePaintContainer = new Paint();
	rectanglePaintContainer.setColor(colorOrientationFailContainer);
	rectanglePaintContainer.setStyle(Paint.Style.STROKE);
	rectanglePaintContainer.setStrokeWidth(strokeWidthContainer);

	rectanglePaintInner = new Paint();
	rectanglePaintInner.setColor(colorOrientationFailInner);
	rectanglePaintInner.setStyle(Paint.Style.STROKE);
	rectanglePaintInner.setStrokeWidth(strokeWidthContainer);

    }

    /**
     * Gets the upper main rect size.
     *
     * @return the upper main rect size
     */
    public float[] getUpperMainRectSize() {
	float[] res = { mainRectangleUpper.width(), mainRectangleUpper.height() };
	return res;

    }

    /**
     * Gets the left right rect size.
     *
     * @return the left right rect size
     */
    public float[] getLeftRightRectSize() {

	float[] res = { mainRectangleSide.width(), mainRectangleSide.height() };
	return res;
    }

    /**
     * Show leveler.
     */
    public void showLeveler() {
	setVisibility(View.VISIBLE);
	invalidate();
	
    }

    /* (non-Javadoc)
     * @see android.widget.ImageView#onDraw(android.graphics.Canvas)
     */
    @Override
    protected void onDraw(Canvas canvas) {

	if (isHorizontalLevel) {
	    drawHorizontalLeveler(canvas);
	} else {
	    drawVerticalLeveler(canvas);
	}

    }

    /**
     *  set default location values for each possible location.
     *
     * @param left the left
     * @param top the top
     */
    private void setDefaultValues(float left, float top) {
	switch (location) {
	case 0:
	    levelerLocation = Location.TOP;
	    defaultPaddingLeftAndRight = (left == 0) ? 45 : left;
	    defaultPaddingTopAndBottom = (top == 0) ? 18 : top;
	    break;
	case 1:
	    levelerLocation = Location.BOTTOM;
	    defaultPaddingLeftAndRight = (left == 0) ? 30 : left;
	    defaultPaddingTopAndBottom = (top == 0) ? 45 : top;
	    break;
	case 2:
	    levelerLocation = Location.LEFT;
	    defaultPaddingLeftAndRight = (left == 0) ? 18 : left;
	    defaultPaddingTopAndBottom = (top == 0) ? 25 : top;
	    break;
	case 3:
	    levelerLocation = Location.RIGHT;
	    defaultPaddingLeftAndRight = (left == 0) ? 45 : left;
	    defaultPaddingTopAndBottom = (top == 0) ? 15 : top;
	    break;
	}

    }

    /**
     * Draw horizontal leveler.
     *
     * @param canvas the canvas
     */
    private void drawHorizontalLeveler(Canvas canvas) {
	if (mainRectangleUpper == null) {
	    drawRectInLocation();
	}
	boolean validOrintation = isLandscapeMode ? validOrientationX : validOrientationY;

	if (validOrintation) {
	    rectanglePaintContainer.setColor(colorOrientationPassContainer);
	    rectanglePaintInner.setColor(colorOrientationPassInner);
	    circlePaint.setColor(colorOrientationPassCircle);
	} else {

	    rectanglePaintContainer.setColor(colorOrientationFailContainer);
	    rectanglePaintInner.setColor(colorOrientationFailInner);
	    circlePaint.setColor(colorOrientationFailCircle);
	}

	canvas.drawRoundRect(mainRectangleUpper, 15f, 15f, rectanglePaintContainer);
	canvas.drawRoundRect(validationRectangleUpper, 15f, 15f, rectanglePaintInner);
	convertPixelsToAccelerometerUpper = levelerTrashold * validationRectangleUpper.width() * (frame.width / 974); // 974 is the base line rectangle for calculation.
	float circleRadiosUpper = (mainRectangleUpper.bottom - mainRectangleUpper.top) * 0.6f;
	float circleX = validationRectangleUpper.centerX();
	float circleXLocation = checkCircleLocationX(circleX + (xValue * convertPixelsToAccelerometerUpper), mainRectangleUpper, circleRadiosUpper);
	canvas.drawCircle(circleXLocation, validationRectangleUpper.centerY(), circleRadiosUpper, circlePaint);
    }

    /**
     * Draw vertical leveler.
     *
     * @param canvas the canvas
     */
    private void drawVerticalLeveler(Canvas canvas) {
	boolean validOrientation = isLandscapeMode ? validOrientationY : validOrientationX;

	if (mainRectangleSide == null) {
	    drawRectInLocation();
	}
	if (validOrientation) {
	    rectanglePaintContainer.setColor(colorOrientationPassContainer);
	    rectanglePaintInner.setColor(colorOrientationPassInner);
	    circlePaint.setColor(colorOrientationPassCircle);
	} else {
	    rectanglePaintContainer.setColor(colorOrientationFailContainer);
	    rectanglePaintInner.setColor(colorOrientationFailInner);
	    circlePaint.setColor(colorOrientationFailCircle);
	}

	canvas.drawRoundRect(mainRectangleSide, 15f, 15f, rectanglePaintContainer);
	canvas.drawRoundRect(validationRectangleSide, 15f, 15f, rectanglePaintInner);

	float trahHoldLeveler = isLandscapeMode ? levelerTrasholdSide : levelerTrasholdSideVertical;
	convertPixelsToAccelerometerSide = trahHoldLeveler * mainRectangleSide.height() * (frame.height / 487);
	// border

	float circleY = validationRectangleSide.centerY();

	float circleRadiosSide = (mainRectangleSide.right - mainRectangleSide.left) * 0.6f;

	float circleYLocation = checkCircleLocationY(circleY - (yValue * convertPixelsToAccelerometerSide), mainRectangleSide, circleRadiosSide);

	canvas.drawCircle(validationRectangleSide.centerX(), circleYLocation, circleRadiosSide, circlePaint);

    }

    /**
     * Check circle location x.
     *
     * @param location the location
     * @param mainRectangle the main rectangle
     * @param radios the radios
     * @return the float
     */
    private float checkCircleLocationX(float location, RectF mainRectangle, float radios) {
	float locationResult = location;

	if (location < mainRectangle.left) {
	    locationResult = mainRectangle.left + radios;
	}
	if (location > mainRectangle.right) {

	    locationResult = mainRectangle.right - radios;
	}

	return locationResult;
    }

    /**
     * Check circle location y.
     *
     * @param location the location
     * @param mainRectangle the main rectangle
     * @param radios the radios
     * @return the float
     */
    private float checkCircleLocationY(float location, RectF mainRectangle, float radios) {
	float locationResult = location;

	if (location < mainRectangleSide.top) {
	    locationResult = mainRectangleSide.top + radios;
	}
	if (location > mainRectangleSide.bottom) {

	    locationResult = mainRectangleSide.bottom - radios;
	}

	return locationResult;
    }

    /**
     * Update leveler location.
     *
     * @param values the values
     * @param isValidX the is valid x
     * @param isValidY the is valid y
     * @param isVertical the is vertical
     */
    public void updateLevelerLocation(float[] values, boolean isValidX, boolean isValidY, boolean isVertical) {
	// TODO Auto-generated method stub
	isValidOrintation = isValidX && isValidY;
	validOrientationX = isValidX;
	validOrientationY = isValidY;
	yValue = values[2];
	xValue = values[1];
	if (isVertical) {
	    xValue = values[2];
	    yValue = values[1];
	    isLandscapeMode = false;
	}
		invalidate();
    }

    /* (non-Javadoc)
     * @see android.widget.ImageView#onMeasure(int, int)
     */
    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
	// TODO Auto-generated method stub
	super.onMeasure(widthMeasureSpec, heightMeasureSpec);
	int widthSpec = MeasureSpec.getMode(widthMeasureSpec);
	int width = MeasureSpec.getSize(widthMeasureSpec);
	int heightSpec = MeasureSpec.getMode(heightMeasureSpec);
	int height = MeasureSpec.getSize(heightMeasureSpec);

	setMeasuredDimension(width, height);

    }

    /**
     * Draw rect in location.
     */
    private void drawRectInLocation() {
	int top;
	int left;
	float validationLeft;
	switch (levelerLocation) {
	case TOP:
	    top = (int) (frame.y + defaultPaddingTopAndBottom);
	    mainRectangleUpper = new RectF(frame.x + defaultPaddingLeftAndRight, top, frame.x + frame.width - defaultPaddingLeftAndRight, top + levelerWidth);
	    // validationLeft = mainRectangleUpper.left + validationRectTopBottomTrashHold * mainRectangleUpper.left;
	    validationRectangleUpper = new RectF(mainRectangleUpper.left * (1 + validationRectTopBottomTrashHold), mainRectangleUpper.top, mainRectangleUpper.right
		    - mainRectangleUpper.left * validationRectTopBottomTrashHold, mainRectangleUpper.bottom);
	    break;
	case BOTTOM:
	    top = (int) (frame.y + frame.height - defaultPaddingTopAndBottom);
	    mainRectangleUpper = new RectF(frame.x + defaultPaddingLeftAndRight, top, frame.x + frame.width - defaultPaddingLeftAndRight, top + levelerWidth);
	    validationRectangleUpper = new RectF(mainRectangleUpper.left * (1 + validationRectTopBottomTrashHold), mainRectangleUpper.top, mainRectangleUpper.right
		    - mainRectangleUpper.left * validationRectTopBottomTrashHold, mainRectangleUpper.bottom);
	    break;

	case LEFT:
	    left = (int) (frame.x + defaultPaddingLeftAndRight);
	    mainRectangleSide = new RectF(left, frame.y + defaultPaddingTopAndBottom, left + levelerWidth, frame.y + frame.height - defaultPaddingTopAndBottom);
	    validationRectangleSide = new RectF(mainRectangleSide.left, mainRectangleSide.top * (1 + validationRectLeftRightTrashHold), mainRectangleSide.right,
		    mainRectangleSide.bottom - mainRectangleSide.top * validationRectLeftRightTrashHold);
	    
	    break;
	case RIGHT:
	    left = (int) (frame.x + frame.width - defaultPaddingLeftAndRight);
	    mainRectangleSide = new RectF(left, frame.y + defaultPaddingTopAndBottom, left + levelerWidth, frame.y + frame.height - defaultPaddingTopAndBottom);
	    validationRectangleSide = new RectF(mainRectangleSide.left, mainRectangleSide.top * (1 + validationRectLeftRightTrashHold), mainRectangleSide.right,
		    mainRectangleSide.bottom - mainRectangleSide.top * validationRectLeftRightTrashHold);
	    break;

	}

    }
};