/*
 * 
 */
package com.topimagesystems.micr;

import com.topimagesystems.R;

// TODO: Auto-generated Javadoc
/**
 * The Class OCRCommon.
 */
public class OCRCommon {
	
	/**
	 * The Enum ErrorCode.
	 */
	public enum ErrorCode {
		
		/** The ok. */
		ok(0, R.string.TISFlowOK), 
		
		/** The detectable color. */
		detectableColor(1,R.string.TISFlowErrorIQANumSpots),
		
		/** The not valid boundaries. */
		notValidBoundaries(2, R.string.TISErrorNotValidBoundaries), 
		
		/** The empty image. */
		emptyImage(3,R.string.TISFlowErrorNotValidImageSize),
		
		/** The error min image size in bytes. */
		errorMinImageSizeInBytes(4,R.string.TISFlowErrorNotValidImageSize), 
		
		/** The error min image dimensions. */
		errorMinImageDimensions(5,R.string.TISFlowErrorUnknown), 
		
		/** The error iqa corner data. */
		errorIQACornerData(6,R.string.TISFlowErrorIQACornerData), 
		
		/** The error iqa edge data. */
		errorIQAEdgeData(7,R.string.TISFlowErrorIQAEdgeData), 
		
		/** The error iqa skew. */
		errorIQASkew(8,R.string.TISFlowErrorIQASkew), 
		
		/** The error iqa darkness. */
		errorIQADarkness(9,R.string.TISFlowErrorIQADarkness), 
		
		/** The error iqa num spots. */
		errorIQANumSpots(10,R.string.TISFlowErrorIQANumSpots), 
		
		/** The error no valid bounding box. */
		errorNoValidBoundingBox(11,R.string.TISFlowErrorNoValidBoundingBox),		
		
		/** The error not valid image size. */
		errorNotValidImageSize(12,R.string.TISFlowErrorNotValidImageSize),
		
		/** The error file too small. */
		errorFileTooSmall(13,R.string.TISFlowErrorFileTooSmall), 
		
		/** The error unknown. */
		errorUnknown(14,R.string.TISFlowErrorUnknown),
		
		/** The error blur detection failed. */
		errorBlurDetectionFailed(15,R.string.TISErrorBlurFail),
		
		/** The error micr interrupted. */
		errorMicrInterrupted(16,R.string.TISFlowMicrInterrupted),
		
		/** The error micr detected on check back. */
		errorMICRDetectedOnCheckBack(19,R.string.TISFlowWarningMICRDetectedOnCheckBack),
		
		
		errorPassportNotFound(17,R.string.TISFlowErrorReadingOCRMessage),
		
		errorPanNotFound(18,R.string.TISFlowErrorReadingOCRMessage),
		
		/** The error inialize ocr. */
		errorInializeOCR(21,R.string.TISFlowErrorReadingOCRMessage),
		
		/** The error_device memory. */
		error_deviceMemory(22,R.string.TISErrorDeviceMemory),
		
		errorOcrReading(23,R.string.TISFlowErrorReadingOCRMessage),
		errorBarcodeNotFound(24,R.string.TISFlowErrorReadingOCRMessage);

		/** The id. */
		int id;
		
		/** The resource id. */
		int resourceId;

		/**
		 * Instantiates a new error code.
		 *
		 * @param id the id
		 * @param resourceId the resource id
		 */
		ErrorCode(int id, int resourceId) {
			this.id = id;
			this.resourceId = resourceId;
		}

		/**
		 * Gets the id.
		 *
		 * @return the id
		 */
		public int getId() {
			return id;
		}

		/**
		 * Gets the resource id.
		 *
		 * @return the resource id
		 */
		public int getResourceId() {
			return resourceId;
		}

		/**
		 * Instance of.
		 *
		 * @param errorCodeId the error code id
		 * @return the error code
		 */
		public static ErrorCode instanceOf(int errorCodeId) {
			

	
			if (errorCodeId == ok.id)
				return ok;
			else if (errorCodeId == errorInializeOCR.id)
				return errorInializeOCR;
			else if (errorCodeId == detectableColor.id)
				return detectableColor;
			else if (errorCodeId == notValidBoundaries.id)
				return notValidBoundaries;
			else if (errorCodeId == emptyImage.id)
				return emptyImage;

			else if (errorCodeId == errorMinImageSizeInBytes.id)
				return errorMinImageSizeInBytes;
			else if (errorCodeId == errorMinImageDimensions.id)
				return errorMinImageDimensions;
			else if (errorCodeId == errorIQACornerData.id)
				return errorIQACornerData;
			else if (errorCodeId == errorIQAEdgeData.id)
				return errorIQAEdgeData;
			else if (errorCodeId == errorIQASkew.id)
				return errorIQASkew;
			else if (errorCodeId == errorIQADarkness.id)
				return errorIQADarkness;
			else if (errorCodeId == errorIQANumSpots.id)
				return errorIQANumSpots;
			else if (errorCodeId == errorFileTooSmall.id)
				return errorFileTooSmall;
			else if (errorCodeId == errorNotValidImageSize.id)
				return errorNotValidImageSize;
			else if (errorCodeId == errorNoValidBoundingBox.id)
				return errorNoValidBoundingBox;
			else if (errorCodeId == errorUnknown.id)
				return errorUnknown;
			else if (errorCodeId == errorBlurDetectionFailed.id)
			    return errorBlurDetectionFailed;
			else if (errorCodeId == errorOcrReading.id){
				return errorOcrReading;
			}
			else if (errorCodeId == errorMicrInterrupted.id)
			    return errorMicrInterrupted;
			else if(errorCodeId == errorPanNotFound.id){
				return errorPanNotFound;
			}
			else if(errorCodeId == errorPassportNotFound.id){
				return errorPassportNotFound;
			}
			return null;
		}
	};

	/**
	 * The Enum OCRDetectorStatus.
	 */
	public enum OCRDetectorStatus {
		
		/** The OCR detector status preparing. */
		OCRDetectorStatusPreparing(0, R.string.TISFlowPreparingImage), 
 /** The OCR detector status validating. */
 OCRDetectorStatusValidating(1, R.string.TISFlowValidatingImag), 
 /** The OCR detector status performing. */
 OCRDetectorStatusPerforming(
				2, R.string.TISFlowPerformingOCR), 
 /** The OCR detector status locating bounderies. */
 OCRDetectorStatusLocatingBounderies(3, R.string.TISFlowPreparingForServerLocatingBoundaries), 
 /** The OCR detector status image cropping. */
 OCRDetectorStatusImageCropping(
				4, R.string.TISFlowPreparingForServerCropping), 
 /** The OCR detector status image binarazing. */
 OCRDetectorStatusImageBinarazing(5, R.string.TISFlowPreparingForServerBinarizing);
		/**/
		/** The id. */
		int id;
		
		/** The resource id. */
		int resourceId;

		/**
		 * Instantiates a new OCR detector status.
		 *
		 * @param id the id
		 * @param resourceId the resource id
		 */
		OCRDetectorStatus(int id, int resourceId) {
			this.id = id;
			this.resourceId = resourceId;
		}

		/**
		 * Gets the id.
		 *
		 * @return the id
		 */
		public int getId() {
			return id;
		}

		/**
		 * Gets the resource id.
		 *
		 * @return the resource id
		 */
		public int getResourceId() {
			return resourceId;
		}

		/**
		 * Instance of.
		 *
		 * @param codeId the code id
		 * @return the OCR detector status
		 */
		public static OCRDetectorStatus instanceOf(int codeId) {
			if (codeId == OCRDetectorStatusPreparing.id)
				return OCRDetectorStatusPreparing;
			else if (codeId == OCRDetectorStatusValidating.id)
				return OCRDetectorStatusValidating;
			else if (codeId == OCRDetectorStatusPerforming.id)
				return OCRDetectorStatusPerforming;
			else if (codeId == OCRDetectorStatusLocatingBounderies.id)
				return OCRDetectorStatusLocatingBounderies;
			else if (codeId == OCRDetectorStatusImageCropping.id)
				return OCRDetectorStatusImageCropping;
			else if (codeId == OCRDetectorStatusImageBinarazing.id)
				return OCRDetectorStatusImageBinarazing;
			return null;
		}
	};
}