package com.topimagesystems.data;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by Ruth on 06/04/16.
 */
public class TISStaticCaptureSettings implements Parcelable {

    /** The error size relatively to image size - default value */
    public static final float MAX_SIZE_ERROR = 0.045f;

    /** The Center position error relatively to image size - default value */
    public static final float MAX_POSITION_ERROR = 0.045f;

    /** The left to right error relatively to image size - default value */
    public static final float LEFT_TO_RIGHT_ERROR = 0.035f;

    /** The max position width error  relatively to image size - default value */
    public static final float MAX_POSITION_WIDTH_ERROR = 0.07f;

    /** The max position height error relatively to image size - default value */
    public static final float MAX_POSITION_HEIGHT_ERROR = 0.07f;



    /** The error size relatively to image size - default value */
    public static final float MAX_SIZE_ERROR_PORTRAIT = 0.3f;

    /** The Center position error relatively to image size - default value */
    public static final float MAX_POSITION_ERROR_PORTRAIT = 0.2f;

    /** The left to right error relatively to image size - default value */
    public static final float LEFT_TO_RIGHT_ERROR_PORTRAIT = 0.17f;

    /** The max position width error  relatively to image size - default value */
    public static final float MAX_POSITION_WIDTH_ERROR_PORTRAIT = 0.3f;

    /** The max position height error relatively to image size - default value */
    public static final float MAX_POSITION_HEIGHT_ERROR_PORTRAIT = 0.07f;

    private float maxHeightErrorFromCenterOfTheScreen;
    private float maxWidthErrorFromCenterOfTheScreen;
    private float moveLeftAndRightAR;
    private float moveLowerAR;
    private float moveTopAndBottomAR;

    /** Handle parameters for document placement while trying to capture
     * @param maxHeightErrorFromCenterOfTheScreen The error size relatively to image size - default value
     * @param maxPositionError The Center position error relatively to image size - default value
     * @param moveLeftAndRightAR The left to right error relatively to image size
     * @param moveLowerAR The max position width error  relatively to image size
     * @param moveTopAndBottomAR The max position height error relatively to image size
     */

    /**
     * Handle parameters for document placement while trying to capture.
     * Default values will be set.
     *<p>
     *     Note:<BR>
     *         When using this constructor it is assumed that the soft-capture is being used:
     *
     *</p>
     */
    // {@link #TISStaticCaptureSettings(boolean isSoftCaptureOrPortrait) TISStaticCaptureSettings(boolean isSoftCaptureOrPortrait)}
    //  with the isSoftCaptureOrPortrait parameter set to true.
    public TISStaticCaptureSettings() {
        this(true);
    }


    /**
     * Handle parameters for document placement while trying to capture.
     * Default values will be set.
     * @param isSoftCaptureOrPortrait indicates using soft capture or portrait mode, in any other case should be false
     */

//    maxHeightErrorFromCenterOfTheScreen = TISStaticCaptureSettings.MAX_SIZE_ERROR_PORTRAIT;
//    maxHeightErrorFromCenterOfTheScreen = TISStaticCaptureSettings.MAX_POSITION_ERROR_PORTRAIT;
//    moveRightAndLeftAR = TISStaticCaptureSettings.LEFT_TO_RIGHT_ERROR_PORTRAIT;
//    moveLowerAR = TISStaticCaptureSettings.MAX_POSITION_WIDTH_ERROR_PORTRAIT;
//    moveTopAndBottomAR = TISStaticCaptureSettings.MAX_POSITION_HEIGHT_ERROR_PORTRAIT;

    private TISStaticCaptureSettings(boolean isSoftCaptureOrPortrait) {
        if (isSoftCaptureOrPortrait) {
            this.maxHeightErrorFromCenterOfTheScreen = MAX_SIZE_ERROR_PORTRAIT;
            this.maxWidthErrorFromCenterOfTheScreen = MAX_POSITION_ERROR_PORTRAIT;
            this.moveLeftAndRightAR = LEFT_TO_RIGHT_ERROR_PORTRAIT;
            this.moveLowerAR = MAX_POSITION_WIDTH_ERROR_PORTRAIT;
            this.moveTopAndBottomAR = MAX_POSITION_HEIGHT_ERROR_PORTRAIT;
        }
    }

    protected TISStaticCaptureSettings(Parcel in) {
        maxHeightErrorFromCenterOfTheScreen = in.readFloat();
        maxWidthErrorFromCenterOfTheScreen = in.readFloat();
        moveLeftAndRightAR = in.readFloat();
        moveLowerAR = in.readFloat();
        moveTopAndBottomAR = in.readFloat();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(maxHeightErrorFromCenterOfTheScreen);
        dest.writeFloat(maxWidthErrorFromCenterOfTheScreen);
        dest.writeFloat(moveLeftAndRightAR);
        dest.writeFloat(moveLowerAR);
        dest.writeFloat(moveTopAndBottomAR);
    }


//    maxHeightErrorFromCenterOfTheScreen = staticCaptureSettings.getMaxHeightErrorFromCenterOfTheScreen();
//    maxHeightErrorFromCenterOfTheScreen = staticCaptureSettings.getMaxWidthErrorFromCenterOfTheScreen();
//    moveRightAndLeftAR = staticCaptureSettings.getMoveLeftAndRightAR();
//    moveLowerAR = staticCaptureSettings.getMoveLowerAR();
//    moveTopAndBottomAR = staticCaptureSettings.getMoveTopAndBottomAR();
//

    public float getMaxHeightErrorFromCenterOfTheScreen() {
        return maxHeightErrorFromCenterOfTheScreen;
    }

//    public void setMaxHeightErrorFromCenterOfTheScreen(float maxHeightErrorFromCenterOfTheScreen) {
//        this.maxHeightErrorFromCenterOfTheScreen = maxHeightErrorFromCenterOfTheScreen;
//    }

    public float getMaxWidthErrorFromCenterOfTheScreen() {
        return maxWidthErrorFromCenterOfTheScreen;
    }

//    public void setMaxPositionError(float maxPositionError) {
//        this.maxPositionError = maxPositionError;
//    }

    public float getMoveLeftAndRightAR() {
        return moveLeftAndRightAR;
    }

    public void setMoveLeftAndRightAR(float moveLeftAndRightAR) {
        this.maxWidthErrorFromCenterOfTheScreen = this.maxHeightErrorFromCenterOfTheScreen * (maxWidthErrorFromCenterOfTheScreen/this.moveLeftAndRightAR);
        this.moveLeftAndRightAR = moveLeftAndRightAR;
    }

    public float getMoveLowerAR() {
        return moveLowerAR;
    }

    public void setMoveLowerAR(float moveLowerAR) {
        this.moveLowerAR = moveLowerAR;
    }

    public float getMoveTopAndBottomAR() {
        return moveTopAndBottomAR;
    }

    public void setMoveTopAndBottomAR(float moveTopAndBottomAR) {
        this.maxHeightErrorFromCenterOfTheScreen = this.maxHeightErrorFromCenterOfTheScreen * (moveTopAndBottomAR/this.moveTopAndBottomAR);
        this.moveTopAndBottomAR = moveTopAndBottomAR;

    }

    @SuppressWarnings("unused")
    public static final Creator<TISStaticCaptureSettings> CREATOR = new Creator<TISStaticCaptureSettings>() {
        @Override
        public TISStaticCaptureSettings createFromParcel(Parcel in) {
            return new TISStaticCaptureSettings(in);
        }

        @Override
        public TISStaticCaptureSettings[] newArray(int size) {
            return new TISStaticCaptureSettings[size];
        }
    };
}