/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import com.topimagesystems.util.Logger;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;

// TODO: Auto-generated Javadoc
/**
 * The Class ErrorCallback.
 */
public class ErrorCallback implements android.hardware.Camera.ErrorCallback{
	
	/** The Constant TAG. */
	final static String TAG = Logger.makeLogTag("ErrorCallback");
	//
	/** The error handler. */
	private Handler errorHandler;
	
	/** The error message. */
	private int errorMessage;

	/**
	 * Sets the handler.
	 *
	 * @param errorHandler the error handler
	 * @param errorMessage the error message
	 */
	void setHandler(Handler errorHandler, int errorMessage) {
		this.errorHandler = errorHandler;
		this.errorMessage = errorMessage;
	}
	
	/* (non-Javadoc)
	 * @see android.hardware.Camera.ErrorCallback#onError(int, android.hardware.Camera)
	 */
	@Override
	public void onError(int paramInt, Camera paramCamera) {
		Logger.d(TAG, "onError, paramInt:" + paramInt + " paramCamera:" + paramCamera);
		if (errorHandler != null) {
			Message message = errorHandler.obtainMessage(errorMessage);
			message.arg1 = paramInt;
			errorHandler.sendMessage(message);
			errorHandler = null;
		}
		else {
			Logger.d(TAG, "Error callback, no handler for it");
		}
	}
}