package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.os.Build;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.ToggleButton;

import com.topimagesystems.R;
import com.topimagesystems.camera2.AutoFitTextureView;
import com.topimagesystems.controllers.imageanalyze.CameraController.ActionClickListener;
import com.topimagesystems.controllers.imageanalyze.CameraTypes.CaptureMode;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.ui.CheckBounderiesView;
import com.topimagesystems.ui.OneUnitLeveler;
import com.topimagesystems.ui.ScaleLeveler;
import com.topimagesystems.ui.TwoUnitsLeveler;
import com.topimagesystems.util.UserInterfaceUtils;

import org.opencv.core.Rect;

public class DynamicCameraOverlayLayout extends CameraOverlayLayout {

	private Context context;
	private boolean grid = true;
	private int heightGridLineNumber = 12;
	private int widthGridLineNumber = 12;
	public float[] topLeft, topRight, bottomLeft, bottomRight;
	public boolean isValidRect;
	public boolean isRectFound;
	private Path path;
	Paint validRectPaintStroke;
	Paint validRectPaintFill;
	Paint inValidRectPaint;
	Paint gridPaint;
	private Button btnCancel;
	private ImageView sucessImg;
	/** The action click listener. */
	private ActionClickListener actionClickListener;
	private  Matrix scaleMatrix = null;


	public DynamicCameraOverlayLayout(Context _context) {
		super(_context);
		context = _context;
		path = new Path();

	}

	/**
	 * Instantiates a new camera overlay layout.
	 *
	 * @param _context
	 *            the _context
	 * @param attributeSet
	 *            the attribute set
	 */
	public DynamicCameraOverlayLayout(Context _context, AttributeSet attributeSet) {
		super(_context, attributeSet);
		context = _context;
		path = new Path();

	}

	@Override
	public void ensureUI() {
		if (!UserInterfaceUtils.hasHardwareAcceleration(DynamicCaptureCameraController.getInstance()) ){
			AutoFitTextureView mTextureView = (AutoFitTextureView) findViewById(R.id.texture);
			mTextureView.setVisibility(View.GONE);
		}


		btnCancel = (Button) findViewById(R.id.dynamicBtnCancel);
		sucessImg = (ImageView) findViewById(R.id.succssesImg);
		sucessImg.setVisibility(View.GONE);
		horizontalScaleLeveler = (ScaleLeveler) findViewById(R.id.dynamicScaleLevelerHorizontal);
		verticalScaleLeveler = (ScaleLeveler) findViewById(R.id.dynamicScaleLevelerVertical);
		oneUnitLeveler = (OneUnitLeveler) findViewById(R.id.dynamicOneUnitLeveler);
		horizontalLeveler = (TwoUnitsLeveler) findViewById(R.id.dynamicLevelerHorizontal);
		verticalLeveler  = (TwoUnitsLeveler)findViewById(R.id.dynamicLevelerPortrait);
		spinner = (ProgressBar) findViewById(R.id.dynamicLayoutProgressBar);
		textIndicator = (TextView)findViewById(R.id.DynamicTxtIndicator);
		 textHoldIndicator = (TextView) findViewById(R.id.DynamicHoldIndicator);
		imgLogoWaterMark = (ImageView) findViewById(R.id.dynamicImgLogoWaterMark);
		btnTorch = (ToggleButton) findViewById(R.id.dynamicBtnTorch);
		
		fadeOut = AnimationUtils.loadAnimation(context, R.anim.view_fade_out);
	    
		isOneUnitLeveler = oneUnitLeveler.getVisibility() == View.VISIBLE;

		fadeOut = AnimationUtils.loadAnimation(context, R.anim.view_fade_out);
		
		/** The portrait leveler. */
		
		// searchSpinner.setBackgroundResource(R.drawable.searching_spinner);
		// AnimationDrawable frameAnimation = (AnimationDrawable)
		// searchSpinner.getBackground();
		// frameAnimation.start();		

		
		
		 
		btnCancel.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				if (!CameraManagerController.isStillMode && CameraController.processStart)
					return;
				else
					actionClickListener.quit();

			}
		});
		
		btnTorch.setOnCheckedChangeListener(new ToggleButton.OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				buttonView.setEnabled(false);
				Message message = CameraController.getInstance().getHandler().obtainMessage(CameraTypes.MESSAGE_TOGGLE_TORCH);
				message.obj = isChecked;
				CameraController.getInstance().getHandler().sendMessage(message);
			}
		});
		
		
		if (oneUnitLeveler != null) {
			initOneUnitLeveler();
		}
		initLeveler();
		setAnimationListener();
		
		// horizontalLeveler.showLeveler();
		if (checkBoundariesRect != null) {
			initcheckBounderiesView(checkBoundariesRect);
		}

		btnTorch.setVisibility(CameraController.isCameraFlashSupported ? VISIBLE : INVISIBLE);

	}

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub

	}

	public void showCheckBoundyRect(boolean isShow, Rect rect) {
		return;
		/*if (isShow) {
			checkRectBounderies.drawCheckRect(rect);
		} else {
			checkRectBounderies.clearCheckRect();
		}*/
	}

	public void setActionClickListener(ActionClickListener actionClickListener) {
		this.actionClickListener = actionClickListener;
	}

	@Override
	public void setCaptureCaption(CaptureMode captureMode) {

	}

	@Override
	protected void onDraw(Canvas canvas) {

		// Find Screen size first
		DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
		int screenWidth = metrics.widthPixels;
		int screenHeight = metrics.heightPixels;
		double widthSize = screenWidth / widthGridLineNumber;
		double heightSize = screenHeight / heightGridLineNumber;
		// Set paint options
		if(textHoldIndicator.getVisibility() == VISIBLE){
			isValidRect = true;
		}
		if (grid) {
			if (gridPaint == null) {
				gridPaint = new Paint();
				gridPaint.setAntiAlias(true);
				gridPaint.setStrokeWidth(3);
				gridPaint.setStyle(Paint.Style.STROKE);
				gridPaint.setColor(getResources().getColor(R.color.grid_line_color));
			}
			// draw vert lines
			for (int i = (int) widthSize; i < screenWidth + widthSize; i += widthSize) {
				canvas.drawLine(i, 0, i, screenHeight, gridPaint);

			}
			// draw horizontal lines
			for (int i = (int) heightSize; i < screenHeight + heightSize; i += heightSize) {
				canvas.drawLine(0, i, screenWidth, i, gridPaint);

			}
		}
		if (validRectPaintStroke == null) {
			validRectPaintStroke = new Paint();
			validRectPaintStroke.setAntiAlias(true);
			validRectPaintStroke.setStrokeWidth(10);
			validRectPaintStroke.setColor(getResources().getColor(R.color.validRectStrokeColor));
			validRectPaintStroke.setStyle(Paint.Style.STROKE);
		}

		if (validRectPaintFill == null) {
			validRectPaintFill = new Paint();
			validRectPaintFill.setAntiAlias(true);
			validRectPaintFill.setStrokeWidth(10);
			validRectPaintFill.setColor(getResources().getColor(R.color.validRectFillColor));
			validRectPaintFill.setStyle(Paint.Style.FILL);
		}
		if (inValidRectPaint == null) {
			inValidRectPaint = new Paint();
			inValidRectPaint.setAntiAlias(true);
			inValidRectPaint.setStrokeWidth(8);
			inValidRectPaint.setStyle(Paint.Style.STROKE);
			inValidRectPaint.setColor(getResources().getColor(R.color.invalidRectStrokeColor));

		}
		if (!isRectFound) {
			path.reset();
			canvas.drawPath(path, validRectPaintStroke);
			return;
		}

		if (bottomLeft != null && topLeft[0] != 0) {

			path.reset();

			if (isRectFound) {

				if (scaleMatrix == null){
					scaleMatrix = new Matrix();
					RectF previewRect; 
					RectF nativeResRect;
					int videoBigRes;
					int videoSmallRes;
					int screenBigRes;
					int screenSmallRes;

					if (CameraConfigurationManager.videoResolutionWidth > CameraConfigurationManager.videoResolutionHeight){
						videoBigRes = CameraConfigurationManager.videoResolutionWidth;
						videoSmallRes = CameraConfigurationManager.videoResolutionHeight;
					}
					else{
						videoSmallRes = CameraConfigurationManager.videoResolutionWidth;
						videoBigRes = CameraConfigurationManager.videoResolutionHeight;
					}
					if ( CameraConfigurationManager.screenResolution.x > CameraConfigurationManager.screenResolution.y){
						screenBigRes  = CameraConfigurationManager.screenResolution.x;
						screenSmallRes = CameraConfigurationManager.screenResolution.y;
					}
					else{
						screenBigRes  = CameraConfigurationManager.screenResolution.y;
						screenSmallRes = CameraConfigurationManager.screenResolution.x;
					}
					if (CameraManagerController.sessionType != CaptureIntent.SessionType.PORTRAIT){
						previewRect = new RectF(0, 0, screenBigRes,screenSmallRes);
						nativeResRect = new RectF(0, 0,
								videoBigRes, videoSmallRes);
					}
					else{
						previewRect = new RectF(0, 0, screenSmallRes,screenBigRes);
						nativeResRect = new RectF(0, 0,
								videoSmallRes, videoBigRes);


					}
//					else {
//						previewRect= new RectF(0, 0, CameraConfigurationManager.screenResolution.y, CameraConfigurationManager.screenResolution.x);
//						nativeResRect = new RectF(0, 0,
//								CameraConfigurationManager.videoResolutionHeight, CameraConfigurationManager.videoResolutionWidth);
//					}


				// create a matrix which scales coordinates of preview size rectangle
				// into the
				// camera's native resolution.
				scaleMatrix.setRectToRect(nativeResRect, previewRect, Matrix.ScaleToFit.FILL);
				}
								
				path.moveTo(topLeft[0], topLeft[1]);
				// BR=TL

				path.quadTo(topLeft[0], topLeft[1], topRight[0], topRight[1]);

				path.quadTo(topRight[0], topRight[1], bottomRight[0], bottomRight[1]);
				path.quadTo(bottomRight[0], bottomRight[1], bottomLeft[0], bottomLeft[1]);
				path.quadTo(bottomLeft[0], bottomLeft[1], topLeft[0], topLeft[1]);
				path.transform(scaleMatrix);
			
				if (isValidRect) {
					canvas.drawPath(path, validRectPaintStroke);
					canvas.drawPath(path, validRectPaintFill);
				} else {
					canvas.drawPath(path, inValidRectPaint);
				}
			}
		}

		invalidate();

	}

	@Override
	protected void initcheckBounderiesView(CheckBoundaries checkBoundariesRect) {
		isCheckBounderiesViewInit = true;
		final Point displayDimensions = UserInterfaceUtils.getDisplayDimensions(getContext());
		checkBounderiesView = (CheckBounderiesView) findViewById(R.id.dynamicCheckBounderiesView);
		checkBounderiesView.setCheckBounderies(displayDimensions, checkBoundariesRect);		
		horizontalLeveler = (TwoUnitsLeveler) findViewById(R.id.dynamicLevelerHorizontal);
		horizontalScaleLeveler = (ScaleLeveler) findViewById(R.id.dynamicScaleLevelerHorizontal);
		verticalLeveler = (TwoUnitsLeveler) findViewById(R.id.dynamicLevelerPortrait);
		verticalScaleLeveler = (ScaleLeveler) findViewById(R.id.dynamicScaleLevelerVertical);
		//initLeveler();
	}
	
	
	public void showSessionSucessImg() {
		sucessImg.setVisibility(View.VISIBLE);

	}
	
	
	public void showProcessImg() {
		spinner.setVisibility(View.VISIBLE);
		oneUnitLeveler.setVisibility(View.GONE);
	}
	
	public void removeCaptureElements() {
		if (sucessImg != null) {
			sucessImg.setVisibility(View.GONE);
		}
		if (spinner != null)
			spinner.setVisibility(View.GONE);
	}

	// @Override
	// protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
	// // TODO Auto-generated method stub
	// DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
	// int screenWidth = metrics.widthPixels;
	// int screenHeight = metrics.heightPixels;
	// int desiredWidth = screenWidth;
	// int desiredHeight = screenHeight;
	//
	// int widthMode = MeasureSpec.getMode(widthMeasureSpec);
	// int widthSize = MeasureSpec.getSize(widthMeasureSpec);
	// int heightMode = MeasureSpec.getMode(heightMeasureSpec);
	// int heightSize = MeasureSpec.getSize(heightMeasureSpec);
	//
	// int width;
	// int height;
	//
	// // Measure Width
	// if (widthMode == MeasureSpec.EXACTLY) {
	// // Must be this size
	// width = widthSize;
	// } else if (widthMode == MeasureSpec.AT_MOST) {
	// // Can't be bigger than...
	// width = Math.min(desiredWidth, widthSize);
	// } else {
	// // Be whatever you want
	// width = desiredWidth;
	// }
	//
	// // Measure Height
	// if (heightMode == MeasureSpec.EXACTLY) {
	// // Must be this size
	// height = heightSize;
	// } else if (heightMode == MeasureSpec.AT_MOST) {
	// // Can't be bigger than...
	// height = Math.min(desiredHeight, heightSize);
	// } else {
	// // Be whatever you want
	// height = desiredHeight;
	// }
	//
	// // MUST CALL THIS
	// setMeasuredDimension(width, height);
	// }

}
