/*
 * 
 */
package com.topimagesystems.controllers;

import java.util.List;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;

import com.topimagesystems.R;
import com.topimagesystems.util.ActivityUtil;

// TODO: Auto-generated Javadoc
/**
 * The Class NavigationManager.
 */
public class NavigationManager {

	/** The instance. */
	private static NavigationManager instance = new NavigationManager() {};
	
	/** The _current screen class. */
	private Class<?> _currentScreenClass;

	/**
	 * Gets the single instance of NavigationManager.
	 *
	 * @return single instance of NavigationManager
	 */
	public static NavigationManager getInstance() {
		return instance;
	}

	/**
	 * The Enum ScreenType.
	 */
	enum ScreenType {
		
		/** The closable. */
		CLOSABLE, 
 /** The keep alive. */
 KEEP_ALIVE
	};

	/**
	 * The Enum AnimationType.
	 */
	enum AnimationType {
		
		/** The fade. */
		FADE, 
 /** The slide down. */
 SLIDE_DOWN, 
 /** The slide up. */
 SLIDE_UP
	};

	/**
	 * Show new screen.
	 *
	 * @param baseActivity the base activity
	 * @param activityClass the activity class
	 * @param extras the extras
	 * @param isFinishCurrentActivity the is finish current activity
	 */
	public void showNewScreen(Activity baseActivity, Class<?> activityClass, Bundle extras, boolean isFinishCurrentActivity) {
		showNewScreen(baseActivity, activityClass, extras, null, -1, isFinishCurrentActivity);
	}

	/**
	 * Show new screen.
	 *
	 * @param baseActivity the base activity
	 * @param activityClass the activity class
	 * @param extras the extras
	 * @param requestCode the request code
	 * @param isFinishCurrentActivity the is finish current activity
	 */
	public void showNewScreen(Activity baseActivity, Class<?> activityClass, Bundle extras, int requestCode, boolean isFinishCurrentActivity) {
		showNewScreen(baseActivity, activityClass, extras, null, requestCode, isFinishCurrentActivity);
	}

	/**
	 * Show new screen.
	 *
	 * @param baseActivity the base activity
	 * @param activityClass the activity class
	 * @param extras the extras
	 * @param flags the flags
	 * @param requestCode the request code
	 * @param isFinishCurrentActivity the is finish current activity
	 */
	public void showNewScreen(Activity baseActivity, Class<?> activityClass, Bundle extras, List<Integer> flags, int requestCode, boolean isFinishCurrentActivity) {
		if (baseActivity == null)
			return;

		showActivity(baseActivity, activityClass, extras, flags, requestCode);

		baseActivity.overridePendingTransition(enterAnimation(), outAnimation());
		_currentScreenClass = activityClass;

		if ( isFinishCurrentActivity ){
			closePreviousActivity(baseActivity);
		}
		else{
			
		}
	}

	/**
	 * Gets the current screen class.
	 *
	 * @return the current screen class
	 */
	public Class<?> getCurrentScreenClass() {
		return _currentScreenClass;
	}

	/**
	 * Enter animation.
	 *
	 * @return the int
	 */
	public static int enterAnimation() {
		return R.anim.screen_enter;
	}

	/**
	 * Out animation.
	 *
	 * @return the int
	 */
	public static int outAnimation() {
		return R.anim.screen_exit;
	}

	/**
	 * Enter dialog animation.
	 *
	 * @return the int
	 */
	public static int enterDialogAnimation() {
		return R.anim.dialog_enter;
	}

	/**
	 * Out dialog animation.
	 *
	 * @return the int
	 */
	public static int outDialogAnimation() {
		return R.anim.dialog_exit;
	}

	/**
	 * Clear current screen.
	 */
	public void clearCurrentScreen() {
		_currentScreenClass = null;
	}

	/**
	 * Show activity.
	 *
	 * @param baseActivity the base activity
	 * @param activityClass the activity class
	 * @param extras the extras
	 * @param flags the flags
	 * @param requestCode the request code
	 */
	private void showActivity(Activity baseActivity, Class<?> activityClass, Bundle extras, List<Integer> flags, int requestCode) {
//		Intent intent = new Intent(baseActivity.getApplicationContext(), activityClass);
		Intent intent = ActivityUtil.createIntent(baseActivity.getApplicationContext(), activityClass);
		if (extras != null) {
			intent.putExtras(extras);
		}

		if (flags != null) {
			for (Integer flag : flags) {
				intent.setFlags(flag);
			}
		}
		intent.setFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
		intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		if (requestCode > -1) {
			baseActivity.startActivityForResult(intent, requestCode);
		}
		else {
			baseActivity.startActivity(intent);
		}
	}

	/**
	 * Close previous activity.
	 *
	 * @param previousActivity the previous activity
	 */
	private void closePreviousActivity(final Activity previousActivity) {
		Runnable runnableClosePreviousActivity;

		// finish previous activity after 1 second - so user will not see black
		// screen
		runnableClosePreviousActivity = new Runnable() {
			public void run() {
				previousActivity.finish();
			}
		};

		Handler handler = new Handler(previousActivity.getMainLooper());
		handler.postDelayed(runnableClosePreviousActivity, 1000L);
	}

	/**
	 * Gets the common in transition.
	 *
	 * @return the common in transition
	 */
	public int getCommonInTransition() {
		return enterAnimation();
	}

	/**
	 * Gets the common out transition.
	 *
	 * @return the common out transition
	 */
	public int getCommonOutTransition() {
		return outAnimation();
	}
}