/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ml;

import org.opencv.core.Mat;
import org.opencv.ml.CvParamGrid;
import org.opencv.ml.CvSVMParams;
import org.opencv.ml.CvStatModel;

public class CvSVM
extends CvStatModel {
    public static final int C_SVC = 100;
    public static final int NU_SVC = 101;
    public static final int ONE_CLASS = 102;
    public static final int EPS_SVR = 103;
    public static final int NU_SVR = 104;
    public static final int LINEAR = 0;
    public static final int POLY = 1;
    public static final int RBF = 2;
    public static final int SIGMOID = 3;
    public static final int C = 0;
    public static final int GAMMA = 1;
    public static final int P = 2;
    public static final int NU = 3;
    public static final int COEF = 4;
    public static final int DEGREE = 5;

    protected CvSVM(long addr) {
        super(addr);
    }

    public CvSVM() {
        super(CvSVM.CvSVM_0());
    }

    public CvSVM(Mat trainData, Mat responses, Mat varIdx, Mat sampleIdx, CvSVMParams params) {
        super(CvSVM.CvSVM_1(trainData.nativeObj, responses.nativeObj, varIdx.nativeObj, sampleIdx.nativeObj, params.nativeObj));
    }

    public CvSVM(Mat trainData, Mat responses) {
        super(CvSVM.CvSVM_2(trainData.nativeObj, responses.nativeObj));
    }

    public void clear() {
        CvSVM.clear_0(this.nativeObj);
    }

    public int get_support_vector_count() {
        int retVal = CvSVM.get_support_vector_count_0(this.nativeObj);
        return retVal;
    }

    public int get_var_count() {
        int retVal = CvSVM.get_var_count_0(this.nativeObj);
        return retVal;
    }

    public float predict(Mat sample, boolean returnDFVal) {
        float retVal = CvSVM.predict_0(this.nativeObj, sample.nativeObj, returnDFVal);
        return retVal;
    }

    public float predict(Mat sample) {
        float retVal = CvSVM.predict_1(this.nativeObj, sample.nativeObj);
        return retVal;
    }

    public void predict_all(Mat samples, Mat results) {
        CvSVM.predict_all_0(this.nativeObj, samples.nativeObj, results.nativeObj);
    }

    public boolean train(Mat trainData, Mat responses, Mat varIdx, Mat sampleIdx, CvSVMParams params) {
        boolean retVal = CvSVM.train_0(this.nativeObj, trainData.nativeObj, responses.nativeObj, varIdx.nativeObj, sampleIdx.nativeObj, params.nativeObj);
        return retVal;
    }

    public boolean train(Mat trainData, Mat responses) {
        boolean retVal = CvSVM.train_1(this.nativeObj, trainData.nativeObj, responses.nativeObj);
        return retVal;
    }

    public boolean train_auto(Mat trainData, Mat responses, Mat varIdx, Mat sampleIdx, CvSVMParams params, int k_fold, CvParamGrid Cgrid, CvParamGrid gammaGrid, CvParamGrid pGrid, CvParamGrid nuGrid, CvParamGrid coeffGrid, CvParamGrid degreeGrid, boolean balanced) {
        boolean retVal = CvSVM.train_auto_0(this.nativeObj, trainData.nativeObj, responses.nativeObj, varIdx.nativeObj, sampleIdx.nativeObj, params.nativeObj, k_fold, Cgrid.nativeObj, gammaGrid.nativeObj, pGrid.nativeObj, nuGrid.nativeObj, coeffGrid.nativeObj, degreeGrid.nativeObj, balanced);
        return retVal;
    }

    public boolean train_auto(Mat trainData, Mat responses, Mat varIdx, Mat sampleIdx, CvSVMParams params) {
        boolean retVal = CvSVM.train_auto_1(this.nativeObj, trainData.nativeObj, responses.nativeObj, varIdx.nativeObj, sampleIdx.nativeObj, params.nativeObj);
        return retVal;
    }

    @Override
    protected void finalize() throws Throwable {
        CvSVM.delete(this.nativeObj);
    }

    private static native long CvSVM_0();

    private static native long CvSVM_1(long var0, long var2, long var4, long var6, long var8);

    private static native long CvSVM_2(long var0, long var2);

    private static native void clear_0(long var0);

    private static native int get_support_vector_count_0(long var0);

    private static native int get_var_count_0(long var0);

    private static native float predict_0(long var0, long var2, boolean var4);

    private static native float predict_1(long var0, long var2);

    private static native void predict_all_0(long var0, long var2, long var4);

    private static native boolean train_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native boolean train_1(long var0, long var2, long var4);

    private static native boolean train_auto_0(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17, long var19, long var21, long var23, boolean var25);

    private static native boolean train_auto_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void delete(long var0);
}

