/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.highgui;

import java.util.LinkedList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.Size;

public class VideoCapture {
    protected final long nativeObj;

    protected VideoCapture(long addr) {
        this.nativeObj = addr;
    }

    public VideoCapture() {
        this.nativeObj = VideoCapture.n_VideoCapture();
    }

    public VideoCapture(int device) {
        this.nativeObj = VideoCapture.n_VideoCapture(device);
    }

    public double get(int propId) {
        double retVal = VideoCapture.n_get(this.nativeObj, propId);
        return retVal;
    }

    public List<Size> getSupportedPreviewSizes() {
        String[] sizes_str = VideoCapture.n_getSupportedPreviewSizes(this.nativeObj).split(",");
        LinkedList<Size> sizes = new LinkedList<Size>();
        String[] stringArray = sizes_str;
        int n = sizes_str.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            String[] wh = str.split("x");
            sizes.add(new Size(Double.parseDouble(wh[0]), Double.parseDouble(wh[1])));
            ++n2;
        }
        return sizes;
    }

    public boolean grab() {
        boolean retVal = VideoCapture.n_grab(this.nativeObj);
        return retVal;
    }

    public boolean isOpened() {
        boolean retVal = VideoCapture.n_isOpened(this.nativeObj);
        return retVal;
    }

    public boolean open(int device) {
        boolean retVal = VideoCapture.n_open(this.nativeObj, device);
        return retVal;
    }

    public boolean read(Mat image) {
        boolean retVal = VideoCapture.n_read(this.nativeObj, image.nativeObj);
        return retVal;
    }

    public void release() {
        VideoCapture.n_release(this.nativeObj);
    }

    public boolean retrieve(Mat image, int channel) {
        boolean retVal = VideoCapture.n_retrieve(this.nativeObj, image.nativeObj, channel);
        return retVal;
    }

    public boolean retrieve(Mat image) {
        boolean retVal = VideoCapture.n_retrieve(this.nativeObj, image.nativeObj);
        return retVal;
    }

    public boolean set(int propId, double value) {
        boolean retVal = VideoCapture.n_set(this.nativeObj, propId, value);
        return retVal;
    }

    protected void finalize() throws Throwable {
        VideoCapture.n_delete(this.nativeObj);
        super.finalize();
    }

    private static native long n_VideoCapture();

    private static native long n_VideoCapture(String var0);

    private static native long n_VideoCapture(int var0);

    private static native double n_get(long var0, int var2);

    private static native boolean n_grab(long var0);

    private static native boolean n_isOpened(long var0);

    private static native boolean n_open(long var0, String var2);

    private static native boolean n_open(long var0, int var2);

    private static native boolean n_read(long var0, long var2);

    private static native void n_release(long var0);

    private static native boolean n_retrieve(long var0, long var2, int var4);

    private static native boolean n_retrieve(long var0, long var2);

    private static native boolean n_set(long var0, int var2, double var3);

    private static native String n_getSupportedPreviewSizes(long var0);

    private static native void n_delete(long var0);
}

