/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ImageUtils {
    private static final String tag = Logger.makeLogTag("ImageUtils");

    public static String convertImageTo64String(String imagePath) {
        String encodedImage = "";
        if (!StringUtils.isEmptyOrNull(imagePath)) {
            byte[] data = FileUtils.getByteArray(imagePath);
            encodedImage = Base64.encodeToString((byte[])data, (int)0);
        }
        return encodedImage;
    }

    public static Bitmap convert64StringToImage(Context context, String content, int requiredWidth, int requiredHeight, boolean isDataEncrypted) {
        Bitmap result = null;
        if (!StringUtils.isEmptyOrNull(content)) {
            byte[] data = Base64.decode((String)content, (int)0);
            if (isDataEncrypted) {
                // empty if block
            }
            result = ImageUtils.decodeScaledByteArray(data, requiredWidth, requiredHeight);
        }
        return result;
    }

    public static Bitmap decodeByteArray(byte[] data) {
        Bitmap image = null;
        try {
            image = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        }
        catch (Exception e) {
            Logger.e(tag, e.getMessage());
        }
        return image;
    }

    public static Bitmap getScalledImageFromFile(Context context, String imagePath, int requiredWidth, int requiredHeight) {
        byte[] data = FileUtils.getByteArray(imagePath);
        if (data == null) {
            return null;
        }
        Bitmap bitmap = ImageUtils.decodeScaledByteArray(data, requiredWidth, requiredHeight);
        return bitmap;
    }

    public static Bitmap decodeScaledByteArray(byte[] data, int requiredWidth, int requiredHeight) {
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)new ByteArrayInputStream(data), null, (BitmapFactory.Options)o);
        int scale = 1;
        while (o.outWidth / scale / 2 >= requiredWidth && o.outHeight / scale / 2 >= requiredHeight) {
            scale *= 2;
        }
        BitmapFactory.Options o2 = new BitmapFactory.Options();
        o2.inPreferredConfig = Bitmap.Config.RGB_565;
        o2.inSampleSize = scale;
        return BitmapFactory.decodeStream((InputStream)new ByteArrayInputStream(data), null, (BitmapFactory.Options)o2);
    }
}

