/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.ToggleButton;
import com.topimagesystems.R;
import com.topimagesystems.camera2.AutoFitTextureView;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraController;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraOverlayLayout;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.controllers.imageanalyze.DynamicCaptureCameraController;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.ui.CheckBounderiesView;
import com.topimagesystems.ui.OneUnitLeveler;
import com.topimagesystems.ui.ScaleLeveler;
import com.topimagesystems.ui.TwoUnitsLeveler;
import com.topimagesystems.util.UserInterfaceUtils;
import org.opencv.core.Rect;

public class DynamicCameraOverlayLayout
extends CameraOverlayLayout {
    private Context context;
    private boolean grid = true;
    private int heightGridLineNumber = 12;
    private int widthGridLineNumber = 12;
    public float[] topLeft;
    public float[] topRight;
    public float[] bottomLeft;
    public float[] bottomRight;
    public boolean isValidRect;
    public boolean isRectFound;
    private Path path;
    Paint validRectPaintStroke;
    Paint validRectPaintFill;
    Paint inValidRectPaint;
    Paint gridPaint;
    private Button btnCancel;
    private ImageView sucessImg;
    private CameraController.ActionClickListener actionClickListener;
    private Matrix scaleMatrix = null;

    public DynamicCameraOverlayLayout(Context _context) {
        super(_context);
        this.context = _context;
        this.path = new Path();
    }

    public DynamicCameraOverlayLayout(Context _context, AttributeSet attributeSet) {
        super(_context, attributeSet);
        this.context = _context;
        this.path = new Path();
    }

    @Override
    public void ensureUI() {
        if (!UserInterfaceUtils.hasHardwareAcceleration(DynamicCaptureCameraController.getInstance())) {
            AutoFitTextureView mTextureView = (AutoFitTextureView)this.findViewById(R.id.texture);
            mTextureView.setVisibility(8);
        }
        this.btnCancel = (Button)this.findViewById(R.id.dynamicBtnCancel);
        this.sucessImg = (ImageView)this.findViewById(R.id.succssesImg);
        this.sucessImg.setVisibility(8);
        this.horizontalScaleLeveler = (ScaleLeveler)this.findViewById(R.id.dynamicScaleLevelerHorizontal);
        this.verticalScaleLeveler = (ScaleLeveler)this.findViewById(R.id.dynamicScaleLevelerVertical);
        this.oneUnitLeveler = (OneUnitLeveler)this.findViewById(R.id.dynamicOneUnitLeveler);
        this.horizontalLeveler = (TwoUnitsLeveler)this.findViewById(R.id.dynamicLevelerHorizontal);
        this.verticalLeveler = (TwoUnitsLeveler)this.findViewById(R.id.dynamicLevelerPortrait);
        this.spinner = (ProgressBar)this.findViewById(R.id.dynamicLayoutProgressBar);
        this.textIndicator = (TextView)this.findViewById(R.id.DynamicTxtIndicator);
        this.textHoldIndicator = (TextView)this.findViewById(R.id.DynamicHoldIndicator);
        this.imgLogoWaterMark = (ImageView)this.findViewById(R.id.dynamicImgLogoWaterMark);
        this.btnTorch = (ToggleButton)this.findViewById(R.id.dynamicBtnTorch);
        this.fadeOut = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.view_fade_out);
        this.isOneUnitLeveler = this.oneUnitLeveler.getVisibility() == 0;
        this.fadeOut = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.view_fade_out);
        this.btnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!CameraManagerController.isStillMode && CameraController.processStart) {
                    return;
                }
                DynamicCameraOverlayLayout.this.actionClickListener.quit();
            }
        });
        this.btnTorch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                buttonView.setEnabled(false);
                Message message = CameraController.getInstance().getHandler().obtainMessage(16);
                message.obj = isChecked;
                CameraController.getInstance().getHandler().sendMessage(message);
            }
        });
        if (this.oneUnitLeveler != null) {
            this.initOneUnitLeveler();
        }
        this.initLeveler();
        this.setAnimationListener();
        if (this.checkBoundariesRect != null) {
            this.initcheckBounderiesView(this.checkBoundariesRect);
        }
        this.btnTorch.setVisibility(CameraController.isCameraFlashSupported ? 0 : 4);
    }

    @Override
    public void onClick(View v) {
    }

    @Override
    public void showCheckBoundyRect(boolean isShow, Rect rect) {
    }

    @Override
    public void setActionClickListener(CameraController.ActionClickListener actionClickListener) {
        this.actionClickListener = actionClickListener;
    }

    @Override
    public void setCaptureCaption(CameraTypes.CaptureMode captureMode) {
    }

    protected void onDraw(Canvas canvas) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        int screenWidth = metrics.widthPixels;
        int screenHeight = metrics.heightPixels;
        double widthSize = screenWidth / this.widthGridLineNumber;
        double heightSize = screenHeight / this.heightGridLineNumber;
        if (this.textHoldIndicator.getVisibility() == 0) {
            this.isValidRect = true;
        }
        if (this.grid) {
            if (this.gridPaint == null) {
                this.gridPaint = new Paint();
                this.gridPaint.setAntiAlias(true);
                this.gridPaint.setStrokeWidth(3.0f);
                this.gridPaint.setStyle(Paint.Style.STROKE);
                this.gridPaint.setColor(this.getResources().getColor(R.color.grid_line_color));
            }
            int i = (int)widthSize;
            while ((double)i < (double)screenWidth + widthSize) {
                canvas.drawLine((float)i, 0.0f, (float)i, (float)screenHeight, this.gridPaint);
                i = (int)((double)i + widthSize);
            }
            i = (int)heightSize;
            while ((double)i < (double)screenHeight + heightSize) {
                canvas.drawLine(0.0f, (float)i, (float)screenWidth, (float)i, this.gridPaint);
                i = (int)((double)i + heightSize);
            }
        }
        if (this.validRectPaintStroke == null) {
            this.validRectPaintStroke = new Paint();
            this.validRectPaintStroke.setAntiAlias(true);
            this.validRectPaintStroke.setStrokeWidth(10.0f);
            this.validRectPaintStroke.setColor(this.getResources().getColor(R.color.validRectStrokeColor));
            this.validRectPaintStroke.setStyle(Paint.Style.STROKE);
        }
        if (this.validRectPaintFill == null) {
            this.validRectPaintFill = new Paint();
            this.validRectPaintFill.setAntiAlias(true);
            this.validRectPaintFill.setStrokeWidth(10.0f);
            this.validRectPaintFill.setColor(this.getResources().getColor(R.color.validRectFillColor));
            this.validRectPaintFill.setStyle(Paint.Style.FILL);
        }
        if (this.inValidRectPaint == null) {
            this.inValidRectPaint = new Paint();
            this.inValidRectPaint.setAntiAlias(true);
            this.inValidRectPaint.setStrokeWidth(8.0f);
            this.inValidRectPaint.setStyle(Paint.Style.STROKE);
            this.inValidRectPaint.setColor(this.getResources().getColor(R.color.invalidRectStrokeColor));
        }
        if (!this.isRectFound) {
            this.path.reset();
            canvas.drawPath(this.path, this.validRectPaintStroke);
            return;
        }
        if (this.bottomLeft != null && this.topLeft[0] != 0.0f) {
            this.path.reset();
            if (this.isRectFound) {
                if (this.scaleMatrix == null) {
                    RectF nativeResRect;
                    RectF previewRect;
                    int screenSmallRes;
                    int screenBigRes;
                    int videoSmallRes;
                    int videoBigRes;
                    this.scaleMatrix = new Matrix();
                    if (CameraConfigurationManager.videoResolutionWidth > CameraConfigurationManager.videoResolutionHeight) {
                        videoBigRes = CameraConfigurationManager.videoResolutionWidth;
                        videoSmallRes = CameraConfigurationManager.videoResolutionHeight;
                    } else {
                        videoSmallRes = CameraConfigurationManager.videoResolutionWidth;
                        videoBigRes = CameraConfigurationManager.videoResolutionHeight;
                    }
                    if (CameraConfigurationManager.screenResolution.x > CameraConfigurationManager.screenResolution.y) {
                        screenBigRes = CameraConfigurationManager.screenResolution.x;
                        screenSmallRes = CameraConfigurationManager.screenResolution.y;
                    } else {
                        screenBigRes = CameraConfigurationManager.screenResolution.y;
                        screenSmallRes = CameraConfigurationManager.screenResolution.x;
                    }
                    if (CameraManagerController.sessionType != CaptureIntent.SessionType.PORTRAIT) {
                        previewRect = new RectF(0.0f, 0.0f, (float)screenBigRes, (float)screenSmallRes);
                        nativeResRect = new RectF(0.0f, 0.0f, (float)videoBigRes, (float)videoSmallRes);
                    } else {
                        previewRect = new RectF(0.0f, 0.0f, (float)screenSmallRes, (float)screenBigRes);
                        nativeResRect = new RectF(0.0f, 0.0f, (float)videoSmallRes, (float)videoBigRes);
                    }
                    this.scaleMatrix.setRectToRect(nativeResRect, previewRect, Matrix.ScaleToFit.FILL);
                }
                this.path.moveTo(this.topLeft[0], this.topLeft[1]);
                this.path.quadTo(this.topLeft[0], this.topLeft[1], this.topRight[0], this.topRight[1]);
                this.path.quadTo(this.topRight[0], this.topRight[1], this.bottomRight[0], this.bottomRight[1]);
                this.path.quadTo(this.bottomRight[0], this.bottomRight[1], this.bottomLeft[0], this.bottomLeft[1]);
                this.path.quadTo(this.bottomLeft[0], this.bottomLeft[1], this.topLeft[0], this.topLeft[1]);
                this.path.transform(this.scaleMatrix);
                if (this.isValidRect) {
                    canvas.drawPath(this.path, this.validRectPaintStroke);
                    canvas.drawPath(this.path, this.validRectPaintFill);
                } else {
                    canvas.drawPath(this.path, this.inValidRectPaint);
                }
            }
        }
        this.invalidate();
    }

    @Override
    protected void initcheckBounderiesView(CheckBoundaries checkBoundariesRect) {
        this.isCheckBounderiesViewInit = true;
        Point displayDimensions = UserInterfaceUtils.getDisplayDimensions(this.getContext());
        this.checkBounderiesView = (CheckBounderiesView)this.findViewById(R.id.dynamicCheckBounderiesView);
        this.checkBounderiesView.setCheckBounderies(displayDimensions, checkBoundariesRect);
        this.horizontalLeveler = (TwoUnitsLeveler)this.findViewById(R.id.dynamicLevelerHorizontal);
        this.horizontalScaleLeveler = (ScaleLeveler)this.findViewById(R.id.dynamicScaleLevelerHorizontal);
        this.verticalLeveler = (TwoUnitsLeveler)this.findViewById(R.id.dynamicLevelerPortrait);
        this.verticalScaleLeveler = (ScaleLeveler)this.findViewById(R.id.dynamicScaleLevelerVertical);
    }

    public void showSessionSucessImg() {
        this.sucessImg.setVisibility(0);
    }

    public void showProcessImg() {
        this.spinner.setVisibility(0);
        this.oneUnitLeveler.setVisibility(8);
    }

    public void removeCaptureElements() {
        if (this.sucessImg != null) {
            this.sucessImg.setVisibility(8);
        }
        if (this.spinner != null) {
            this.spinner.setVisibility(8);
        }
    }
}

