/*
 * Decompiled with CFR 0.152.
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.hardware.Camera;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.topimagesystems.R;
import com.topimagesystems.camera2.CameraAPI2Manager;
import com.topimagesystems.controllers.BaseController;
import com.topimagesystems.controllers.imageanalyze.CameraConfigurationManager;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;
import com.topimagesystems.controllers.imageanalyze.CameraOverlayLayout;
import com.topimagesystems.controllers.imageanalyze.CameraSessionManager;
import com.topimagesystems.controllers.imageanalyze.CameraTypes;
import com.topimagesystems.controllers.imageanalyze.CheckBoundaries;
import com.topimagesystems.controllers.imageanalyze.DynamicCameraOverlayLayout;
import com.topimagesystems.controllers.imageanalyze.DynamicCaptureCameraController;
import com.topimagesystems.controllers.imageanalyze.OCRAnalyzeSession;
import com.topimagesystems.controllers.imageanalyze.OCRHelper;
import com.topimagesystems.controllers.imageanalyze.PreviewCallback;
import com.topimagesystems.controllers.imageanalyze.ProcessStillImageThread;
import com.topimagesystems.data.Preferences;
import com.topimagesystems.data.SessionResultParams;
import com.topimagesystems.intent.CaptureIntent;
import com.topimagesystems.micr.BoundingBoxResult;
import com.topimagesystems.micr.MobiCHECKOCR;
import com.topimagesystems.micr.OCRCommon;
import com.topimagesystems.micr.OCRResult;
import com.topimagesystems.micr.TISPassportProcessingResults;
import com.topimagesystems.ui.InfoScreenActivity;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.OcrValidationUtils;
import com.topimagesystems.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import org.opencv.android.OpenCVLoader;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.imgproc.Imgproc;

@SuppressLint(value={"NewApi"})
public class CameraController
extends BaseController
implements SurfaceHolder.Callback,
CaptureIntent.callbackReturnMessage {
    protected static final String TAG = Logger.makeLogTag("CameraController");
    protected boolean isDebug;
    protected static boolean isInitalized;
    protected CameraActivityHandler handler;
    protected boolean isSurfaceCreated;
    protected MobiCHECKOCR mobiCHECKOCR;
    public RelativeLayout layoutRoot;
    public SurfaceView surfaceView;
    public CameraOverlayLayout cameraOverlayView;
    public CameraAPI2Manager camera2Instance;
    protected DynamicCameraOverlayLayout dynamicCameraOverlayView;
    protected boolean isValidOrientation = true;
    private CameraConfigurationManager configManager;
    public SensorManager sensorManager;
    protected CameraSessionManager cameraSessionManager;
    protected boolean isBinarizeCurrentImageAsIs;
    public static boolean captureStillStarted;
    private Preferences preferences;
    private Timer infoScreenTimer;
    protected boolean isInfoScreenEnable = true;
    protected long infoScreenInterval;
    public static boolean dontShowActivityInfoScreen;
    public static boolean doOcrOnly;
    protected Camera camera;
    private Mat matYuv;
    protected static CameraController activity;
    public static Rect checkRect;
    private Context context;
    boolean isBlurEnabled;
    public static int currentImage;
    private boolean initialized = false;
    private String[] inputFilesPath;
    private TextView ImageNumberTitle;
    private TextView ImageNumberCounter;
    private Activity currentActivity;
    public static boolean videoImageTaken;
    public static boolean timeVideoCaptureEnd;
    public static boolean drawFoundedRectangle;
    private int sessionResult = -1;
    protected CameraTypes.TISFlowGeneralMessages currentCallBack;
    protected CameraTypes.TISFlowErrorMessage currentError;
    public static CameraManagerController.TISMobiFlowMessages listener;
    private static boolean backPressed;
    public static boolean processStart;
    protected static boolean useCustomAlert;
    protected static boolean isCameraFlashSupported;
    protected String[] extraDataToCallingApp = new String[10];
    protected static CaptureIntent.callbackReturnMessage callBack;
    private CheckBoundaries checkBoundaries;
    private ProgressBar mProgress;

    public static CameraController getInstance() {
        return activity;
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        try {
            CameraManagerController.falseRecognitionVideoFrames = 0;
            CameraManagerController.BarcodeDetectionTries = 0;
            this.checkExceptionalDevices();
            OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
            FileUtils.makeAppDirExists((Context)this);
            Logger.i(TAG, "onCreate started");
            activity = this;
            this.isDebug = CameraManagerController.isDebug;
            this.getWindow().setFlags(1024, 1024);
            this.requestWindowFeature(1);
            callBack = this;
            this.currentActivity = this;
            if (this.getIntent() != null) {
                doOcrOnly = this.getIntent().getBooleanExtra("FIND_RECT_ON_HIGH_RES_IMAGE", false);
            }
            backPressed = false;
            this.verifyMobiCHeckOCR();
            processStart = false;
            if (ocrAnalyzeSession == null || ocrAnalyzeSession.getCheckBoundaries() == null) {
                Intent data = new Intent();
                Logger.e(TAG, this.getResources().getString(R.string.TISFlowFailedToOpenCamera));
                data.putExtra("MOBIFLOW_ERROR_DETAILS", this.getResources().getString(R.string.TISFlowFailedToOpenCamera));
                this.setResult(119, data);
                this.finish();
                return;
            }
            this.checkBoundaries = ocrAnalyzeSession.getCheckBoundaries();
            CameraSessionManager.init(this.currentActivity, this.checkBoundaries, ocrAnalyzeSession.minRatioHW, ocrAnalyzeSession.maxRatioHW);
            Logger.i(TAG, "verifyMobiHWOCR started");
            this.cameraSessionManager = CameraSessionManager.getInstance();
            CheckBoundaries checkBoundariesRect = this.cameraSessionManager.getCheckBoundariesRect();
            Logger.i(TAG, "ValidationRect is: x= " + checkBoundariesRect.getValidationRect().x + "y=" + checkBoundariesRect.getValidationRect().y + "width=" + checkBoundariesRect.getValidationRect().width + "height=" + checkBoundariesRect.getValidationRect().height);
            Logger.i(TAG, "MinCheckRect is: x= " + checkBoundariesRect.getMinCheckRect().x + "y=" + checkBoundariesRect.getMinCheckRect().y + "width=" + checkBoundariesRect.getMinCheckRect().width + "height=" + checkBoundariesRect.getMinCheckRect().height);
            if (CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
                CheckBoundaries checkBoundariesRectView = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).getCheckBoundariesDisp();
                this.mobiCHECKOCR.setValidationCheckRect(checkBoundariesRectView.getValidationRect(), checkBoundariesRectView.getMinCheckRect(), checkBoundariesRectView.getValidationRectBack(), checkBoundariesRectView.getMinCheckRectBack());
            } else {
                this.mobiCHECKOCR.setValidationCheckRect(checkBoundariesRect.getValidationRect(), checkBoundariesRect.getMinCheckRect(), checkBoundariesRect.getValidationRectBack(), checkBoundariesRect.getMinCheckRectBack());
            }
            Window window = this.getWindow();
            window.addFlags(128);
            if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
                this.setRequestedOrientation(1);
            } else {
                this.setRequestedOrientation(0);
            }
            if (doOcrOnly) {
                String imagePath = this.getIntent().getStringExtra("IMAGE_PATH_AFTER_FALIURE");
                this.ProceedAfterMaxRetries();
                this.startBinarizationAfterFaliure(imagePath);
            }
            if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST) {
                this.setContentView(R.layout.run_ocr_library);
                String libLocation = this.getIntent().getStringExtra("FOLDER_LOCATION");
                this.ImageNumberTitle = (TextView)this.findViewById(R.id.ImageNumberTitle);
                this.ImageNumberCounter = (TextView)this.findViewById(R.id.ImageNumberCounter);
                this.configManager = new CameraConfigurationManager(this);
                if (this.camera == null) {
                    this.camera = Camera.open();
                }
                if (!this.initialized) {
                    this.initialized = true;
                }
                this.configManager.setDesiredCameraParameters(this.camera, false);
                this.camera.release();
                new TestOcrTask().execute(new String[]{libLocation});
                return;
            }
            this.initUI();
            if (this.isBinarizeCurrentImageAsIs) {
                // empty if block
            }
            Logger.i(TAG, "verifyMobiCHeckOCR ended");
            this.preferences = Preferences.getInstance((Context)this);
            if (!this.preferences.getIsNoInfoDisplay()) {
                this.showInfoActivity();
            }
            captureStillStarted = false;
            Logger.i(TAG, "scan front only parameter set to " + CameraManagerController.scanFrontOnly);
            this.checkMinHWConditions();
        }
        catch (Exception e) {
            String errorMessage = Log.getStackTraceString((Throwable)e);
            if (errorMessage == null) {
                errorMessage = "";
            }
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile(TAG + " Exception ", errorMessage, this.getApplicationContext());
            }
            Intent data = new Intent();
            Logger.e(TAG, errorMessage);
            data.putExtra("MOBIFLOW_ERROR_DETAILS", errorMessage);
            this.setResult(119, data);
            this.finish();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkExceptionalDevices() {
        try {
            int i;
            CameraManagerController.invertedCamera = false;
            String all = "all";
            String[] invertedCameraList = this.getResources().getStringArray(R.array.exception_devices_invertedCamera);
            String[] useAPI2DevicesList = this.getResources().getStringArray(R.array.exception_devices_use_cameraAPI2);
            if (!(invertedCameraList != null && invertedCameraList.length != 0 || useAPI2DevicesList != null && useAPI2DevicesList.length != 0)) {
                return;
            }
            if (invertedCameraList != null && invertedCameraList.length > 0) {
                for (i = 0; i < invertedCameraList.length; ++i) {
                    invertedCameraList[i] = invertedCameraList[i].trim().toLowerCase();
                    if (!invertedCameraList[i].equals(all.trim())) continue;
                    CameraManagerController.invertedCamera = true;
                    return;
                }
                if (Arrays.asList(invertedCameraList).contains(CameraManagerController.deviceName.trim().toLowerCase())) {
                    CameraManagerController.invertedCamera = true;
                    return;
                }
            }
            if (useAPI2DevicesList != null && useAPI2DevicesList.length > 0 && !CameraManagerController.isDynamicCapture && !CameraManagerController.useCameraAPI2) {
                for (i = 0; i < useAPI2DevicesList.length; ++i) {
                    useAPI2DevicesList[i] = useAPI2DevicesList[i].trim().toLowerCase();
                    if (!useAPI2DevicesList[i].equals(all.trim())) continue;
                    CameraManagerController.useCameraAPI2 = true;
                    return;
                }
                if (Arrays.asList(useAPI2DevicesList).contains(CameraManagerController.deviceName.trim().toLowerCase())) {
                    CameraManagerController.useCameraAPI2 = true;
                    return;
                }
            }
        }
        catch (Exception e) {
            Logger.e(TAG, Log.getStackTraceString((Throwable)e));
        }
    }

    protected void onStart() {
        super.onStart();
    }

    public void startCameraAPI2() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mobiCHECKOCR.setHandler(this.handler);
            this.handleProcessPreviouslyCapturedImage();
            this.sensorManager.registerListener((SensorEventListener)(CameraManagerController.isDynamicCapture ? this.dynamicCameraOverlayView : this.cameraOverlayView), this.sensorManager.getDefaultSensor(2), 0);
            this.sensorManager.registerListener((SensorEventListener)(CameraManagerController.isDynamicCapture ? this.dynamicCameraOverlayView : this.cameraOverlayView), this.sensorManager.getDefaultSensor(1), 0);
            this.camera2Instance = new CameraAPI2Manager();
            this.camera2Instance.startCamera();
        }
    }

    public static void unregisterListener() {
        listener = null;
    }

    public void onSentUIEventMessage(CameraTypes.TISFlowUIMessages message) {
        if (listener != null) {
            listener.onMobiFlowUIEventMessageReceived(message, (ViewGroup)this.cameraOverlayView);
        }
    }

    protected boolean continueVideoModeOrShowAlert() {
        try {
            OCRCommon.ErrorCode error = CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode;
            if (CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode == CameraTypes.OCRAnalyzeErrorCode.ERROR_MICR_LENGTH) {
                return true;
            }
            switch (error) {
                case errorNoValidBoundingBox: {
                    return true;
                }
                case errorBlurDetectionFailed: {
                    this.cameraSessionManager.requestAutoFocus(this.handler, 3);
                    Logger.e(TAG, "taking focus!!");
                    return !CameraManagerController.isStillMode;
                }
                case notValidBoundaries: {
                    return true;
                }
                case errorPanNotFound: {
                    return true;
                }
                case errorOcrReading: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void initUI() {
        this.layoutRoot = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams rlp = new RelativeLayout.LayoutParams(-1, -1);
        this.layoutRoot.setLayoutParams((ViewGroup.LayoutParams)rlp);
        RelativeLayout.LayoutParams previewSurfaceParams = new RelativeLayout.LayoutParams(-1, -1);
        this.surfaceView = new SurfaceView(this.getApplicationContext());
        this.surfaceView.setLayoutParams((ViewGroup.LayoutParams)previewSurfaceParams);
        this.layoutRoot.addView((View)this.surfaceView);
        Logger.i(TAG, "surfaceView added");
        this.cameraOverlayView = (CameraOverlayLayout)this.getLayoutInflater().inflate(CameraManagerController.isCustomView ? R.layout.custom_mbck_camera_layout : R.layout.mbck_camera_layout, null);
        this.cameraOverlayView.setIsTorchOn(CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).isTorchOn);
        this.cameraOverlayView.setIsManualCapture(CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).isManualCapture);
        if (CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).isBarcodeSession) {
            this.cameraOverlayView.setCheckBoundariesRect(CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).getCheckBoundariesDisp());
        } else {
            this.cameraOverlayView.setCheckBoundariesRect(CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).getCheckBoundariesDisp());
        }
        this.cameraOverlayView.setActionClickListener(new ActionClickListenerImpl());
        videoImageTaken = false;
        this.layoutRoot.addView((View)this.cameraOverlayView);
        if (doOcrOnly) {
            // empty if block
        }
        this.setContentView((View)this.layoutRoot);
        this.sensorManager = (SensorManager)this.getSystemService("sensor");
        this.handler = null;
        this.isSurfaceCreated = false;
        if (this.getIntent() != null) {
            this.isBinarizeCurrentImageAsIs = this.getIntent().getBooleanExtra("INTENT_IS_BINARIZE_CURRENT_IMAGE_AS_IS", false);
            this.isInfoScreenEnable = this.getIntent().getBooleanExtra("INFO_SCREEN_ENABLED", this.isInfoScreenEnable);
            this.infoScreenInterval = this.getIntent().getLongExtra("INFO_SCREEN_INTERVAL", this.infoScreenInterval);
        }
        if (listener != null) {
            listener.onMobiFlowUIEventMessageReceived(CameraTypes.TISFlowUIMessages.INIT_LAYOUT, (ViewGroup)this.cameraOverlayView);
        }
    }

    private void startTestFlow() {
        try {
            currentImage = 0;
            if (this.inputFilesPath == null || this.inputFilesPath.length == 0 || this.inputFilesPath[currentImage] == null) {
                Toast.makeText((Context)this.getBaseContext(), (CharSequence)"Files Not Found in destenation folder", (int)0).show();
                this.setResult(0);
                this.finish();
            }
            this.ImageNumberTitle.setText((CharSequence)("Process Image " + this.inputFilesPath[currentImage]));
            this.ImageNumberCounter.setText((CharSequence)(currentImage + "/" + this.inputFilesPath.length));
            this.mProgress = (ProgressBar)this.findViewById(R.id.progress_bar);
            this.mProgress.setMax(this.inputFilesPath.length + 1);
            this.mProgress.setProgress(currentImage);
            this.startBinarizationAfterFaliure(this.inputFilesPath[currentImage]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showInfoActivity() {
        if (!this.isInfoScreenEnable) {
            return;
        }
        if (this.infoScreenTimer != null) {
            this.infoScreenTimer.cancel();
            this.infoScreenTimer = null;
        }
        this.infoScreenTimer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!(CameraManagerController.getOcrAnalyzeSession(CameraController.this.getApplicationContext()) == null || CameraManagerController.getOcrAnalyzeSession((Context)CameraController.this.getApplicationContext()).captureMode == null || processStart || dontShowActivityInfoScreen || captureStillStarted)) {
                        CameraController.this.startActivity(new Intent((Context)CameraController.this, InfoScreenActivity.class));
                        dontShowActivityInfoScreen = true;
                    }
                }
                catch (Exception e) {
                    Logger.e(TAG, "Failed to open info screen");
                }
            }
        };
        this.infoScreenTimer.schedule(timerTask, this.infoScreenInterval);
    }

    public boolean getIsDontShowInfoChecked() {
        return this.preferences.getIsNoInfoDisplay();
    }

    protected boolean verifyMobiCHeckOCR() throws Throwable {
        boolean numberOfFaliures = false;
        try {
            if (!isInitalized) {
                this.displayFrameworkBugMessageAndExit(StringUtils.dynamicString((Context)this, "TISFlowErrorReadingImageGeneral"));
                return false;
            }
            OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
            if (ocrAnalyzeSession == null) {
                this.displayFrameworkBugMessageAndExit(StringUtils.dynamicString((Context)this, "TISFlowErrorReadingImageGeneral"));
                return false;
            }
            if (doOcrOnly || ocrAnalyzeSession.captureMode == CameraTypes.CaptureMode.BACK) {
                CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).isBluredEnabled = false;
            }
            if (this.mobiCHECKOCR == null && !this.isFinishing()) {
                try {
                    System.loadLibrary("mobicheck");
                }
                catch (Exception e) {
                    this.displayFrameworkBugMessageAndExit(StringUtils.dynamicString((Context)this, "TISFlowErrorReadingImageGeneral"));
                    return false;
                }
                this.mobiCHECKOCR = new MobiCHECKOCR(this.getApplicationContext(), this.isDebug, ocrAnalyzeSession.minRatioHW, ocrAnalyzeSession.maxRatioHW, ocrAnalyzeSession.currentMICRType.getId(), ocrAnalyzeSession.isUseCustomAlgorithmOnBack, ocrAnalyzeSession.isBinarizeBackSameAsFront, ocrAnalyzeSession.outputHeightInInch, ocrAnalyzeSession.outputWidthInInch, ocrAnalyzeSession.minRatioHWBack, ocrAnalyzeSession.maxRatioHWBack, ocrAnalyzeSession.isIQAEnabled, ocrAnalyzeSession.iqaSettings, ocrAnalyzeSession.isBluredEnabled);
            }
            return true;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            Logger.e(TAG, "Failed to init MobiCHECKOCR (NoSuchFieldException)");
            Intent data = new Intent();
            data.putExtra("MOBIFLOW_ERROR_DETAILS", this.getResources().getString(R.string.TISFlowFailedToOpenResources));
            this.setResult(119, data);
            this.finish();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.e(TAG, "Failed to init MobiCHECKOCR");
            Intent data = new Intent();
            data.putExtra("MOBIFLOW_ERROR_DETAILS", this.getResources().getString(R.string.TISFlowFailedToOpenCamera));
            this.setResult(119, data);
            this.finish();
            throw e;
        }
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void quitActivity() {
        if (this.handler != null) {
            this.handler.removeAllMessages();
        }
        if (this.mobiCHECKOCR != null) {
            this.mobiCHECKOCR.release();
            this.mobiCHECKOCR = null;
        }
        this.setResult(0);
        this.finish();
    }

    public boolean isPreviewing() {
        if (CameraManagerController.useCameraAPI2) {
            return this.camera2Instance != null && !this.camera2Instance.isSessionClosed;
        }
        return this.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW;
    }

    public CameraActivityHandler getHandler() {
        return this.handler;
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.isDebug = savedInstanceState.getBoolean("isDebug");
        OCRAnalyzeSession ocrAnalyzeSession = new OCRAnalyzeSession(savedInstanceState.getBundle("ocrAnalyzeSession"));
        if (CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()) == null) {
            CameraManagerController.setOcrAnalyzeSession(ocrAnalyzeSession);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
        outState.putBoolean("isDebug", this.isDebug);
        try {
            outState.putBundle("ocrAnalyzeSession", ocrAnalyzeSession.toBundle());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        backPressed = false;
        PreviewCallback.processingVideo = false;
        if (!doOcrOnly && CameraManagerController.sessionType != CaptureIntent.SessionType.TEST) {
            try {
                if (!CameraManagerController.useCameraAPI2) {
                    this.startCamera();
                } else {
                    this.handler = new CameraActivityHandler(this, true);
                    this.startCameraAPI2();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                Logger.e(TAG, "Failed to init MobiCHECKOCR (NoSuchFieldException)");
                Intent data = new Intent();
                data.putExtra("MOBIFLOW_ERROR_DETAILS", this.getResources().getString(R.string.TISFlowFailedToOpenResources));
                this.setResult(119, data);
                this.finish();
            }
        }
    }

    private void startCamera() throws Throwable {
        if (this.verifyMobiCHeckOCR()) {
            this.resetCameraOverlay(CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode);
            SurfaceHolder surfaceHolder = this.surfaceView.getHolder();
            if (this.isSurfaceCreated) {
                this.initCamera(surfaceHolder, CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).isTorchOn);
            } else {
                surfaceHolder.addCallback((SurfaceHolder.Callback)this);
                surfaceHolder.setType(3);
            }
            this.sensorManager.registerListener((SensorEventListener)(CameraManagerController.isDynamicCapture ? this.dynamicCameraOverlayView : this.cameraOverlayView), this.sensorManager.getDefaultSensor(2), 0);
            this.sensorManager.registerListener((SensorEventListener)(CameraManagerController.isDynamicCapture ? this.dynamicCameraOverlayView : this.cameraOverlayView), this.sensorManager.getDefaultSensor(1), 0);
        } else {
            this.CloseSession();
            this.displayFrameworkBugMessageAndExit(StringUtils.dynamicString((Context)this, "failedConnectToCamera"));
        }
    }

    protected void onStop() {
        this.isInfoScreenEnable = false;
        if (this.infoScreenTimer != null) {
            this.infoScreenTimer.cancel();
            this.infoScreenTimer = null;
        }
        if (CameraManagerController.useCameraAPI2 && this.camera2Instance != null) {
            this.camera2Instance.closeSessionAndResources();
        }
        super.onStop();
    }

    @Override
    protected void onPause() {
        Logger.i(TAG, "onPause");
        PreviewCallback.processingVideo = true;
        if (CameraManagerController.useCameraAPI2 && this.handler != null) {
            this.handler.removeAllMessages();
        }
        if (!doOcrOnly && CameraManagerController.sessionType != CaptureIntent.SessionType.TEST) {
            this.releaseCameraAndResources();
            Logger.i(TAG, "onPause Camera Closed");
        }
        this.isInfoScreenEnable = false;
        super.onPause();
    }

    private void CloseSession() {
        Logger.i(TAG, "onPause");
        if (this.sensorManager != null) {
            // empty if block
        }
        if (!doOcrOnly && CameraManagerController.sessionType != CaptureIntent.SessionType.TEST) {
            this.releaseCameraAndResources();
            Logger.i(TAG, "onPause Camera Closed");
        }
        this.isInfoScreenEnable = false;
    }

    public void releaseCameraAndResources() {
        Logger.i(TAG, "releasing camera");
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        if (this.sensorManager != null) {
            if (CameraManagerController.isDynamicCapture) {
                this.sensorManager.unregisterListener((SensorEventListener)this.cameraOverlayView);
            } else {
                this.sensorManager.unregisterListener((SensorEventListener)this.dynamicCameraOverlayView);
            }
        }
        if (CameraManagerController.useCameraAPI2 && this.camera2Instance != null) {
            this.camera2Instance.closeSession();
        } else if (this.cameraSessionManager != null) {
            this.cameraSessionManager.closeCamera();
        }
    }

    protected void onDestroy() {
        block4: {
            if (this.camera != null) {
                this.camera.release();
            }
            this.releaseCameraAndResources();
            try {
                if (this.mobiCHECKOCR != null) {
                    this.mobiCHECKOCR.release();
                    this.mobiCHECKOCR = null;
                }
                super.onDestroy();
            }
            catch (Exception e) {
                if (!CameraManagerController.isDebug) break block4;
                Logger.e(TAG, Log.getStackTraceString((Throwable)e));
                FileUtils.addToLogFile(Log.getStackTraceString((Throwable)e), (Context)this);
            }
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        super.onPrepareOptionsMenu(menu2);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        item.getItemId();
        return super.onOptionsItemSelected(item);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.isSurfaceCreated) {
            this.isSurfaceCreated = true;
            Logger.i(TAG, "isSurfaceCreated  init camera");
            this.initCamera(holder, CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).isTorchOn);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.isSurfaceCreated = false;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void setIsValidOrientation(boolean isValidOrientation) {
        this.isValidOrientation = isValidOrientation;
    }

    public boolean isValidOrientation() {
        return this.isValidOrientation;
    }

    protected void initCamera(SurfaceHolder surfaceHolder, boolean isTorchOn) {
        try {
            Logger.i(TAG, "isSurfaceCreated  init camera");
            if (CameraManagerController.deviceName.equals("LGE Nexus 5X") || CameraManagerController.invertedCamera) {
                this.cameraSessionManager.openDriver(surfaceHolder);
            } else {
                this.cameraSessionManager.openCamera(surfaceHolder, isTorchOn);
            }
            this.handleFlashSupport();
            if (this.handler == null && !CameraManagerController.isDynamicCapture) {
                this.handler = new CameraActivityHandler(this, true);
            }
            this.mobiCHECKOCR.setHandler(this.handler);
            this.handleProcessPreviouslyCapturedImage();
        }
        catch (IOException ioe) {
            Logger.w(TAG, "IOException", ioe);
            this.displayFrameworkBugMessageAndExit(StringUtils.dynamicString((Context)this, "failedConnectToCamera"));
        }
        catch (RuntimeException e) {
            Logger.w(TAG, "Unexpected error initializating camera", e);
            this.displayFrameworkBugMessageAndExit(StringUtils.dynamicString((Context)this, "failedConnectToCamera"));
        }
    }

    protected void handleFlashSupport() {
        boolean supported = true;
        Camera sessionCamera = this.cameraSessionManager.getCamera();
        if (sessionCamera == null) {
            supported = false;
        } else {
            List supportedFlashModes;
            Camera.Parameters parameters = sessionCamera.getParameters();
            if (parameters.getFlashMode() == null) {
                supported = false;
            }
            if ((supportedFlashModes = parameters.getSupportedFlashModes()) == null || supportedFlashModes.isEmpty() || supportedFlashModes.size() == 1 && ((String)supportedFlashModes.get(0)).equals("off")) {
                supported = false;
            }
        }
        isCameraFlashSupported = supported;
        if (this.cameraOverlayView != null) {
            this.cameraOverlayView.handleCameraFlashSupport();
        }
        if (this.dynamicCameraOverlayView != null) {
            this.dynamicCameraOverlayView.handleCameraFlashSupport();
        }
    }

    protected void handleProcessPreviouslyCapturedImage() {
        if (this.isBinarizeCurrentImageAsIs) {
            Message message = this.handler.obtainMessage(9);
            OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
            message.obj = ocrAnalyzeSession.captureMode == CameraTypes.CaptureMode.FRONT ? ocrAnalyzeSession.getFrontImagePath() : ocrAnalyzeSession.getBackImagePath();
            this.handler.handleMessage(message);
        }
    }

    private void displayFrameworkBugMessageAndExit(final String message) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)CameraController.this);
                    builder.setTitle((CharSequence)StringUtils.dynamicString(CameraController.this.getBaseContext(), "TISFlowErrorReading"));
                    builder.setMessage((CharSequence)message);
                    builder.setPositiveButton((CharSequence)StringUtils.dynamicString(CameraController.this.getBaseContext(), "TISFlowOK"), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface paramDialogInterface, int paramInt) {
                            CameraController.this.quitActivity();
                        }
                    });
                    if (!CameraController.this.isFinishing()) {
                        builder.show();
                    } else {
                        CameraController.this.quitActivity();
                    }
                }
                catch (Exception e) {
                    Logger.e(TAG, e.getMessage());
                }
            }
        });
    }

    private void resetCameraOverlay(CameraTypes.CaptureMode captureMode) {
        if (!CameraManagerController.isDynamicCapture) {
            this.cameraOverlayView.resetCameraOverlay(captureMode);
        }
    }

    protected void activityResultFinish(boolean result) {
        try {
            if (CameraManagerController.isDebug) {
                FileUtils.addToLogFile(String.valueOf(result), this.getBaseContext());
            }
            this.cameraSessionManager.resetRectComapreCounter();
            Logger.i(TAG, "activity result finish result: " + result);
            if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST) {
                this.onTestActionFinish(result);
                return;
            }
            if (this.cameraSessionManager != null) {
                if (CameraManagerController.isDynamicCapture) {
                    this.cameraSessionManager.resetRectComapreCounter();
                }
                this.cameraSessionManager.setState(CameraSessionManager.State.DONE);
            }
            if (CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).isErrorCountExeedsMaximum()) {
                if (CameraManagerController.scanFrontOnly || CameraManagerController.scanBackOnly || CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode == CameraTypes.CaptureMode.BACK) {
                    this.setResult(112);
                    this.finish();
                } else {
                    this.onCameraControllerSessionResult(true);
                }
                return;
            }
            Intent data = new Intent();
            data.putExtra("result", result);
            if ((CameraManagerController.sessionType == CaptureIntent.SessionType.TEST || this.sessionResult == 0 || doOcrOnly) && result) {
                this.finish();
            } else {
                this.onCameraControllerSessionResult(result);
            }
        }
        catch (Exception e) {
            this.setResult(119);
            String errorMessage = Log.getStackTraceString((Throwable)e);
            Intent data = new Intent();
            Logger.e(TAG, errorMessage);
            data.putExtra("MOBIFLOW_ERROR_DETAILS", errorMessage);
            this.setResult(119, data);
            this.finish();
        }
    }

    protected void onCameraControllerSessionResult(boolean result) {
        OCRAnalyzeSession ocrAnalyzeSession;
        Logger.i(TAG, "Enter CameraManager onCameraControllerSessionResult");
        this.onSentUIEventMessage(CameraTypes.TISFlowUIMessages.AFTER_PROCESSING);
        this.cameraSessionManager.stopPreview();
        this.currentError = null;
        if (CameraManagerController.isDebug) {
            FileUtils.addToLogFile("onCameraControllerSessionResult - build result object", this.getBaseContext());
        }
        if ((ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext())).getFrontImagePath() != null) {
            this.extraDataToCallingApp[0] = ocrAnalyzeSession.getFrontImagePath();
        }
        if (ocrAnalyzeSession.getBackImagePath() != null) {
            if (ocrAnalyzeSession.getFrontImagePath() != null) {
                this.extraDataToCallingApp[1] = ocrAnalyzeSession.getBackImagePath();
            } else {
                this.extraDataToCallingApp[0] = ocrAnalyzeSession.getBackImagePath();
            }
        }
        if (CameraManagerController.isMultiCapture && (CameraManagerController.scanFrontOnly || CameraManagerController.doOcrOnImage && CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode == CameraTypes.CaptureMode.BACK)) {
            OCRResult ocrResult;
            this.currentCallBack = CameraTypes.TISFlowGeneralMessages.MULTI_CAPTURE;
            this.currentError = null;
            if (this.extraDataToCallingApp != null && this.extraDataToCallingApp[0] != null && ocrAnalyzeSession.getOCRAnalyzeResult().getOcrResult() != null && (ocrResult = ocrAnalyzeSession.getOCRAnalyzeResult().getOcrResult()) != null) {
                this.extraDataToCallingApp[2] = String.valueOf(ocrResult.digitalRowLength);
                this.extraDataToCallingApp[3] = ocrResult.ocrResultWithDelimiter;
                this.extraDataToCallingApp[4] = ocrResult.ocrRawResult;
                this.extraDataToCallingApp[5] = ocrResult.scoreResult;
            }
        }
        if (!result) {
            this.sendMessageToCallingApp();
        } else if (!CameraManagerController.scanFrontOnly && CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode == CameraTypes.CaptureMode.FRONT) {
            this.currentCallBack = CameraTypes.TISFlowGeneralMessages.CAPTURE_BACK;
            this.currentError = null;
            listener.onMobiFlowGeneralMessageReceived(this.currentCallBack, null, !CameraManagerController.isDynamicCapture ? this.cameraOverlayView.getContext() : this.dynamicCameraOverlayView.getContext());
        } else if (CameraManagerController.isMultiCapture) {
            this.currentCallBack = CameraTypes.TISFlowGeneralMessages.MULTI_CAPTURE;
            this.currentError = null;
            listener.onMobiFlowGeneralMessageReceived(this.currentCallBack, this.extraDataToCallingApp, !CameraManagerController.isDynamicCapture ? this.cameraOverlayView.getContext() : this.dynamicCameraOverlayView.getContext());
        } else {
            this.setResult(-1);
            this.finish();
        }
    }

    protected void sendMessageToCallingApp() {
        OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
        CameraTypes.TISFlowErrorMessage errorCode = null;
        ocrAnalyzeSession.AddToErrorCounter();
        if (ocrAnalyzeSession.isErrorCountExeedsMaximum()) {
            this.currentError = CameraTypes.TISFlowErrorMessage.ERROR_MAX_RETRIES;
            listener.onMobiFlowErrorMessageReceived(this.currentError, null, !CameraManagerController.isDynamicCapture ? this.cameraOverlayView.getContext() : this.dynamicCameraOverlayView.getContext());
            return;
        }
        if (ocrAnalyzeSession.ocrErrorCode != null) {
            switch (ocrAnalyzeSession.ocrErrorCode) {
                case errorNoValidBoundingBox: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_NO_VALID_BOUNDING_BOX;
                    break;
                }
                case errorIQACornerData: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_IQA_CORNER_DATA;
                    break;
                }
                case errorIQAEdgeData: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_IQA_EDGE_DATA;
                    break;
                }
                case errorIQASkew: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_IQA_SKEW;
                    break;
                }
                case errorIQADarkness: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_IQA_DARKNESS;
                    break;
                }
                case errorIQANumSpots: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_IQA_NUM_SPOTS;
                    break;
                }
                case errorBlurDetectionFailed: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_BLUR_DETECTED;
                    break;
                }
                case detectableColor: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_IMAGE_CONTRAST;
                    break;
                }
                case errorMicrInterrupted: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_MICR_INTERUPPTED;
                    break;
                }
                case errorMICRDetectedOnCheckBack: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_MICR_ON_BACK;
                    break;
                }
            }
        }
        if (errorCode == null && CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).analyzeErrorCode != CameraTypes.OCRAnalyzeErrorCode.NONE) {
            switch (CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).analyzeErrorCode) {
                case FAILED_READING_OCR_GENERAL: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_OCR_READING;
                    break;
                }
                case TISFlowErrorMaxRetries: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_MAX_RETRIES;
                    break;
                }
                case ERROR_MICR_LENGTH: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_MICR_LENGHT;
                    break;
                }
                case FAILED_PREPARING_IMAGE: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_NO_VALID_BOUNDING_BOX;
                    break;
                }
                default: {
                    errorCode = CameraTypes.TISFlowErrorMessage.ERROR_GENERAL_FAIL;
                }
            }
        }
        CameraManagerController.isStillMode = CameraManagerController.isSessionStartsInStills;
        CameraManagerController.falseRecognitionVideoFrames = 0;
        CameraManagerController.BarcodeDetectionTries = 0;
        this.extraDataToCallingApp = new String[10];
        this.currentError = errorCode;
        listener.onMobiFlowErrorMessageReceived(errorCode, null, !CameraManagerController.isDynamicCapture ? this.cameraOverlayView.getContext() : this.dynamicCameraOverlayView.getContext());
    }

    public static void registerListener(CameraManagerController.TISMobiFlowMessages _listener) {
        listener = _listener;
    }

    protected void showOCRReadingError(String title, String message, String confirmText, String cancelText) {
        this.showProcessImageErrorDialog(title, message, confirmText, cancelText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, final int which) {
                dialog.dismiss();
                if (CameraController.this.handler == null) {
                    return;
                }
                CameraController.this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (which == -1) {
                            if (CameraManagerController.getOcrAnalyzeSession(CameraController.this.getApplicationContext()).isErrorCountExeedsMaximum()) {
                                CameraManagerController.getOcrAnalyzeSession(CameraController.this.getApplicationContext()).clearErrorCode();
                                CameraController.this.activityResultFinish(true);
                            } else {
                                if (!CameraManagerController.isDynamicCapture) {
                                    CameraController.this.cameraOverlayView.finishCapture();
                                    CameraController.this.cameraOverlayView.invalidate();
                                } else {
                                    CameraController.this.dynamicCameraOverlayView.removeCaptureElements();
                                }
                                CameraController.this.handler.startPreview();
                            }
                        } else {
                            Intent data = new Intent();
                            if (!CameraManagerController.isMultiCapture) {
                                CameraController.this.setResult(114, data);
                            } else {
                                CameraController.this.setResult(118, data);
                            }
                            CameraController.this.finish();
                        }
                    }
                }, 100L);
            }
        });
    }

    private void showProcessImageErrorDialog(final String title, final String message, final String positiveText, final String cancelText, final DialogInterface.OnClickListener clickListener) {
        if (this.handler == null) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (!CameraController.this.isFinishing()) {
                    AlertDialog ad = new AlertDialog.Builder((Context)CameraController.this).create();
                    ad.setCancelable(false);
                    ad.setTitle((CharSequence)title);
                    ad.setMessage((CharSequence)message);
                    ad.setButton(-1, (CharSequence)positiveText, clickListener);
                    ad.setButton(-2, (CharSequence)cancelText, clickListener);
                    Logger.i(TAG, "positiveText is " + positiveText + " cancelText " + cancelText);
                    ad.show();
                }
            }
        });
    }

    protected void parseResult(boolean result) {
        Logger.i(TAG, "enter parse result camera controller activity");
        OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
        if (!result && CameraManagerController.isDynamicCapture) {
            this.cameraSessionManager.resetRectComapreCounter();
            this.dynamicCameraOverlayView.removeCaptureElements();
        }
        switch (ocrAnalyzeSession.captureMode) {
            case FRONT: {
                if (ocrAnalyzeSession.analyzeErrorCode == null) {
                    ocrAnalyzeSession.analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.NONE;
                }
                if (!useCustomAlert) {
                    this.showErrorAlert();
                    break;
                }
                this.cameraOverlayView.finishCapture();
                this.cameraOverlayView.invalidate();
                if (CameraManagerController.useCameraAPI2) break;
                this.handler.startPreview();
                break;
            }
            case BACK: {
                if (!useCustomAlert) {
                    this.showErrorAlert();
                    break;
                }
                this.cameraOverlayView.finishCapture();
                this.cameraOverlayView.invalidate();
                if (CameraManagerController.useCameraAPI2) break;
                this.handler.startPreview();
                break;
            }
        }
        CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).clearErrorCode();
    }

    protected void showProceedingDialog(String title, String message, final CameraTypes.NEXT_ACTION nextAction) {
        this.showProcessImageErrorDialog(title, message, StringUtils.dynamicString(this.getBaseContext(), "TISFlowOK"), StringUtils.dynamicString(this.getBaseContext(), "TISFlowCancel"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, final int which) {
                dialog.dismiss();
                CameraController.this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (which == -1) {
                            if (nextAction == CameraTypes.NEXT_ACTION.CAPTURE_FRONT) {
                                CameraController.this.handler.startPreview();
                                CameraController.this.cameraOverlayView.finishCapture();
                                CameraController.this.cameraOverlayView.invalidate();
                                CameraController.this.openCameraForFrontCapture(false);
                            } else if (nextAction == CameraTypes.NEXT_ACTION.CAPTURE_BACK) {
                                CameraController.this.handler.startPreview();
                                if (!CameraManagerController.isDynamicCapture) {
                                    CameraController.this.cameraOverlayView.finishCapture();
                                }
                                CameraController.this.openCameraForBackCapture(false);
                                if (!CameraManagerController.isDynamicCapture) {
                                    CameraController.this.cameraOverlayView.invalidate();
                                }
                            } else if (nextAction == CameraTypes.NEXT_ACTION.PROCESS_IMAGE_FOR_SERVER) {
                                CameraController.this.doImageBinarizationOnly();
                            }
                        } else {
                            CameraController.this.setResult(114);
                            CameraController.this.finish();
                        }
                    }
                }, 100L);
            }
        });
    }

    private void onTestActionFinish(boolean result) {
        this.saveImagesToDevice();
        String imageNumber = String.valueOf(currentImage);
        OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
        OCRResult c = ocrAnalyzeSession.getOcrResult();
        String message = null;
        String res = result ? "PASS" : "FAIL";
        String externalStorge = Environment.getExternalStorageDirectory().toString();
        File externalStorageFile = new File(externalStorge);
        String baseImagesFolder = externalStorageFile.getAbsolutePath() + "/" + ".mobiflow/LOG.txt";
        FileUtils.createTestLogFile("", "image name: " + this.inputFilesPath[currentImage] + "  RESULT :" + res, baseImagesFolder, this.getApplicationContext());
        FileUtils.modifySingleImgeLogFile("", "image name: " + this.inputFilesPath[currentImage] + "  RESULT :" + res, null, this.getApplicationContext());
        if (!result) {
            if (ocrAnalyzeSession.analyzeErrorCode != null && ocrAnalyzeSession.analyzeErrorCode.name() != null) {
                message = ocrAnalyzeSession.analyzeErrorCode.name();
                FileUtils.modifySingleImgeLogFile("", message, null, this.getApplicationContext());
            }
            if (ocrAnalyzeSession.ocrErrorCode != null) {
                message = this.getResources().getString(ocrAnalyzeSession.ocrErrorCode.getResourceId());
                String errorMessage = ocrAnalyzeSession.ocrErrorMessage;
                if (CameraManagerController.isDebug && errorMessage != null) {
                    message = message + " | error message: " + errorMessage;
                    FileUtils.modifySingleImgeLogFile("", message, null, this.getApplicationContext());
                }
            }
            if (ocrAnalyzeSession.ocrErrorCode != null && ocrAnalyzeSession.ocrErrorCode.name() != null) {
                message = message + " | error message: " + ocrAnalyzeSession.ocrErrorCode.name().toString();
                FileUtils.modifySingleImgeLogFile("Error Message : ", message, null, this.getApplicationContext());
            }
            if (message != null) {
                FileUtils.modifySingleImgeLogFile("", message, this.inputFilesPath[currentImage], this.getApplicationContext());
            }
        } else if (c != null && c.scoreResult != null && c.scoreResult.length() > 0 && c.ocrRawResult != null && c.ocrRawResult.length() > 0) {
            if (c.scoreResult != null) {
                FileUtils.modifySingleImgeLogFile("Raw Result: ", c.ocrRawResult, this.inputFilesPath[currentImage], this.getApplicationContext());
                FileUtils.modifySingleImgeLogFile("Score Result: ", c.scoreResult, this.inputFilesPath[currentImage], this.getApplicationContext());
            }
            if (c.ocrRawResult != null) {
                FileUtils.modifySingleImgeLogFile("Raw Result With Delimiter", c.ocrResultWithDelimiter, this.inputFilesPath[currentImage], this.getApplicationContext());
            }
        } else {
            FileUtils.modifySingleImgeLogFile("", "okay", this.inputFilesPath[currentImage], this.getApplicationContext());
        }
        Logger.i(TAG, "Image number return is " + currentImage);
        if (++currentImage < this.inputFilesPath.length) {
            this.ImageNumberTitle.setText((CharSequence)("Process Image " + this.inputFilesPath[currentImage]));
            this.ImageNumberCounter.setText((CharSequence)(currentImage + "/" + this.inputFilesPath.length));
            this.mProgress.setProgress(currentImage + 1);
            this.startBinarizationAfterFaliure(this.inputFilesPath[currentImage]);
            Logger.i(TAG, "MobiTest processing image number " + currentImage);
        } else {
            Toast.makeText((Context)this, (CharSequence)("Finish binarization of " + String.valueOf(currentImage) + " images"), (int)0).show();
            Intent data = new Intent();
            this.setResult(111, data);
            this.finish();
        }
    }

    public Camera getCamera() {
        return this.camera;
    }

    private void saveImagesToDevice() {
        if (this.inputFilesPath[currentImage] == null) {
            return;
        }
        String fileName = this.inputFilesPath[currentImage];
        if (CameraManagerController.isDebug) {
            FileUtils.addToLogFile("Test Mode", "current Test image is  " + this.inputFilesPath[currentImage], this.getApplicationContext());
        }
        String imageType = ".jpg";
        if (fileName.contains("_original")) {
            fileName = fileName.replace("original", "");
        }
        if (fileName.contains("jpeg")) {
            imageType = ".jpeg";
        }
        FileUtils.writeToFile(SessionResultParams.tiffFront, fileName.replace(imageType, "bin.tiff"));
        FileUtils.writeToFile(SessionResultParams.jpegBWFront, fileName.replace(imageType, "bin.jpg"));
        FileUtils.writeToFile(SessionResultParams.colorFront, fileName.replace(imageType, "colored.jpg"));
        FileUtils.writeToFile(SessionResultParams.grayscaleFront, fileName.replace(imageType, "gray.jpg"));
    }

    public void updateProcessingMessageFromJNI(final OCRCommon.OCRDetectorStatus ocrDetectorStatus) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String srcName = CameraController.this.getResources().getResourceEntryName(ocrDetectorStatus.getResourceId());
                String text = StringUtils.dynamicString(CameraController.this.getBaseContext(), srcName);
                if (CameraController.this.cameraOverlayView != null) {
                    CameraController.this.cameraOverlayView.updateProcessingMessage(text);
                }
            }
        });
    }

    public void processCapturedImage(String imagePath) {
        CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).setImagePath(imagePath);
        int timestamp = CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).timestamp;
        if (CameraManagerController.isDynamicCapture) {
            this.handler = DynamicCaptureCameraController.getInstance().getHandler();
        }
        ProcessStillImageThread processStillImageThread = new ProcessStillImageThread(this.getApplicationContext(), this.handler, this.mobiCHECKOCR, this.isDebug, timestamp);
        processStillImageThread.start();
    }

    public void ProceedAfterMaxRetries() {
        OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
        CheckBoundaries checkBoundaries = ocrAnalyzeSession.getCheckBoundaries();
        CameraSessionManager.init(this.currentActivity, checkBoundaries, ocrAnalyzeSession.minRatioHW, ocrAnalyzeSession.maxRatioHW);
        this.cameraSessionManager = CameraSessionManager.getInstance();
        CheckBoundaries checkBoundariesRect = this.cameraSessionManager.getCheckBoundariesRect();
        this.mobiCHECKOCR.setValidationCheckRect(checkBoundariesRect.getValidationRect(), checkBoundariesRect.getMinCheckRect(), checkBoundariesRect.getValidationRectBack(), checkBoundariesRect.getMinCheckRectBack());
        this.handler = new CameraActivityHandler(CameraController.getInstance(), false);
        this.mobiCHECKOCR.setHandler(this.handler);
        this.configManager = new CameraConfigurationManager(this);
        try {
            if (this.camera == null) {
                this.camera = Camera.open();
            }
            this.configManager.initFromCameraParameters(this.camera);
            this.configManager.setDesiredCameraParameters(this.camera, false);
            this.camera.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startBinarizationAfterFaliure(String imagePath) {
        this.matYuv = new Mat();
        byte[] imageData = FileUtils.getByteArray(imagePath);
        if (imageData == null) {
            this.matYuv.put(0, 0, CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode == CameraTypes.CaptureMode.FRONT ? SessionResultParams.originalFront : SessionResultParams.originalBack);
        } else {
            this.matYuv.put(0, 0, imageData);
        }
        long defaultAspectRatio = 1L;
        if (imagePath == null || !imagePath.contains("BACK")) {
            CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode = CameraTypes.CaptureMode.FRONT;
        }
        BoundingBoxResult boundingBoxResult = this.mobiCHECKOCR.findCheckBoundingBoxContinueAnyway(this.matYuv, defaultAspectRatio);
        checkRect = boundingBoxResult.getRect();
        CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).setImagePath(imagePath);
        int timestamp = CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).timestamp;
        if (CameraManagerController.sessionType == CaptureIntent.SessionType.TEST || CameraManagerController.scanBackOnly) {
            this.handler = new CameraActivityHandler(CameraController.getInstance(), false);
            this.mobiCHECKOCR.setHandler(this.handler);
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).checkRect = checkRect;
        }
        ProcessStillImageThread processStillImageThread = new ProcessStillImageThread(this.getApplicationContext(), this.handler, this.mobiCHECKOCR, this.isDebug, timestamp);
        processStillImageThread.start();
    }

    protected void proceedSuccessfullFront(String dialogTitleMessage) {
        CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).isFrontSuccessfull = true;
        CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).frontRetries = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).getOcrErrorCounter();
        CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).initOcrErrorCounter();
        CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode = CameraTypes.CaptureMode.BACK;
        if (!CameraManagerController.enableProcessingView) {
            this.cameraOverlayView.showProcessingOverlay(true);
        }
        if (!useCustomAlert) {
            this.showProceedingDialog(dialogTitleMessage, StringUtils.dynamicString((Context)this, "TISFlowPleaseCaptureCheckBack"), CameraTypes.NEXT_ACTION.CAPTURE_BACK);
        } else {
            if (!CameraManagerController.useCameraAPI2) {
                this.handler.startPreview();
            }
            this.cameraOverlayView.finishCapture();
            this.openCameraForBackCapture(false);
        }
    }

    public void startCallingAppActivity(View view) {
        if (captureStillStarted) {
            return;
        }
        try {
            String infoClass = this.getResources().getString(R.string.TISCallingAppActivityName);
            Class<?> infoActivity = null;
            if (infoClass != null) {
                try {
                    infoActivity = Class.forName(infoClass);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            this.startActivity(new Intent((Context)this, infoActivity));
        }
        catch (Exception e) {
            Logger.e(TAG, "Failed to open Activity on runTime ");
        }
    }

    public void showGreenIndicatorForVideo() {
        if (!CameraManagerController.isDynamicCapture) {
            CameraController.getInstance().cameraOverlayView.setConfirmationIndicators();
        }
    }

    public void showRedIndicatorForVideo() {
        if (!CameraManagerController.isDynamicCapture) {
            this.cameraOverlayView.setNonConfirmationIndicators();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        if (rotation == 0) {
            this.setRequestedOrientation(0);
        } else if (rotation == 1) {
            this.setRequestedOrientation(0);
        } else if (rotation == 2) {
            this.setRequestedOrientation(8);
        }
    }

    public static CaptureIntent.callbackReturnMessage getManagerListener() {
        return callBack;
    }

    public void onBackPressed() {
        if (!processStart) {
            backPressed = true;
            if (listener != null) {
                this.currentCallBack = CameraTypes.TISFlowGeneralMessages.BACK_PRESSED;
                listener.onMobiFlowGeneralMessageReceived(this.currentCallBack, null, this.context);
            } else {
                this.quitActivity();
            }
        }
    }

    public void onDefaultBackPressed() {
        super.onBackPressed();
    }

    @Override
    protected void ensureActionBar() {
    }

    protected void openCameraForFrontCapture(boolean isProcessCurrentImage) {
        Bundle extras = new Bundle();
        extras.putBoolean("INFO_SCREEN_ENABLED", this.isInfoScreenEnable);
        extras.putLong("INFO_SCREEN_INTERVAL", this.infoScreenInterval);
        CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode = CameraTypes.CaptureMode.FRONT;
        this.cameraOverlayView.setCaptureCaption(CameraTypes.CaptureMode.FRONT);
    }

    public void openCameraForBackCapture(boolean isProcessCurrentImage) {
        if (CameraManagerController.isDynamicCapture) {
            this.cameraSessionManager.resetRectComapreCounter();
            this.dynamicCameraOverlayView.removeCaptureElements();
        }
        OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
        ocrAnalyzeSession.captureMode = CameraTypes.CaptureMode.BACK;
        boolean bl = ocrAnalyzeSession.isBarcodeSession = CameraManagerController.enableBarcodeDetection && (CameraManagerController.scanBarcodeLocation == CaptureIntent.TISScanBarcodeLocation.BARCODE_BACK || CameraManagerController.scanBarcodeLocation == CaptureIntent.TISScanBarcodeLocation.BARCODE_FRONT_AND_BACK);
        if (ocrAnalyzeSession.isBarcodeSession && !CameraManagerController.isDynamicCapture) {
            this.cameraOverlayView.setCaptureCaption(ocrAnalyzeSession.captureMode);
        }
        Bundle extras = new Bundle();
        extras.putBoolean("INFO_SCREEN_ENABLED", this.isInfoScreenEnable);
        extras.putLong("INFO_SCREEN_INTERVAL", this.infoScreenInterval);
        if (!CameraManagerController.isDynamicCapture) {
            this.cameraOverlayView.setCaptureCaption(ocrAnalyzeSession.captureMode);
        }
        this.showInfoActivity();
        captureStillStarted = false;
        ocrAnalyzeSession.initOcrErrorCounter();
        CameraManagerController.isStillMode = CameraManagerController.isSessionStartsInStills;
        CameraManagerController.falseRecognitionVideoFrames = 0;
        CameraManagerController.BarcodeDetectionTries = 0;
        if (FileUtils.isSamsungS5() && CameraManagerController.isStillMode) {
            this.cameraSessionManager.requestAutoFocus(this.getHandler(), 3);
        }
    }

    @Override
    public void onMessageReturn(CameraTypes.TISFlowInputMessages result) {
        if (this.currentCallBack == CameraTypes.TISFlowGeneralMessages.BACK_PRESSED) {
            if (result == CameraTypes.TISFlowInputMessages.CONTINUE_CURRENT_SESSION) {
                this.handler.proceedWithProcessing();
                return;
            }
            this.quitActivity();
        }
        if (result == CameraTypes.TISFlowInputMessages.CONTINUE_MOBI_FLOW_CUSTOM_UI) {
            useCustomAlert = true;
            result = CameraTypes.TISFlowInputMessages.CONTINUE_MOBI_FLOW;
        } else {
            useCustomAlert = false;
        }
        if (this.isDebug) {
            FileUtils.addToLogFile(result.name().toString(), this.getBaseContext());
        }
        if (result == null) {
            result = CameraTypes.TISFlowInputMessages.CONTINUE_MOBI_FLOW;
        }
        if (result == CameraTypes.TISFlowInputMessages.CONTINUE_MOBI_FLOW && this.currentCallBack == CameraTypes.TISFlowGeneralMessages.CAPTURE_BACK & this.currentError == null) {
            this.proceedSuccessfullFront(StringUtils.dynamicString((Context)this, "TISSuccessfulReadingTitle"));
            return;
        }
        if (result == CameraTypes.TISFlowInputMessages.CANCEL_SESSION && this.currentCallBack == CameraTypes.TISFlowGeneralMessages.CAPTURE_BACK) {
            this.setResult(117);
            this.finish();
            return;
        }
        if (this.currentCallBack == CameraTypes.TISFlowGeneralMessages.PASSPORT_OCR_RESULT) {
            if (result == CameraTypes.TISFlowInputMessages.OCR_RESULT_FAILED) {
                this.handler.proceedWithProcessing();
            } else {
                activity.activityResultFinish(true);
            }
        }
        switch (result) {
            case CONTINUE_MOBI_FLOW: {
                if (this.currentCallBack == CameraTypes.TISFlowGeneralMessages.MULTI_CAPTURE) {
                    if (CameraManagerController.enableBarcodeDetection) {
                        CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).isBarcodeSession = true;
                    }
                    CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode = !CameraManagerController.scanBackOnly ? CameraTypes.CaptureMode.FRONT : CameraTypes.CaptureMode.BACK;
                    if (!useCustomAlert) {
                        OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
                        if (ocrAnalyzeSession.analyzeErrorCode == null || ocrAnalyzeSession.analyzeErrorCode == CameraTypes.OCRAnalyzeErrorCode.NONE) {
                            this.showOCRReadingError(StringUtils.dynamicString((Context)this, "TISFlowMultiCaptureTitle"), StringUtils.dynamicString((Context)this, "TISMultiCaptureShouldContinueCapture"), StringUtils.dynamicString((Context)this, "TISFlowCapture"), StringUtils.dynamicString((Context)this, "TISFlowFinish"));
                        } else {
                            this.parseResult(false);
                        }
                    } else {
                        this.cameraOverlayView.finishCapture();
                        this.cameraOverlayView.invalidate();
                        if (!CameraManagerController.useCameraAPI2) {
                            this.handler.startPreview();
                        }
                    }
                    this.currentCallBack = null;
                    break;
                }
                this.parseResult(false);
                break;
            }
            case OCR_RESULT_FAILED: {
                this.handler.proceedWithProcessing();
                break;
            }
            case OCR_RESULT_OK: {
                this.activityResultFinish(true);
                break;
            }
            case CANCEL_SESSION: {
                this.setResult(113);
                this.finish();
                break;
            }
            default: {
                this.parseResult(false);
            }
        }
        captureStillStarted = false;
        this.isInfoScreenEnable = false;
    }

    private boolean checkMinHWConditions() {
        try {
            if (!FileUtils.isMinimumCPUSpeed()) {
                Logger.e(TAG, "Device CPU not supported, application need minimum 1000 MHZ");
                if (listener != null) {
                    this.currentError = CameraTypes.TISFlowErrorMessage.UNSPORTTED_CPU;
                    listener.onMobiFlowErrorMessageReceived(this.currentError, null, !CameraManagerController.isDynamicCapture ? this.cameraOverlayView.getContext() : this.dynamicCameraOverlayView.getContext());
                }
                return false;
            }
            if (!this.getPackageManager().hasSystemFeature("android.hardware.camera.autofocus")) {
                if (listener != null) {
                    this.currentError = CameraTypes.TISFlowErrorMessage.UNSPORTTED_AUTO_FOCUS;
                    listener.onMobiFlowErrorMessageReceived(this.currentError, null, !CameraManagerController.isDynamicCapture ? this.cameraOverlayView.getContext() : this.dynamicCameraOverlayView.getContext());
                }
                return false;
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "fail to get camera properties");
            return true;
        }
        return true;
    }

    private void doImageBinarizationOnly() {
        String imagePath = CameraManagerController.getOcrAnalyzeSession((Context)this.getApplicationContext()).captureMode == CameraTypes.CaptureMode.FRONT ? CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).getOCRAnalyzeResult().getFrontImagePath() : CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext()).getOCRAnalyzeResult().getBackImagePath();
        this.startBinarizationAfterFaliure(imagePath);
    }

    @Override
    public void onMessageReturnFailed() {
    }

    private void setScreenOrientation() {
        if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == CaptureIntent.SessionType.PORTRAIT) {
            this.setRequestedOrientation(1);
        } else {
            int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
            if (rotation == 0) {
                this.setRequestedOrientation(0);
            } else if (rotation == 3) {
                this.setRequestedOrientation(8);
            } else if (rotation == 1) {
                this.setRequestedOrientation(0);
            } else if (rotation == 2) {
                this.setRequestedOrientation(8);
            }
        }
    }

    private void showErrorAlert() {
        String message = null;
        OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(this.getApplicationContext());
        if (ocrAnalyzeSession.isErrorCountExeedsMaximum()) {
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorCode = null;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).ocrErrorMessage = null;
            CameraManagerController.getOcrAnalyzeSession((Context)this.context).analyzeErrorCode = CameraTypes.OCRAnalyzeErrorCode.TISFlowErrorMaxRetries;
            message = StringUtils.dynamicString((Context)this, "TISFlowErrorReadingMaxTries");
            this.showOCRReadingError(StringUtils.dynamicString((Context)this, "TISFlowErrorReadingImageGeneral"), message, StringUtils.dynamicString((Context)this, "TISFlowOK"), StringUtils.dynamicString((Context)this, "TISFlowCancel"));
            return;
        }
        if (ocrAnalyzeSession.ocrErrorCode != null) {
            message = this.getResources().getString(ocrAnalyzeSession.ocrErrorCode.getResourceId());
            String errorMessage = ocrAnalyzeSession.ocrErrorMessage;
            if (!CameraManagerController.isDebug || errorMessage != null) {
                // empty if block
            }
            switch (ocrAnalyzeSession.ocrErrorCode) {
                case errorBlurDetectionFailed: {
                    message = StringUtils.dynamicString((Context)this, "TISErrorBlurFail");
                    if (CameraManagerController.isStillMode) break;
                    this.cameraSessionManager.requestAutoFocus(this.getHandler(), 3);
                    break;
                }
                case errorIQADarkness: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorIQADarkness");
                    break;
                }
                case errorIQANumSpots: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorIQANumSpots");
                    break;
                }
                case errorIQAEdgeData: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorIQAEdgeData");
                    break;
                }
                case errorIQACornerData: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorIQACornerData");
                    break;
                }
                case errorIQASkew: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorIQASkew");
                    break;
                }
                case errorInializeOCR: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorReadingOCRMessage");
                    break;
                }
                case errorMicrInterrupted: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowMicrInterrupted");
                    break;
                }
                case errorMICRDetectedOnCheckBack: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowWarningMICRDetectedOnCheckBack");
                    break;
                }
                case errorOcrReading: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorReadingOCRMessage");
                    break;
                }
                case errorPanNotFound: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorReadingOCRMessage");
                    break;
                }
                case errorPassportNotFound: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorReadingOCRMessage");
                    break;
                }
                case errorNoValidBoundingBox: {
                    if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CHECK) {
                        message = StringUtils.dynamicString((Context)this, "TISFlowErrorNoValidBoundingBox");
                        break;
                    }
                    message = StringUtils.dynamicString((Context)this, "TISErrorImageGeneral");
                    break;
                }
            }
        }
        if (message == null) {
            message = "";
            switch (ocrAnalyzeSession.analyzeErrorCode) {
                case FAILED_READING_OCR_GENERAL: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorReadingOCRMessage");
                    break;
                }
                case ERROR_MICR_LENGTH: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowErrorMicrLength");
                    break;
                }
                case FAILED_PREPARING_IMAGE: {
                    if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CHECK) {
                        message = StringUtils.dynamicString((Context)this, "TISFlowErrorNoValidBoundingBox");
                        break;
                    }
                    message = StringUtils.dynamicString((Context)this, "TISErrorImageGeneral");
                    break;
                }
                case TISFlowErrorMicrInterrupted: {
                    message = StringUtils.dynamicString((Context)this, "TISFlowMicrInterrupted");
                    break;
                }
            }
        }
        Logger.i(TAG, "error message is " + message);
        this.showOCRReadingError(StringUtils.dynamicString((Context)this, "TISFlowErrorReadingImageGeneral"), message, StringUtils.dynamicString((Context)this, "TISFlowOK"), StringUtils.dynamicString((Context)this, "TISFlowCancel"));
    }

    static /* synthetic */ String[] access$202(CameraController x0, String[] x1) {
        x0.inputFilesPath = x1;
        return x1;
    }

    static {
        captureStillStarted = false;
        dontShowActivityInfoScreen = false;
        doOcrOnly = false;
        currentImage = 0;
        videoImageTaken = false;
        timeVideoCaptureEnd = false;
        drawFoundedRectangle = false;
        backPressed = false;
        processStart = false;
        useCustomAlert = false;
        isCameraFlashSupported = true;
        isInitalized = OpenCVLoader.initDebug();
    }

    class CheckDeviceHW
    implements Runnable {
        boolean isSucsses = true;

        @Override
        public void run() {
            this.isSucsses = CameraController.this.checkMinHWConditions();
        }
    }

    public static class CameraActivityHandler
    extends Handler {
        final int NEXT_FRAME_DELAY_MAX_INTERVAL = 100000;
        final int NEXT_FRAME_DELAY_COUNTER_STEP_TRIGGER = 2;
        final int NEXT_FRAME_DELAY_COUNTER_STEP_MULITPLIER = 100;
        final int NEXT_FRAME_MAX_DELAY = 1000;
        final WeakReference<CameraController> looperActivity;
        protected long lastTimeWasreceived;
        protected long notOptimalStateCounter = 0L;
        protected long proceedingToNextFrameDelay = 0L;

        public CameraActivityHandler(CameraController cameraController, boolean startPreview) {
            this.looperActivity = new WeakReference<CameraController>(cameraController);
            this.initProceedingToNextFrameDelay();
            if (startPreview) {
                this.startPreview();
            }
        }

        public void handleMessage(Message message) {
            Bundle messageData = message.getData();
            CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "handleMessage cameraController reference is null");
                return;
            }
            Logger.i(TAG, "handler processing message:" + message.what);
            switch (message.what) {
                case 11: {
                    Logger.i(TAG, "MESSAGE_SHOW_COUNTER");
                    int elapsedTime = message.arg1;
                    cameraController.cameraOverlayView.showCounter(true, elapsedTime);
                    if (!CameraManagerController.isDebug || cameraController == null || cameraController.getBaseContext() == null) break;
                    FileUtils.addToLogFile("MESSAGE_SHOW_COUNTER", cameraController.getBaseContext());
                    break;
                }
                case 13: {
                    cameraController.cameraOverlayView.showIndicator(null, false);
                    if (!CameraManagerController.isDebug || cameraController == null || cameraController.getBaseContext() == null) break;
                    FileUtils.addToLogFile("MESSAGE_HIDE_HINT_INDICATOR", cameraController.getBaseContext());
                    break;
                }
                case 12: {
                    Logger.i(TAG, "MESSAGE_SHOW_PROCESSING_LABEL");
                    cameraController.onSentUIEventMessage(CameraTypes.TISFlowUIMessages.BEFORE_PROCESSING);
                    String text = (String)message.obj;
                    if (!CameraManagerController.isStillMode) {
                        if (text.toLowerCase(Locale.getDefault()).contains("processing")) {
                            Logger.d(TAG, "debug");
                        }
                        if (cameraController.cameraOverlayView != null) {
                            cameraController.cameraOverlayView.updateProcessingMessage(text);
                        }
                    }
                    if (!CameraManagerController.isDebug) break;
                    FileUtils.addToLogFile("MESSAGE_SHOW_PROCESSING_LABEL", cameraController.getBaseContext());
                    break;
                }
                case 14: {
                    Logger.i(TAG, "MESSAGE_HIDE_BOUNDARIES_RECT");
                    if (cameraController.isDebug || drawFoundedRectangle) {
                        cameraController.cameraOverlayView.showCheckBoundyRect(false, null);
                    }
                    if (!CameraManagerController.isDebug) break;
                    FileUtils.addToLogFile("MESSAGE_HIDE_BOUNDARIES_RECT", cameraController.getBaseContext());
                    break;
                }
                case 15: {
                    Logger.i(TAG, "MESSAGE_HIDE_ERROR_MESSAGE");
                    cameraController.cameraOverlayView.hideErrorMessage();
                    if (!CameraManagerController.isDebug) break;
                    FileUtils.addToLogFile("MESSAGE_HIDE_ERROR_MESSAGE", cameraController.getBaseContext());
                    break;
                }
                case 3: {
                    Logger.i(TAG, "MESSAGE_AUTO_FOCUS");
                    if (cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW) {
                        cameraController.cameraSessionManager.requestAutoFocus(this, 3);
                    }
                    if (!CameraManagerController.isDebug) break;
                    FileUtils.addToLogFile("MESSAGE_AUTO_FOCUS", cameraController.getBaseContext());
                    break;
                }
                case 4: {
                    Logger.i(TAG, "MESSAGE_RESTART_PREVIEW");
                    Logger.d(TAG, "Got restart preview message");
                    this.restartPreviewAndDecode();
                    if (!CameraManagerController.isDebug) break;
                    FileUtils.addToLogFile("MESSAGE_RESTART_PREVIEW", cameraController.getBaseContext());
                    break;
                }
                case 6: {
                    String hintName = messageData.getString("hintName");
                    String errorCodeName = messageData.getString("analyzeErrorCode");
                    Bundle checkRectBundle = messageData.getBundle("checkRect");
                    double orientation = messageData.getDouble("orientation", 0.0);
                    if (!StringUtils.isEmptyOrNull(hintName)) {
                        CameraTypes.HintIndicator hintIndicator = CameraTypes.HintIndicator.valueOf(hintName);
                        this.checkNextFrameDelay(hintIndicator);
                        CameraController.getInstance().cameraOverlayView.showIndicator(hintIndicator, true);
                        CameraController.getInstance().cameraOverlayView.showCheckBoundyRect(false, null);
                    }
                    if (!StringUtils.isEmptyOrNull(errorCodeName)) {
                        OCRCommon.ErrorCode errorCode = OCRCommon.ErrorCode.valueOf(errorCodeName);
                        if (errorCode == OCRCommon.ErrorCode.error_deviceMemory) {
                            String exception = messageData.getString("exceptionError");
                            Intent data = new Intent();
                            data.putExtra("MOBIFLOW_ERROR_DETAILS", exception);
                            ((CameraController)this.looperActivity.get()).setResult(119, data);
                            ((CameraController)this.looperActivity.get()).finish();
                            return;
                        }
                        if (errorCode == OCRCommon.ErrorCode.errorPassportNotFound) {
                            this.proceedWithProcessing();
                            return;
                        }
                        cameraController.cameraOverlayView.showErrorMessage(errorCode);
                        cameraController.cameraOverlayView.showCheckBoundyRect(false, null);
                    }
                    if ((cameraController.isDebug || drawFoundedRectangle) && checkRectBundle != null) {
                        Rect rect = OCRHelper.bundleToRect(checkRectBundle);
                        cameraController.cameraOverlayView.showCheckBoundyRect(true, rect);
                        this.dispatchHintIndicator(messageData);
                        this.sendEmptyMessageDelayed(14, CameraConfigurationManager.SHOW_CHECK_RECT_BOUNDERIES_DELAY);
                    }
                    this.proceedWithProcessing();
                    if (!CameraManagerController.isDebug) break;
                    FileUtils.addToLogFile("MESSAGE_PROCESS_NOT_VALID", cameraController.getBaseContext());
                    break;
                }
                case 7: {
                    Logger.i(TAG, "MESSAGE_CAPTURE_STILL_IMAGE");
                    cameraController.cameraOverlayView.setConfirmationIndicators();
                    this.initProceedingToNextFrameDelay();
                    if (cameraController.isFinishing()) {
                        return;
                    }
                    Bundle bundleCaptureStillImage = messageData;
                    if (cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW) {
                        Bundle checkRectCaptureBundle = bundleCaptureStillImage.getBundle("checkRect");
                        Rect rect = OCRHelper.bundleToRect(checkRectCaptureBundle);
                        if (cameraController.isDebug || drawFoundedRectangle) {
                            cameraController.cameraOverlayView.showCheckBoundyRect(true, rect);
                        }
                        CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).checkRect = OCRHelper.bundleToRect(checkRectCaptureBundle);
                        CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).orientation = bundleCaptureStillImage.getDouble("orientation");
                        this.removeAllMessages();
                        this.captureStillImage();
                    }
                    if (!CameraManagerController.isDebug) break;
                    FileUtils.addToLogFile("MESSAGE_CAPTURE_STILL_IMAGE", cameraController.getBaseContext());
                    break;
                }
                case 20: {
                    Logger.i(TAG, "MESSAGE_BARCODE_DETECTED");
                    OCRAnalyzeSession ocrAnalyzeSession = CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext());
                    if (cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW) {
                        String barcodeType = messageData.getString("barCodeType");
                        String barcodeData = messageData.getString("barCodeData");
                        if (ocrAnalyzeSession.captureMode == CameraTypes.CaptureMode.FRONT) {
                            ocrAnalyzeSession.setFrontBarcodeType(barcodeType);
                            ocrAnalyzeSession.setFrontBarcodeData(barcodeData);
                        } else {
                            ocrAnalyzeSession.setBackBarcodeType(barcodeType);
                            ocrAnalyzeSession.setBackBarcodeData(barcodeData);
                        }
                        if (CameraManagerController.isDebug) {
                            FileUtils.addToLogFile("MESSAGE_BARCODE_DETECTED", cameraController.getBaseContext());
                        }
                        cameraController.cameraOverlayView.animateToCheckBoundariesRect(ocrAnalyzeSession.getCheckBoundariesDisp());
                        ocrAnalyzeSession.isBarcodeSession = false;
                        break;
                    }
                    cameraController.cameraOverlayView.setCaptureCaption(ocrAnalyzeSession.captureMode);
                    this.proceedWithProcessing();
                    break;
                }
                case 21: {
                    cameraController.cameraOverlayView.setCheckBoundariesRect(CameraManagerController.getOcrAnalyzeSession(cameraController.getApplicationContext()).getCheckBoundariesDisp());
                    cameraController.cameraOverlayView.setCaptureCaption(CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).captureMode);
                    this.proceedWithProcessing();
                    break;
                }
                case 22: {
                    TISPassportProcessingResults passportResult = new TISPassportProcessingResults();
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile("PASSPORT_RESULT", cameraController.getBaseContext());
                    }
                    passportResult.ocrRawResult = messageData.getString("PASSPORT_OCR_RESULT");
                    passportResult.ocrResultWithDelimiter = messageData.getString("PASSPORT_OCR_RESULT_WITH_DELIMETER");
                    passportResult.digitalRowLength = messageData.getInt("PASSPORT_OCR_RESULT_LENGTH");
                    int[] boundingBoxResult = messageData.getIntArray("INTENT_BOUNDING_BOX_RESULT");
                    Log.i((String)TAG, (String)("PASSPORT_OCR_RESULT_WITH_DELIMETER" + passportResult.ocrResultWithDelimiter));
                    CameraManagerController.getOcrAnalyzeSession((Context)activity).setOcrResult(passportResult);
                    boolean isPassportValid = OcrValidationUtils.validatePassport(passportResult.ocrResultWithDelimiter, passportResult.digitalRowLength);
                    if (!isPassportValid) {
                        this.proceedWithProcessing();
                        break;
                    }
                    cameraController.currentError = null;
                    Object[] ocrResult = new Object[5];
                    passportResult.setPassportResult(OcrValidationUtils.parsePassportResult(passportResult.ocrResultWithDelimiter));
                    ocrResult[0] = passportResult.ocrResultWithDelimiter;
                    ocrResult[1] = String.valueOf(passportResult.digitalRowLength);
                    ocrResult[2] = passportResult.ocrRawResult;
                    ocrResult[3] = passportResult.scoreResult;
                    ocrResult[4] = passportResult.passportResultsByField;
                    Mat originalImg = CameraManagerController.getOcrAnalyzeSession((Context)activity).getVideoMat();
                    Rect cvRect = new Rect(boundingBoxResult[0], boundingBoxResult[1], boundingBoxResult[2], boundingBoxResult[3]);
                    Mat cropped = new Mat(originalImg, cvRect);
                    Mat grayImage = new Mat();
                    if (CameraManagerController.shouldOutputBWImage) {
                        String basePath = activity.getFilesDir().getAbsolutePath() + "/" + FileUtils.tempPath + "/";
                        String currentDateAndTime = FileUtils.getCurrentTime();
                        String path = basePath + "FRONT" + "_" + currentDateAndTime + "_" + ".jpg";
                        Mat bradlyImage = new Mat();
                        CameraController.activity.mobiCHECKOCR.binarizeWithoutSearchingBoundingBox(cropped, grayImage, bradlyImage, path, boundingBoxResult, true);
                        SessionResultParams.jpegBWFront = FileUtils.convertJpgMatToByte(bradlyImage);
                        bradlyImage.release();
                        bradlyImage = null;
                    }
                    if (CameraManagerController.shouldOutputColoredImage) {
                        SessionResultParams.colorFront = FileUtils.convertJpgMatToByte(cropped, CameraManagerController.colorImageCompression);
                    }
                    if (CameraManagerController.shouldOutputGrayscaleImage) {
                        Mat gray = cropped.clone();
                        Imgproc.cvtColor((Mat)cropped, (Mat)gray, (int)6);
                        SessionResultParams.grayscaleFront = FileUtils.convertJpgMatToByte(gray, CameraManagerController.grayScaleImageCompression);
                        gray.release();
                        gray = null;
                    }
                    if (CameraManagerController.shouldOutputOriginalImage) {
                        SessionResultParams.originalFront = FileUtils.convertJpgMatToByte(originalImg);
                    }
                    cropped.release();
                    cropped = null;
                    grayImage.release();
                    grayImage = null;
                    cameraController.currentCallBack = CameraTypes.TISFlowGeneralMessages.PASSPORT_OCR_RESULT;
                    listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, ocrResult, ((CameraController)this.looperActivity.get()).cameraOverlayView.getContext());
                    break;
                }
                case 25: {
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile("ID_CARD_RESULT", cameraController.getBaseContext());
                    }
                    cameraController.currentCallBack = CameraTypes.TISFlowGeneralMessages.ID_CARD_OCR_RESULT;
                    cameraController.currentError = null;
                    Object[] idResult = new String[4];
                    OCRResult result = (OCRResult)message.obj;
                    idResult[0] = String.valueOf(result.digitalRowLength);
                    idResult[1] = result.ocrResultWithDelimiter;
                    idResult[2] = result.ocrRawResult;
                    idResult[3] = result.scoreResult;
                    if (!CameraManagerController.isStillMode) {
                        listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, idResult, ((CameraController)this.looperActivity.get()).cameraOverlayView.getContext());
                        break;
                    }
                    cameraController.activityResultFinish(result.isValidRead);
                    break;
                }
                case 18: {
                    Logger.i(TAG, "MESSAGE_ERROR");
                    if (!CameraManagerController.isStillMode) {
                        this.proceedWithProcessing();
                    } else {
                        String errorMessage = (String)message.obj;
                        cameraController.displayFrameworkBugMessageAndExit(errorMessage);
                    }
                    if (!CameraManagerController.isDebug) break;
                    FileUtils.addToLogFile("MESSAGE_ERROR", cameraController.getBaseContext());
                    break;
                }
                case 9: {
                    Logger.i(TAG, "MESSAGE_PROCESS_PRE_CAPTURED_IMAGE");
                    cameraController.onSentUIEventMessage(CameraTypes.TISFlowUIMessages.BEFORE_PROCESSING);
                    if (CameraManagerController.isStillMode) {
                        this.stopPreview();
                    }
                    if (!CameraManagerController.isDebug) break;
                    FileUtils.addToLogFile("MESSAGE_PROCESS_PRE_CAPTURED_IMAGE", cameraController.getBaseContext());
                    break;
                }
                case 8: {
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile("MESSAGE_PROCESS_CAPTURED_IMAGE", cameraController.getBaseContext());
                    }
                    Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE");
                    if (CameraManagerController.isStillMode) {
                        cameraController.cameraSessionManager.stopPreviewOnly();
                        if (CameraManagerController.useCameraAPI2) {
                            CameraController.getInstance().camera2Instance.closeSession();
                        }
                        if (!CameraManagerController.enableProcessingView) {
                            cameraController.cameraOverlayView.showProcessingOverlay(true);
                        } else {
                            cameraController.cameraOverlayView.switchToProcessingView(false);
                        }
                    }
                    String imagePath = (String)message.obj;
                    if (CameraManagerController.isStillMode) {
                        this.removeAllMessages();
                    }
                    if (CameraManagerController.scanBackOnly) {
                        cameraController.processCapturedImage(imagePath);
                        break;
                    }
                    cameraController.processCapturedImage(imagePath);
                    break;
                }
                case 10: {
                    Logger.i(TAG, "MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT");
                    if (CameraManagerController.isStillMode) {
                        // empty if block
                    }
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile("MESSAGE_PROCESS_CAPTURED_IMAGE_RESULT", cameraController.getBaseContext());
                    }
                    OCRResult result = (OCRResult)message.obj;
                    if (!CameraManagerController.isStillMode && CameraManagerController.sessionType != CaptureIntent.SessionType.TEST) {
                        if (result.isValidRead) {
                            cameraController.activityResultFinish(result.isValidRead);
                            break;
                        }
                        if (cameraController.continueVideoModeOrShowAlert() && !CameraManagerController.isStillMode) {
                            this.proceedWithProcessing();
                            break;
                        }
                        cameraController.activityResultFinish(result.isValidRead);
                        break;
                    }
                    cameraController.activityResultFinish(result.isValidRead);
                    break;
                }
                case 24: {
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile("CHECK_MICR_RESULT", cameraController.getBaseContext());
                    }
                    cameraController.currentCallBack = CameraTypes.TISFlowGeneralMessages.CHECK_OCR_RESULT;
                    cameraController.currentError = null;
                    Object[] ocrResult = new String[4];
                    OCRResult result = (OCRResult)message.obj;
                    ocrResult[0] = String.valueOf(result.digitalRowLength);
                    ocrResult[1] = result.ocrResultWithDelimiter;
                    ocrResult[2] = result.ocrRawResult;
                    ocrResult[3] = result.scoreResult;
                    if (!CameraManagerController.isStillMode) {
                        listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, ocrResult, ((CameraController)this.looperActivity.get()).cameraOverlayView.getContext());
                        break;
                    }
                    cameraController.activityResultFinish(result.isValidRead);
                    break;
                }
                case 23: {
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile("PAN_CARD_RESULT", cameraController.getBaseContext());
                    }
                    cameraController.currentCallBack = CameraTypes.TISFlowGeneralMessages.PAN_CARD_OCR_RESULT;
                    cameraController.currentError = null;
                    Object[] panResult = new String[4];
                    OCRResult result = (OCRResult)message.obj;
                    panResult[0] = String.valueOf(result.digitalRowLength);
                    panResult[1] = result.ocrResultWithDelimiter;
                    panResult[2] = result.ocrRawResult;
                    panResult[3] = result.scoreResult;
                    if (!CameraManagerController.isStillMode) {
                        if (OcrValidationUtils.validationPanCard(result.ocrResultWithDelimiter)) {
                            listener.onMobiFlowGeneralMessageReceived(cameraController.currentCallBack, panResult, ((CameraController)this.looperActivity.get()).cameraOverlayView.getContext());
                            break;
                        }
                        cameraController.cameraSessionManager.requestAutoFocus(this, 3);
                        this.proceedWithProcessing();
                        break;
                    }
                    cameraController.activityResultFinish(result.isValidRead);
                    break;
                }
                case 19: {
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile("MESSAGE_CONTINUE_ANYWAY", cameraController.getBaseContext());
                    }
                    cameraController.activityResultFinish(true);
                    break;
                }
                case 16: {
                    if (CameraManagerController.isDebug) {
                        FileUtils.addToLogFile("MESSAGE_TOGGLE_TORCH", cameraController.getBaseContext());
                    }
                    CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).isTorchOn = (Boolean)message.obj;
                    this.restartPreview();
                    cameraController.cameraOverlayView.enableTorchButton(true);
                }
            }
        }

        private int[] getFrontImageArrayValues() {
            if (CameraManagerController.frontImageRectArray == null) {
                CameraManagerController.frontImageRectArray = new int[4];
                if (CameraManagerController.imageType == CaptureIntent.TISDocumentType.CHECK) {
                    CameraManagerController.frontImageRectArray[0] = 0;
                    CameraManagerController.frontImageRectArray[1] = 0;
                    CameraManagerController.frontImageRectArray[2] = 1200;
                    CameraManagerController.frontImageRectArray[3] = 600;
                }
            }
            return CameraManagerController.frontImageRectArray;
        }

        protected void initProceedingToNextFrameDelay() {
            this.lastTimeWasreceived = 0L;
            this.notOptimalStateCounter = 0L;
            this.proceedingToNextFrameDelay = 0L;
        }

        protected void checkNextFrameDelay(CameraTypes.HintIndicator hintIndicator) {
            if (hintIndicator == CameraTypes.HintIndicator.NoLight) {
                long currentTimeWasreceived = Calendar.getInstance().getTimeInMillis();
                long timeDelta = currentTimeWasreceived - this.lastTimeWasreceived;
                if (this.lastTimeWasreceived > 0L && timeDelta <= 100000L) {
                    if (this.notOptimalStateCounter > 2L) {
                        long multiplier = this.notOptimalStateCounter / 2L;
                        long nextDelay = 100L * multiplier;
                        this.proceedingToNextFrameDelay = nextDelay = nextDelay > 1000L ? 1000L : nextDelay;
                    }
                    ++this.notOptimalStateCounter;
                }
                this.lastTimeWasreceived = currentTimeWasreceived;
            } else {
                this.initProceedingToNextFrameDelay();
            }
        }

        private void dispatchHintIndicator(Bundle messageData) {
            String hintIndicatorName;
            CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "dispatchHintIndicator cameraController reference is null");
                return;
            }
            if (messageData != null && !StringUtils.isEmptyOrNull(hintIndicatorName = messageData.getString("hintName"))) {
                CameraTypes.HintIndicator indicator = CameraTypes.HintIndicator.valueOf(hintIndicatorName);
                if (!CameraManagerController.isDynamicCapture) {
                    cameraController.cameraOverlayView.showIndicator(indicator, true);
                }
            }
        }

        private void proceedWithProcessing() {
            final CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "proceedWithProcessing cameraController reference is null");
                return;
            }
            if (cameraController.isFinishing()) {
                return;
            }
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    cameraController.cameraSessionManager.requestPreviewFrame(activity, cameraController.mobiCHECKOCR);
                }
            }, this.proceedingToNextFrameDelay);
        }

        private void captureStillImage() {
            Logger.i(TAG, "captureStillImage");
            captureStillStarted = true;
            final CameraController cameraController = (CameraController)this.looperActivity.get();
            if (!CameraManagerController.isDynamicCapture) {
                cameraController.cameraOverlayView.prepareForStillCapture();
            }
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    cameraController.cameraSessionManager.requestCaptureStillImage(cameraController.handler, 8, CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).captureMode);
                }
            }, 100L);
        }

        private void restartPreview() {
            this.stopPreview();
            this.startPreview();
        }

        void startPreview() {
            CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "startPreview cameraController reference is null");
                return;
            }
            if (CameraManagerController.useCameraAPI2) {
                CameraController.getInstance().startCameraAPI2();
                return;
            }
            cameraController.cameraSessionManager.startPreview(CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).isTorchOn);
            this.restartPreviewAndDecode();
        }

        public void stopPreview() {
            CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "stopPreview cameraController reference is null");
                return;
            }
            cameraController.cameraSessionManager.setState(CameraSessionManager.State.DONE);
            cameraController.cameraSessionManager.stopPreview();
        }

        public void quitSynchronously() {
            this.stopPreview();
            this.removeAllMessages();
        }

        public void removeAllMessages() {
            this.removeMessages(2);
            this.removeMessages(3);
            this.removeMessages(4);
            this.removeMessages(6);
            this.removeMessages(7);
            this.removeMessages(8);
            this.removeMessages(10);
            this.removeMessages(11);
            this.removeMessages(12);
            this.removeMessages(13);
            this.removeMessages(14);
            this.removeMessages(16);
            this.removeMessages(17);
            this.removeMessages(18);
            this.removeMessages(20);
            this.removeMessages(21);
            this.removeMessages(22);
            this.removeMessages(23);
            this.removeMessages(24);
            this.removeMessages(25);
        }

        public void removeAllPreviewProcessingMessages() {
            this.removeMessages(4);
            this.removeMessages(6);
            this.removeMessages(7);
            this.removeMessages(8);
            this.removeMessages(10);
            this.removeMessages(11);
            this.removeMessages(12);
            this.removeMessages(13);
            this.removeMessages(14);
            this.removeMessages(17);
            this.removeMessages(18);
            this.removeMessages(20);
            this.removeMessages(21);
        }

        private void restartPreviewAndDecode() {
            CameraController cameraController = (CameraController)this.looperActivity.get();
            if (cameraController == null) {
                Logger.e(TAG, "restartPreviewAndDecode cameraController reference is null");
                return;
            }
            if (cameraController.cameraSessionManager.getState() == CameraSessionManager.State.NONE || cameraController.cameraSessionManager.getState() == CameraSessionManager.State.PREVIEW || cameraController.cameraSessionManager.getState() == CameraSessionManager.State.SUCCESS) {
                cameraController.resetCameraOverlay(CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).captureMode);
                if (!CameraManagerController.getOcrAnalyzeSession((Context)cameraController.getApplicationContext()).isManualCapture) {
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CameraActivityHandler.this.proceedWithProcessing();
                        }
                    }, 500L);
                }
                cameraController.cameraSessionManager.requestAutoFocus(this, 3);
            }
        }

        public void removeLowPriorityMessages() {
            this.removeMessages(3);
            this.removeMessages(11);
            this.removeMessages(12);
            this.removeMessages(13);
            this.removeMessages(14);
        }
    }

    private class TestOcrTask
    extends AsyncTask<String, Void, String> {
        private TestOcrTask() {
        }

        protected String doInBackground(String ... params) {
            String directory = params[0];
            if (directory == null) {
                directory = FileUtils.getTempFilePath(CameraController.this.getBaseContext());
            }
            ArrayList<String> filesPath = new ArrayList<String>();
            File parentDir = new File(directory);
            File[] files = parentDir.listFiles();
            if (files == null) {
                return null;
            }
            for (File file : files) {
                if (!file.getName().toLowerCase(Locale.US).endsWith("jpg") && !file.getName().toLowerCase(Locale.US).endsWith("jpeg") || file.getName().contains("binar")) continue;
                filesPath.add(file.getPath());
            }
            CameraController.access$202(CameraController.this, filesPath.toArray(new String[filesPath.size()]));
            return directory;
        }

        protected void onPostExecute(String result) {
            if (result == null) {
                Toast.makeText((Context)CameraController.this.getBaseContext(), (CharSequence)"Files Not Found in destenation folder", (int)0).show();
                CameraController.this.setResult(0);
                CameraController.this.finish();
            }
            if (CameraController.this.inputFilesPath != null) {
                CameraController.this.startTestFlow();
            }
        }

        protected void onPreExecute() {
        }

        protected void onProgressUpdate(Void ... values) {
        }
    }

    public class ActionClickListenerImpl
    implements ActionClickListener {
        @Override
        public void quit() {
            CameraController.this.quitActivity();
        }

        @Override
        public void capture() {
            CameraController.this.handler.removeLowPriorityMessages();
            Message message = CameraController.this.handler.obtainMessage(7);
            message.sendToTarget();
        }

        @Override
        public void info() {
        }
    }

    public static interface ActionClickListener {
        public void quit();

        public void capture();

        public void info();
    }
}

