/*
 * 
 */
package com.topimagesystems.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.Path;
import android.graphics.Path.Direction;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.text.Layout.Alignment;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

import com.topimagesystems.R;
import com.topimagesystems.controllers.imageanalyze.CameraManagerController;

// TODO: Auto-generated Javadoc
/**
 * The Class Counter.
 */
public class Counter extends ImageView {

    /** The is start countdown. */
    private boolean isStartCountdown;
    
    /** The stroke width. */
    private final float strokeWidth = 5.0f;
    
    /** The circle paint. */
    private Paint circlePaint;
    
    /** The border paint. */
    private Paint borderPaint;
    
    /** The count down value. */
    private int countDownValue = 0;
    
    /** The text paint. */
    private TextPaint textPaint;
    
    /** The beep sound. */
    private int beepSound = 0;

    /** The Constant sTextResizeCanvas. */
    private static final Canvas sTextResizeCanvas = new Canvas();
    // Text view line spacing multiplier
    /** The m spacing mult. */
    private float mSpacingMult = 1.0f;
    // Text view additional line spacing
    /** The m spacing add. */
    private float mSpacingAdd = 0.0f;
    
    /** The text size. */
    private float textSize = 38.0f;
    
    /** The path. */
    private Path path;
    
    /** The text bounds. */
    private Rect textBounds;
    
    /** The initial value. */
    private int initialValue;
    
    /** The context. */
    private Context context;
    
    /** The Counter typface. */
    private Typeface CounterTypface;
    
    /** The total time. */
    private float totalTime;
    
    /** The default interval. */
    private final long defaultInterval = 1000;
    
    /** The start integer. */
    private int startInteger = 2;
    
    /** The end integer. */
    private int endInteger = 0;
    
    /** The background color. */
    private int backgroundColor;
    
    /** The text color. */
    private int textColor;
    
    /** The border color. */
    private int borderColor;
    
    /** The counter font. */
    private String counterFont = "BOLD";

    /**
     * Instantiates a new counter.
     *
     * @param context the context
     * @param attrs the attrs
     */
    public Counter(Context context, AttributeSet attrs) {
	super(context, attrs);
	this.context = context;
	TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.counter);
	startInteger = a.getInteger(R.styleable.counter_countDownStartValue, startInteger);
	endInteger = a.getInteger(R.styleable.counter_countDownStopValue, endInteger);
	backgroundColor = a.getResourceId(R.styleable.counter_counterBackground, R.color.counter_background);
	textColor = a.getResourceId(R.styleable.counter_counterTextColor, R.color.camera_counter_text_color);
	borderColor = a.getResourceId(R.styleable.counter_counterBorderColor, R.color.counter_border_color);
	textSize = a.getFloat(R.styleable.counter_counterTextSize, 38.0f);
	counterFont = a.getString(R.styleable.counter_counterFont);
	if (counterFont == null) {
	    counterFont = "BOLD";
	}
	a.recycle();

	init();
    }

    /**
     * Instantiates a new counter.
     *
     * @param context the context
     * @param attrs the attrs
     * @param defStyle the def style
     */
    public Counter(Context context, AttributeSet attrs, int defStyle) {
	super(context, attrs, defStyle);
	this.context = context;
	init();
    }

    /**
     * Gets the count down start number.
     *
     * @return the count down start number
     */
    public int getCountDownStartNumber() {
	return startInteger;
    }

    /**
     * Inits the.
     */
    private void init() {
	if (isInEditMode()) {
	    return;
	}
	circlePaint = new Paint();
	circlePaint.setStyle(Style.FILL);
	circlePaint.setAntiAlias(true);
	circlePaint.setColor(context.getResources().getColor(backgroundColor));

	borderPaint = new Paint();
	borderPaint.setStyle(Style.STROKE);
	borderPaint.setStrokeWidth(strokeWidth);
	borderPaint.setColor(context.getResources().getColor(borderColor));
	//borderPaint.setColor(Color.WHITE);
	borderPaint.setAntiAlias(true);
	// set the text content.
	textPaint = new TextPaint();

	if (counterFont.equals("BOLD")) {
	    textPaint.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
	} else if (counterFont.equals("BOLD_ITALIC")) {

	    textPaint.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD_ITALIC));
	} else if (counterFont.equals("ITALIC")) {
	    textPaint.setTypeface(Typeface.defaultFromStyle(Typeface.ITALIC));
	} else if (counterFont.equals("NORMAL")) {
	    textPaint.setTypeface(Typeface.defaultFromStyle(Typeface.NORMAL));
	} else {
	    textPaint.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
	}

	textPaint.setTextSize(textSize);
	textPaint.setStyle(Style.FILL);
	textPaint.setColor(context.getResources().getColor(textColor));

	//textPaint.setColor(Color.WHITE);
	textPaint.setAntiAlias(true);

	path = new Path();
	textBounds = new Rect();
    }

    /**
     * Start countdown.
     *
     * @param from the from
     */
    public void startCountdown(int from) {
	isStartCountdown = true;
	initialValue = from;
	countDownValue = initialValue;
	setVisibility(View.VISIBLE);
	invalidate();
    }

    /**
     * Stop countdown.
     */
    public void stopCountdown() {
	isStartCountdown = false;
	setVisibility(View.GONE);
    }

    // Set the text size of the text paint object and use a static layout to
    // render text off screen before measuring
    /**
     * Gets the text height.
     *
     * @param source the source
     * @param paint the paint
     * @param width the width
     * @param textSize the text size
     * @return the text height
     */
    private int getTextHeight(CharSequence source, TextPaint paint, int width, float textSize) {
	// Update the text paint object
	paint.setTextSize(textSize);
	// Draw using a static layout
	StaticLayout layout = new StaticLayout(source, paint, width, Alignment.ALIGN_NORMAL, mSpacingMult, mSpacingAdd, true);
	layout.draw(sTextResizeCanvas);
	return layout.getHeight();
    }

    /* (non-Javadoc)
     * @see android.widget.ImageView#onDraw(android.graphics.Canvas)
     */
    @Override
    protected void onDraw(Canvas canvas) {

	final int radius = getWidth() / 2;
	// circle
	canvas.drawCircle(radius - 2, radius - 2, radius - 4, circlePaint);

	// border
	path.addCircle(radius, radius, radius - strokeWidth, Direction.CW);
	canvas.drawPath(path, borderPaint);

	String textToDraw = String.valueOf(countDownValue);
	int textHeight = getTextHeight(textToDraw, textPaint, getWidth(), textSize);

	textPaint.getTextBounds(textToDraw, 0, textToDraw.length(), textBounds);
	int textWidth = textBounds.width();
	int xOffset = (getWidth() - textWidth) / 2;
	if (textToDraw.equals("1")) {
	    xOffset -= 5;
	}
	int yOffset = (getHeight() + textHeight) / 2 + textBounds.top / 2;

	canvas.drawText(textToDraw, xOffset, yOffset, textPaint);

	if (isStartCountdown) {
	    MediaPlayer mp = MediaPlayer.create(context, R.raw.beep_android);

	    try {
		Thread.sleep(defaultInterval);
		countDownValue--;
		countDownValue = (countDownValue < endInteger) ? endInteger : countDownValue;
		AudioManager am = (AudioManager)context.getSystemService(Context.AUDIO_SERVICE);
		
		switch (am.getRingerMode()) { // check if the device on silent mode if true don't play capture sound.
	    case AudioManager.RINGER_MODE_SILENT:	        
	        break;
	    case AudioManager.RINGER_MODE_VIBRATE:	        
	        break;
	    case AudioManager.RINGER_MODE_NORMAL:
	    	if (CameraManagerController.countDownSound) {
			    mp.start();
			}
	        break;
	}
		
	    } catch (InterruptedException e) {
		e.printStackTrace();
	    }
	    invalidate();
	}
    }
};