/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import java.util.ArrayList;
import java.util.List;


// TODO: Auto-generated Javadoc
/**
 * The Class StabilityDetection.
 */
public class StabilityDetection {

	/**
	 * The Class StableSampleQueue.
	 */
	static class StableSampleQueue {

		/** The Constant MAX_WINDOW_SIZE. */
		private static final long MAX_WINDOW_SIZE = 250000000; // 0.25s
		
		/** The Constant MIN_WINDOW_SIZE. */
		private static final long MIN_WINDOW_SIZE = MAX_WINDOW_SIZE >> 1; // 0.25s

		/** The Constant MIN_QUEUE_SIZE. */
		private static final int MIN_QUEUE_SIZE = 4;

		/** The pool. */
		private final SampleList pool = new SampleList();

		/** The oldest. */
		private SampleNode oldest;
		
		/** The newest. */
		private SampleNode newest;
		
		/** The sample count. */
		private int sampleCount;
		
		/** The stable count. */
		private int stableCount;
		
		/**
		 * Adds the sample.
		 *
		 * @param timestamp the timestamp
		 * @param accelerating the accelerating
		 */
		void addSample(long timestamp, boolean accelerating) {
			while (sampleCount >= MIN_QUEUE_SIZE && oldest != null
					&& (timestamp - MAX_WINDOW_SIZE) - oldest.timestamp > 0) {
				SampleNode removed = oldest;
				if (!removed.accelerating) {
					stableCount--;
				}
				sampleCount--;

				oldest = removed.next;
				if (oldest == null) {
					newest = null;
				}
				pool.release(removed);
			}
			

			SampleNode added = pool.acquire();
			added.timestamp = timestamp;
			added.accelerating = accelerating;
			added.next = null;
			if (newest != null) {
				newest.next = added;
			}
			newest = added;
			if (oldest == null) {
				oldest = added;
			}

			// Update running average.
			sampleCount++;
			if (!accelerating) {
				stableCount++;
			}
		}

		/**
		 * Clear.
		 */
		void clear() {
			while (oldest != null) {
				SampleNode removed = oldest;
				oldest = removed.next;
				pool.release(removed);
			}
			newest = null;
			sampleCount = 0;
			stableCount = 0;
		}

		/**
		 * As list.
		 *
		 * @return the list
		 */
		List<SampleNode> asList() {
			List<SampleNode> list = new ArrayList<SampleNode>();
			SampleNode s = oldest;
			while (s != null) {
				list.add(s);
				s = s.next;
			}
			return list;
		}
		
		/**
		 * Checks if is stable.
		 *
		 * @return true, if is stable
		 */
		boolean isStable() {
			return newest != null
					&& oldest != null
					&& newest.timestamp - oldest.timestamp >= MIN_WINDOW_SIZE
					&& stableCount >= (sampleCount >> 1)
							+ (sampleCount >> 2);
		}
	}

	/**
	 * The Class SampleNode.
	 */
	static class SampleNode {
		
		/** The timestamp. */
		long timestamp;

		/** The accelerating. */
		boolean accelerating;
		
		/** The next. */
		SampleNode next;
	}

	/**
	 * The Class SampleList.
	 */
	static class SampleList {
		
		/** The head. */
		private SampleNode head;

		/**
		 * Acquire.
		 *
		 * @return the sample node
		 */
		SampleNode acquire() {
			SampleNode acquired = head;
			if (acquired == null) {
				acquired = new SampleNode();
			} else {
				head = acquired.next;
			}
			return acquired;
		}

		/**
		 * Release.
		 *
		 * @param sample the sample
		 */
		void release(SampleNode sample) {
			sample.next = head;
			head = sample;
		}
	}
}
