/*
 * 
 */
package com.topimagesystems.controllers.imageanalyze;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.hardware.Camera.Parameters;
import android.util.Log;
import android.util.Size;
import android.view.Surface;

import com.topimagesystems.R;
import com.topimagesystems.intent.CaptureIntent.SessionType;
import com.topimagesystems.intent.CaptureIntent.TISDocumentType;
import com.topimagesystems.util.FileUtils;
import com.topimagesystems.util.Logger;
import com.topimagesystems.util.UserInterfaceUtils;

import org.opencv.core.Rect;

import java.util.Arrays;
import java.util.List;

// TODO: Auto-generated Javadoc
/**
 * The Class CameraConfigurationManager.
 */
@SuppressLint("NewApi")
public final class CameraConfigurationManager {

	/** The Constant TAG. */
	private static final String TAG = Logger.makeLogTag("CameraConfigurationManager");

	/** The Constant TEN_DESIRED_ZOOM. */
	private static final int TEN_DESIRED_ZOOM = 27;

	/** The Constant SHOW_ORIENTATION_VALUES_DELAY. */
	final static public long SHOW_ORIENTATION_VALUES_DELAY = 0L;

	/** The autofocus interval. */
	static public long AUTOFOCUS_INTERVAL = 1700L;
	/** The show check rect bounderies delay. */
	static public long SHOW_CHECK_RECT_BOUNDERIES_DELAY = 1000L;

	/** The Constant SHOW_HINT_INDICATOR_DELAY. */
	final static public long SHOW_HINT_INDICATOR_DELAY = 2000L;

	/** The Constant ANNOUNCE_HINT_INDICATOR_DELAY. */
	final static public long ANNOUNCE_HINT_INDICATOR_DELAY = 6000L;

	/** The take picture interval. */
	static public long TAKE_PICTURE_INTERVAL = 650L;

	/** The context. */
	private final Activity context;

	/** The screen resolution. */
	public static Point screenResolution;

	/** The camera preview resolution. */
	public static Point cameraPreviewResolution;

	/** The camera capture resolution. */
	public static Point cameraCaptureResolution;

	/** The preview format. */
	private int previewFormat;

	/** The camerapixels. */
	private static int CAMERAPIXELS = 0;

	/** The preview format string. */
	private String previewFormatString;
	// high res images!!!

	/** The Constant minimumCameraPixels. */
	private static final double minimumCameraPixels = 3.5;

	/** The normal image width. */
	public static int normalImageWidth = 2048;

	/** The normal image height. */
	public static int normalImageHeight = 1152;

	/** The screen and video ratio width. */
	public static float screenAndVideoRatioWidth;

	/** The screen and video ratio height. */
	public static float screenAndVideoRatioHeight;

	/** The video resolution width. */
	public static int videoResolutionWidth;

	/** The video resolution height. */
	public static int videoResolutionHeight;
	public static float screenAspectRatio;
	public static float videoAspectRatio;

	/** The video height res. */
	public static int videoHeightRes = 0;

	/** The video width res. */
	public static int videoWidthRes = 0;

	/** The still height res. */
	public static int stillHeightRes = 0;

	/** The still width res. */
	public static int stillWidthRes = 0;

	/** The capture resolution width. */
	public static int captureResolutionWidth;

	/** The capture resolution height. */
	public static int captureResolutionHeight;

	/** The min height for video capture. */
	private static int minHeightForVideoCapture = 1080;

	/** The min width for video capture. */
	private static int minWidthForVideoCapture = 1920;
	private static String[] exceptionDevices;



	/** The focus mode. */
	private String[] focusMode;

	/**
	 * Instantiates a new camera configuration manager.
	 *
	 * @param context
	 *            the context
	 */
	CameraConfigurationManager(Activity context) {
		this.context = context;
	}

	/**
	 * Reads, one time, values from the camera that are needed by the app.
	 *
	 * @param camera
	 *            the camera
	 */
	void initFromCameraParameters(Camera camera) {

		Camera.Parameters parameters = camera.getParameters();
		context.getPackageManager();
		// turn off flash at the begining of the sesison.

		
		videoHeightRes = context.getResources().getInteger(R.integer.videoHeightResolution);
		videoWidthRes = context.getResources().getInteger(R.integer.videoWidthResolution);
		stillWidthRes = context.getResources().getInteger(R.integer.stillWidthResolution);
		stillHeightRes = context.getResources().getInteger(R.integer.stillHeightResolution);
		minWidthForVideoCapture = context.getResources().getInteger(R.integer.minimumWidthForVideoCapture);
		minHeightForVideoCapture = context.getResources().getInteger(R.integer.minimumHeightForVideoCapture);
		previewFormat = parameters.getPreviewFormat();
		previewFormatString = parameters.get("preview-format");
		Logger.d(TAG, "Default preview format: " + previewFormat + '/' + previewFormatString);

		screenResolution = UserInterfaceUtils.getDisplayDimensions(context);

//		if (videoResolutionWidth == 0 || videoResolutionHeight == 0) {
			cameraPreviewResolution = getCameraPreviewResolution(parameters, screenResolution, context);
//		}
//		else{
//			cameraPreviewResolution = new Point(videoResolutionWidth,videoResolutionHeight);
//		}
		cameraCaptureResolution = getCameraCaptureResolution(parameters, screenResolution, context);
		setCameraDisplayOrientation(context, 1, camera);
		Logger.i(TAG, "Camera preview resolution: " + cameraPreviewResolution + " | cameraCaptureResolution:" + cameraCaptureResolution);
		if (CameraManagerController.isDebug) {
			String deviceDetails = "device type is " + FileUtils.getDeviceName() + "device model is " + FileUtils.getDeviceModel() + "device brand is "
					+ FileUtils.getDeviceBrand();

			FileUtils.addToLogFile("deviceDetails ", deviceDetails, context.getApplicationContext());
			FileUtils.addToLogFile("Camera Preview resolution ", cameraPreviewResolution.x + " * " + cameraPreviewResolution.y, context.getApplicationContext());
			FileUtils.addToLogFile("Camera Capture resolution ", cameraCaptureResolution.x + " * " + cameraCaptureResolution.y, context.getApplicationContext());

		}
		screenAspectRatio = (float)screenResolution.x/(float)screenResolution.y;
		videoAspectRatio = (float)cameraPreviewResolution.x/(float)cameraPreviewResolution.y;

	}

	/**
	 * Sets the desired camera parameters.
	 *
	 * @param camera
	 *            the camera
	 * @param isTorchOn
	 *            the is torch on
	 */
	void setDesiredCameraParameters(Camera camera, boolean isTorchOn) {
		//Logger.i(TAG, "setDesiredCameraParameters");
		Camera.Parameters parameters = camera.getParameters();

		// preview size
		parameters.setPreviewSize(cameraPreviewResolution.x, cameraPreviewResolution.y);
		// picture size
		parameters.setPictureSize(cameraCaptureResolution.x, cameraCaptureResolution.y);
		// Continues focus mode
		// setFocusMode(parameters);
		// Flash
		setFlash(parameters, isTorchOn);

		// Zoom
		setCameraDisplayOrientation(context, 1, camera);

		int result;

		if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.sessionType == SessionType.PORTRAIT) {
			result = 90;

		} else {
			result = 0;
		}
		camera.setDisplayOrientation(result);
		setZoom(parameters);
		setFocusMode(parameters);
		camera.setParameters(parameters);
	}

	/**
	 * Sets the focus mode.
	 *
	 * @param parameters
	 *            the new focus mode
	 */
	private void setFocusMode(Camera.Parameters parameters) {
		//Logger.i(TAG, "setFocusMode");
		List<String> FocusModes = parameters.getSupportedFocusModes();
		if (checkExceptionDeviceFocus(parameters, FocusModes)) {
			return;
		}
		if (FocusModes.contains(Camera.Parameters.FOCUS_MODE_AUTO)) { //
			parameters.setFocusMode(Camera.Parameters.FOCUS_MODE_AUTO);
		} else if (FocusModes.contains(Camera.Parameters.FOCUS_MODE_CONTINUOUS_PICTURE)) {
			parameters.setFocusMode(Camera.Parameters.FOCUS_MODE_CONTINUOUS_PICTURE);
		} else if (FocusModes.contains(Camera.Parameters.FOCUS_MODE_MACRO)) {
			parameters.setFocusMode(Camera.Parameters.FOCUS_MODE_MACRO);
		}

	}

	/**
	 * Check exception device focus.
	 *
	 * @param parameters
	 *            the parameters
	 * @param FocusModes
	 *            the focus modes
	 * @return true, if successful
	 */
	private boolean checkExceptionDeviceFocus(Camera.Parameters parameters, List<String> FocusModes) {
//		if (FileUtils.isSamsungS5()) {
//			AUTOFOCUS_INTERVAL = 200000;
//			if (CameraManagerController.deviceModal.toLowerCase().contains("a")) {
//				android.graphics.Rect newRect = new android.graphics.Rect(-50, -50, 50, 50);
//				Camera.Area focusArea = new Camera.Area(newRect, 1000);
//				List<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
//				focusAreas.add(focusArea);
//				parameters.setFocusAreas(focusAreas);
//				parameters.setFocusMode(Camera.Parameters.FOCUS_MODE_MACRO);
//				return true;
//			}
//
//		}
		return false;
	}

	/**
	 * Gets the video rect.
	 *
	 * @return the video rect
	 */
	public static Rect getVideoRect() {

		Rect videoRect = new Rect(0, 0, 1920, 1080);
		return videoRect;
	}
	public static Rect getScreenRect() {
		Rect videoRect = new Rect(0, 0, screenResolution.x, screenResolution.y);
		return videoRect;
	}

	/**
	 * Gets the camera preview resolution.
	 *
	 * @return the camera preview resolution
	 */
	public  static Point getCameraPreviewResolution() {
		return cameraPreviewResolution;
	}

	/**
	 * Gets the camera capture resolution.
	 *
	 * @return the camera capture resolution
	 */
	public static Point getCameraCaptureResolution() {
		return cameraCaptureResolution;
	}

	/**
	 * Gets the screen resolution.
	 *
	 * @return the screen resolution
	 */
	public Point getScreenResolution() {
		return screenResolution;
	}

	public void setScreenResolution(Point screenResolutionVal) {

		screenResolution  = screenResolutionVal;
	}

	/**
	 * Gets the preview format.
	 *
	 * @return the preview format
	 */
	int getPreviewFormat() {
		return previewFormat;
	}

	/**
	 * Gets the preview format string.
	 *
	 * @return the preview format string
	 */
	String getPreviewFormatString() {
		return previewFormatString;
	}

	/**
	 * Gets the camera preview resolution.
	 *
	 * @param parameters
	 *            the parameters
	 * @param screenResolution
	 *            the screen resolution
	 * @param c
	 *            the c
	 * @return the camera preview resolution
	 */
	@SuppressWarnings("deprecation")
	public static Point getCameraPreviewResolution(Camera.Parameters parameters, Point screenResolution, Context c) {
		long startTime = System.currentTimeMillis();
		//Logger.i(TAG, "getCameraPreviewResolution");
		boolean defaultVideoResFound = false;
		List<Camera.Size> sizes = parameters.getSupportedPreviewSizes();
		if (CameraManagerController.isDebug) {
			FileUtils.addToLogFile("Screen resolution ", screenResolution.x + " * " + screenResolution.y, c);

		}

		if (screenResolution.y > screenResolution.x) {
			int tmp = screenResolution.x;
			screenResolution.x = screenResolution.y;
			screenResolution.y = tmp;
		}
		int frameWidth = screenResolution.x;
		int frameHeight = screenResolution.y;
		int max = 0;
		if (videoWidthRes != 0 && videoHeightRes != 0) {
			videoResolutionWidth = videoWidthRes;
			videoResolutionHeight = videoHeightRes;
			return new Point(videoResolutionWidth, videoResolutionHeight);
		}
		for (Camera.Size size : sizes) {
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("Preview size ", size.width + " * " + size.height, c);
			}
			if (size.height == minHeightForVideoCapture && size.width == minWidthForVideoCapture) {
				defaultVideoResFound = true;
			}
			if (size.height * size.width > max) {

				max = size.height * size.width;
				videoResolutionWidth = size.width;
				videoResolutionHeight = size.height;

			}
		}
		// limit the video res to 1920x1080 for new phones we dont want the
		// video frames to get stuck due to large frame size.
		if (videoResolutionHeight > minHeightForVideoCapture && videoResolutionWidth > minWidthForVideoCapture && defaultVideoResFound) {
			videoResolutionWidth = minWidthForVideoCapture;
			videoResolutionHeight = minHeightForVideoCapture;
		}
		screenAndVideoRatioWidth = (float) frameWidth / videoResolutionWidth;
		screenAndVideoRatioHeight = (float) frameHeight / videoResolutionHeight;
		if (screenAndVideoRatioWidth == 0) {
			screenAndVideoRatioWidth = 1.0f;
		}
		if (screenAndVideoRatioHeight == 0) {
			screenAndVideoRatioHeight = 1.0f;
		}
		// android.hardware.Camera.Size videoSize =
		// parameters.getPreferredPreviewSizeForVideo();

		if (CameraManagerController.deviceModal.equals("XT1032") && CameraManagerController.deviceBrand.equals("Motorola")) {
			// Moto G device screen has AR that is not equal to any of the video
			// resolution
			videoResolutionWidth = 1280;
			videoResolutionHeight = 720;			
		}
		long endTime = System.currentTimeMillis();
		Logger.i(TAG, "getCameraPreviewResolution time is" + String.valueOf(startTime - endTime));
		return new Point(videoResolutionWidth, videoResolutionHeight);

	}

	/**
	 * Checks if is video mode supported.
	 *
	 * @return true, if is video mode supported
	 */
	public static boolean isVideoModeSupported(Context c) {
		if (videoResolutionHeight < minHeightForVideoCapture || videoResolutionWidth < minWidthForVideoCapture) {
			return false;
		} else {
			if (!checkForExceptionDevices(c)) {
				return true;
			}
			return false;
		}
	}

	public static boolean checkForExceptionDevices(Context c){
		try {
			exceptionDevices = c.getResources().getStringArray(R.array.exception_devices_name_stills_only);
			if (exceptionDevices == null || exceptionDevices.length == 0){
				return false;
			}
			for(int i = 0; i<exceptionDevices.length ; i++){
				exceptionDevices[i] = exceptionDevices[i].trim().toLowerCase();
			}
			if (Arrays.asList(exceptionDevices).contains(CameraManagerController.deviceName.trim().toLowerCase())){
				return true;
			}
			return false;
		}catch(Exception e){
			Logger.e(TAG, Log.getStackTraceString(e));
			return false;
		}
	}

	/**
	 * Sets the camera display orientation.
	 *
	 * @param activity
	 *            the activity
	 * @param cameraId
	 *            the camera id
	 * @param camera
	 *            the camera
	 */


	public static void setCameraDisplayOrientation(Activity activity, int cameraId, android.hardware.Camera camera) {
		android.hardware.Camera.CameraInfo info = new android.hardware.Camera.CameraInfo();

		int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
		int degrees = 0;
		switch (rotation) {
		case Surface.ROTATION_0:
			degrees = 0;
			break;
		case Surface.ROTATION_90:
			degrees = 90;
			break;
		case Surface.ROTATION_180:
			degrees = 180;
			break;
		case Surface.ROTATION_270:
			degrees = 270;
			break;
		}

		int result = 0;
		if (info.facing == Camera.CameraInfo.CAMERA_FACING_FRONT) {
			result = (info.orientation + degrees) % 360;
			result = (360 - result) % 360; // compensate the mirror } else { //
											// back-facing
			result = (info.orientation - degrees + 360) % 360;
		}
		camera.setDisplayOrientation(result);
	}

	/**
	 * Checks if is camera mega pixels supported.
	 *
	 * @return true, if is camera mega pixels supported
	 */
	public static boolean isCameraMegaPixelsSupported() {
		Camera camera = Camera.open();
		Camera.Parameters params = camera.getParameters();
		Point maxMegaPixels = getMaximumMegaPixels(params);
		CAMERAPIXELS = maxMegaPixels.x * maxMegaPixels.y;
		camera.release();
		if (CAMERAPIXELS > minimumCameraPixels * 1000000) {
			return true;
		}
		return false;
	}

	/**
	 * Gets the camera capture resolution.
	 *
	 * @param parameters
	 *            the parameters
	 * @param screenResolution
	 *            the screen resolution
	 * @param c
	 *            the c
	 * @return the camera capture resolution
	 */

	// dupplicate code need to change this!!
	public static Point chooseCaptureResolution(Size[] supportedSizes,Context c){
		boolean foundLowImageRes = false;
		boolean foundMediumDefaultRes = false;
		boolean foundHighDefaultRes = false;
		Size maxMegaPixels = getMaxSize(supportedSizes);
		captureResolutionWidth = maxMegaPixels.getWidth(); // use default highest res.
		captureResolutionHeight = maxMegaPixels.getHeight();

		int currMediumCaptureWidth = captureResolutionWidth;
		int currMediumCaptureHeight = captureResolutionHeight;
		int currHighCaptureWidth = captureResolutionWidth;
		int currHighCaptureHeight = captureResolutionHeight;
		for (Size size : supportedSizes) {
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("Stills size ", size.getWidth() + " * " + size.getWidth(),c);
			}
			if (size.getWidth() == normalImageWidth && size.getHeight() == normalImageHeight) {
				foundLowImageRes = true;
			}

			double videoResolutionRatio = (double) videoResolutionWidth / videoResolutionHeight;
			double stillsResolutionRatio;
			if (size.getWidth() * size.getHeight() > 2300000) {
				stillsResolutionRatio = (double) size.getWidth() / size.getHeight();
				if (Math.abs(stillsResolutionRatio - videoResolutionRatio) < 0.1) {
					if ((size.getWidth() * size.getHeight()) < (currMediumCaptureWidth * currMediumCaptureHeight)) {
						currMediumCaptureWidth = size.getWidth();
						currMediumCaptureHeight = size.getHeight();
						foundMediumDefaultRes = true;
					}
				}

			}

			if ((size.getWidth() >= 2500 && size.getWidth() < 2600) && (size.getHeight() > 1900 && size.getHeight() < 2000)) {
				foundHighDefaultRes = true;
				currHighCaptureWidth = size.getWidth();
				currHighCaptureHeight = size.getHeight();

			}

		}
		if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.useMaxResolutionStills) {
			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
		}
		if (FileUtils.getDeviceName().equals("Motorola XT1052")){
			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
		}
		if (FileUtils.getDeviceName().equals("Motorola XT1254")){
			return new Point(2592, 1458);
		}


		if (stillWidthRes != 0 && stillHeightRes != 0) {
			captureResolutionWidth = stillWidthRes;
			captureResolutionHeight = stillHeightRes;
			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
		}
		// FileUtils.isSamsungS4() ||
		if (FileUtils.isSamsungS4() || CameraManagerController.deviceName.equals("HTC One X+")) {

			captureResolutionWidth = normalImageWidth;
			captureResolutionHeight = normalImageHeight;
			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
		}

		if (FileUtils.isSamsungS5()) {
			captureResolutionWidth = 3264;
			captureResolutionHeight = 1836;

			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
		}

		if (foundLowImageRes) { // first try to use low resolution.
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("choose default resolution ", normalImageWidth + "* " + normalImageHeight, c);
			}
			captureResolutionWidth = normalImageWidth;
			captureResolutionHeight = normalImageHeight;
			return new Point((int) normalImageWidth, (int) normalImageHeight);
		}
		if (foundMediumDefaultRes) { // meduim resolution should be over 3MP
			// with c ratio as the video
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("choose medium resolution ", currMediumCaptureWidth + "* " + currMediumCaptureHeight, c);
			}
			captureResolutionWidth = currMediumCaptureWidth;
			captureResolutionHeight = currMediumCaptureHeight;
			return new Point((int) currMediumCaptureWidth, (int) currMediumCaptureHeight);
		}
		if (foundHighDefaultRes) { // if low and medium res not found take ~5MP
			// res.
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("choose high resolution ", currHighCaptureWidth + "* " + currHighCaptureHeight, c);
			}
			captureResolutionWidth = currHighCaptureWidth;
			captureResolutionHeight = currHighCaptureHeight;
			return new Point((int) currHighCaptureWidth, (int) currHighCaptureHeight);
		}
		// return max resolution if non of the above work.
		return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
	}

	public static Point getCameraCaptureResolution(Camera.Parameters parameters, Point screenResolution, Context c) {
		List<Camera.Size> supportedSizes = parameters.getSupportedPictureSizes();
		//Logger.i(TAG, "getCameraCaptureResolution");
		// setting picture size
		boolean foundLowImageRes = false;
		boolean foundMediumDefaultRes = false;
		boolean foundHighDefaultRes = false;
		Point maxMegaPixels = getMaximumMegaPixels(parameters);
		captureResolutionWidth = maxMegaPixels.x; // use default highest res.
		captureResolutionHeight = maxMegaPixels.y;

		int currMediumCaptureWidth = captureResolutionWidth;
		int currMediumCaptureHeight = captureResolutionHeight;
		int currHighCaptureWidth = captureResolutionWidth;
		int currHighCaptureHeight = captureResolutionHeight;
		// high resolution images use for big documents and CMC7!!!


//		CAMERAPIXELS = maxMegaPixels.x * maxMegaPixels.y;
//
//		if (CAMERAPIXELS > minimumCameraPixels * 1000000) {
//			return true;
//		}
//		return false;

		for (Camera.Size size : supportedSizes) {
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("Stills size ", size.width + " * " + size.height, c);
			}
			if (size.width == normalImageWidth && size.height == normalImageHeight) {
				foundLowImageRes = true;
			}

			double videoResolutionRatio = (double) videoResolutionWidth / videoResolutionHeight;
			double stillsResolutionRatio;
			if (size.width * size.height > 2300000) {
				stillsResolutionRatio = (double) size.width / size.height;
				if (Math.abs(stillsResolutionRatio - videoResolutionRatio) < 0.1) {
					if ((size.width * size.height) < (currMediumCaptureWidth * currMediumCaptureHeight)) {
						currMediumCaptureWidth = size.width;
						currMediumCaptureHeight = size.height;
						foundMediumDefaultRes = true;
					}
				}

			}

			if ((size.width >= 2500 && size.width < 2600) && (size.height > 1900 && size.height < 2000)) {
				foundHighDefaultRes = true;
				currHighCaptureWidth = size.width;
				currHighCaptureHeight = size.height;

			}

		}
		if (CameraManagerController.imageType == TISDocumentType.FULL_PAGE || CameraManagerController.useMaxResolutionStills) {
			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
		}
		if (FileUtils.getDeviceName().equals("Motorola XT1052")){
			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);			
		} 
		if (FileUtils.getDeviceName().equals("Motorola XT1254")){
			return new Point(2592, 1458);
		}	
		

		if (stillWidthRes != 0 && stillHeightRes != 0) {
			captureResolutionWidth = stillWidthRes;
			captureResolutionHeight = stillHeightRes;
			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
		}
		// FileUtils.isSamsungS4() ||
		if (FileUtils.isSamsungS4() || CameraManagerController.deviceName.equals("HTC One X+")) {

			captureResolutionWidth = normalImageWidth;
			captureResolutionHeight = normalImageHeight;
			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
		}

		if (FileUtils.isSamsungS5()) {
			captureResolutionWidth = 3264;
			captureResolutionHeight = 1836;

			return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);
		}

		if (foundLowImageRes) { // first try to use low resolution.
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("choose default resolution ", normalImageWidth + "* " + normalImageHeight, c);
			}
			captureResolutionWidth = normalImageWidth;
			captureResolutionHeight = normalImageHeight;
			return new Point((int) normalImageWidth, (int) normalImageHeight);
		}
		if (foundMediumDefaultRes) { // meduim resolution should be over 3MP
										// with c ratio as the video
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("choose medium resolution ", currMediumCaptureWidth + "* " + currMediumCaptureHeight, c);
			}
			captureResolutionWidth = currMediumCaptureWidth;
			captureResolutionHeight = currMediumCaptureHeight;
			return new Point((int) currMediumCaptureWidth, (int) currMediumCaptureHeight);
		}
		if (foundHighDefaultRes) { // if low and medium res not found take ~5MP
									// res.
			if (CameraManagerController.isDebug) {
				FileUtils.addToLogFile("choose high resolution ", currHighCaptureWidth + "* " + currHighCaptureHeight, c);
			}
			captureResolutionWidth = currHighCaptureWidth;
			captureResolutionHeight = currHighCaptureHeight;
			return new Point((int) currHighCaptureWidth, (int) currHighCaptureHeight);
		}
		// return max resolution if non of the above work.
		return new Point((int) captureResolutionWidth, (int) captureResolutionHeight);

	}

	/**
	 * Gets the maximum mega pixels.
	 *
	 * @param parameters
	 *            the parameters
	 * @return the maximum mega pixels
	 */
	private static Point getMaximumMegaPixels(Camera.Parameters parameters) {
		List<Camera.Size> supportedSizes = parameters.getSupportedPictureSizes();
		int max = 0;
		int width = 0;
		int height = 0;
		for (Camera.Size size : supportedSizes) {
			if (size.width * size.height > max) {
				max = size.width * size.height;
				width = size.width;
				height = size.height;
			}
		}
		return new Point(width, height);
	}
	private static Size getMaxSize(Size[] cameraSizes){
		int max = 0;
		int width = 0;
		int height = 0;
		for (Size  size: cameraSizes) {
			if (size.getWidth() * size.getHeight() > max) {
				max = size.getWidth() * size.getHeight();
				width = size.getWidth();
				height = size.getHeight();
			}
		}
		return new Size(width, height);
	}

	/**
	 * Sets the flash.
	 *
	 * @param parameters
	 *            the parameters
	 * @param isTorchOn
	 *            the is torch on
	 */
	private void setFlash(Camera.Parameters parameters, boolean isTorchOn) {
		if (isTorchOn) {
			parameters.setFlashMode(Parameters.FLASH_MODE_TORCH);
			FlashlightManager.enableFlashlight();
		} else {
			parameters.setFlashMode(Parameters.FLASH_MODE_OFF);
			// Samsung hack
			parameters.set("flash-value", 2);
			// Standard setting to turn off flash
			parameters.set("flash-mode", "off");
			FlashlightManager.disableFlashlight();
		}
	}

	/**
	 * Sets the zoom.
	 *
	 * @param parameters
	 *            the new zoom
	 */
	private void setZoom(Camera.Parameters parameters) {
		String zoomSupportedString = parameters.get("zoom-supported");
		if (zoomSupportedString != null && !Boolean.parseBoolean(zoomSupportedString)) {
			return;
		}

		int tenDesiredZoom = TEN_DESIRED_ZOOM;

		String maxZoomString = parameters.get("max-zoom");
		if (maxZoomString != null) {
			try {
				int tenMaxZoom = (int) (10.0 * Double.parseDouble(maxZoomString));
				if (tenDesiredZoom > tenMaxZoom) {
					tenDesiredZoom = tenMaxZoom;
				}
			} catch (NumberFormatException nfe) {
				Logger.w(TAG, "Bad max-zoom: " + maxZoomString);
			}
		}

		String takingPictureZoomMaxString = parameters.get("taking-picture-zoom-max");
		if (takingPictureZoomMaxString != null) {
			try {
				int tenMaxZoom = Integer.parseInt(takingPictureZoomMaxString);
				if (tenDesiredZoom > tenMaxZoom) {
					tenDesiredZoom = tenMaxZoom;
				}
			} catch (NumberFormatException nfe) {
				Logger.w(TAG, "Bad taking-picture-zoom-max: " + takingPictureZoomMaxString);
			}
		}

		if (maxZoomString != null) {
			parameters.set("zoom", String.valueOf(tenDesiredZoom / 10.0));
		}

		if (takingPictureZoomMaxString != null) {
			parameters.set("taking-picture-zoom", tenDesiredZoom);
		}
	}
}