/*
 * 
 */
package com.topimagesystems.controllers;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.Window;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.topimagesystems.R;
import com.topimagesystems.ui.ActionBar;
import com.topimagesystems.util.StringUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class BaseController.
 */
public abstract class BaseController extends Activity {
	
	/** The btn back. */
	protected Button btnBack;
	
	/** The btn right button. */
	protected Button btnRightButton;
	
	/** The txt action bar title. */
	protected TextView txtActionBarTitle;
	
	/** The img action bar icon. */
	protected ImageView imgActionBarIcon;
	
	/** The action bar. */
	protected ActionBar actionBar;
	
	/** The progress dialog. */
	private ProgressDialog progressDialog;
//	private ZubhiumSDK sdk;

	/* (non-Javadoc)
 * @see android.app.Activity#onCreate(android.os.Bundle)
 */
@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		ensureActionBar();
	}
	
	/**
	 * On create.
	 *
	 * @param savedInstanceState the saved instance state
	 * @param layoutResID the layout res id
	 */
	protected void onCreate(Bundle savedInstanceState, int layoutResID) {
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		if (layoutResID > -1) {
			setContentView(layoutResID);
		}
		ensureActionBar();
	}

	/**
	 * Ensure action bar.
	 */
	protected abstract void ensureActionBar();

	/* (non-Javadoc)
	 * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.mbck_main_menu, menu);
		return true;
	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onOptionsItemSelected(android.view.MenuItem)
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		return super.onOptionsItemSelected(item);
	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onResume()
	 */
	@Override
	protected void onResume() {
		super.onResume();
		//TODO BugSenseHandler.initAndStartSession(this, Config.BUGSENSE_APIKEY);
	}

	/* (non-Javadoc)
	 * @see android.app.Activity#onPause()
	 */
	@Override
	protected void onPause() {
		super.onPause();
		//TODO BugSenseHandler.closeSession(this);
	}

	/**
	 * Show error.
	 *
	 * @param title the title
	 * @param message the message
	 * @param onclickListener the onclick listener
	 */
	protected void showError(final String title, final String message, final DialogInterface.OnClickListener onclickListener) {
		if (!isFinishing()) {
			runOnUiThread(new Runnable() {

				@Override
				public void run() {
					showProgressDialog(false);
					AlertDialog alertDialog = new AlertDialog.Builder(BaseController.this).setTitle(title).setMessage(message)
							.setCancelable(false).setPositiveButton(StringUtils.dynamicString(getBaseContext(), "TISFlowOK"), onclickListener).create();
					alertDialog.show();
				}
			});
		}
		return;
	}

	/**
	 * Show progress dialog.
	 *
	 * @param isShow the is show
	 */
	protected void showProgressDialog(boolean isShow) {
		showProgressDialog(isShow, StringUtils.dynamicString(this,"TISProcessing"));
	}

	/**
	 * Show progress dialog.
	 *
	 * @param isShow the is show
	 * @param message the message
	 */
	protected void showProgressDialog(final boolean isShow, final String message) {
		if (!isFinishing()) {
			runOnUiThread(new Runnable() {
				@Override
				public void run() {
					if (isShow) {
						if (progressDialog == null) {
							progressDialog = new ProgressDialog(BaseController.this);
							progressDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
						}
						progressDialog.setMessage(message);
						progressDialog.show();
					}
					else {
						if (progressDialog != null) {
							progressDialog.dismiss();
						}
					}
				}
			});
		}
	}
}