/*
 * Decompiled with CFR 0.152.
 */
package com.tomer.fadingtextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.ArrayRes;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import com.tomer.fadingtextview.R;

public class FadingTextView
extends TextView {
    private Animation fadeInAnimation;
    private Animation fadeOutAnimation;
    private Handler handler;
    private CharSequence[] texts;
    private boolean isShown;
    private int position;
    private int timeout = 15000;

    public FadingTextView(Context context) {
        super(context);
        this.init(context);
    }

    public FadingTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
        this.handleAttrs(context, attrs);
    }

    public FadingTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
        this.handleAttrs(context, attrs);
    }

    @RequiresApi(api=21)
    public FadingTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
        this.handleAttrs(context, attrs);
    }

    public void resume() {
        this.isShown = true;
        this.startAnimation();
    }

    public void pause() {
        this.isShown = false;
        this.handler.removeCallbacksAndMessages(null);
    }

    private void init(Context context) {
        this.fadeInAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.fadein);
        this.fadeOutAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.fadeout);
        this.handler = new Handler();
        this.isShown = true;
        this.setMaxLines(1);
        if (Build.VERSION.SDK_INT >= 23) {
            this.setTextAppearance(16974318);
            this.setTextColor(ContextCompat.getColor((Context)context, (int)17170443));
        }
    }

    private void handleAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.fading_text_view);
        this.texts = a.getTextArray(R.styleable.fading_text_view_texts);
        this.timeout = Math.abs(a.getInteger(R.styleable.fading_text_view_timeout, 14500)) + this.getResources().getInteger(17694722);
        a.recycle();
        this.startAnimation();
    }

    public CharSequence[] getTexts() {
        return this.texts;
    }

    public void setTexts(@ArrayRes int texts) {
        this.texts = this.getResources().getStringArray(texts);
    }

    protected void startAnimation() {
        this.setText(this.texts[this.position]);
        this.startAnimation(this.fadeInAnimation);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                FadingTextView.this.startAnimation(FadingTextView.this.fadeOutAnimation);
                FadingTextView.this.getAnimation().setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        if (FadingTextView.this.isShown) {
                            FadingTextView.this.position = FadingTextView.this.position == FadingTextView.this.texts.length - 1 ? 0 : FadingTextView.this.position + 1;
                            FadingTextView.this.startAnimation();
                        }
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
            }
        }, (long)this.timeout);
    }
}

