/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.rendering;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.util.Log;
import com.tom_roush.harmony.awt.geom.AffineTransform;
import com.tom_roush.pdfbox.contentstream.PDFGraphicsStreamEngine;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.common.function.PDFunction;
import com.tom_roush.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType0;
import com.tom_roush.pdfbox.pdmodel.font.PDCIDFontType2;
import com.tom_roush.pdfbox.pdmodel.font.PDFont;
import com.tom_roush.pdfbox.pdmodel.font.PDTrueTypeFont;
import com.tom_roush.pdfbox.pdmodel.font.PDType0Font;
import com.tom_roush.pdfbox.pdmodel.font.PDType1CFont;
import com.tom_roush.pdfbox.pdmodel.font.PDType1Font;
import com.tom_roush.pdfbox.pdmodel.font.PDType3Font;
import com.tom_roush.pdfbox.pdmodel.graphics.PDLineDashPattern;
import com.tom_roush.pdfbox.pdmodel.graphics.PDXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.blend.BlendMode;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColor;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDColorSpace;
import com.tom_roush.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDFormXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImage;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImageXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import com.tom_roush.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentMembershipDictionary;
import com.tom_roush.pdfbox.pdmodel.graphics.shading.PDShading;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDGraphicsState;
import com.tom_roush.pdfbox.pdmodel.graphics.state.PDSoftMask;
import com.tom_roush.pdfbox.pdmodel.graphics.state.RenderingMode;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.AnnotationFilter;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationUnknown;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import com.tom_roush.pdfbox.rendering.CIDType0Glyph2D;
import com.tom_roush.pdfbox.rendering.Glyph2D;
import com.tom_roush.pdfbox.rendering.PDFRenderer;
import com.tom_roush.pdfbox.rendering.PageDrawerParameters;
import com.tom_roush.pdfbox.rendering.RenderDestination;
import com.tom_roush.pdfbox.rendering.TTFGlyph2D;
import com.tom_roush.pdfbox.rendering.Type1Glyph2D;
import com.tom_roush.pdfbox.util.Matrix;
import com.tom_roush.pdfbox.util.Vector;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PageDrawer
extends PDFGraphicsStreamEngine {
    private final PDFRenderer renderer;
    private final boolean subsamplingAllowed;
    private Paint paint;
    private Canvas canvas;
    private AffineTransform xform;
    private float xformScalingFactorX;
    private float xformScalingFactorY;
    private PDRectangle pageSize;
    private boolean flipTG = false;
    private Path.FillType clipWindingRule = null;
    private Path linePath = new Path();
    private Region lastClip;
    private int lastStackSize = 0;
    private Path initialClip;
    private List<Path> textClippings;
    private final Map<PDFont, Glyph2D> fontGlyph2D = new HashMap<PDFont, Glyph2D>();
    private PointF currentPoint = new PointF();
    private final Deque<TransparencyGroup> transparencyGroupStack = new ArrayDeque<TransparencyGroup>();
    private int nestedHiddenOCGCount;
    private final RenderDestination destination;
    private final float imageDownscalingOptimizationThreshold;
    private AnnotationFilter annotationFilter = new AnnotationFilter(){

        @Override
        public boolean accept(PDAnnotation annotation) {
            return true;
        }
    };

    public PageDrawer(PageDrawerParameters parameters) throws IOException {
        super(parameters.getPage());
        this.renderer = parameters.getRenderer();
        this.subsamplingAllowed = parameters.isSubsamplingAllowed();
        this.destination = parameters.getDestination();
        this.imageDownscalingOptimizationThreshold = parameters.getImageDownscalingOptimizationThreshold();
    }

    public AnnotationFilter getAnnotationFilter() {
        return this.annotationFilter;
    }

    public void setAnnotationFilter(AnnotationFilter annotationFilter) {
        this.annotationFilter = annotationFilter;
    }

    public final PDFRenderer getRenderer() {
        return this.renderer;
    }

    protected final Canvas getCanvas() {
        return this.canvas;
    }

    protected final Path getLinePath() {
        return this.linePath;
    }

    private void setRenderingHints() {
        this.paint.setAntiAlias(true);
    }

    public void drawPage(Paint p, Canvas c, PDRectangle pageSize) throws IOException {
        this.paint = p;
        this.canvas = c;
        this.xform = new AffineTransform(this.canvas.getMatrix());
        Matrix m = new Matrix(this.xform);
        this.xformScalingFactorX = Math.abs(m.getScalingFactorX());
        this.xformScalingFactorY = Math.abs(m.getScalingFactorY());
        this.canvas.save();
        this.pageSize = pageSize;
        this.setRenderingHints();
        this.canvas.translate(0.0f, pageSize.getHeight());
        this.canvas.scale(1.0f, -1.0f);
        this.canvas.translate(-pageSize.getLowerLeftX(), -pageSize.getLowerLeftY());
        this.processPage(this.getPage());
        for (PDAnnotation annotation : this.getPage().getAnnotations(this.annotationFilter)) {
            this.showAnnotation(annotation);
        }
        this.canvas.restore();
    }

    private float clampColor(float color) {
        return color < 0.0f ? 0.0f : (color > 1.0f ? 1.0f : color);
    }

    private int getColor(PDColor color) throws IOException {
        double alphaConstant = this.getGraphicsState().getAlphaConstant();
        PDColorSpace colorSpace = color.getColorSpace();
        float[] floats = colorSpace.toRGB(color.getComponents());
        int alpha = Long.valueOf(Math.round(alphaConstant * 255.0)).intValue();
        int r = Math.round(floats[0] * 255.0f);
        int g = Math.round(floats[1] * 255.0f);
        int b = Math.round(floats[2] * 255.0f);
        return Color.argb((int)alpha, (int)r, (int)g, (int)b);
    }

    protected final void setClip() {
        Region clippingPath = this.getGraphicsState().getCurrentClippingPath();
        if (clippingPath != this.lastClip) {
            if (this.lastStackSize >= 1) {
                this.canvas.restoreToCount(this.lastStackSize);
            }
            this.lastStackSize = this.canvas.save();
            if (!clippingPath.isEmpty()) {
                this.canvas.clipPath(clippingPath.getBoundaryPath());
            }
            if (this.initialClip != null) {
                // empty if block
            }
            this.lastClip = clippingPath;
        }
    }

    @Override
    public void beginText() throws IOException {
        this.setClip();
        this.beginTextClip();
    }

    @Override
    public void endText() throws IOException {
        this.endTextClip();
    }

    private void beginTextClip() {
        this.textClippings = new ArrayList<Path>();
    }

    private void endTextClip() {
        PDGraphicsState state = this.getGraphicsState();
        RenderingMode renderingMode = state.getTextState().getRenderingMode();
        if (renderingMode.isClip() && !this.textClippings.isEmpty()) {
            Path path = new Path();
            path.setFillType(Path.FillType.WINDING);
            for (Path shape : this.textClippings) {
                path.addPath(shape);
            }
            state.intersectClippingPath(path);
            this.textClippings = new ArrayList<Path>();
            this.lastClip = null;
        }
    }

    @Override
    protected void showFontGlyph(Matrix textRenderingMatrix, PDFont font, int code, Vector displacement) throws IOException {
        AffineTransform at = textRenderingMatrix.createAffineTransform();
        at.concatenate(font.getFontMatrix().createAffineTransform());
        Glyph2D glyph2D = this.createGlyph2D(font);
        try {
            this.drawGlyph2D(glyph2D, font, code, displacement, at);
        }
        catch (IOException ex) {
            Log.e((String)"PdfBox-Android", (String)("Could not draw glyph for code " + code + " at position (" + at.getTranslateX() + "," + at.getTranslateY() + ")"), (Throwable)ex);
        }
    }

    private void drawGlyph2D(Glyph2D glyph2D, PDFont font, int code, Vector displacement, AffineTransform at) throws IOException {
        PDGraphicsState state = this.getGraphicsState();
        RenderingMode renderingMode = state.getTextState().getRenderingMode();
        Path path = glyph2D.getPathForCharacterCode(code);
        if (path != null) {
            float fontWidth;
            if (!font.isEmbedded() && !font.isVertical() && !font.isStandard14() && font.hasExplicitWidth(code) && (fontWidth = font.getWidthFromFont(code)) > 0.0f && (double)Math.abs(fontWidth - displacement.getX() * 1000.0f) > 1.0E-4) {
                float pdfWidth = displacement.getX() * 1000.0f;
                at.scale(pdfWidth / fontWidth, 1.0);
            }
            path.transform(at.toMatrix());
            if (this.isContentRendered()) {
                if (renderingMode.isFill()) {
                    this.paint.setColor(this.getNonStrokingColor());
                    this.setClip();
                    this.paint.setStyle(Paint.Style.FILL);
                    this.canvas.drawPath(path, this.paint);
                }
                if (renderingMode.isStroke()) {
                    this.paint.setColor(this.getStrokingColor());
                    this.setStroke();
                    this.setClip();
                    this.paint.setStyle(Paint.Style.STROKE);
                    this.canvas.drawPath(path, this.paint);
                }
            }
            if (renderingMode.isClip()) {
                // empty if block
            }
        }
    }

    @Override
    protected void showType3Glyph(Matrix textRenderingMatrix, PDType3Font font, int code, Vector displacement) throws IOException {
        PDGraphicsState state = this.getGraphicsState();
        RenderingMode renderingMode = state.getTextState().getRenderingMode();
        if (!RenderingMode.NEITHER.equals((Object)renderingMode)) {
            super.showType3Glyph(textRenderingMatrix, font, code, displacement);
        }
    }

    private Glyph2D createGlyph2D(PDFont font) throws IOException {
        Glyph2D glyph2D = this.fontGlyph2D.get(font);
        if (glyph2D != null) {
            return glyph2D;
        }
        if (font instanceof PDTrueTypeFont) {
            PDTrueTypeFont ttfFont = (PDTrueTypeFont)font;
            glyph2D = new TTFGlyph2D(ttfFont);
        } else if (font instanceof PDType1Font) {
            PDType1Font pdType1Font = (PDType1Font)font;
            glyph2D = new Type1Glyph2D(pdType1Font);
        } else if (font instanceof PDType1CFont) {
            PDType1CFont type1CFont = (PDType1CFont)font;
            glyph2D = new Type1Glyph2D(type1CFont);
        } else if (font instanceof PDType0Font) {
            PDType0Font type0Font = (PDType0Font)font;
            if (type0Font.getDescendantFont() instanceof PDCIDFontType2) {
                glyph2D = new TTFGlyph2D(type0Font);
            } else if (type0Font.getDescendantFont() instanceof PDCIDFontType0) {
                PDCIDFontType0 cidType0Font = (PDCIDFontType0)type0Font.getDescendantFont();
                glyph2D = new CIDType0Glyph2D(cidType0Font);
            }
        } else {
            throw new IllegalStateException("Bad font type: " + font.getClass().getSimpleName());
        }
        if (glyph2D != null) {
            this.fontGlyph2D.put(font, glyph2D);
        }
        if (glyph2D == null) {
            throw new UnsupportedOperationException("No font for " + font.getName());
        }
        return glyph2D;
    }

    @Override
    public void appendRectangle(PointF p0, PointF p1, PointF p2, PointF p3) {
        this.linePath.moveTo(p0.x, p0.y);
        this.linePath.lineTo(p1.x, p1.y);
        this.linePath.lineTo(p2.x, p2.y);
        this.linePath.lineTo(p3.x, p3.y);
        this.linePath.close();
    }

    private int getStrokingColor() throws IOException {
        return this.getColor(this.getGraphicsState().getStrokingColor());
    }

    protected final int getNonStrokingColor() throws IOException {
        return this.getColor(this.getGraphicsState().getNonStrokingColor());
    }

    private void setStroke() {
        PDLineDashPattern dashPattern;
        float[] dashArray;
        PDGraphicsState state = this.getGraphicsState();
        float lineWidth = this.transformWidth(state.getLineWidth());
        if ((double)lineWidth < 0.25) {
            lineWidth = 0.25f;
        }
        if (this.isAllZeroDash(dashArray = (dashPattern = state.getLineDashPattern()).getDashArray())) {
            return;
        }
        float phaseStart = dashPattern.getPhase();
        dashArray = this.getDashArray(dashPattern);
        phaseStart = this.transformWidth(phaseStart);
        this.paint.setStrokeWidth(lineWidth);
        this.paint.setStrokeCap(state.getLineCap());
        this.paint.setStrokeJoin(state.getLineJoin());
        float miterLimit = state.getMiterLimit();
        if (miterLimit < 1.0f) {
            Log.w((String)"PdfBox-Android", (String)("Miter limit must be >= 1, value " + miterLimit + " is ignored"));
            miterLimit = 10.0f;
        }
        this.paint.setStrokeMiter(miterLimit);
        if (dashArray != null) {
            this.paint.setPathEffect((PathEffect)new DashPathEffect(dashArray, phaseStart));
        }
    }

    private boolean isAllZeroDash(float[] dashArray) {
        if (dashArray.length > 0) {
            for (int i = 0; i < dashArray.length; ++i) {
                if (dashArray[i] == 0.0f) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private float[] getDashArray(PDLineDashPattern dashPattern) {
        int i;
        float[] dashArray = dashPattern.getDashArray();
        int phase = dashPattern.getPhase();
        if (dashArray.length == 0 || Float.isInfinite(phase) || Float.isNaN(phase)) {
            return null;
        }
        for (i = 0; i < dashArray.length; ++i) {
            if (!Float.isInfinite(dashArray[i]) && !Float.isNaN(dashArray[i])) continue;
            return null;
        }
        for (i = 0; i < dashArray.length; ++i) {
            float w = this.transformWidth(dashArray[i]);
            dashArray[i] = this.xformScalingFactorX < 0.5f ? Math.max(w, 0.2f) : Math.max(w, 0.062f);
        }
        return dashArray;
    }

    @Override
    public void strokePath() throws IOException {
        if (this.isContentRendered()) {
            this.setStroke();
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setColor(this.getStrokingColor());
            this.setClip();
            this.canvas.drawPath(this.linePath, this.paint);
        }
        this.linePath.reset();
    }

    @Override
    public void fillPath(Path.FillType windingRule) throws IOException {
        boolean noAntiAlias;
        PDGraphicsState graphicsState = this.getGraphicsState();
        this.paint.setColor(this.getNonStrokingColor());
        this.setClip();
        this.linePath.setFillType(windingRule);
        RectF bounds = new RectF();
        this.linePath.computeBounds(bounds, true);
        boolean bl = noAntiAlias = this.isRectangular(this.linePath) && bounds.width() > 1.0f && bounds.height() > 1.0f;
        if (noAntiAlias) {
            this.paint.setAntiAlias(false);
        }
        if (this.isContentRendered()) {
            this.paint.setStyle(Paint.Style.FILL);
            this.canvas.drawPath(this.linePath, this.paint);
        }
        this.linePath.reset();
        if (noAntiAlias) {
            this.setRenderingHints();
        }
    }

    private boolean isRectangular(Path path) {
        RectF rect = new RectF();
        return path.isRect(rect);
    }

    @Override
    public void fillAndStrokePath(Path.FillType windingRule) throws IOException {
        Path path = new Path(this.linePath);
        this.fillPath(windingRule);
        this.linePath = path;
        this.strokePath();
    }

    @Override
    public void clip(Path.FillType windingRule) {
        this.clipWindingRule = windingRule;
    }

    @Override
    public void moveTo(float x, float y) {
        this.currentPoint.set(x, y);
        this.linePath.moveTo(x, y);
    }

    @Override
    public void lineTo(float x, float y) {
        this.currentPoint.set(x, y);
        this.linePath.lineTo(x, y);
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.currentPoint.set(x3, y3);
        this.linePath.cubicTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public PointF getCurrentPoint() {
        return this.currentPoint;
    }

    @Override
    public void closePath() {
        this.linePath.close();
    }

    @Override
    public void endPath() {
        this.linePath.reset();
    }

    @Override
    public void drawImage(PDImage pdImage) throws IOException {
        if (pdImage instanceof PDImageXObject && this.isHiddenOCG(((PDImageXObject)pdImage).getOptionalContent())) {
            return;
        }
        if (!this.isContentRendered()) {
            return;
        }
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        AffineTransform at = ctm.createAffineTransform();
        if (!pdImage.getInterpolate()) {
            boolean isScaledUp;
            Bitmap bim = this.subsamplingAllowed ? pdImage.getImage(null, this.getSubsampling(pdImage, at)) : pdImage.getImage();
            Matrix m = new Matrix(at);
            boolean bl = isScaledUp = bim.getWidth() < Math.abs(Math.round(m.getScalingFactorX())) || bim.getHeight() < Math.abs(Math.round(m.getScalingFactorY()));
            if (isScaledUp) {
                // empty if block
            }
        }
        this.setClip();
        if (!pdImage.isStencil()) {
            if (this.subsamplingAllowed) {
                int subsampling = this.getSubsampling(pdImage, at);
                this.drawBitmap(pdImage.getImage(null, subsampling), at);
            } else {
                this.drawBitmap(pdImage.getImage(), at);
            }
        }
        if (!pdImage.getInterpolate()) {
            this.setRenderingHints();
        }
    }

    private int getSubsampling(PDImage pdImage, AffineTransform at) {
        double scale = Math.abs(at.getDeterminant() * this.xform.getDeterminant());
        int subsampling = (int)Math.floor(Math.sqrt((double)(pdImage.getWidth() * pdImage.getHeight()) / scale));
        if (subsampling > 8) {
            subsampling = 8;
        }
        if (subsampling < 1) {
            subsampling = 1;
        }
        if (subsampling > pdImage.getWidth() || subsampling > pdImage.getHeight()) {
            subsampling = Math.min(pdImage.getWidth(), pdImage.getHeight());
        }
        return subsampling;
    }

    private void drawBitmap(Bitmap image, AffineTransform at) throws IOException {
        this.setClip();
        AffineTransform imageTransform = new AffineTransform(at);
        int width = image.getWidth();
        int height = image.getHeight();
        imageTransform.scale(1.0 / (double)width, -1.0 / (double)height);
        imageTransform.translate(0.0, -height);
        PDSoftMask softMask = this.getGraphicsState().getSoftMask();
        if (softMask != null) {
            RectF rectF = new RectF(0.0f, 0.0f, (float)width, (float)height);
        } else {
            COSBase transfer = this.getGraphicsState().getTransfer();
            if (transfer instanceof COSArray || transfer instanceof COSDictionary) {
                image = this.applyTransferFunction(image, transfer);
            }
            this.canvas.drawBitmap(image, imageTransform.toMatrix(), this.paint);
        }
    }

    private Bitmap applyTransferFunction(Bitmap image, COSBase transfer) throws IOException {
        Integer[] bMap;
        Integer[] gMap;
        Integer[] rMap;
        PDFunction bf;
        PDFunction gf;
        PDFunction rf;
        Bitmap bim = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (transfer instanceof COSArray) {
            COSArray ar = (COSArray)transfer;
            rf = PDFunction.create(ar.getObject(0));
            gf = PDFunction.create(ar.getObject(1));
            bf = PDFunction.create(ar.getObject(2));
            rMap = new Integer[256];
            gMap = new Integer[256];
            bMap = new Integer[256];
        } else {
            gf = rf = PDFunction.create(transfer);
            bf = rf;
            gMap = rMap = new Integer[256];
            bMap = rMap;
        }
        float[] input = new float[1];
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int bo;
                int go;
                int ro;
                int rgb = image.getPixel(x, y);
                int ri = rgb >> 16 & 0xFF;
                int gi = rgb >> 8 & 0xFF;
                int bi = rgb & 0xFF;
                if (rMap[ri] != null) {
                    ro = rMap[ri];
                } else {
                    input[0] = (float)(ri & 0xFF) / 255.0f;
                    ro = (int)(rf.eval(input)[0] * 255.0f);
                    rMap[ri] = ro;
                }
                if (gMap[gi] != null) {
                    go = gMap[gi];
                } else {
                    input[0] = (float)(gi & 0xFF) / 255.0f;
                    go = (int)(gf.eval(input)[0] * 255.0f);
                    gMap[gi] = go;
                }
                if (bMap[bi] != null) {
                    bo = bMap[bi];
                } else {
                    input[0] = (float)(bi & 0xFF) / 255.0f;
                    bo = (int)(bf.eval(input)[0] * 255.0f);
                    bMap[bi] = bo;
                }
                bim.setPixel(x, y, rgb & 0xFF000000 | ro << 16 | go << 8 | bo);
            }
        }
        return bim;
    }

    @Override
    public void shadingFill(COSName shadingName) throws IOException {
        RectF bounds;
        if (!this.isContentRendered()) {
            return;
        }
        PDShading shading = this.getResources().getShading(shadingName);
        if (shading == null) {
            Log.e((String)"PdfBox-Android", (String)("shading " + shadingName + " does not exist in resources dictionary"));
            return;
        }
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        PDRectangle bbox = shading.getBBox();
        if (bbox == null && (bounds = shading.getBounds(new AffineTransform(), ctm)) != null) {
            bounds.union((float)Math.floor(bounds.left - 1.0f), (float)Math.floor(bounds.top - 1.0f));
            bounds.union((float)Math.ceil(bounds.right + 1.0f), (float)Math.ceil(bounds.bottom + 1.0f));
        }
    }

    @Override
    public void showAnnotation(PDAnnotation annotation) throws IOException {
        this.lastClip = null;
        if (annotation.isNoView()) {
            return;
        }
        if (annotation.isHidden()) {
            return;
        }
        if (annotation.isInvisible() && annotation instanceof PDAnnotationUnknown) {
            return;
        }
        if (this.isHiddenOCG(annotation.getOptionalContent())) {
            return;
        }
        PDAppearanceDictionary appearance = annotation.getAppearance();
        if (appearance == null || appearance.getNormalAppearance() == null) {
            annotation.constructAppearances(this.renderer.document);
        }
        if (annotation.isNoRotate() && this.getCurrentPage().getRotation() != 0) {
            PDRectangle rect = annotation.getRectangle();
            android.graphics.Matrix savedTransform = this.canvas.getMatrix();
            this.canvas.rotate((float)this.getCurrentPage().getRotation(), rect.getLowerLeftX(), rect.getUpperRightY());
            super.showAnnotation(annotation);
            this.canvas.setMatrix(savedTransform);
        } else {
            super.showAnnotation(annotation);
        }
    }

    @Override
    public void showForm(PDFormXObject form) throws IOException {
        if (this.isHiddenOCG(form.getOptionalContent())) {
            return;
        }
        if (this.isContentRendered()) {
            Path savedLinePath = new Path(this.linePath);
            this.linePath = new Path();
            super.showForm(form);
            this.linePath = savedLinePath;
        }
    }

    public void setStroke(Paint p, float width, Paint.Cap cap, Paint.Join join, float miterLimit, float[] dash, float dash_phase) {
        p.setStrokeWidth(width);
        p.setStrokeCap(cap);
        p.setStrokeJoin(join);
        p.setStrokeMiter(miterLimit);
        if (dash != null) {
            p.setPathEffect((PathEffect)new DashPathEffect(dash, dash_phase));
        }
    }

    @Override
    public void showTransparencyGroup(PDTransparencyGroup form) throws IOException {
        this.showTransparencyGroupOnCanvas(form, this.canvas);
    }

    protected void showTransparencyGroupOnCanvas(PDTransparencyGroup form, Canvas canvas) throws IOException {
        PDSoftMask softMask;
        if (this.isHiddenOCG(form.getOptionalContent())) {
            return;
        }
        if (!this.isContentRendered()) {
            return;
        }
        TransparencyGroup group = new TransparencyGroup(form, false, this.getGraphicsState().getCurrentTransformationMatrix(), null);
        this.setClip();
        AffineTransform transform = new AffineTransform(this.xform);
        transform.scale(1.0 / (double)this.xformScalingFactorX, 1.0 / (double)this.xformScalingFactorY);
        if (this.flipTG) {
            // empty if block
        }
        if ((softMask = this.getGraphicsState().getSoftMask()) != null) {
            // empty if block
        }
    }

    private boolean hasBlendMode(PDTransparencyGroup group, Set<COSBase> groupsDone) {
        if (groupsDone.contains(group.getCOSObject())) {
            return false;
        }
        groupsDone.add(group.getCOSObject());
        PDResources resources = group.getResources();
        if (resources == null) {
            return false;
        }
        for (COSName name : resources.getExtGStateNames()) {
            BlendMode blendMode;
            PDExtendedGraphicsState extGState = resources.getExtGState(name);
            if (extGState == null || (blendMode = extGState.getBlendMode()) == BlendMode.NORMAL) continue;
            return true;
        }
        for (COSName name : resources.getXObjectNames()) {
            PDXObject xObject;
            try {
                xObject = resources.getXObject(name);
            }
            catch (IOException ex) {
                continue;
            }
            if (!(xObject instanceof PDTransparencyGroup) || !this.hasBlendMode((PDTransparencyGroup)xObject, groupsDone)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beginMarkedContentSequence(COSName tag, COSDictionary properties) {
        if (this.nestedHiddenOCGCount > 0) {
            ++this.nestedHiddenOCGCount;
            return;
        }
        if (tag == null || this.getPage().getResources() == null) {
            return;
        }
        if (this.isHiddenOCG(this.getPage().getResources().getProperties(tag))) {
            this.nestedHiddenOCGCount = 1;
        }
    }

    @Override
    public void endMarkedContentSequence() {
        if (this.nestedHiddenOCGCount > 0) {
            --this.nestedHiddenOCGCount;
        }
    }

    private boolean isContentRendered() {
        return this.nestedHiddenOCGCount <= 0;
    }

    private boolean isHiddenOCG(PDPropertyList propertyList) {
        if (propertyList instanceof PDOptionalContentGroup) {
            PDOptionalContentGroup group = (PDOptionalContentGroup)propertyList;
            PDOptionalContentGroup.RenderState printState = group.getRenderState(this.destination);
            if (printState == null ? !this.getRenderer().isGroupEnabled(group) : PDOptionalContentGroup.RenderState.OFF.equals((Object)printState)) {
                return true;
            }
        } else if (propertyList instanceof PDOptionalContentMembershipDictionary) {
            return this.isHiddenOCMD((PDOptionalContentMembershipDictionary)propertyList);
        }
        return false;
    }

    private boolean isHiddenOCMD(PDOptionalContentMembershipDictionary ocmd) {
        Iterator iterator;
        List<PDPropertyList> oCGs;
        if (ocmd.getCOSObject().getCOSArray(COSName.VE) != null) {
            Log.i((String)"PdfBox-Android", (String)"/VE entry ignored in Optional Content Membership Dictionary");
        }
        if ((oCGs = ocmd.getOCGs()).isEmpty()) {
            return false;
        }
        ArrayList<Boolean> visibles = new ArrayList<Boolean>();
        for (PDPropertyList prop : oCGs) {
            visibles.add(!this.isHiddenOCG(prop));
        }
        COSName visibilityPolicy = ocmd.getVisibilityPolicy();
        if (COSName.ANY_OFF.equals(visibilityPolicy)) {
            iterator = visibles.iterator();
            while (iterator.hasNext()) {
                boolean visible = (Boolean)iterator.next();
                if (visible) continue;
                return false;
            }
            return true;
        }
        if (COSName.ALL_ON.equals(visibilityPolicy)) {
            iterator = visibles.iterator();
            while (iterator.hasNext()) {
                boolean visible = (Boolean)iterator.next();
                if (visible) continue;
                return true;
            }
            return false;
        }
        if (COSName.ALL_OFF.equals(visibilityPolicy)) {
            iterator = visibles.iterator();
            while (iterator.hasNext()) {
                boolean visible = (Boolean)iterator.next();
                if (!visible) continue;
                return true;
            }
            return false;
        }
        iterator = visibles.iterator();
        while (iterator.hasNext()) {
            boolean visible = (Boolean)iterator.next();
            if (!visible) continue;
            return false;
        }
        return true;
    }

    private final class TransparencyGroup {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TransparencyGroup(PDTransparencyGroup form, boolean isSoftMask, Matrix ctm, PDColor backdropColor) throws IOException {
            Matrix transform = Matrix.concatenate(ctm, form.getMatrix());
            PDRectangle formBBox = form.getBBox();
            if (formBBox == null) {
                Log.w((String)"PdfBox-Android", (String)"transparency group ignored because BBox is null");
                formBBox = new PDRectangle();
            }
            Path transformedBox = formBBox.transform(transform);
            AffineTransform xformOriginal = PageDrawer.this.xform;
            PageDrawer.this.xform = AffineTransform.getScaleInstance(PageDrawer.this.xformScalingFactorX, PageDrawer.this.xformScalingFactorY);
            if (this.isGray(form.getGroup().getColorSpace(form.getResources()))) {
                // empty if block
            }
            boolean needsBackdrop = !isSoftMask && !form.getGroup().isIsolated() && PageDrawer.this.hasBlendMode(form, new HashSet());
            Bitmap backdropImage = null;
            boolean backdropX = false;
            boolean backdropY = false;
            if (needsBackdrop) {
                if (PageDrawer.this.transparencyGroupStack.isEmpty()) {
                    backdropImage = PageDrawer.this.renderer.getPageImage();
                    if (backdropImage == null) {
                        needsBackdrop = false;
                    }
                } else {
                    TransparencyGroup transparencyGroup = (TransparencyGroup)PageDrawer.this.transparencyGroupStack.peek();
                }
            }
            if (needsBackdrop) {
                // empty if block
            }
            if (!isSoftMask || backdropColor != null) {
                // empty if block
            }
            boolean savedFlipTG = PageDrawer.this.flipTG;
            PageDrawer.this.flipTG = false;
            PDRectangle pageSizeOriginal = PageDrawer.this.pageSize;
            Path.FillType clipWindingRuleOriginal = PageDrawer.this.clipWindingRule;
            PageDrawer.this.clipWindingRule = null;
            Path linePathOriginal = PageDrawer.this.linePath;
            PageDrawer.this.linePath = new Path();
            PageDrawer.this.setRenderingHints();
            try {
                if (isSoftMask) {
                    PageDrawer.this.processSoftMask(form);
                } else {
                    PageDrawer.this.transparencyGroupStack.push(this);
                    PageDrawer.this.processTransparencyGroup(form);
                    if (!PageDrawer.this.transparencyGroupStack.isEmpty()) {
                        PageDrawer.this.transparencyGroupStack.pop();
                    }
                }
                if (needsBackdrop) {
                    // empty if block
                }
            }
            finally {
                PageDrawer.this.flipTG = savedFlipTG;
                PageDrawer.this.clipWindingRule = clipWindingRuleOriginal;
                PageDrawer.this.linePath = linePathOriginal;
                PageDrawer.this.pageSize = pageSizeOriginal;
                PageDrawer.this.xform = xformOriginal;
            }
        }

        private boolean isGray(PDColorSpace colorSpace) {
            return colorSpace instanceof PDDeviceGray;
        }
    }
}

