/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.multipdf;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDPage;
import java.io.IOException;

public class PageExtractor {
    private final PDDocument sourceDocument;
    private int startPage = 1;
    private int endPage;

    public PageExtractor(PDDocument sourceDocument) {
        this.sourceDocument = sourceDocument;
        this.endPage = sourceDocument.getNumberOfPages();
    }

    public PageExtractor(PDDocument sourceDocument, int startPage, int endPage) {
        this.sourceDocument = sourceDocument;
        this.startPage = startPage;
        this.endPage = endPage;
    }

    public PDDocument extract() throws IOException {
        PDDocument extractedDocument = new PDDocument();
        extractedDocument.setDocumentInformation(this.sourceDocument.getDocumentInformation());
        extractedDocument.getDocumentCatalog().setViewerPreferences(this.sourceDocument.getDocumentCatalog().getViewerPreferences());
        for (int i = this.startPage; i <= this.endPage; ++i) {
            PDPage page = this.sourceDocument.getPage(i - 1);
            PDPage imported = extractedDocument.importPage(page);
            if (page.getResources() == null || page.getCOSObject().containsKey(COSName.RESOURCES)) continue;
            imported.setResources(page.getResources());
            Log.i((String)"PdfBox-Android", (String)"Done in PageExtractor");
        }
        return extractedDocument;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }
}

