/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.rendering;

import android.graphics.Path;
import android.util.Log;
import com.tom_roush.pdfbox.pdmodel.font.PDSimpleFont;
import com.tom_roush.pdfbox.rendering.Glyph2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class Type1Glyph2D
implements Glyph2D {
    private final Map<Integer, Path> cache = new HashMap<Integer, Path>();
    private final PDSimpleFont font;

    Type1Glyph2D(PDSimpleFont font) {
        this.font = font;
    }

    @Override
    public Path getPathForCharacterCode(int code) {
        Path path = this.cache.get(code);
        if (path == null) {
            try {
                String name = this.font.getEncoding().getName(code);
                if (!this.font.hasGlyph(name)) {
                    Log.w((String)"PdfBox-Android", (String)("No glyph for code " + code + " (" + name + ") in font " + this.font.getName()));
                    if (code == 10 && this.font.isStandard14()) {
                        path = new Path();
                        this.cache.put(code, path);
                        return path;
                    }
                }
                if ((path = this.font.getPath(name)) == null) {
                    path = this.font.getPath(".notdef");
                }
                return path;
            }
            catch (IOException e) {
                Log.e((String)"PdfBox-Android", (String)"Glyph rendering failed", (Throwable)e);
                path = new Path();
            }
        }
        return path;
    }

    @Override
    public void dispose() {
        this.cache.clear();
    }
}

