/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdfparser;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDocument;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSObjectKey;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdfparser.BaseParser;
import com.tom_roush.pdfbox.pdfparser.InputStreamSource;
import com.tom_roush.pdfbox.pdfparser.XrefTrailerResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class PDFXrefStreamParser
extends BaseParser {
    private final COSStream stream;
    private final XrefTrailerResolver xrefTrailerResolver;

    public PDFXrefStreamParser(COSStream stream, COSDocument document, XrefTrailerResolver resolver) throws IOException {
        super(new InputStreamSource(stream.createInputStream()));
        this.stream = stream;
        this.document = document;
        this.xrefTrailerResolver = resolver;
    }

    public void parse() throws IOException {
        COSArray indexArray;
        COSBase w = this.stream.getDictionaryObject(COSName.W);
        if (!(w instanceof COSArray)) {
            throw new IOException("/W array is missing in Xref stream");
        }
        COSArray xrefFormat = (COSArray)w;
        COSBase base = this.stream.getDictionaryObject(COSName.INDEX);
        if (base instanceof COSArray) {
            indexArray = (COSArray)base;
        } else {
            indexArray = new COSArray();
            indexArray.add(COSInteger.ZERO);
            indexArray.add(COSInteger.get(this.stream.getInt(COSName.SIZE, 0)));
        }
        ArrayList<Long> objNums = new ArrayList<Long>();
        Iterator<COSBase> indexIter = indexArray.iterator();
        while (indexIter.hasNext()) {
            base = indexIter.next();
            if (!(base instanceof COSInteger)) {
                throw new IOException("Xref stream must have integer in /Index array");
            }
            long objID = ((COSInteger)base).longValue();
            if (!indexIter.hasNext()) break;
            base = indexIter.next();
            if (!(base instanceof COSInteger)) {
                throw new IOException("Xref stream must have integer in /Index array");
            }
            int size = ((COSInteger)base).intValue();
            for (int i = 0; i < size; ++i) {
                objNums.add(objID + (long)i);
            }
        }
        Iterator objIter = objNums.iterator();
        int w0 = xrefFormat.getInt(0, 0);
        int w1 = xrefFormat.getInt(1, 0);
        int w2 = xrefFormat.getInt(2, 0);
        int lineSize = w0 + w1 + w2;
        while (!this.seqSource.isEOF() && objIter.hasNext()) {
            int type;
            byte[] currLine = new byte[lineSize];
            this.seqSource.read(currLine);
            if (w0 == 0) {
                type = 1;
            } else {
                type = 0;
                for (int i = 0; i < w0; ++i) {
                    type += (currLine[i] & 0xFF) << (w0 - i - 1) * 8;
                }
            }
            Long objID = (Long)objIter.next();
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    int offset = 0;
                    for (int i = 0; i < w1; ++i) {
                        offset += (currLine[i + w0] & 0xFF) << (w1 - i - 1) * 8;
                    }
                    int genNum = 0;
                    for (int i = 0; i < w2; ++i) {
                        genNum += (currLine[i + w0 + w1] & 0xFF) << (w2 - i - 1) * 8;
                    }
                    COSObjectKey objKey = new COSObjectKey(objID, genNum);
                    this.xrefTrailerResolver.setXRef(objKey, offset);
                    break;
                }
                case 2: {
                    int objstmObjNr = 0;
                    for (int i = 0; i < w1; ++i) {
                        objstmObjNr += (currLine[i + w0] & 0xFF) << (w1 - i - 1) * 8;
                    }
                    COSObjectKey objKey = new COSObjectKey(objID, 0);
                    this.xrefTrailerResolver.setXRef(objKey, -objstmObjNr);
                    break;
                }
            }
        }
    }
}

