/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.rendering;

import android.graphics.Path;
import android.util.Log;
import com.tom_roush.pdfbox.pdmodel.font.PDSimpleFont;
import com.tom_roush.pdfbox.rendering.Glyph2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class Type1Glyph2D
implements Glyph2D {
    private final Map<Integer, Path> cache = new HashMap<Integer, Path>();
    private final PDSimpleFont font;

    Type1Glyph2D(PDSimpleFont font) {
        this.font = font;
    }

    @Override
    public Path getPathForCharacterCode(int code) {
        if (this.cache.containsKey(code)) {
            return this.cache.get(code);
        }
        try {
            Path path;
            String name = this.font.getEncoding().getName(code);
            if (!this.font.hasGlyph(name)) {
                Log.w((String)"PdfBox-Android", (String)("No glyph for " + code + " (" + name + ") in font " + this.font.getName()));
            }
            if ((path = this.font.getPath(name)) == null) {
                path = this.font.getPath(".notdef");
            }
            this.cache.put(code, path);
            return path;
        }
        catch (IOException e) {
            Log.e((String)"PdfBox-Android", (String)"Glyph rendering failed", (Throwable)e);
            return new Path();
        }
    }

    @Override
    public void dispose() {
        this.cache.clear();
    }
}

