/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.PDSeedValue;
import com.tom_roush.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDTerminalField;
import java.io.IOException;
import java.util.HashSet;

public class PDSignatureField
extends PDTerminalField {
    public PDSignatureField(PDAcroForm acroForm) throws IOException {
        super(acroForm);
        this.dictionary.setItem(COSName.FT, (COSBase)COSName.SIG);
        this.getWidgets().get(0).setLocked(true);
        this.getWidgets().get(0).setPrinted(true);
        this.setPartialName(this.generatePartialName());
    }

    PDSignatureField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    private String generatePartialName() {
        String fieldName = "Signature";
        HashSet<String> sigNames = new HashSet<String>();
        for (PDField field : this.acroForm.getFields()) {
            if (!(field instanceof PDSignatureField)) continue;
            sigNames.add(field.getPartialName());
        }
        int i = 1;
        while (sigNames.contains(fieldName + i)) {
            ++i;
        }
        return fieldName + i;
    }

    @Deprecated
    public void setSignature(PDSignature value) throws IOException {
        this.setValue(value);
    }

    public PDSignature getSignature() {
        return this.getValue();
    }

    public void setValue(PDSignature value) throws IOException {
        this.dictionary.setItem(COSName.V, (COSObjectable)value);
        this.applyChange();
    }

    public void setDefaultValue(PDSignature value) throws IOException {
        this.dictionary.setItem(COSName.DV, (COSObjectable)value);
    }

    public PDSignature getValue() {
        COSBase value = this.dictionary.getDictionaryObject(COSName.V);
        if (value == null) {
            return null;
        }
        return new PDSignature((COSDictionary)value);
    }

    public PDSignature getDefaultValue() {
        COSBase value = this.dictionary.getDictionaryObject(COSName.DV);
        if (value == null) {
            return null;
        }
        return new PDSignature((COSDictionary)value);
    }

    @Override
    public String getValueAsString() {
        PDSignature signature = this.getValue();
        return signature != null ? signature.toString() : "";
    }

    public PDSeedValue getSeedValue() {
        COSDictionary dict = (COSDictionary)this.dictionary.getDictionaryObject(COSName.SV);
        PDSeedValue sv = null;
        if (dict != null) {
            sv = new PDSeedValue(dict);
        }
        return sv;
    }

    public void setSeedValue(PDSeedValue sv) {
        if (sv != null) {
            this.dictionary.setItem(COSName.SV, (COSObjectable)sv);
        }
    }

    @Override
    void constructAppearances() throws IOException {
        PDAnnotationWidget widget = this.getWidgets().get(0);
        if (widget != null) {
            if (widget.getRectangle() == null || widget.getRectangle().getHeight() == 0.0f && widget.getRectangle().getWidth() == 0.0f || widget.isNoView() || widget.isHidden()) {
                return;
            }
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

