/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.form;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDAcroForm;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDButton;
import com.tom_roush.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PDRadioButton
extends PDButton {
    private static final int FLAG_NO_TOGGLE_TO_OFF = 16384;

    public PDRadioButton(PDAcroForm acroForm) {
        super(acroForm);
        this.setRadioButton(true);
    }

    PDRadioButton(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public void setRadiosInUnison(boolean radiosInUnison) {
        this.dictionary.setFlag(COSName.FF, 0x2000000, radiosInUnison);
    }

    public boolean isRadiosInUnison() {
        return this.dictionary.getFlag(COSName.FF, 0x2000000);
    }

    public List<String> getSelectedExportValues() throws IOException {
        List<String> onValues = this.getSelectableOnValues();
        List<String> exportValues = this.getExportValues();
        ArrayList<String> selectedExportValues = new ArrayList<String>();
        if (exportValues.isEmpty()) {
            selectedExportValues.add(this.getValue());
            return selectedExportValues;
        }
        String fieldValue = this.getValue();
        int idx = 0;
        for (String onValue : onValues) {
            if (onValue.compareTo(fieldValue) != 0) continue;
            selectedExportValues.add(exportValues.get(idx));
        }
        return selectedExportValues;
    }

    public String getValue() {
        COSBase value = this.getInheritableAttribute(COSName.V);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    public String getDefaultValue() {
        COSBase value = this.getInheritableAttribute(COSName.DV);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    public void setValue(String value) throws IOException {
        this.checkValue(value);
        this.dictionary.setName(COSName.V, value);
        for (PDAnnotationWidget widget : this.getWidgets()) {
            PDAppearanceEntry appearanceEntry = widget.getAppearance().getNormalAppearance();
            if (((COSDictionary)appearanceEntry.getCOSObject()).containsKey(value)) {
                widget.getCOSObject().setName(COSName.AS, value);
                continue;
            }
            widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
        }
        this.applyChange();
    }

    public void setDefaultValue(String value) {
        this.checkValue(value);
        this.dictionary.setName(COSName.DV, value);
    }

    public Set<String> getOnValues() {
        HashSet<String> onValues = new HashSet<String>();
        onValues.addAll(this.getSelectableOnValues());
        return onValues;
    }

    private void checkValue(String value) throws IllegalArgumentException {
        Set<String> onValues = this.getOnValues();
        if (COSName.Off.getName().compareTo(value) != 0 && !onValues.contains(value)) {
            throw new IllegalArgumentException("value '" + value + "' is not a valid option for the radio button " + this.getFullyQualifiedName() + ", valid values are: " + onValues + " and " + COSName.Off.getName());
        }
    }

    private List<String> getSelectableOnValues() {
        List<PDAnnotationWidget> widgets = this.getWidgets();
        ArrayList<String> onValues = new ArrayList<String>();
        for (PDAnnotationWidget widget : widgets) {
            PDAppearanceEntry normalAppearance;
            PDAppearanceDictionary apDictionary = widget.getAppearance();
            if (apDictionary == null || (normalAppearance = apDictionary.getNormalAppearance()) == null) continue;
            Set<COSName> entries = normalAppearance.getSubDictionary().keySet();
            for (COSName entry : entries) {
                if (COSName.Off.compareTo(entry) == 0) continue;
                onValues.add(entry.getName());
            }
        }
        return onValues;
    }
}

