/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.interactive.annotation;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDAction;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDActionFactory;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public class PDAnnotationWidget
extends PDAnnotation {
    public static final String SUB_TYPE = "Widget";

    public PDAnnotationWidget() {
        this.getCOSObject().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public PDAnnotationWidget(COSDictionary field) {
        super(field);
        this.getCOSObject().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public String getHighlightingMode() {
        return this.getCOSObject().getNameAsString(COSName.H, "I");
    }

    public void setHighlightingMode(String highlightingMode) {
        if (!(highlightingMode == null || "N".equals(highlightingMode) || "I".equals(highlightingMode) || "O".equals(highlightingMode) || "P".equals(highlightingMode) || "T".equals(highlightingMode))) {
            throw new IllegalArgumentException("Valid values for highlighting mode are 'N', 'N', 'O', 'P' or 'T'");
        }
        this.getCOSObject().setName(COSName.H, highlightingMode);
    }

    public PDAppearanceCharacteristicsDictionary getAppearanceCharacteristics() {
        COSBase mk = this.getCOSObject().getDictionaryObject(COSName.MK);
        if (mk instanceof COSDictionary) {
            return new PDAppearanceCharacteristicsDictionary((COSDictionary)mk);
        }
        return null;
    }

    public void setAppearanceCharacteristics(PDAppearanceCharacteristicsDictionary appearanceCharacteristics) {
        this.getCOSObject().setItem(COSName.MK, (COSObjectable)appearanceCharacteristics);
    }

    public PDAction getAction() {
        COSDictionary action = (COSDictionary)this.getCOSObject().getDictionaryObject(COSName.A);
        return PDActionFactory.createAction(action);
    }

    public void setAction(PDAction action) {
        this.getCOSObject().setItem(COSName.A, (COSObjectable)action);
    }

    public PDAnnotationAdditionalActions getActions() {
        COSDictionary aa = (COSDictionary)this.getCOSObject().getDictionaryObject(COSName.AA);
        PDAnnotationAdditionalActions retval = null;
        if (aa != null) {
            retval = new PDAnnotationAdditionalActions(aa);
        }
        return retval;
    }

    public void setActions(PDAnnotationAdditionalActions actions) {
        this.getCOSObject().setItem(COSName.AA, (COSObjectable)actions);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getCOSObject().setItem(COSName.BS, (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBorderStyle() {
        COSDictionary bs = (COSDictionary)this.getCOSObject().getItem(COSName.BS);
        if (bs != null) {
            return new PDBorderStyleDictionary(bs);
        }
        return null;
    }
}

