/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.graphics;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.ResourceCache;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.form.PDFormXObject;
import com.tom_roush.pdfbox.pdmodel.graphics.image.PDImageXObject;
import java.io.IOException;

public class PDXObject
implements COSObjectable {
    private final PDStream stream;

    public static PDXObject createXObject(COSBase base, PDResources resources) throws IOException {
        if (base == null) {
            return null;
        }
        if (!(base instanceof COSStream)) {
            throw new IOException("Unexpected object type: " + base.getClass().getName());
        }
        COSStream stream = (COSStream)base;
        String subtype = stream.getNameAsString(COSName.SUBTYPE);
        if (COSName.IMAGE.getName().equals(subtype)) {
            return new PDImageXObject(new PDStream(stream), resources);
        }
        if (COSName.FORM.getName().equals(subtype)) {
            ResourceCache cache = resources != null ? resources.getResourceCache() : null;
            return new PDFormXObject(stream, cache);
        }
        if (COSName.PS.getName().equals(subtype)) {
            return new PDPostScriptXObject(stream);
        }
        throw new IOException("Invalid XObject Subtype: " + subtype);
    }

    protected PDXObject(COSStream stream, COSName subtype) {
        this.stream = new PDStream(stream);
        stream.setName(COSName.TYPE, COSName.XOBJECT.getName());
        stream.setName(COSName.SUBTYPE, subtype.getName());
    }

    protected PDXObject(PDStream stream, COSName subtype) {
        this.stream = stream;
        stream.getStream().setName(COSName.TYPE, COSName.XOBJECT.getName());
        stream.getStream().setName(COSName.SUBTYPE, subtype.getName());
    }

    protected PDXObject(PDDocument document, COSName subtype) {
        this.stream = new PDStream(document);
        this.stream.getStream().setName(COSName.TYPE, COSName.XOBJECT.getName());
        this.stream.getStream().setName(COSName.SUBTYPE, subtype.getName());
    }

    @Override
    public final COSBase getCOSObject() {
        return this.stream.getCOSObject();
    }

    public final COSStream getCOSStream() {
        return this.stream.getStream();
    }

    @Deprecated
    public final PDStream getPDStream() {
        return this.stream;
    }

    public final PDStream getStream() {
        return this.stream;
    }
}

