/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.font.encoding;

import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.font.encoding.MacRomanEncoding;
import com.tom_roush.pdfbox.pdmodel.font.encoding.StandardEncoding;
import com.tom_roush.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Encoding
implements COSObjectable {
    protected final Map<Integer, String> codeToName = new HashMap<Integer, String>();
    protected final Set<String> names = new HashSet<String>();

    public static Encoding getInstance(COSName name) {
        if (COSName.STANDARD_ENCODING.equals(name)) {
            return StandardEncoding.INSTANCE;
        }
        if (COSName.WIN_ANSI_ENCODING.equals(name)) {
            return WinAnsiEncoding.INSTANCE;
        }
        if (COSName.MAC_ROMAN_ENCODING.equals(name)) {
            return MacRomanEncoding.INSTANCE;
        }
        return null;
    }

    public Map<Integer, String> getCodeToNameMap() {
        return Collections.unmodifiableMap(this.codeToName);
    }

    protected void add(int code, String name) {
        this.codeToName.put(code, name);
        this.names.add(name);
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public boolean contains(int code) {
        return this.codeToName.containsKey(code);
    }

    public String getName(int code) {
        String name = this.codeToName.get(code);
        if (name != null) {
            return name;
        }
        return ".notdef";
    }
}

