/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdfparser;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDocument;
import com.tom_roush.pdfbox.cos.COSObject;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdfparser.BaseParser;
import com.tom_roush.pdfbox.pdfparser.InputStreamSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PDFObjectStreamParser
extends BaseParser {
    private List<COSObject> streamObjects = null;
    private final COSStream stream;

    public PDFObjectStreamParser(COSStream stream, COSDocument document) throws IOException {
        super(new InputStreamSource(stream.createInputStream()));
        this.document = document;
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            COSBase cosObject;
            int numberOfObjects = this.stream.getInt("N");
            ArrayList<Long> objectNumbers = new ArrayList<Long>(numberOfObjects);
            this.streamObjects = new ArrayList<COSObject>(numberOfObjects);
            for (int i = 0; i < numberOfObjects; ++i) {
                long objectNumber = this.readObjectNumber();
                this.readLong();
                objectNumbers.add(objectNumber);
            }
            int objectCounter = 0;
            while ((cosObject = this.parseDirObject()) != null) {
                COSObject object = new COSObject(cosObject);
                object.setGenerationNumber(0);
                if (objectCounter >= objectNumbers.size()) {
                    Log.e((String)"PdfBox-Android", (String)("/ObjStm (object stream) has more objects than /N " + numberOfObjects));
                    break;
                }
                object.setObjectNumber((Long)objectNumbers.get(objectCounter));
                this.streamObjects.add(object);
                Log.d((String)"PdfBox-Android", (String)("parsed=" + object));
                if (!this.seqSource.isEOF() && this.seqSource.peek() == 101) {
                    this.readLine();
                }
                ++objectCounter;
            }
        }
        finally {
            this.seqSource.close();
        }
    }

    public List<COSObject> getObjects() {
        return this.streamObjects;
    }
}

